/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.palette;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.php.twig.editor.palette.Bundle;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;

public class TwigPaletteFactory {
    private static final String TWIG_PALETTE_FOLDER = "Palettes/Twig";
    private static PaletteController controller = null;

    public static PaletteController createPalette() throws IOException {
        if (controller == null) {
            controller = PaletteFactory.createPalette((String)TWIG_PALETTE_FOLDER, (PaletteActions)new TwigPaletteActions(), null, (DragAndDropHandler)new TwigPaletteDragAndDropHandler());
        }
        return controller;
    }

    private static class TwigPaletteDragAndDropHandler
    extends DragAndDropHandler {
        public TwigPaletteDragAndDropHandler() {
            super(true);
        }

        public void customize(ExTransferable t, Lookup item) {
        }
    }

    private static class TwigPaletteInsertAction
    extends AbstractAction {
        private static final long serialVersionUID = -2545383594436146990L;
        private final Lookup item;

        TwigPaletteInsertAction(Lookup item) {
            this.item = item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            ActiveEditorDrop drop = (ActiveEditorDrop)this.item.lookup(ActiveEditorDrop.class);
            JTextComponent target = Utilities.getFocusedComponent();
            if (target == null) {
                String msg = Bundle.TwigPaletteInsertAction_ErrorNoFocusedDocument();
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                return;
            }
            if (drop == null) {
                Logger.getLogger("global").log(Level.INFO, "{0} doesn''t provide {1}", new Object[]{this.item.getClass(), ActiveEditorDrop.class});
                return;
            }
            try {
                drop.handleTransfer(target);
            }
            finally {
                Utilities.requestFocus((JTextComponent)target);
            }
            try {
                PaletteController paletteController = TwigPaletteFactory.createPalette();
                paletteController.clearSelection();
            }
            catch (IOException ioe) {
                Logger.getLogger("global").log(Level.INFO, null, ioe);
            }
        }
    }

    private static class TwigPaletteActions
    extends PaletteActions {
        private TwigPaletteActions() {
        }

        public Action[] getImportActions() {
            return new Action[0];
        }

        public Action[] getCustomPaletteActions() {
            return new Action[0];
        }

        public Action[] getCustomCategoryActions(Lookup category) {
            return new Action[0];
        }

        public Action[] getCustomItemActions(Lookup item) {
            return new Action[0];
        }

        public Action getPreferredAction(Lookup item) {
            return new TwigPaletteInsertAction(item);
        }
    }
}

