/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class PlatformJavadocForBinaryQuery
implements JavadocForBinaryQueryImplementation {
    private static final Logger LOG = Logger.getLogger(PlatformJavadocForBinaryQuery.class.getName());
    private static final int STATE_ERROR = -1;
    private static final int STATE_START = 0;
    private static final int STATE_DOCS = 1;
    private static final int STATE_LAN = 2;
    private static final int STATE_API = 3;
    private static final int STATE_INDEX = 4;
    private static final String NAME_DOCS = "docs";
    private static final String NAME_API = "api";
    private static final String NAME_IDNEX = "index-files";

    public JavadocForBinaryQuery.Result findJavadoc(@NonNull URL binaryRoot) {
        ArrayDeque<JavaPlatform> candidates = new ArrayDeque<JavaPlatform>();
        for (JavaPlatform jp : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            for (ClassPath.Entry entry : jp.getBootstrapLibraries().entries()) {
                if (!binaryRoot.equals(entry.getURL())) continue;
                candidates.add(jp);
            }
        }
        return candidates.isEmpty() ? null : new R(candidates);
    }

    static final class R
    implements JavadocForBinaryQuery.Result,
    PropertyChangeListener {
        private static Set<String> locales;
        private final Iterable<? extends JavaPlatform> platforms;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private URL[] cachedRoots;

        public R(@NonNull Iterable<? extends JavaPlatform> platforms) {
            Parameters.notNull((CharSequence)"platforms", platforms);
            this.platforms = platforms;
            for (JavaPlatform javaPlatform : platforms) {
                javaPlatform.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)javaPlatform));
            }
        }

        @NonNull
        public synchronized URL[] getRoots() {
            if (this.cachedRoots == null) {
                ArrayList<URL> l = new ArrayList<URL>();
                for (JavaPlatform javaPlatform : this.platforms) {
                    List<URL> javadoc = javaPlatform.getJavadocFolders();
                    if (javadoc.isEmpty()) continue;
                    for (URL u : javadoc) {
                        if (u == null) continue;
                        FileObject root = URLMapper.findFileObject((URL)u);
                        if (root == null) {
                            l.add(u);
                            continue;
                        }
                        if (root.isFolder()) {
                            try {
                                l.add(R.getIndexFolder(root));
                            }
                            catch (FileStateInvalidException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                            continue;
                        }
                        LOG.log(Level.WARNING, "Ignoring non folder root: {0}", FileUtil.getFileDisplayName((FileObject)root));
                    }
                }
                this.cachedRoots = l.toArray(new URL[l.size()]);
            }
            return this.cachedRoots;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            assert (l != null) : "Listener can not be null";
            this.cs.addChangeListener(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            assert (l != null) : "Listener can not be null";
            this.cs.removeChangeListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("javadocFolders".equals(event.getPropertyName())) {
                R r = this;
                synchronized (r) {
                    this.cachedRoots = null;
                }
                this.cs.fireChange();
            }
        }

        private static URL getIndexFolder(FileObject root) throws FileStateInvalidException {
            FileObject result = R.findIndexFolder(root);
            return result == null ? root.toURL() : result.toURL();
        }

        static FileObject findIndexFolder(FileObject fo) {
            int state = 0;
            while (state != -1 && state != 4) {
                switch (state) {
                    case 0: {
                        FileObject tmpFo = fo.getFileObject(PlatformJavadocForBinaryQuery.NAME_DOCS);
                        if (tmpFo != null) {
                            fo = tmpFo;
                            state = 1;
                            break;
                        }
                        tmpFo = fo.getFileObject(PlatformJavadocForBinaryQuery.NAME_API);
                        if (tmpFo != null) {
                            fo = tmpFo;
                            state = 3;
                            break;
                        }
                        tmpFo = R.getLocalization(fo);
                        if (tmpFo != null) {
                            fo = tmpFo;
                            state = 2;
                            break;
                        }
                        fo = null;
                        state = -1;
                        break;
                    }
                    case 1: {
                        FileObject tmpFo = fo.getFileObject(PlatformJavadocForBinaryQuery.NAME_API);
                        if (tmpFo != null) {
                            fo = tmpFo;
                            state = 3;
                            break;
                        }
                        tmpFo = R.getLocalization(fo);
                        if (tmpFo != null) {
                            fo = tmpFo;
                            state = 2;
                            break;
                        }
                        fo = null;
                        state = -1;
                        break;
                    }
                    case 2: {
                        FileObject tmpFo = fo.getFileObject(PlatformJavadocForBinaryQuery.NAME_API);
                        if (tmpFo != null) {
                            fo = tmpFo;
                            state = 3;
                            break;
                        }
                        fo = null;
                        state = -1;
                        break;
                    }
                    case 3: {
                        FileObject tmpFo = fo.getFileObject(PlatformJavadocForBinaryQuery.NAME_IDNEX);
                        if (tmpFo != null) {
                            state = 4;
                            break;
                        }
                        fo = null;
                        state = -1;
                        break;
                    }
                }
            }
            return fo;
        }

        private static FileObject getLocalization(FileObject root) {
            FileObject[] children = root.getChildren();
            if (children.length == 0) {
                return null;
            }
            if (children.length == 1) {
                return children[0];
            }
            HashSet<FileObject> candidates = new HashSet<FileObject>();
            for (FileObject fo : children) {
                if (!fo.isFolder() || fo.getName().charAt(0) == '.') continue;
                candidates.add(fo);
            }
            if (candidates.isEmpty()) {
                return null;
            }
            if (candidates.size() == 1) {
                return (FileObject)candidates.iterator().next();
            }
            Set<String> locales = R.getLocales();
            for (FileObject fo : candidates) {
                if (!locales.contains(fo.getName())) continue;
                return fo;
            }
            return null;
        }

        private static synchronized Set<String> getLocales() {
            if (locales == null) {
                Locale[] locs = Locale.getAvailableLocales();
                locales = new HashSet<String>();
                for (Locale l : locs) {
                    locales.add(l.toString());
                }
            }
            return locales;
        }
    }
}

