/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localtasks.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import org.netbeans.modules.localtasks.LocalRepository;
import org.openide.filesystems.FileUtil;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        if (sourceFile == null || targetFile == null) {
            throw new NullPointerException("sourceFile and targetFile must not be null");
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = FileUtils.createInputStream(sourceFile);
            FileUtils.copyStreamToFile(inputStream, targetFile);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void copyDirFiles(File sourceDir, File targetDir) {
        FileUtils.copyDirFiles(sourceDir, targetDir, false);
    }

    public static void copyDirFiles(File sourceDir, File targetDir, boolean preserveTimestamp) {
        File[] files = sourceDir.listFiles();
        if (files == null || files.length == 0) {
            targetDir.mkdirs();
            if (preserveTimestamp) {
                targetDir.setLastModified(sourceDir.lastModified());
            }
            return;
        }
        if (preserveTimestamp) {
            targetDir.setLastModified(sourceDir.lastModified());
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                File target = FileUtil.normalizeFile((File)new File(targetDir.getAbsolutePath() + "/" + files[i].getName()));
                if (files[i].isDirectory()) {
                    FileUtils.copyDirFiles(files[i], target, preserveTimestamp);
                    continue;
                }
                FileUtils.copyFile(files[i], target);
                if (!preserveTimestamp) continue;
                target.setLastModified(files[i].lastModified());
                continue;
            }
            catch (IOException ex) {
                LocalRepository.LOG.log(Level.INFO, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToFile(InputStream inputStream, File targetFile) throws IOException {
        if (inputStream == null || targetFile == null) {
            throw new NullPointerException("sourcStream and targetFile must not be null");
        }
        File directory = targetFile.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Could not create directory '" + directory + "'");
        }
        BufferedOutputStream outputStream = null;
        try {
            outputStream = FileUtils.createOutputStream(targetFile);
            try {
                byte[] buffer = new byte[32768];
                int readBytes = inputStream.read(buffer);
                while (readBytes > 0) {
                    ((OutputStream)outputStream).write(buffer, 0, readBytes);
                    readBytes = inputStream.read(buffer);
                }
            }
            catch (IOException ex) {
                targetFile.delete();
                throw ex;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileContentsAsByteArray(File file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5120);
        try (BufferedInputStream bis = null;){
            bis = FileUtils.createInputStream(file);
            byte[] buffer = new byte[1024];
            int byteRead = bis.read(buffer);
            while (byteRead > 0) {
                baos.write(buffer, 0, byteRead);
                byteRead = bis.read(buffer);
            }
        }
        return baos.toByteArray();
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtils.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }

    public static void renameFile(File orig, File dest) throws IOException {
        int i;
        boolean destExists = dest.exists();
        if (destExists) {
            for (i = 0; i < 3; ++i) {
                if (dest.delete()) {
                    destExists = false;
                    break;
                }
                try {
                    Thread.sleep(71L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!destExists) {
            for (i = 0; i < 3; ++i) {
                if (orig.renameTo(dest)) {
                    return;
                }
                try {
                    Thread.sleep(71L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        FileUtils.copyFile(orig, dest);
        for (i = 0; i < 3; ++i) {
            if (orig.delete()) {
                return;
            }
            try {
                Thread.sleep(71L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new IOException("Can not delete: " + orig.getAbsolutePath());
    }

    private FileUtils() {
    }

    public static BufferedInputStream createInputStream(File file) throws IOException {
        int retry = 0;
        while (true) {
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (IOException ex) {
                if (++retry > 7) {
                    throw ex;
                }
                try {
                    Thread.sleep(retry * 34);
                }
                catch (InterruptedException iex) {
                    throw ex;
                }
            }
        }
    }

    public static BufferedOutputStream createOutputStream(File file) throws IOException {
        int retry = 0;
        while (true) {
            try {
                return new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (IOException ex) {
                if (++retry > 7) {
                    throw ex;
                }
                try {
                    Thread.sleep(retry * 34);
                }
                catch (InterruptedException iex) {
                    throw ex;
                }
            }
        }
    }

    public static File createTmpFolder(String prefix) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File tmpFolder = new File(tmpDir);
        File checkoutFolder = null;
        try {
            File tmp = File.createTempFile(prefix, "", tmpFolder);
            if (!tmp.delete()) {
                return checkoutFolder;
            }
            if (!tmp.mkdirs()) {
                return checkoutFolder;
            }
            checkoutFolder = FileUtil.normalizeFile((File)tmp);
        }
        catch (IOException e) {
            LocalRepository.LOG.log(Level.SEVERE, null, e);
        }
        return checkoutFolder;
    }

    public static String getExistingFilenameInParent(File file) {
        File[] children;
        String filename = null;
        if (file == null) {
            return filename;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return filename;
        }
        for (File child : children = parent.listFiles()) {
            if (!file.getName().equalsIgnoreCase(child.getName())) continue;
            filename = child.getName();
            break;
        }
        return filename;
    }

    public static void copyStreamsCloseAll(OutputStream writer, InputStream reader) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, n);
        }
        writer.close();
        reader.close();
    }

    public static void copyStreamsCloseAll(Writer writer, Reader reader) throws IOException {
        int n;
        char[] buffer = new char[4096];
        while ((n = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, n);
        }
        writer.close();
        reader.close();
    }
}

