/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.PrefetchableJavaFileObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.Enumerations;

public class FileObjectArchive
implements Archive {
    private static final Logger LOG = Logger.getLogger(FileObjectArchive.class.getName());
    private final FileObject root;
    private volatile Boolean multiRelease;

    public FileObjectArchive(FileObject root) {
        this.root = root;
    }

    @Override
    @NonNull
    public Iterable<JavaFileObject> getFiles(@NonNull String folderName, @NullAllowed ClassPath.Entry entry, @NullAllowed Set<JavaFileObject.Kind> kinds, @NullAllowed JavaFileFilterImplementation filter, boolean recursive) throws IOException {
        ArrayList<JavaFileObject> result;
        Enumeration children;
        FileObject folder = this.root.getFileObject(folderName);
        if (folder == null || entry != null && !entry.includes(folder)) {
            return Collections.emptySet();
        }
        if (recursive) {
            children = Enumerations.filter((Enumeration)folder.getChildren(recursive), (p, x) -> !p.isFolder() && FileObjectArchive.isInJavaPackage(folder, p) ? p : null);
            result = new ArrayList<JavaFileObject>();
        } else {
            Object[] chlds = folder.getChildren();
            children = Enumerations.array((Object[])chlds);
            result = new ArrayList(chlds.length);
        }
        while (children.hasMoreElements()) {
            FileObject fo = (FileObject)children.nextElement();
            if (!fo.isData() || entry != null && !entry.includes(fo)) continue;
            JavaFileObject.Kind kind = FileObjects.getKind(fo.getExt());
            if (kinds != null && !kinds.contains((Object)kind)) continue;
            PrefetchableJavaFileObject file = kind == JavaFileObject.Kind.CLASS ? FileObjects.fileObjectFileObject(fo, this.root, filter, null) : FileObjects.sourceFileObject(fo, this.root, filter, false);
            result.add(file);
        }
        return result;
    }

    @Override
    public JavaFileObject create(String relativePath, JavaFileFilterImplementation filter) {
        throw new UnsupportedOperationException("Write not supported");
    }

    @Override
    public void clear() {
        this.multiRelease = null;
    }

    @Override
    public JavaFileObject getFile(String name) throws IOException {
        FileObject file = this.root.getFileObject(name);
        return file == null ? null : FileObjects.sourceFileObject(file, this.root, null, false);
    }

    @Override
    public boolean isMultiRelease() {
        Boolean res = this.multiRelease;
        if (res == null) {
            block8: {
                res = Boolean.FALSE;
                try {
                    FileObject manifest;
                    if (!(this.root.getFileSystem() instanceof JarFileSystem) || (manifest = this.root.getFileObject("META-INF/MANIFEST.MF")) == null) break block8;
                    try (BufferedInputStream in = new BufferedInputStream(manifest.getInputStream());){
                        res = FileObjects.isMultiVersionArchive(in);
                    }
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, "Cannot read: {0} manifest", FileUtil.getFileDisplayName((FileObject)this.root));
                }
            }
            this.multiRelease = res;
        }
        return res;
    }

    public String toString() {
        return String.format("%s[folder: %s]", this.getClass().getSimpleName(), FileUtil.getFileDisplayName((FileObject)this.root));
    }

    private static boolean isInJavaPackage(@NonNull FileObject root, @NonNull FileObject file) {
        for (FileObject fld = file.getParent(); fld != null && !fld.equals(root); fld = fld.getParent()) {
            if (SourceVersion.isIdentifier(fld.getNameExt())) continue;
            return false;
        }
        return true;
    }
}

