/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.annotate;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AnnotateLine {
    private String author;
    private String revision;
    private String id;
    private String file;
    private Date date;
    private String content;
    private int lineNum = -1;
    private int prevLineNum;
    private String commitMessage;
    private static final Pattern validUserFormat = Pattern.compile("(.+)\\<(.*)\\>.*");
    private boolean canBeRolledBack = true;
    private String username;

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
        this.username = this.parseUsername(author);
    }

    public String getFileName() {
        return this.file;
    }

    public void setFileName(String file) {
        this.file = file;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public Integer getLineNumInteger() {
        return this.lineNum;
    }

    public void setLineNum(int lineNum) {
        this.lineNum = lineNum;
    }

    public boolean canBeRolledBack() {
        return this.canBeRolledBack;
    }

    public void setCanBeRolledBack(boolean canBeRolledBack) {
        this.canBeRolledBack = canBeRolledBack;
    }

    public int getPreviousLineNumber() {
        return this.prevLineNum;
    }

    public void setPrevLineNum(int lineNum) {
        this.prevLineNum = lineNum;
    }

    public String getUsername() {
        if (this.username == null) {
            return "";
        }
        String shortened = this.username;
        if (shortened.length() > 15) {
            shortened = shortened.substring(0, 12) + "...";
        }
        return shortened;
    }

    private String parseUsername(String author) {
        if (author == null) {
            return null;
        }
        String shortened = null;
        String email = this.parseEmail(author);
        if (email != null && !email.isEmpty()) {
            int pos = email.indexOf(64);
            shortened = pos > -1 ? email.substring(0, pos) : email;
        }
        if (shortened == null) {
            shortened = author;
        }
        return shortened;
    }

    private String parseEmail(String author) {
        String mail = author;
        Matcher m = validUserFormat.matcher(author.trim());
        if (m.matches()) {
            mail = m.groupCount() > 1 ? (m.group(2) != null ? m.group(2) : "") : "";
            mail = mail.trim();
        }
        return mail;
    }
}

