/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.hierarchy;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.java.navigation.actions.NameActions;
import org.netbeans.modules.java.navigation.actions.SortActions;
import org.netbeans.modules.java.navigation.base.Utils;
import org.netbeans.modules.java.navigation.hierarchy.Bundle;
import org.netbeans.modules.java.navigation.hierarchy.HierarchyFilters;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class Nodes {
    private static final String INSPECT_HIERARCHY_ACTION = "Actions/Edit/org-netbeans-modules-java-navigation-actions-ShowHierarchyAction.instance";
    private static final String ICON = "org/netbeans/modules/java/navigation/resources/wait.gif";
    private static final String ACTION_FOLDER = "Navigator/Actions/Hierarchy/text/x-java";
    private static final WaitNode WAIT_NODE = new WaitNode();

    private Nodes() {
        throw new IllegalStateException();
    }

    static Node rootNode(@NonNull Children cld, @NonNull HierarchyFilters filters) {
        assert (filters != null);
        return new RootNode(cld, Nodes.globalActions(filters));
    }

    static Node waitNode() {
        return WAIT_NODE;
    }

    static Node superTypeHierarchy(@NonNull DeclaredType type, @NonNull ClasspathInfo cpInfo, @NonNull HierarchyFilters filters) {
        assert (type != null);
        assert (cpInfo != null);
        assert (filters != null);
        return Nodes.superTypeHierarchy(type, cpInfo, filters, 0);
    }

    private static Node superTypeHierarchy(@NonNull DeclaredType type, @NonNull ClasspathInfo cpInfo, @NonNull HierarchyFilters filters, int order) {
        Object cld;
        TypeElement element = (TypeElement)type.asElement();
        TypeMirror superClass = element.getSuperclass();
        List<? extends TypeMirror> interfaces = element.getInterfaces();
        ArrayList<Node> childNodes = new ArrayList<Node>(interfaces.size() + 1);
        int childOrder = 0;
        if (superClass.getKind() != TypeKind.NONE) {
            childNodes.add(Nodes.superTypeHierarchy((DeclaredType)superClass, cpInfo, filters, childOrder));
        }
        for (TypeMirror typeMirror : interfaces) {
            childNodes.add(Nodes.superTypeHierarchy((DeclaredType)typeMirror, cpInfo, filters, ++childOrder));
        }
        if (childNodes.isEmpty()) {
            cld = Children.LEAF;
        } else {
            cld = new SuperTypeChildren(filters);
            cld.add(childNodes.toArray(new Node[childNodes.size()]));
        }
        return new TypeNode((Children)cld, new Description(cpInfo, (ElementHandle<TypeElement>)ElementHandle.create((Element)element), order), filters, Nodes.globalActions(filters));
    }

    private static Action[] globalActions(@NonNull HierarchyFilters filters) {
        return new Action[]{NameActions.createFullyQualifiedNameAction(filters), SortActions.createSortByNameAction(filters), SortActions.createSortBySourceAction(filters)};
    }

    static Node subTypeHierarchy(@NonNull TypeElement element, @NonNull CompilationInfo info, @NonNull HierarchyFilters filters, @NonNull AtomicBoolean cancel) {
        try {
            boolean isSourceRoot = true;
            FileObject thisRoot = Nodes.findSourceRoot(SourceUtils.getFile((Element)element, (ClasspathInfo)info.getClasspathInfo()));
            if (thisRoot == null) {
                thisRoot = Nodes.findBinaryRoot(element, info);
                isSourceRoot = false;
            }
            if (thisRoot == null) {
                return null;
            }
            ElementHandle elementHandle = ElementHandle.create((Element)element);
            TypeDescription td = new TypeDescription(info.getClasspathInfo(), (ElementHandle<TypeElement>)elementHandle);
            Map<TypeDescription, Set<TypeDescription>> subclassesJoined = new ComputeSubClasses(cancel).computeUsers(info, thisRoot, Collections.singleton(td), new long[1], false, isSourceRoot);
            if (subclassesJoined == null) {
                return null;
            }
            List inOrder = Utilities.topologicalSort(subclassesJoined.keySet(), subclassesJoined);
            Collections.reverse(inOrder);
            HashMap<TypeDescription, TypeNode> type2Node = new HashMap<TypeDescription, TypeNode>();
            for (TypeDescription toProcess : inOrder) {
                Object cld;
                Set<TypeDescription> subclasses = subclassesJoined.get(toProcess);
                ArrayList<FilterNode> childNodes = new ArrayList<FilterNode>(subclasses.size());
                for (TypeDescription subclass : subclasses) {
                    FilterNode subNode = new FilterNode((Node)type2Node.get(subclass));
                    assert (subNode != null);
                    childNodes.add(subNode);
                }
                if (childNodes.isEmpty()) {
                    cld = Children.LEAF;
                } else {
                    cld = new SuperTypeChildren(filters);
                    cld.add(childNodes.toArray(new Node[childNodes.size()]));
                }
                type2Node.put(toProcess, new TypeNode((Children)cld, new Description(toProcess.cpInfo, (ElementHandle<TypeElement>)toProcess.element, 0), filters, new Action[0]));
            }
            return (Node)type2Node.get(td);
        }
        catch (TopologicalSortException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static FileObject findSourceRoot(FileObject file) {
        ClassPath cp = file != null ? ClassPath.getClassPath((FileObject)file, (String)"classpath/source") : null;
        return cp != null ? cp.findOwnerRoot(file) : null;
    }

    @CheckForNull
    private static FileObject findBinaryRoot(@NonNull TypeElement element, @NonNull CompilationInfo info) {
        FileObject res = Nodes.findBinaryInCp(info.getElements(), element, info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT));
        if (res != null) {
            return res;
        }
        return Nodes.findBinaryInCp(info.getElements(), element, info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE));
    }

    @CheckForNull
    private static FileObject findBinaryInCp(@NonNull Elements elements, @NonNull TypeElement element, @NonNull ClassPath cp) {
        FileObject file = cp.findResource(String.format("%s.class", elements.getBinaryName(element).toString().replace('.', '/')));
        return file == null ? null : cp.findOwnerRoot(file);
    }

    private static String getSimpleName(@NonNull String fqn) {
        int sepIndex = fqn.lastIndexOf(36);
        if (sepIndex == -1) {
            sepIndex = fqn.lastIndexOf(46);
        }
        return sepIndex >= 0 ? fqn.substring(sepIndex + 1) : fqn;
    }

    private static final class TypeDescription {
        private final ClasspathInfo cpInfo;
        private final ElementHandle<TypeElement> element;

        public TypeDescription(ClasspathInfo cpInfo, ElementHandle<TypeElement> element) {
            this.cpInfo = cpInfo;
            this.element = element;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.cpInfo != null ? this.cpInfo.hashCode() : 0);
            hash = 79 * hash + (this.element != null ? this.element.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeDescription other = (TypeDescription)obj;
            if (!(this.cpInfo == other.cpInfo || this.cpInfo != null && this.cpInfo.equals((Object)other.cpInfo))) {
                return false;
            }
            return this.element == other.element || this.element != null && this.element.equals(other.element);
        }
    }

    static final class ComputeSubClasses {
        private final AtomicBoolean cancel;
        private static final Logger LOG = Logger.getLogger(Nodes.class.getName());
        static Map<URL, List<URL>> dependenciesOverride;
        static Map<URL, List<URL>> rootPeers;
        static List<URL> reverseSourceRootsInOrderOverride;

        public ComputeSubClasses(AtomicBoolean cancel) {
            this.cancel = cancel;
        }

        Map<TypeDescription, Set<TypeDescription>> computeUsers(CompilationInfo info, FileObject thisRoot, Set<TypeDescription> baseHandles, long[] classIndexCumulative, boolean interactive, boolean isSourceRoot) {
            Map<URL, List<URL>> rootPeers;
            Map<URL, List<URL>> sourceDeps = ComputeSubClasses.getDependencies(false);
            Map<URL, List<URL>> binaryDeps = ComputeSubClasses.getDependencies(true);
            if (sourceDeps == null || binaryDeps == null) {
                LOG.log(Level.FINE, "No dependencies");
                return null;
            }
            URL thisRootURL = thisRoot.toURL();
            List<URL> sourceRoots = this.reverseSourceRootsInOrder(info, thisRootURL, thisRoot, sourceDeps, binaryDeps, rootPeers = ComputeSubClasses.getRootPeers(), interactive, isSourceRoot);
            if (sourceRoots == null) {
                return null;
            }
            baseHandles = new HashSet<TypeDescription>(baseHandles);
            Iterator<TypeDescription> it = baseHandles.iterator();
            while (it.hasNext()) {
                if (this.cancel.get()) {
                    return null;
                }
                if (!it.next().element.getBinaryName().contentEquals("java.lang.Object")) continue;
                it.remove();
                break;
            }
            HashMap<TypeDescription, Set<TypeDescription>> result = new HashMap<TypeDescription, Set<TypeDescription>>();
            HashMap<TypeDescription, Set<TypeDescription>> auxHandles = new HashMap<TypeDescription, Set<TypeDescription>>();
            if (!sourceDeps.containsKey(thisRootURL)) {
                HashSet<URL> binaryRoots = new HashSet<URL>();
                for (URL sr : sourceRoots) {
                    List<URL> deps = sourceDeps.get(sr);
                    if (deps == null) continue;
                    binaryRoots.addAll(deps);
                }
                binaryRoots.retainAll(binaryDeps.keySet());
                for (TypeDescription handle : baseHandles) {
                    Set<TypeDescription> types = this.computeUsers(ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPathSupport.createClassPath((URL[])binaryRoots.toArray(new URL[0])), (ClassPath)ClassPath.EMPTY), ClassIndex.SearchScope.DEPENDENCIES, Collections.singleton(handle), classIndexCumulative, result);
                    if (types == null || this.cancel.get()) {
                        return null;
                    }
                    auxHandles.put(handle, types);
                }
            }
            LinkedHashMap<URL, LinkedHashMap<TypeDescription, Set<TypeDescription>>> root2SubClasses = new LinkedHashMap<URL, LinkedHashMap<TypeDescription, Set<TypeDescription>>>();
            for (URL file : sourceRoots) {
                for (TypeDescription base : baseHandles) {
                    if (this.cancel.get()) {
                        return null;
                    }
                    HashSet<TypeDescription> baseTypes = new HashSet<TypeDescription>();
                    baseTypes.add(base);
                    Set aux = (Set)auxHandles.get(base);
                    if (aux != null) {
                        baseTypes.addAll(aux);
                    }
                    for (URL dep : sourceDeps.get(file)) {
                        Map depTypesMulti = (Map)root2SubClasses.get(dep);
                        Set depTypes = depTypesMulti != null ? (Set)depTypesMulti.get(base) : null;
                        if (depTypes == null) continue;
                        baseTypes.addAll(depTypes);
                    }
                    Set<TypeDescription> types = this.computeUsers(file, baseTypes, classIndexCumulative, result);
                    if (types == null || this.cancel.get()) {
                        return null;
                    }
                    types.removeAll(baseTypes);
                    LinkedHashMap<TypeDescription, Set<TypeDescription>> currentUsers = (LinkedHashMap<TypeDescription, Set<TypeDescription>>)root2SubClasses.get(file);
                    if (currentUsers == null) {
                        currentUsers = new LinkedHashMap<TypeDescription, Set<TypeDescription>>();
                        root2SubClasses.put(file, currentUsers);
                    }
                    currentUsers.put(base, types);
                }
            }
            return result;
        }

        private static Map<URL, List<URL>> getDependencies(boolean binary) {
            if (dependenciesOverride != null) {
                return dependenciesOverride;
            }
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                return null;
            }
            Class<?> clazz = null;
            String method = null;
            try {
                clazz = l.loadClass("org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController");
                method = binary ? "getBinaryRootDependencies" : "getRootDependencies";
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.FINE, null, ex);
                try {
                    clazz = l.loadClass("org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater");
                    method = binary ? "getDependencies" : "doesnotexist";
                }
                catch (ClassNotFoundException inner) {
                    LOG.log(Level.FINE, null, inner);
                    return null;
                }
            }
            try {
                Method getDefault = clazz.getDeclaredMethod("getDefault", new Class[0]);
                Object instance = getDefault.invoke(null, new Object[0]);
                Method dependenciesMethod = clazz.getDeclaredMethod(method, new Class[0]);
                return (Map)dependenciesMethod.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
            catch (InvocationTargetException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
            catch (NoSuchMethodException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
            catch (SecurityException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
            catch (ClassCastException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
        }

        private static Map<URL, List<URL>> getRootPeers() {
            if (rootPeers != null) {
                return rootPeers;
            }
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                return null;
            }
            Class<?> clazz = null;
            String method = null;
            try {
                clazz = l.loadClass("org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController");
                method = "getRootPeers";
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
            try {
                Method getDefault = clazz.getDeclaredMethod("getDefault", new Class[0]);
                Object instance = getDefault.invoke(null, new Object[0]);
                Method peersMethod = clazz.getDeclaredMethod(method, new Class[0]);
                return (Map)peersMethod.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
            catch (InvocationTargetException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
            catch (NoSuchMethodException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
            catch (SecurityException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
            catch (ClassCastException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
        }

        private List<URL> reverseSourceRootsInOrder(CompilationInfo info, URL thisRoot, FileObject thisRootFO, Map<URL, List<URL>> sourceDeps, Map<URL, List<URL>> binaryDeps, Map<URL, List<URL>> rootPeers, boolean interactive, boolean isSourceRoot) {
            LinkedList<URL> sourceRoots;
            Set<Object> sourceRootsSet;
            if (reverseSourceRootsInOrderOverride != null) {
                return reverseSourceRootsInOrderOverride;
            }
            if (sourceDeps.containsKey(thisRoot)) {
                sourceRootsSet = ComputeSubClasses.findReverseSourceRoots(thisRoot, sourceDeps, rootPeers, info.getFileObject());
            } else {
                sourceRootsSet = new HashSet();
                for (URL binary : this.findBinaryRootsForSourceRoot(thisRootFO, binaryDeps, isSourceRoot)) {
                    List<URL> deps = binaryDeps.get(binary);
                    if (deps == null) continue;
                    sourceRootsSet.addAll(deps);
                }
            }
            try {
                sourceRoots = new LinkedList<URL>(Utilities.topologicalSort(sourceDeps.keySet(), sourceDeps));
            }
            catch (TopologicalSortException ex) {
                if (interactive) {
                    Exceptions.printStackTrace((Throwable)ex);
                } else {
                    LOG.log(Level.FINE, null, ex);
                }
                return null;
            }
            sourceRoots.retainAll(sourceRootsSet);
            Collections.reverse(sourceRoots);
            return sourceRoots;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Set<URL> findReverseSourceRoots(URL thisSourceRoot, Map<URL, List<URL>> sourceDeps, Map<URL, List<URL>> rootPeers, FileObject thisFile) {
            HashSet<URL> hashSet;
            long startTime = System.currentTimeMillis();
            try {
                List<URL> peers;
                HashMap<URL, ArrayList<URL>> inverseDeps = new HashMap<URL, ArrayList<URL>>();
                for (Map.Entry<URL, List<URL>> entry : sourceDeps.entrySet()) {
                    URL u1 = entry.getKey();
                    List<URL> l1 = entry.getValue();
                    for (URL u2 : l1) {
                        ArrayList<URL> l2 = (ArrayList<URL>)inverseDeps.get(u2);
                        if (l2 == null) {
                            l2 = new ArrayList<URL>();
                            inverseDeps.put(u2, l2);
                        }
                        l2.add(u1);
                    }
                }
                HashSet<URL> result = new HashSet<URL>();
                LinkedList<URL> todo = new LinkedList<URL>();
                todo.add(thisSourceRoot);
                List<URL> list = peers = rootPeers != null ? rootPeers.get(thisSourceRoot) : null;
                if (peers != null) {
                    todo.addAll(peers);
                }
                while (!todo.isEmpty()) {
                    URL u = (URL)todo.removeFirst();
                    if (result.contains(u)) continue;
                    result.add(u);
                    List ideps = (List)inverseDeps.get(u);
                    if (ideps == null) continue;
                    todo.addAll(ideps);
                }
                hashSet = result;
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                Logger.getLogger("TIMER").log(Level.FINE, "Find Reverse Source Roots", new Object[]{thisFile, endTime - startTime});
                throw throwable;
            }
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Find Reverse Source Roots", new Object[]{thisFile, endTime - startTime});
            return hashSet;
        }

        private Set<URL> findBinaryRootsForSourceRoot(FileObject root, Map<URL, List<URL>> binaryDeps, boolean isSourceRoot) {
            HashSet<URL> result = new HashSet<URL>();
            if (isSourceRoot) {
                for (URL bin : binaryDeps.keySet()) {
                    if (this.cancel.get()) {
                        return Collections.emptySet();
                    }
                    for (FileObject s : SourceForBinaryQuery.findSourceRoots((URL)bin).getRoots()) {
                        if (s != root) continue;
                        result.add(bin);
                    }
                }
            } else if (binaryDeps.containsKey(root.toURL())) {
                result.add(root.toURL());
            }
            return result;
        }

        private Set<TypeDescription> computeUsers(URL source, Set<TypeDescription> base, long[] classIndexCumulative, Map<TypeDescription, Set<TypeDescription>> output) {
            ClasspathInfo cpinfo = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[]{source}));
            return this.computeUsers(cpinfo, ClassIndex.SearchScope.SOURCE, base, classIndexCumulative, output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<TypeDescription> computeUsers(ClasspathInfo cpinfo, ClassIndex.SearchScope scope, Set<TypeDescription> base, long[] classIndexCumulative, Map<TypeDescription, Set<TypeDescription>> output) {
            long startTime = System.currentTimeMillis();
            try {
                HashSet<TypeDescription> hashSet;
                LinkedList<TypeDescription> l = new LinkedList<TypeDescription>(base);
                HashSet<TypeDescription> result = new HashSet<TypeDescription>();
                while (!l.isEmpty()) {
                    if (this.cancel.get()) {
                        hashSet = null;
                        return hashSet;
                    }
                    TypeDescription eh = (TypeDescription)l.remove(0);
                    result.add(eh);
                    Set typeElements = cpinfo.getClassIndex().getElements(eh.element, Collections.singleton(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(scope));
                    if (typeElements == null) continue;
                    Set<TypeDescription> outputElements = output.get(eh);
                    if (outputElements == null) {
                        outputElements = new HashSet<TypeDescription>();
                        output.put(eh, outputElements);
                    }
                    for (ElementHandle te : typeElements) {
                        TypeDescription currentTD = new TypeDescription(cpinfo, (ElementHandle<TypeElement>)te);
                        outputElements.add(currentTD);
                        l.add(currentTD);
                    }
                }
                hashSet = result;
                return hashSet;
            }
            finally {
                classIndexCumulative[0] = classIndexCumulative[0] + (System.currentTimeMillis() - startTime);
            }
        }
    }

    private static final class OrderComparator
    implements Comparator<Node> {
        private OrderComparator() {
        }

        @Override
        public int compare(Node n1, Node n2) {
            int o2;
            int o1 = ((Description)n1.getLookup().lookup(Description.class)).getSourceOrder();
            return o1 < (o2 = ((Description)n2.getLookup().lookup(Description.class)).getSourceOrder()) ? -1 : (o1 == o2 ? 0 : 1);
        }
    }

    private static final class LexicographicComparator
    implements Comparator<Node> {
        private LexicographicComparator() {
        }

        @Override
        public int compare(Node n1, Node n2) {
            return n1.getDisplayName().compareTo(n2.getDisplayName());
        }
    }

    private static class SuperTypeChildren
    extends Children.SortedArray
    implements PropertyChangeListener {
        private final HierarchyFilters hierarchy;

        SuperTypeChildren(@NonNull HierarchyFilters filters) {
            assert (filters != null);
            this.hierarchy = filters;
            this.hierarchy.addPropertyChangeListener(this);
            this.updateComparator();
        }

        private void updateComparator() {
            if (this.hierarchy.isNaturalSort()) {
                this.setComparator(new OrderComparator());
            } else {
                this.setComparator(new LexicographicComparator());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("naturalSort".equals(evt.getPropertyName())) {
                this.updateComparator();
            } else if (!this.hierarchy.isNaturalSort() && "fqn".equals(evt.getPropertyName())) {
                this.updateComparator();
            }
        }
    }

    private static final class TypeNode
    extends AbstractNode
    implements PropertyChangeListener {
        private final Description description;
        private final HierarchyFilters filters;
        private final Action[] globalActions;
        private Action openAction;
        private static final InstanceContent.Convertor<Description, TreePathHandle> ConvertDescription2TreePathHandle = new InstanceContent.Convertor<Description, TreePathHandle>(){

            public TreePathHandle convert(Description desc) {
                return TreePathHandle.from(desc.getHandle(), (ClasspathInfo)desc.getClasspathInfo());
            }

            public Class<? extends TreePathHandle> type(Description desc) {
                return TreePathHandle.class;
            }

            public String id(Description desc) {
                return "IL[" + desc.toString();
            }

            public String displayName(Description desc) {
                return this.id(desc);
            }
        };
        private static final InstanceContent.Convertor<Description, FileObject> ConvertDescription2FileObject = new InstanceContent.Convertor<Description, FileObject>(){

            public FileObject convert(Description desc) {
                return Utils.getFile(desc.getHandle(), desc.getClasspathInfo());
            }

            public Class<? extends FileObject> type(Description desc) {
                return FileObject.class;
            }

            public String id(Description desc) {
                return "IL[" + desc.toString();
            }

            public String displayName(Description desc) {
                return this.id(desc);
            }
        };
        private static final InstanceContent.Convertor<Description, DataObject> ConvertDescription2DataObject = new InstanceContent.Convertor<Description, DataObject>(){

            public DataObject convert(Description desc) {
                try {
                    FileObject file = Utils.getFile(desc.getHandle(), desc.getClasspathInfo());
                    return file == null ? null : DataObject.find((FileObject)file);
                }
                catch (DataObjectNotFoundException ex) {
                    return null;
                }
            }

            public Class<? extends DataObject> type(Description desc) {
                return DataObject.class;
            }

            public String id(Description desc) {
                return "IL[" + desc.toString();
            }

            public String displayName(Description desc) {
                return this.id(desc);
            }
        };

        TypeNode(@NonNull Children cld, @NonNull Description description, @NonNull HierarchyFilters filters, @NonNull Action[] globalActions) {
            super(cld, TypeNode.createLookup(description));
            assert (description != null);
            assert (filters != null);
            assert (globalActions != null);
            this.description = description;
            this.filters = filters;
            this.globalActions = globalActions;
            this.filters.addPropertyChangeListener(this);
            this.updateDisplayName();
        }

        public String getShortDescription() {
            if (this.filters.isFqn()) {
                return super.getShortDescription();
            }
            return this.description.getHandle().getQualifiedName();
        }

        public Image getIcon(int type) {
            return ImageUtilities.icon2Image((Icon)ElementIcons.getElementIcon((ElementKind)this.description.getHandle().getKind(), EnumSet.noneOf(Modifier.class)));
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("fqn".equals(evt.getPropertyName())) {
                this.updateDisplayName();
            }
        }

        public Action[] getActions(boolean context) {
            if (context) {
                return this.globalActions;
            }
            List additionalActions = Utilities.actionsForPath((String)Nodes.ACTION_FOLDER);
            int additionalActionSize = additionalActions.isEmpty() ? 0 : additionalActions.size() + 1;
            ArrayList<Action> actions = new ArrayList<Action>(4 + this.globalActions.length + additionalActionSize);
            actions.add(this.getOpenAction());
            actions.add((Action)FileUtil.getConfigObject((String)Nodes.INSPECT_HIERARCHY_ACTION, Action.class));
            actions.add((Action)RefactoringActionsFactory.whereUsedAction());
            actions.add(null);
            if (additionalActionSize > 0) {
                actions.addAll(additionalActions);
                actions.add(null);
            }
            actions.addAll(Arrays.asList(this.globalActions));
            return actions.toArray(new Action[actions.size()]);
        }

        public Action getPreferredAction() {
            return this.getOpenAction();
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public PasteType getDropType(Transferable t, int action, int index) {
            return null;
        }

        public Transferable drag() throws IOException {
            return null;
        }

        protected void createPasteTypes(Transferable t, List<PasteType> s) {
        }

        private synchronized Action getOpenAction() {
            if (this.openAction == null) {
                this.openAction = new OpenAction();
            }
            return this.openAction;
        }

        private void updateDisplayName() {
            String name = this.description.handle.getQualifiedName();
            if (!this.filters.isFqn()) {
                name = Nodes.getSimpleName(name);
            }
            this.setDisplayName(name);
        }

        @NonNull
        private static Lookup createLookup(@NonNull Description desc) {
            InstanceContent ic = new InstanceContent();
            ic.add((Object)desc);
            ic.add((Object)desc, ConvertDescription2TreePathHandle);
            ic.add((Object)desc, ConvertDescription2FileObject);
            ic.add((Object)desc, ConvertDescription2DataObject);
            return new AbstractLookup((AbstractLookup.Content)ic);
        }

        private class OpenAction
        extends AbstractAction {
            OpenAction() {
                this.putValue("Name", Bundle.LBL_GoTo());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ElementOpen.open((ClasspathInfo)TypeNode.this.description.getClasspathInfo(), TypeNode.this.description.getHandle())) {
                    Toolkit.getDefaultToolkit().beep();
                    StatusDisplayer.getDefault().setStatusText(Bundle.MSG_NoSource(TypeNode.this.description.getHandle().getQualifiedName()));
                }
            }
        }
    }

    private static class WaitNode
    extends AbstractNode {
        WaitNode() {
            super(Children.LEAF);
            this.setIconBaseWithExtension(Nodes.ICON);
            this.setDisplayName(Bundle.LBL_PleaseWait());
        }
    }

    private static class RootNode
    extends AbstractNode {
        private Action[] globalActions;

        RootNode(@NonNull Children cld, @NonNull Action[] globalActions) {
            super(cld);
            assert (globalActions != null);
            this.globalActions = globalActions;
        }

        public Action[] getActions(boolean context) {
            return this.globalActions;
        }
    }

    private static final class Description {
        private final ClasspathInfo cpInfo;
        private final ElementHandle<TypeElement> handle;
        private final int order;

        Description(@NonNull ClasspathInfo cpInfo, @NonNull ElementHandle<TypeElement> handle, int order) {
            assert (cpInfo != null);
            assert (handle != null);
            this.cpInfo = cpInfo;
            this.handle = handle;
            this.order = order;
        }

        ClasspathInfo getClasspathInfo() {
            return this.cpInfo;
        }

        ElementHandle<TypeElement> getHandle() {
            return this.handle;
        }

        int getSourceOrder() {
            return this.order;
        }
    }
}

