/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser.processors;

import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstanceCopy;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.FxReference;
import org.netbeans.modules.javafx2.editor.completion.model.TextPositions;
import org.netbeans.modules.javafx2.editor.parser.BuildEnvironment;
import org.netbeans.modules.javafx2.editor.parser.ModelBuilderStep;
import org.netbeans.modules.javafx2.editor.parser.processors.Bundle;

public class ReferenceResolver
extends FxNodeVisitor.ModelTraversal
implements ModelBuilderStep {
    private BuildEnvironment env;

    public ReferenceResolver() {
    }

    ReferenceResolver(BuildEnvironment env) {
        this.env = env;
    }

    private void reportError(FxNode decl, String id) {
        int end;
        int start;
        int[] attributePos = this.env.getTreeUtilities().findAttributePos(decl, null, "source", true);
        if (attributePos == null) {
            TextPositions pos = this.env.getTreeUtilities().positions(decl);
            start = pos.getStart();
            end = pos.isDefined(TextPositions.Position.ContentStart) ? pos.getContentStart() : pos.getEnd();
        } else {
            start = attributePos[0];
            end = attributePos[1];
        }
        this.env.addError(ErrorMark.makeError(start, end - start, "unresolved-source-id", Bundle.ERR_unresolvedReferenceTarget(id), decl));
    }

    @Override
    public void visitCopy(FxInstanceCopy decl) {
        if (decl.getBlueprintId() != null) {
            FxInstance inst = this.env.getModel().getInstance(decl.getBlueprintId());
            if (inst == null) {
                this.reportError(decl, decl.getBlueprintId());
                this.env.getAccessor().makeBroken(decl);
            } else {
                this.env.getAccessor().resolveReference(decl, inst);
            }
        } else {
            this.env.getAccessor().makeBroken(decl);
        }
        super.visitCopy(decl);
    }

    @Override
    public void visitReference(FxReference decl) {
        if (decl.getTargetId() != null) {
            FxInstance inst = this.env.getModel().getInstance(decl.getTargetId());
            if (inst == null) {
                this.reportError(decl, decl.getTargetId());
                this.env.getAccessor().makeBroken(decl);
            } else {
                this.env.getAccessor().resolveReference(decl, inst);
            }
        } else {
            this.env.getAccessor().makeBroken(decl);
        }
        super.visitReference(decl);
    }

    @Override
    public FxNodeVisitor createVisitor(BuildEnvironment env) {
        return new ReferenceResolver(env);
    }
}

