/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * greaterThan(dvec4(-1.5lf, -1.5lf, -1.5lf, -1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(false, false, false, false)
 * greaterThan(dvec4(-0.5lf, -0.5lf, -0.5lf, -0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(true, false, false, false)
 * greaterThan(dvec4(0.5lf, 0.5lf, 0.5lf, 0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(true, true, false, false)
 * greaterThan(dvec4(1.5lf, 1.5lf, 1.5lf, 1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(true, true, true, false)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[all(equal(greaterThan(dvec4(-1.5lf, -1.5lf, -1.5lf, -1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)), bvec4(false, false, false, false))) ? 1 : -1] array0;
  double[all(equal(greaterThan(dvec4(-0.5lf, -0.5lf, -0.5lf, -0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)), bvec4(true, false, false, false))) ? 1 : -1] array1;
  double[all(equal(greaterThan(dvec4(0.5lf, 0.5lf, 0.5lf, 0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)), bvec4(true, true, false, false))) ? 1 : -1] array2;
  double[all(equal(greaterThan(dvec4(1.5lf, 1.5lf, 1.5lf, 1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)), bvec4(true, true, true, false))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
