/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(-64, 72, 88, -76) | (- 12)) => ivec4(-12, -4, -4, -12)
 * (ivec4(-64, 72, 88, -76) | (- -6)) => ivec4(-58, 78, 94, -74)
 * (ivec4(-64, 72, 88, -76) | (- 76)) => ivec4(-12, -4, -4, -76)
 * (ivec4(-64, 72, 88, -76) | (- -32)) => ivec4(-32, 104, 120, -76)
 * (ivec4(-64, 72, 88, -76) | (- 0)) => ivec4(-64, 72, 88, -76)
 * (ivec4(64, 72, 88, 76) | (- 12)) => ivec4(-12, -4, -4, -4)
 * (ivec4(64, 72, 88, 76) | (- -6)) => ivec4(70, 78, 94, 78)
 * (ivec4(64, 72, 88, 76) | (- 76)) => ivec4(-12, -4, -4, -4)
 * (ivec4(64, 72, 88, 76) | (- -32)) => ivec4(96, 104, 120, 108)
 * (ivec4(64, 72, 88, 76) | (- 0)) => ivec4(64, 72, 88, 76)
 * (ivec4(-24, 40, -23, 64) | (- 12)) => ivec4(-4, -4, -3, -12)
 * (ivec4(-24, 40, -23, 64) | (- -6)) => ivec4(-18, 46, -17, 70)
 * (ivec4(-24, 40, -23, 64) | (- 76)) => ivec4(-4, -68, -3, -12)
 * (ivec4(-24, 40, -23, 64) | (- -32)) => ivec4(-24, 40, -23, 96)
 * (ivec4(-24, 40, -23, 64) | (- 0)) => ivec4(-24, 40, -23, 64)
 * (ivec4(24, 40, 23, 64) | (- 12)) => ivec4(-4, -4, -9, -12)
 * (ivec4(24, 40, 23, 64) | (- -6)) => ivec4(30, 46, 23, 70)
 * (ivec4(24, 40, 23, 64) | (- 76)) => ivec4(-68, -68, -73, -12)
 * (ivec4(24, 40, 23, 64) | (- -32)) => ivec4(56, 40, 55, 96)
 * (ivec4(24, 40, 23, 64) | (- 0)) => ivec4(24, 40, 23, 64)
 */
#version 130

void main()
{
  float[all(equal((ivec4(-64, 72, 88, -76) | (- 12)), ivec4(-12, -4, -4, -12))) ? 1 : -1] array0;
  float[all(equal((ivec4(-64, 72, 88, -76) | (- -6)), ivec4(-58, 78, 94, -74))) ? 1 : -1] array1;
  float[all(equal((ivec4(-64, 72, 88, -76) | (- 76)), ivec4(-12, -4, -4, -76))) ? 1 : -1] array2;
  float[all(equal((ivec4(-64, 72, 88, -76) | (- -32)), ivec4(-32, 104, 120, -76))) ? 1 : -1] array3;
  float[all(equal((ivec4(-64, 72, 88, -76) | (- 0)), ivec4(-64, 72, 88, -76))) ? 1 : -1] array4;
  float[all(equal((ivec4(64, 72, 88, 76) | (- 12)), ivec4(-12, -4, -4, -4))) ? 1 : -1] array5;
  float[all(equal((ivec4(64, 72, 88, 76) | (- -6)), ivec4(70, 78, 94, 78))) ? 1 : -1] array6;
  float[all(equal((ivec4(64, 72, 88, 76) | (- 76)), ivec4(-12, -4, -4, -4))) ? 1 : -1] array7;
  float[all(equal((ivec4(64, 72, 88, 76) | (- -32)), ivec4(96, 104, 120, 108))) ? 1 : -1] array8;
  float[all(equal((ivec4(64, 72, 88, 76) | (- 0)), ivec4(64, 72, 88, 76))) ? 1 : -1] array9;
  float[all(equal((ivec4(-24, 40, -23, 64) | (- 12)), ivec4(-4, -4, -3, -12))) ? 1 : -1] array10;
  float[all(equal((ivec4(-24, 40, -23, 64) | (- -6)), ivec4(-18, 46, -17, 70))) ? 1 : -1] array11;
  float[all(equal((ivec4(-24, 40, -23, 64) | (- 76)), ivec4(-4, -68, -3, -12))) ? 1 : -1] array12;
  float[all(equal((ivec4(-24, 40, -23, 64) | (- -32)), ivec4(-24, 40, -23, 96))) ? 1 : -1] array13;
  float[all(equal((ivec4(-24, 40, -23, 64) | (- 0)), ivec4(-24, 40, -23, 64))) ? 1 : -1] array14;
  float[all(equal((ivec4(24, 40, 23, 64) | (- 12)), ivec4(-4, -4, -9, -12))) ? 1 : -1] array15;
  float[all(equal((ivec4(24, 40, 23, 64) | (- -6)), ivec4(30, 46, 23, 70))) ? 1 : -1] array16;
  float[all(equal((ivec4(24, 40, 23, 64) | (- 76)), ivec4(-68, -68, -73, -12))) ? 1 : -1] array17;
  float[all(equal((ivec4(24, 40, 23, 64) | (- -32)), ivec4(56, 40, 55, 96))) ? 1 : -1] array18;
  float[all(equal((ivec4(24, 40, 23, 64) | (- 0)), ivec4(24, 40, 23, 64))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
