# frozen_string_literal: true

##
#
# Makes a small pie graph suitable for display at 200px or even smaller.
#
module Gruff
  module Mini
    class Pie < Gruff::Pie
      include Gruff::Mini::Legend

      def initialize_ivars
        super

        @hide_legend = true
        @hide_title = true
        @hide_line_numbers = true

        @marker_font_size = 60.0
        @legend_font_size = 60.0
      end
      private :initialize_ivars

      def draw
        expand_canvas_for_vertical_legend

        super

        draw_vertical_legend

        Gruff::Renderer.finish
      end
    end
  end
end
