/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.ArrayList;
import java.util.List;
import org.jparsec.internal.util.Lists;

abstract class ListFactory<T> {
    private static final ListFactory ARRAY_LIST_FACTORY = new ListFactory<Object>(){

        @Override
        List<Object> newList() {
            return Lists.arrayList();
        }
    };

    ListFactory() {
    }

    abstract List<T> newList();

    static <T> ListFactory<T> arrayListFactory() {
        return ARRAY_LIST_FACTORY;
    }

    static <T> ListFactory<T> arrayListFactoryWithFirstElement(final T first) {
        return new ListFactory<T>(){

            @Override
            List<T> newList() {
                ArrayList list = Lists.arrayList();
                list.add(first);
                return list;
            }
        };
    }
}

