/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import org.jparsec.NestableBlockCommentScanner;
import org.jparsec.ParseContext;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.ScannerState;
import org.jparsec.pattern.CharPredicate;
import org.jparsec.pattern.CharPredicates;
import org.jparsec.pattern.Pattern;
import org.jparsec.pattern.Patterns;

public final class Scanners {
    public static final Parser<Void> WHITESPACES = Patterns.many1(CharPredicates.IS_WHITESPACE).toScanner("whitespaces");
    public static final Parser<Void> ANY_CHAR = new Parser<Void>(){

        @Override
        boolean apply(ParseContext ctxt) {
            if (ctxt.isEof()) {
                ctxt.missing("any character");
                return false;
            }
            ctxt.next();
            ctxt.result = null;
            return true;
        }

        public String toString() {
            return "any character";
        }
    };
    public static final Parser<Void> JAVA_LINE_COMMENT = Scanners.lineComment("//");
    public static final Parser<Void> SQL_LINE_COMMENT = Scanners.lineComment("--");
    public static final Parser<Void> HASKELL_LINE_COMMENT = Scanners.lineComment("--");
    private static final Parser<Void> JAVA_BLOCK_COMMENTED = Scanners.notChar2('*', '/').many().toScanner("commented block");
    public static final Parser<Void> JAVA_BLOCK_COMMENT = Parsers.sequence(Scanners.string("/*"), JAVA_BLOCK_COMMENTED, Scanners.string("*/"));
    public static final Parser<Void> SQL_BLOCK_COMMENT = Parsers.sequence(Scanners.string("/*"), JAVA_BLOCK_COMMENTED, Scanners.string("*/"));
    public static final Parser<Void> HASKELL_BLOCK_COMMENT = Parsers.sequence(Scanners.string("{-"), Scanners.notChar2('-', '}').many().toScanner("commented block"), Scanners.string("-}"));
    public static final Parser<String> SINGLE_QUOTE_STRING = Scanners.quotedBy(Patterns.notString("'").or(Patterns.string("''")).many().toScanner("quoted string"), Scanners.isChar('\'')).source();
    public static final Parser<String> DOUBLE_QUOTE_STRING = Scanners.quotedBy(Scanners.escapedChar('\\').or(Patterns.isChar(CharPredicates.notChar('\"'))).many().toScanner("quoted string"), Scanners.isChar('\"')).source();
    public static final Parser<String> SINGLE_QUOTE_CHAR = Scanners.quotedBy(Scanners.escapedChar('\\').or(Patterns.isChar(CharPredicates.notChar('\''))).toScanner("quoted char"), Scanners.isChar('\'')).source();
    public static final Parser<Void> JAVA_DELIMITER = Parsers.or(WHITESPACES, JAVA_LINE_COMMENT, JAVA_BLOCK_COMMENT).skipMany();
    public static final Parser<Void> HASKELL_DELIMITER = Parsers.or(WHITESPACES, HASKELL_LINE_COMMENT, HASKELL_BLOCK_COMMENT).skipMany();
    public static final Parser<Void> SQL_DELIMITER = Parsers.or(WHITESPACES, SQL_LINE_COMMENT, SQL_BLOCK_COMMENT).skipMany();
    public static final Parser<String> IDENTIFIER = Patterns.WORD.toScanner("word").source();
    public static final Parser<String> INTEGER = Patterns.INTEGER.toScanner("integer").source();
    public static final Parser<String> DECIMAL = Patterns.DECIMAL.toScanner("decimal").source();
    public static final Parser<String> DEC_INTEGER = Patterns.DEC_INTEGER.toScanner("decimal integer").source();
    public static final Parser<String> OCT_INTEGER = Patterns.OCT_INTEGER.toScanner("octal integer").source();
    public static final Parser<String> HEX_INTEGER = Patterns.HEX_INTEGER.toScanner("hexadecimal integer").source();
    public static final Parser<String> SCIENTIFIC_NOTATION = Patterns.SCIENTIFIC_NOTATION.toScanner("scientific notation").source();

    public static Parser<Void> many(CharPredicate predicate) {
        return Patterns.isChar(predicate).many().toScanner(predicate + "*");
    }

    public static Parser<Void> many1(CharPredicate predicate) {
        return Patterns.many1(predicate).toScanner(predicate + "+");
    }

    @Deprecated
    public static Parser<Void> many(Pattern pattern, String name) {
        return pattern.many().toScanner(name);
    }

    @Deprecated
    public static Parser<Void> many1(Pattern pattern, String name) {
        return pattern.many1().toScanner(name);
    }

    public static Parser<Void> string(String str) {
        return Patterns.string(str).toScanner(str);
    }

    @Deprecated
    public static Parser<Void> string(String str, String name) {
        return Patterns.string(str).toScanner(name);
    }

    @Deprecated
    public static Parser<Void> pattern(final Pattern pattern, final String name) {
        return new Parser<Void>(){

            @Override
            boolean apply(ParseContext ctxt) {
                int at = ctxt.at;
                CharSequence src = ctxt.characters();
                int matchLength = pattern.match(src, at, src.length());
                if (matchLength < 0) {
                    ctxt.missing(name);
                    return false;
                }
                ctxt.next(matchLength);
                ctxt.result = null;
                return true;
            }

            public String toString() {
                return name;
            }
        };
    }

    @Deprecated
    public static Parser<Void> stringCaseInsensitive(String str, String name) {
        return Patterns.stringCaseInsensitive(str).toScanner(name);
    }

    public static Parser<Void> stringCaseInsensitive(String str) {
        return Patterns.stringCaseInsensitive(str).toScanner(str);
    }

    public static Parser<Void> isChar(final CharPredicate predicate) {
        return new Parser<Void>(){
            final String name;
            {
                this.name = predicate.toString();
            }

            @Override
            boolean apply(ParseContext ctxt) {
                if (ctxt.isEof()) {
                    ctxt.missing(this.name);
                    return false;
                }
                char c = ctxt.peekChar();
                if (predicate.isChar(c)) {
                    ctxt.next();
                    ctxt.result = null;
                    return true;
                }
                ctxt.missing(this.name);
                return false;
            }

            public String toString() {
                return this.name;
            }
        };
    }

    @Deprecated
    public static Parser<Void> isChar(CharPredicate predicate, String name) {
        return Patterns.isChar(predicate).toScanner(name);
    }

    @Deprecated
    public static Parser<Void> isChar(char ch, String name) {
        return Scanners.isChar(CharPredicates.isChar(ch), name);
    }

    public static Parser<Void> isChar(char ch) {
        return Scanners.isChar(CharPredicates.isChar(ch));
    }

    @Deprecated
    public static Parser<Void> notChar(char ch, String name) {
        return Scanners.isChar(CharPredicates.notChar(ch), name);
    }

    public static Parser<Void> notChar(char ch) {
        return Scanners.isChar(CharPredicates.notChar(ch));
    }

    @Deprecated
    public static Parser<Void> among(String chars, String name) {
        return Scanners.isChar(CharPredicates.among(chars), name);
    }

    public static Parser<Void> among(String chars) {
        if (chars.length() == 0) {
            return Scanners.isChar(CharPredicates.NEVER);
        }
        if (chars.length() == 1) {
            return Scanners.isChar(chars.charAt(0));
        }
        return Scanners.isChar(CharPredicates.among(chars));
    }

    @Deprecated
    public static Parser<Void> notAmong(String chars, String name) {
        return Scanners.isChar(CharPredicates.notAmong(chars), name);
    }

    public static Parser<Void> notAmong(String chars) {
        if (chars.length() == 0) {
            return ANY_CHAR;
        }
        if (chars.length() == 1) {
            return Scanners.notChar(chars.charAt(0));
        }
        return Scanners.isChar(CharPredicates.notAmong(chars));
    }

    public static Parser<Void> lineComment(String begin) {
        return Patterns.lineComment(begin).toScanner(begin);
    }

    public static Parser<Void> blockComment(String begin, String end) {
        Pattern opening = Patterns.string(begin).next(Patterns.notString(end).many());
        return opening.toScanner(begin).next(Scanners.string(end));
    }

    public static Parser<Void> blockComment(String begin, String end, Pattern commented) {
        Pattern opening = Patterns.string(begin).next(Patterns.string(end).not().next(commented).many());
        return opening.toScanner(begin).next(Scanners.string(end));
    }

    public static Parser<Void> blockComment(Parser<Void> begin, Parser<Void> end, Parser<?> commented) {
        return Parsers.sequence(begin, end.not().next(commented).skipMany(), end);
    }

    public static Parser<Void> nestableBlockComment(String begin, String end) {
        return Scanners.nestableBlockComment(begin, end, Patterns.isChar(CharPredicates.ALWAYS));
    }

    public static Parser<Void> nestableBlockComment(String begin, String end, Pattern commented) {
        return Scanners.nestableBlockComment(Scanners.string(begin), Scanners.string(end), commented.toScanner("commented"));
    }

    public static Parser<Void> nestableBlockComment(Parser<?> begin, Parser<?> end, Parser<?> commented) {
        return new NestableBlockCommentScanner(begin, end, commented);
    }

    public static Parser<String> quoted(char begin, char end) {
        Pattern beforeClosingQuote = Patterns.isChar(begin).next(Patterns.many(CharPredicates.notChar(end)));
        return beforeClosingQuote.toScanner(Character.toString(begin)).next(Scanners.isChar(end)).source();
    }

    @Deprecated
    public static Parser<String> quoted(Parser<Void> begin, Parser<Void> end, Parser<?> quoted) {
        return Parsers.sequence(begin, quoted.skipMany(), end).source();
    }

    public static Parser<Void> nestedScanner(final Parser<?> outer, final Parser<Void> inner) {
        return new Parser<Void>(){

            @Override
            boolean apply(ParseContext ctxt) {
                int from = ctxt.at;
                if (!outer.apply(ctxt)) {
                    return false;
                }
                ScannerState innerState = new ScannerState(ctxt.module, ctxt.characters(), from, ctxt.at, ctxt.locator, ctxt.result);
                ctxt.getTrace().startFresh(innerState);
                innerState.getTrace().setStateAs(ctxt.getTrace());
                return ctxt.applyNested(inner, innerState);
            }

            public String toString() {
                return "nested scanner";
            }
        };
    }

    private static Pattern notChar2(final char c1, final char c2) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                if (begin == end - 1) {
                    return 1;
                }
                if (begin >= end) {
                    return -1;
                }
                if (src.charAt(begin) == c1 && src.charAt(begin + 1) == c2) {
                    return -1;
                }
                return 1;
            }
        };
    }

    private static Parser<Void> quotedBy(Parser<Void> parser, Parser<?> quote) {
        return parser.between(quote, quote);
    }

    private static Pattern escapedChar(char escape) {
        return Patterns.isChar(escape).next(Patterns.ANY_CHAR);
    }

    private Scanners() {
    }
}

