/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.jparsec.Keywords;
import org.jparsec.Lexicon;
import org.jparsec.Operators;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Scanners;
import org.jparsec.StringCase;
import org.jparsec.Token;
import org.jparsec.TokenMap;
import org.jparsec.TokenizerMaps;
import org.jparsec.Tokens;
import org.jparsec.internal.annotations.Private;
import org.jparsec.internal.util.Checks;
import org.jparsec.internal.util.Objects;
import org.jparsec.internal.util.Strings;

public final class Terminals
extends Lexicon {
    public static final Parser<String> RESERVED = Terminals.fragment(new Object[]{Tokens.Tag.RESERVED});

    private Terminals(Lexicon lexicon) {
        super(lexicon.words, lexicon.tokenizer);
    }

    @Deprecated
    public static Terminals caseInsensitive(String[] ops, String[] keywords) {
        return Terminals.operators(ops).words(Scanners.IDENTIFIER).caseInsensitiveKeywords(Arrays.asList(keywords)).build();
    }

    @Deprecated
    public static Terminals caseSensitive(String[] ops, String[] keywords) {
        return Terminals.operators(ops).words(Scanners.IDENTIFIER).keywords(Arrays.asList(keywords)).build();
    }

    @Deprecated
    public static Terminals caseInsensitive(Parser<String> wordScanner, String[] ops, String[] keywords) {
        return Terminals.operators(ops).words(wordScanner).caseInsensitiveKeywords(keywords).build();
    }

    @Deprecated
    public static Terminals caseSensitive(Parser<String> wordScanner, String[] ops, String[] keywords) {
        return Terminals.operators(ops).words(wordScanner).keywords(keywords).build();
    }

    @Deprecated
    public static Terminals caseInsensitive(Parser<String> wordScanner, String[] ops, String[] keywords, Function<String, ?> wordMap) {
        return Terminals.operators(ops).words(wordScanner).caseInsensitiveKeywords(keywords).tokenizeWordsWith(wordMap).build();
    }

    @Deprecated
    public static Terminals caseSensitive(Parser<String> wordScanner, String[] ops, String[] keywords, Function<String, ?> wordMap) {
        return Terminals.operators(ops).words(wordScanner).keywords(keywords).tokenizeWordsWith(wordMap).build();
    }

    public static Terminals operators(String ... ops) {
        return Terminals.operators(Arrays.asList(ops));
    }

    public static Terminals operators(Collection<String> ops) {
        return new Terminals(Operators.lexicon(ops));
    }

    public Builder words(Parser<String> wordScanner) {
        return new Builder(wordScanner);
    }

    public static Parser<String> identifier() {
        return Identifier.PARSER;
    }

    public static Parser<String> fragment(Object ... tags) {
        return Parsers.token(Terminals.fromFragment(tags));
    }

    static TokenMap<String> fromFragment(final Object ... tags) {
        return new TokenMap<String>(){

            @Override
            public String map(Token token) {
                Object val = token.value();
                if (val instanceof Tokens.Fragment) {
                    Tokens.Fragment c = (Tokens.Fragment)val;
                    if (!Objects.in(c.tag(), tags)) {
                        return null;
                    }
                    return c.text();
                }
                return null;
            }

            public String toString() {
                if (tags.length == 0) {
                    return "";
                }
                if (tags.length == 1) {
                    return String.valueOf(tags[0]);
                }
                return "[" + Strings.join(", ", tags) + "]";
            }
        };
    }

    @Private
    static void checkDup(Iterable<String> a, Iterable<String> b) {
        for (String s1 : a) {
            for (String s2 : b) {
                Checks.checkArgument(!s1.equals(s2), "%s duplicated", s1);
            }
        }
    }

    public final class Builder {
        private final Parser<String> wordScanner;
        private Collection<String> keywords = new ArrayList<String>();
        private StringCase stringCase = StringCase.CASE_SENSITIVE;
        private Function<String, ?> wordTokenMap = TokenizerMaps.IDENTIFIER_FRAGMENT;

        Builder(Parser<String> wordScanner) {
            this.wordScanner = Checks.checkNotNull(wordScanner);
        }

        public Builder keywords(String ... keywords) {
            return this.keywords(Arrays.asList(keywords));
        }

        public Builder keywords(Collection<String> keywords) {
            this.keywords = keywords;
            this.stringCase = StringCase.CASE_SENSITIVE;
            return this;
        }

        public Builder caseInsensitiveKeywords(String ... keywords) {
            return this.caseInsensitiveKeywords(Arrays.asList(keywords));
        }

        public Builder caseInsensitiveKeywords(Collection<String> keywords) {
            this.keywords = keywords;
            this.stringCase = StringCase.CASE_INSENSITIVE;
            return this;
        }

        public Builder tokenizeWordsWith(Function<String, ?> wordMap) {
            this.wordTokenMap = Checks.checkNotNull(wordMap);
            return this;
        }

        public Terminals build() {
            return new Terminals(Terminals.this.union(Keywords.lexicon(this.wordScanner, this.keywords, this.stringCase, this.wordTokenMap)));
        }
    }

    public static final class Identifier {
        public static final Parser<String> PARSER = Terminals.fragment(new Object[]{Tokens.Tag.IDENTIFIER});
        public static final Parser<Tokens.Fragment> TOKENIZER = Scanners.IDENTIFIER.map(TokenizerMaps.IDENTIFIER_FRAGMENT);

        private Identifier() {
        }
    }

    public static final class ScientificNumberLiteral {
        public static final Parser<Tokens.ScientificNotation> PARSER = Parsers.tokenType(Tokens.ScientificNotation.class, "scientific number literal");
        public static final Parser<Tokens.ScientificNotation> TOKENIZER = Scanners.SCIENTIFIC_NOTATION.map(TokenizerMaps.SCIENTIFIC_NOTATION);

        private ScientificNumberLiteral() {
        }
    }

    public static final class DecimalLiteral {
        public static final Parser<String> PARSER = Terminals.fragment(new Object[]{Tokens.Tag.DECIMAL});
        public static final Parser<Tokens.Fragment> TOKENIZER = Scanners.DECIMAL.map(TokenizerMaps.DECIMAL_FRAGMENT);

        private DecimalLiteral() {
        }
    }

    public static final class IntegerLiteral {
        public static final Parser<String> PARSER = Terminals.fragment(new Object[]{Tokens.Tag.INTEGER});
        public static final Parser<Tokens.Fragment> TOKENIZER = Scanners.INTEGER.map(TokenizerMaps.INTEGER_FRAGMENT);

        private IntegerLiteral() {
        }
    }

    public static final class LongLiteral {
        public static final Parser<Long> PARSER = Parsers.tokenType(Long.class, "integer literal");
        public static final Parser<Long> DEC_TOKENIZER = Scanners.DEC_INTEGER.map(TokenizerMaps.DEC_AS_LONG);
        public static final Parser<Long> OCT_TOKENIZER = Scanners.OCT_INTEGER.map(TokenizerMaps.OCT_AS_LONG);
        public static final Parser<Long> HEX_TOKENIZER = Scanners.HEX_INTEGER.map(TokenizerMaps.HEX_AS_LONG);
        public static final Parser<Long> TOKENIZER = Parsers.or(HEX_TOKENIZER, DEC_TOKENIZER, OCT_TOKENIZER);

        private LongLiteral() {
        }
    }

    public static final class StringLiteral {
        public static final Parser<String> PARSER = Parsers.tokenType(String.class, "string literal");
        public static final Parser<String> DOUBLE_QUOTE_TOKENIZER = Scanners.DOUBLE_QUOTE_STRING.map(TokenizerMaps.DOUBLE_QUOTE_STRING);
        public static final Parser<String> SINGLE_QUOTE_TOKENIZER = Scanners.SINGLE_QUOTE_STRING.map(TokenizerMaps.SINGLE_QUOTE_STRING);

        private StringLiteral() {
        }
    }

    public static final class CharLiteral {
        public static final Parser<Character> PARSER = Parsers.tokenType(Character.class, "character literal");
        public static final Parser<Character> SINGLE_QUOTE_TOKENIZER = Scanners.SINGLE_QUOTE_CHAR.map(TokenizerMaps.SINGLE_QUOTE_CHAR);

        private CharLiteral() {
        }
    }
}

