/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.Map;
import org.traccar.BaseProtocolDecoder;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Context;
import org.traccar.Main;
import org.traccar.MainEventHandler;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerConnector;
import org.traccar.WebDataHandler;
import org.traccar.WrapperInboundHandler;
import org.traccar.WrapperOutboundHandler;
import org.traccar.config.Keys;
import org.traccar.handler.ComputedAttributesHandler;
import org.traccar.handler.CopyAttributesHandler;
import org.traccar.handler.DefaultDataHandler;
import org.traccar.handler.DistanceHandler;
import org.traccar.handler.EngineHoursHandler;
import org.traccar.handler.FilterHandler;
import org.traccar.handler.GeocoderHandler;
import org.traccar.handler.GeolocationHandler;
import org.traccar.handler.HemisphereHandler;
import org.traccar.handler.MotionHandler;
import org.traccar.handler.NetworkMessageHandler;
import org.traccar.handler.OpenChannelHandler;
import org.traccar.handler.RemoteAddressHandler;
import org.traccar.handler.SpeedLimitHandler;
import org.traccar.handler.StandardLoggingHandler;
import org.traccar.handler.TimeHandler;
import org.traccar.handler.events.AlertEventHandler;
import org.traccar.handler.events.BehaviorEventHandler;
import org.traccar.handler.events.CommandResultEventHandler;
import org.traccar.handler.events.DriverEventHandler;
import org.traccar.handler.events.FuelDropEventHandler;
import org.traccar.handler.events.GeofenceEventHandler;
import org.traccar.handler.events.IgnitionEventHandler;
import org.traccar.handler.events.MaintenanceEventHandler;
import org.traccar.handler.events.MotionEventHandler;
import org.traccar.handler.events.OverspeedEventHandler;

public abstract class BasePipelineFactory
extends ChannelInitializer<Channel> {
    private final TrackerConnector connector;
    private final String protocol;
    private int timeout;

    public BasePipelineFactory(TrackerConnector connector, String protocol) {
        this.connector = connector;
        this.protocol = protocol;
        this.timeout = Context.getConfig().getInteger(Keys.PROTOCOL_TIMEOUT.withPrefix(protocol));
        if (this.timeout == 0) {
            this.timeout = Context.getConfig().getInteger(Keys.SERVER_TIMEOUT);
        }
    }

    protected abstract void addTransportHandlers(PipelineBuilder var1);

    protected abstract void addProtocolHandlers(PipelineBuilder var1);

    @SafeVarargs
    private void addHandlers(ChannelPipeline pipeline, Class<? extends ChannelHandler> ... handlerClasses) {
        for (Class<? extends ChannelHandler> handlerClass : handlerClasses) {
            if (handlerClass == null) continue;
            pipeline.addLast(new ChannelHandler[]{(ChannelHandler)Main.getInjector().getInstance(handlerClass)});
        }
    }

    public static <T extends ChannelHandler> T getHandler(ChannelPipeline pipeline, Class<T> clazz) {
        for (Map.Entry handlerEntry : pipeline) {
            ChannelHandler handler = (ChannelHandler)handlerEntry.getValue();
            if (handler instanceof WrapperInboundHandler) {
                handler = ((WrapperInboundHandler)handler).getWrappedHandler();
            } else if (handler instanceof WrapperOutboundHandler) {
                handler = ((WrapperOutboundHandler)handler).getWrappedHandler();
            }
            if (!clazz.isAssignableFrom(handler.getClass())) continue;
            return (T)handler;
        }
        return null;
    }

    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        this.addTransportHandlers(xva$0 -> pipeline.addLast(new ChannelHandler[]{xva$0}));
        if (this.timeout > 0 && !this.connector.isDatagram()) {
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(this.timeout, 0, 0)});
        }
        pipeline.addLast(new ChannelHandler[]{new OpenChannelHandler(this.connector)});
        pipeline.addLast(new ChannelHandler[]{new NetworkMessageHandler()});
        pipeline.addLast(new ChannelHandler[]{new StandardLoggingHandler(this.protocol)});
        this.addProtocolHandlers(handler -> {
            if (!(handler instanceof BaseProtocolDecoder) && !(handler instanceof BaseProtocolEncoder)) {
                handler = handler instanceof ChannelInboundHandler ? new WrapperInboundHandler((ChannelInboundHandler)handler) : new WrapperOutboundHandler((ChannelOutboundHandler)handler);
            }
            pipeline.addLast(new ChannelHandler[]{handler});
        });
        this.addHandlers(pipeline, TimeHandler.class, GeolocationHandler.class, HemisphereHandler.class, DistanceHandler.class, RemoteAddressHandler.class, FilterHandler.class, GeocoderHandler.class, SpeedLimitHandler.class, MotionHandler.class, CopyAttributesHandler.class, EngineHoursHandler.class, ComputedAttributesHandler.class, WebDataHandler.class, DefaultDataHandler.class, CommandResultEventHandler.class, OverspeedEventHandler.class, BehaviorEventHandler.class, FuelDropEventHandler.class, MotionEventHandler.class, GeofenceEventHandler.class, AlertEventHandler.class, IgnitionEventHandler.class, MaintenanceEventHandler.class, DriverEventHandler.class);
        pipeline.addLast(new ChannelHandler[]{new MainEventHandler()});
    }
}

