/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class Mavlink2ProtocolDecoder
extends BaseProtocolDecoder {
    public Mavlink2ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.readUnsignedByte() != 253) {
            return null;
        }
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        short senderSystemId = buf.readUnsignedByte();
        buf.readUnsignedByte();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, Integer.toString(senderSystemId));
        if (deviceSession == null) {
            return null;
        }
        int type = buf.readUnsignedMediumLE();
        if (type == 33) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("timeBoot", buf.readUnsignedIntLE());
            position.setValid(true);
            position.setTime(new Date());
            position.setLatitude((double)buf.readIntLE() / 1.0E7);
            position.setLongitude((double)buf.readIntLE() / 1.0E7);
            position.setAltitude((double)buf.readIntLE() / 1000.0);
            position.set("relativeAltitude", (double)buf.readIntLE() / 1000.0);
            short groundSpeedX = buf.readShortLE();
            short groundSpeedY = buf.readShortLE();
            buf.readShortLE();
            double speed = Math.sqrt(Math.pow(groundSpeedX, 2.0) + Math.pow(groundSpeedY, 2.0));
            position.setSpeed(UnitsConverter.knotsFromCps(speed));
            position.setCourse((double)buf.readUnsignedShortLE() / 100.0);
            return position;
        }
        return null;
    }
}

