/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class MeitrackProtocolDecoder
extends BaseProtocolDecoder {
    private ByteBuf photo;
    private static final Pattern PATTERN = new PatternBuilder().text("$$").expression(".").number("d+,").number("(d+),").number("xxx,").number("d+,").optional().number("(d+),").number("(-?d+.d+),").number("(-?d+.d+),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").number("([AV]),").number("(d+),").number("(d+),").number("(d+.?d*),").number("(d+),").number("(d+.?d*),").number("(-?d+),").number("(d+),").number("(d+),").number("(d+)|").number("(d+)|").number("(x+)?|").number("(x+)?,").number("(xx)").number("(xx),").groupBegin().number("(d+.d+)|").number("(d+.d+)|").number("d+.d+|").number("d+.d+|").number("d+.d+,").or().number("(x+)?|").number("(x+)?|").number("(x+)?|").number("(x+)|").number("(x+)?,").groupEnd().groupBegin().expression("([^,]+)?,").optional().expression("[^,]*,").number("(d+)?,").number("(x{4})?").groupBegin().number(",(x{6}(?:|x{6})*)?").groupBegin().number(",(d+)").expression(",([^*]*)").groupEnd("?").groupEnd("?").or().any().groupEnd().text("*").number("xx").text("\r\n").optional().compile();

    public MeitrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int event) {
        switch (event) {
            case 1: {
                return "sos";
            }
            case 17: {
                return "lowBattery";
            }
            case 18: {
                return "lowPower";
            }
            case 19: {
                return "overspeed";
            }
            case 20: {
                return "geofenceEnter";
            }
            case 21: {
                return "geofenceExit";
            }
            case 22: {
                return "powerRestored";
            }
            case 23: {
                return "powerCut";
            }
            case 36: {
                return "tow";
            }
            case 44: {
                return "jamming";
            }
            case 78: {
                return "accident";
            }
            case 90: 
            case 91: {
                return "hardCornering";
            }
            case 129: {
                return "hardBraking";
            }
            case 130: {
                return "hardAcceleration";
            }
            case 135: {
                return "fatigueDriving";
            }
        }
        return null;
    }

    private Position decodeRegular(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        Parser parser = new Parser(PATTERN, buf.toString(StandardCharsets.US_ASCII));
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        int event = parser.nextInt();
        position.set("event", event);
        position.set("alarm", this.decodeAlarm(event));
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setTime(parser.nextDateTime());
        position.setValid(parser.next().equals("A"));
        position.set("sat", parser.nextInt());
        int rssi = parser.nextInt();
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.setCourse(parser.nextDouble());
        position.set("hdop", parser.nextDouble());
        position.setAltitude(parser.nextDouble());
        position.set("odometer", parser.nextInt());
        position.set("runtime", parser.next());
        int mcc = parser.nextInt();
        int mnc = parser.nextInt();
        int lac = parser.nextHexInt(0);
        int cid = parser.nextHexInt(0);
        if (mcc != 0 && mnc != 0) {
            position.setNetwork(new Network(CellTower.from(mcc, mnc, lac, cid, rssi)));
        }
        position.set("input", parser.nextHexInt());
        position.set("output", parser.nextHexInt());
        if (parser.hasNext(2)) {
            position.set("battery", parser.nextDouble());
            position.set("power", parser.nextDouble());
        } else {
            for (int i = 1; i <= 3; ++i) {
                position.set("adc" + i, parser.nextHexInt());
            }
            String deviceModel = Context.getIdentityManager().getById(deviceSession.getDeviceId()).getModel();
            if (deviceModel == null) {
                deviceModel = "";
            }
            switch (deviceModel.toUpperCase()) {
                case "MVT340": 
                case "MVT380": {
                    position.set("battery", (double)parser.nextHexInt(0) * 3.0 * 2.0 / 1024.0);
                    position.set("power", (double)parser.nextHexInt(0) * 3.0 * 16.0 / 1024.0);
                    break;
                }
                case "MT90": {
                    position.set("battery", (double)parser.nextHexInt(0) * 3.3 * 2.0 / 4096.0);
                    position.set("power", parser.nextHexInt(0));
                    break;
                }
                case "T1": 
                case "T3": 
                case "MVT100": 
                case "MVT600": 
                case "MVT800": 
                case "TC68": 
                case "TC68S": {
                    position.set("battery", (double)parser.nextHexInt(0) * 3.3 * 2.0 / 4096.0);
                    position.set("power", (double)parser.nextHexInt(0) * 3.3 * 16.0 / 4096.0);
                    break;
                }
                case "T311": 
                case "T322X": 
                case "T333": 
                case "T355": {
                    position.set("battery", (double)parser.nextHexInt(0) / 100.0);
                    position.set("power", (double)parser.nextHexInt(0) / 100.0);
                    break;
                }
                default: {
                    position.set("battery", parser.nextHexInt(0));
                    position.set("power", parser.nextHexInt(0));
                }
            }
        }
        String eventData = parser.next();
        if (eventData != null && !eventData.isEmpty()) {
            switch (event) {
                case 37: {
                    position.set("driverUniqueId", eventData);
                    break;
                }
                default: {
                    position.set("eventData", eventData);
                }
            }
        }
        int protocol = parser.nextInt(0);
        if (parser.hasNext()) {
            String fuel = parser.next();
            position.set("fuel", (double)Integer.parseInt(fuel.substring(0, 2), 16) + (double)Integer.parseInt(fuel.substring(2), 16) * 0.01);
        }
        if (parser.hasNext()) {
            for (String temp : parser.next().split("\\|")) {
                double value;
                int index = Integer.parseInt(temp.substring(0, 2), 16);
                if (protocol >= 3) {
                    value = (short)Integer.parseInt(temp.substring(2), 16);
                    position.set("temp" + index, value * 0.01);
                    continue;
                }
                position.set("temp" + index, value += ((value = (double)Byte.parseByte(temp.substring(2, 4), 16)) < 0.0 ? -0.01 : 0.01) * (double)Integer.parseInt(temp.substring(4), 16));
            }
        }
        if (parser.hasNext(2)) {
            parser.nextInt();
            this.decodeDataFields(position, parser.next().split(","));
        }
        return position;
    }

    private void decodeDataFields(Position position, String[] values) {
        if (values.length > 1 && !values[1].isEmpty()) {
            position.set("tempData", values[1]);
        }
        if (values.length > 5 && !values[5].isEmpty()) {
            String[] data = values[5].split("\\|");
            boolean started = data[0].charAt(1) == '0';
            position.set("taximeterOn", started);
            position.set("taximeterStart", data[1]);
            if (data.length > 2) {
                position.set("taximeterEnd", data[2]);
                position.set("taximeterDistance", Integer.parseInt(data[3]));
                position.set("taximeterFare", Integer.parseInt(data[4]));
                position.set("taximeterTrip", data[5]);
                position.set("taximeterWait", data[6]);
            }
        }
    }

    private List<Position> decodeBinaryC(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        LinkedList<Position> positions = new LinkedList<Position>();
        String flag = buf.toString(2, 1, StandardCharsets.US_ASCII);
        int index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)44);
        String imei = buf.toString(index + 1, 15, StandardCharsets.US_ASCII);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        buf.skipBytes(index + 1 + 15 + 1 + 3 + 1 + 2 + 2 + 4);
        while (buf.readableBytes() >= 52) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("event", buf.readUnsignedByte());
            position.setLatitude((double)buf.readIntLE() * 1.0E-6);
            position.setLongitude((double)buf.readIntLE() * 1.0E-6);
            position.setTime(new Date((946684800L + buf.readUnsignedIntLE()) * 1000L));
            position.setValid(buf.readUnsignedByte() == 1);
            position.set("sat", buf.readUnsignedByte());
            short rssi = buf.readUnsignedByte();
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShortLE()));
            position.setCourse(buf.readUnsignedShortLE());
            position.set("hdop", (double)buf.readUnsignedShortLE() * 0.1);
            position.setAltitude(buf.readUnsignedShortLE());
            position.set("odometer", buf.readUnsignedIntLE());
            position.set("runtime", buf.readUnsignedIntLE());
            position.setNetwork(new Network(CellTower.from(buf.readUnsignedShortLE(), buf.readUnsignedShortLE(), buf.readUnsignedShortLE(), buf.readUnsignedShortLE(), rssi)));
            position.set("status", buf.readUnsignedShortLE());
            position.set("adc1", buf.readUnsignedShortLE());
            position.set("battery", (double)buf.readUnsignedShortLE() * 0.01);
            position.set("power", buf.readUnsignedShortLE());
            buf.readUnsignedIntLE();
            positions.add(position);
        }
        if (channel != null) {
            StringBuilder command = new StringBuilder("@@");
            command.append(flag).append(27 + positions.size() / 10).append(",");
            command.append(imei).append(",CCC,").append(positions.size()).append("*");
            int checksum = 0;
            for (int i = 0; i < command.length(); ++i) {
                checksum += command.charAt(i);
            }
            command.append(String.format("%02x", checksum & 0xFF).toUpperCase());
            command.append("\r\n");
            channel.writeAndFlush((Object)new NetworkMessage(command.toString(), remoteAddress));
        }
        return positions;
    }

    private List<Position> decodeBinaryE(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        LinkedList<Position> positions = new LinkedList<Position>();
        buf.readerIndex(buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)44) + 1);
        String imei = buf.readSlice(15).toString(StandardCharsets.US_ASCII);
        buf.skipBytes(5);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        buf.readUnsignedIntLE();
        int count = buf.readUnsignedShortLE();
        for (int i = 0; i < count; ++i) {
            short id;
            int j;
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            int paramCount = buf.readUnsignedByte();
            block36: for (j = 0; j < paramCount; ++j) {
                id = buf.readUnsignedByte();
                switch (id) {
                    case 1: {
                        position.set("event", buf.readUnsignedByte());
                        continue block36;
                    }
                    case 5: {
                        position.setValid(buf.readUnsignedByte() > 0);
                        continue block36;
                    }
                    case 6: {
                        position.set("sat", buf.readUnsignedByte());
                        continue block36;
                    }
                    case 7: {
                        position.set("rssi", buf.readUnsignedByte());
                        continue block36;
                    }
                    case 20: {
                        position.set("output", buf.readUnsignedByte());
                        continue block36;
                    }
                    case 21: {
                        position.set("input", buf.readUnsignedByte());
                        continue block36;
                    }
                    case 151: {
                        position.set("throttle", buf.readUnsignedByte());
                        continue block36;
                    }
                    case 157: {
                        position.set("fuel", buf.readUnsignedByte());
                        continue block36;
                    }
                    default: {
                        buf.readUnsignedByte();
                    }
                }
            }
            paramCount = buf.readUnsignedByte();
            block37: for (j = 0; j < paramCount; ++j) {
                id = buf.readUnsignedByte();
                switch (id) {
                    case 8: {
                        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShortLE()));
                        continue block37;
                    }
                    case 9: {
                        position.setCourse(buf.readUnsignedShortLE());
                        continue block37;
                    }
                    case 10: {
                        position.set("hdop", buf.readUnsignedShortLE());
                        continue block37;
                    }
                    case 11: {
                        position.setAltitude(buf.readShortLE());
                        continue block37;
                    }
                    case 22: {
                        position.set("adc1", (double)buf.readUnsignedShortLE() * 0.01);
                        continue block37;
                    }
                    case 25: {
                        position.set("battery", (double)buf.readUnsignedShortLE() * 0.01);
                        continue block37;
                    }
                    case 26: {
                        position.set("power", (double)buf.readUnsignedShortLE() * 0.01);
                        continue block37;
                    }
                    case 64: {
                        position.set("event", buf.readUnsignedShortLE());
                        continue block37;
                    }
                    case 145: 
                    case 146: {
                        position.set("obdSpeed", buf.readUnsignedShortLE());
                        continue block37;
                    }
                    case 152: {
                        position.set("fuelUsed", buf.readUnsignedShortLE());
                        continue block37;
                    }
                    case 153: {
                        position.set("rpm", buf.readUnsignedShortLE());
                        continue block37;
                    }
                    case 156: {
                        position.set("coolantTemp", buf.readUnsignedShortLE());
                        continue block37;
                    }
                    case 159: {
                        position.set("temp1", buf.readUnsignedShortLE());
                        continue block37;
                    }
                    case 201: {
                        position.set("fuelConsumption", buf.readUnsignedShortLE());
                        continue block37;
                    }
                    default: {
                        buf.readUnsignedShortLE();
                    }
                }
            }
            paramCount = buf.readUnsignedByte();
            block38: for (j = 0; j < paramCount; ++j) {
                id = buf.readUnsignedByte();
                switch (id) {
                    case 2: {
                        position.setLatitude((double)buf.readIntLE() * 1.0E-6);
                        continue block38;
                    }
                    case 3: {
                        position.setLongitude((double)buf.readIntLE() * 1.0E-6);
                        continue block38;
                    }
                    case 4: {
                        position.setTime(new Date((946684800L + buf.readUnsignedIntLE()) * 1000L));
                        continue block38;
                    }
                    case 12: 
                    case 155: {
                        position.set("odometer", buf.readUnsignedIntLE());
                        continue block38;
                    }
                    case 13: {
                        position.set("runtime", buf.readUnsignedIntLE());
                        continue block38;
                    }
                    case 160: {
                        position.set("fuelUsed", (double)buf.readUnsignedIntLE() * 0.001);
                        continue block38;
                    }
                    case 162: {
                        position.set("fuelConsumption", (double)buf.readUnsignedIntLE() * 0.01);
                        continue block38;
                    }
                    default: {
                        buf.readUnsignedIntLE();
                    }
                }
            }
            paramCount = buf.readUnsignedByte();
            for (j = 0; j < paramCount; ++j) {
                buf.readUnsignedByte();
                buf.skipBytes((int)buf.readUnsignedByte());
            }
            positions.add(position);
        }
        return positions;
    }

    private void requestPhotoPacket(Channel channel, SocketAddress socketAddress, String imei, String file, int index) {
        if (channel != null) {
            String content = "D00," + file + "," + index;
            int length = 1 + imei.length() + 1 + content.length() + 5;
            Object response = String.format("@@O%02d,%s,%s*", length, imei, content);
            response = (String)response + Checksum.sum((String)response) + "\r\n";
            channel.writeAndFlush((Object)new NetworkMessage(response, socketAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String type;
        ByteBuf buf = (ByteBuf)msg;
        int index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)44);
        String imei = buf.toString(index + 1, 15, StandardCharsets.US_ASCII);
        index = buf.indexOf(index + 1, buf.writerIndex(), (byte)44);
        switch (type = buf.toString(index + 1, 3, StandardCharsets.US_ASCII)) {
            case "D00": {
                if (this.photo == null) {
                    this.photo = Unpooled.buffer();
                }
                index = index + 1 + type.length() + 1;
                int endIndex = buf.indexOf(index, buf.writerIndex(), (byte)44);
                String file = buf.toString(index, endIndex - index, StandardCharsets.US_ASCII);
                index = endIndex + 1;
                endIndex = buf.indexOf(index, buf.writerIndex(), (byte)44);
                int total = Integer.parseInt(buf.toString(index, endIndex - index, StandardCharsets.US_ASCII));
                index = endIndex + 1;
                endIndex = buf.indexOf(index, buf.writerIndex(), (byte)44);
                int current = Integer.parseInt(buf.toString(index, endIndex - index, StandardCharsets.US_ASCII));
                buf.readerIndex(endIndex + 1);
                this.photo.writeBytes(buf.readSlice(buf.readableBytes() - 1 - 2 - 2));
                if (current == total - 1) {
                    Position position = new Position(this.getProtocolName());
                    position.setDeviceId(this.getDeviceSession(channel, remoteAddress, imei).getDeviceId());
                    this.getLastLocation(position, null);
                    position.set("image", Context.getMediaManager().writeFile(imei, this.photo, "jpg"));
                    this.photo.release();
                    this.photo = null;
                    return position;
                }
                if ((current + 1) % 8 == 0) {
                    this.requestPhotoPacket(channel, remoteAddress, imei, file, current + 1);
                }
                return null;
            }
            case "D03": {
                this.photo = Unpooled.buffer();
                this.requestPhotoPacket(channel, remoteAddress, imei, "camera_picture.jpg", 0);
                return null;
            }
            case "CCC": {
                return this.decodeBinaryC(channel, remoteAddress, buf);
            }
            case "CCE": {
                return this.decodeBinaryE(channel, remoteAddress, buf);
            }
        }
        return this.decodeRegular(channel, remoteAddress, buf);
    }
}

