/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class S168ProtocolDecoder
extends BaseProtocolDecoder {
    public S168ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String[] fragments;
        String sentence = (String)msg;
        String[] values = sentence.split("#");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, values[1]);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        String content = values[4];
        block6: for (String fragment : fragments = content.split(";")) {
            int dataIndex = fragment.indexOf(58);
            String type = fragment.substring(0, dataIndex);
            values = fragment.substring(dataIndex + 1).split(",");
            int index = 0;
            switch (type) {
                case "GDATA": {
                    position.setValid(values[index++].equals("A"));
                    position.set("sat", Integer.parseInt(values[index++]));
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    position.setTime(dateFormat.parse(values[index++]));
                    position.setLatitude(Double.parseDouble(values[index++]));
                    position.setLongitude(Double.parseDouble(values[index++]));
                    position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[index++])));
                    position.setCourse(Integer.parseInt(values[index++]));
                    position.setAltitude(Integer.parseInt(values[index++]));
                    continue block6;
                }
            }
        }
        return position.getAttributes().containsKey("sat") ? position : null;
    }
}

