/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class StartekProtocolEncoder
extends StringProtocolEncoder {
    public StartekProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected String formatCommand(Command command, String format, String ... keys) {
        String uniqueId = this.getUniqueId(command.getDeviceId());
        String payload = super.formatCommand(command, format, keys);
        int length = 1 + uniqueId.length() + 1 + payload.length();
        String sentence = "$$:" + length + "," + uniqueId + "," + payload;
        return sentence + Checksum.sum(sentence) + "\r\n";
    }

    @Override
    protected Object encodeCommand(Channel channel, Command command) {
        switch (command.getType()) {
            case "custom": {
                return this.formatCommand(command, "%s", "data");
            }
            case "outputControl": {
                return this.formatCommand(command, "900,%s,%s", "index", "data");
            }
            case "engineStop": {
                return this.formatCommand(command, "900,1,1", new String[0]);
            }
            case "engineResume": {
                return this.formatCommand(command, "900,1,0", new String[0]);
            }
        }
        return null;
    }
}

