/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class Tk102ProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN_REQUEST = 128;
    public static final int MSG_LOGIN_REQUEST_2 = 33;
    public static final int MSG_LOGIN_RESPONSE = 0;
    public static final int MSG_HEARTBEAT_REQUEST = 240;
    public static final int MSG_HEARTBEAT_RESPONSE = 255;
    public static final int MSG_REPORT_ONCE = 144;
    public static final int MSG_REPORT_INTERVAL = 147;
    public static final int MODE_GPRS = 48;
    public static final int MODE_GPRS_SMS = 51;
    private static final Pattern PATTERN = new PatternBuilder().text("(").expression("[A-Z]+").number("(dd)(dd)(dd)").expression("([AV])").number("(dd)(dd.dddd)([NS])").number("(ddd)(dd.dddd)([EW])").number("(ddd.ddd)").number("(dd)(dd)(dd)").any().text(")").compile();

    public Tk102ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, int type, ByteBuf dataSequence, ByteBuf content) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(91);
            response.writeByte(type);
            response.writeBytes(dataSequence);
            response.writeByte(content.readableBytes());
            response.writeBytes(content);
            content.release();
            response.writeByte(93);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(1);
        short type = buf.readUnsignedByte();
        ByteBuf dataSequence = buf.readSlice(10);
        short length = buf.readUnsignedByte();
        if (type == 128 || type == 33) {
            ByteBuf data = buf.readSlice((int)length);
            String id = type == 128 ? data.toString(StandardCharsets.US_ASCII) : data.copy(1, 15).toString(StandardCharsets.US_ASCII);
            if (this.getDeviceSession(channel, remoteAddress, id) != null) {
                ByteBuf response = Unpooled.buffer();
                response.writeByte(48);
                response.writeBytes(data);
                this.sendResponse(channel, 0, dataSequence, response);
            }
        } else if (type == 240) {
            this.sendResponse(channel, 255, dataSequence, buf.readRetainedSlice((int)length));
        } else {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Parser parser = new Parser(PATTERN, buf.readSlice((int)length).toString(StandardCharsets.US_ASCII));
            if (!parser.matches()) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setValid(parser.next().equals("A"));
            position.setLatitude(parser.nextCoordinate());
            position.setLongitude(parser.nextCoordinate());
            position.setSpeed(parser.nextDouble(0.0));
            dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setTime(dateBuilder.getDate());
            return position;
        }
        return null;
    }
}

