/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.replace.Replace;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SubSelect;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class ReplaceDeParser
extends AbstractDeParser<Replace>
implements ItemsListVisitor {
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public ReplaceDeParser() {
        super(new StringBuilder());
    }

    public ReplaceDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder stringBuilder) {
        super(stringBuilder);
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(Replace replace) {
        this.buffer.append("REPLACE ");
        if (replace.isUseIntoTables()) {
            this.buffer.append("INTO ");
        }
        this.buffer.append(replace.getTable().getFullyQualifiedName());
        if (replace.getItemsList() != null) {
            if (replace.getColumns() != null) {
                this.buffer.append(" (");
                for (int i2 = 0; i2 < replace.getColumns().size(); ++i2) {
                    Column column = replace.getColumns().get(i2);
                    this.buffer.append(column.getFullyQualifiedName());
                    if (i2 >= replace.getColumns().size() - 1) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            } else {
                this.buffer.append(" ");
            }
        } else {
            this.buffer.append(" SET ");
            for (int i3 = 0; i3 < replace.getColumns().size(); ++i3) {
                Column column = replace.getColumns().get(i3);
                this.buffer.append(column.getFullyQualifiedName()).append("=");
                replace.getExpressions().get(i3).accept(this.expressionVisitor);
                if (i3 >= replace.getColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        }
        if (replace.getItemsList() != null) {
            replace.getItemsList().accept(this);
        }
    }

    @Override
    public void visit(ExpressionList object) {
        this.buffer.append("VALUES (");
        object = ((ExpressionList)object).getExpressions().iterator();
        while (object.hasNext()) {
            ((Expression)object.next()).accept(this.expressionVisitor);
            if (!object.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(NamedExpressionList namedExpressionList) {
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void visit(MultiExpressionList object) {
        this.buffer.append("VALUES ");
        object = ((MultiExpressionList)object).getExprList().iterator();
        while (object.hasNext()) {
            this.buffer.append("(");
            Iterator<Expression> iterator = ((ExpressionList)object.next()).getExpressions().iterator();
            while (iterator.hasNext()) {
                iterator.next().accept(this.expressionVisitor);
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
            if (!object.hasNext()) continue;
            this.buffer.append(", ");
        }
    }
}

