//
// h225.h
//
// Code automatically generated by asnparse.
//

#if ! H323_DISABLE_H225

#ifndef __H225_H
#define __H225_H

#ifdef P_USE_PRAGMA
#pragma interface
#endif

#include <ptclib/asner.h>

#include "h235.h"
#include "h245.h"


//
// ReleaseCompleteReason
//

class H225_NonStandardParameter;
class H225_ConferenceIdentifier;
class H225_SecurityErrors;

class H225_ReleaseCompleteReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ReleaseCompleteReason, PASN_Choice);
#endif
  public:
    H225_ReleaseCompleteReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_noBandwidth,
      e_gatekeeperResources,
      e_unreachableDestination,
      e_destinationRejection,
      e_invalidRevision,
      e_noPermission,
      e_unreachableGatekeeper,
      e_gatewayResources,
      e_badFormatAddress,
      e_adaptiveBusy,
      e_inConf,
      e_undefinedReason,
      e_facilityCallDeflection,
      e_securityDenied,
      e_calledPartyNotRegistered,
      e_callerNotRegistered,
      e_newConnectionNeeded,
      e_nonStandardReason,
      e_replaceWithConferenceInvite,
      e_genericDataReason,
      e_neededFeatureNotSupported,
      e_tunnelledSignallingRejected,
      e_invalidCID,
      e_securityError,
      e_hopCountExceeded
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NonStandardParameter &() const;
#else
    operator H225_NonStandardParameter &();
    operator const H225_NonStandardParameter &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ConferenceIdentifier &() const;
#else
    operator H225_ConferenceIdentifier &();
    operator const H225_ConferenceIdentifier &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SecurityErrors &() const;
#else
    operator H225_SecurityErrors &();
    operator const H225_SecurityErrors &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ScnConnectionType
//

class H225_ScnConnectionType : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ScnConnectionType, PASN_Choice);
#endif
  public:
    H225_ScnConnectionType(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_unknown,
      e_bChannel,
      e_hybrid2x64,
      e_hybrid384,
      e_hybrid1536,
      e_hybrid1920,
      e_multirate
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ScnConnectionAggregation
//

class H225_ScnConnectionAggregation : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ScnConnectionAggregation, PASN_Choice);
#endif
  public:
    H225_ScnConnectionAggregation(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_auto,
      e_none,
      e_h221,
      e_bonded_mode1,
      e_bonded_mode2,
      e_bonded_mode3
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// PresentationIndicator
//

class H225_PresentationIndicator : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_PresentationIndicator, PASN_Choice);
#endif
  public:
    H225_PresentationIndicator(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_presentationAllowed,
      e_presentationRestricted,
      e_addressNotAvailable
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ScreeningIndicator
//

class H225_ScreeningIndicator : public PASN_Enumeration
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ScreeningIndicator, PASN_Enumeration);
#endif
  public:
    H225_ScreeningIndicator(unsigned tag = UniversalEnumeration, TagClass tagClass = UniversalTagClass);

    enum Enumerations {
      e_userProvidedNotScreened,
      e_userProvidedVerifiedAndPassed,
      e_userProvidedVerifiedAndFailed,
      e_networkProvided
    };

    H225_ScreeningIndicator & operator=(unsigned v);
    PObject * Clone() const;
};


//
// FacilityReason
//

class H225_FacilityReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_FacilityReason, PASN_Choice);
#endif
  public:
    H225_FacilityReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_routeCallToGatekeeper,
      e_callForwarded,
      e_routeCallToMC,
      e_undefinedReason,
      e_conferenceListChoice,
      e_startH245,
      e_noH245,
      e_newTokens,
      e_featureSetUpdate,
      e_forwardedElements,
      e_transportedInformation
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// TransportAddress
//

class H225_TransportAddress_ipAddress;
class H225_TransportAddress_ipSourceRoute;
class H225_TransportAddress_ipxAddress;
class H225_TransportAddress_ip6Address;
class H225_NonStandardParameter;

class H225_TransportAddress : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TransportAddress, PASN_Choice);
#endif
  public:
    H225_TransportAddress(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_ipAddress,
      e_ipSourceRoute,
      e_ipxAddress,
      e_ip6Address,
      e_netBios,
      e_nsap,
      e_nonStandardAddress
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_TransportAddress_ipAddress &() const;
#else
    operator H225_TransportAddress_ipAddress &();
    operator const H225_TransportAddress_ipAddress &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_TransportAddress_ipSourceRoute &() const;
#else
    operator H225_TransportAddress_ipSourceRoute &();
    operator const H225_TransportAddress_ipSourceRoute &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_TransportAddress_ipxAddress &() const;
#else
    operator H225_TransportAddress_ipxAddress &();
    operator const H225_TransportAddress_ipxAddress &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_TransportAddress_ip6Address &() const;
#else
    operator H225_TransportAddress_ip6Address &();
    operator const H225_TransportAddress_ip6Address &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NonStandardParameter &() const;
#else
    operator H225_NonStandardParameter &();
    operator const H225_NonStandardParameter &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// SupportedProtocols
//

class H225_NonStandardParameter;
class H225_H310Caps;
class H225_H320Caps;
class H225_H321Caps;
class H225_H322Caps;
class H225_H323Caps;
class H225_H324Caps;
class H225_VoiceCaps;
class H225_T120OnlyCaps;
class H225_NonStandardProtocol;
class H225_T38FaxAnnexbOnlyCaps;
class H225_SIPCaps;

class H225_SupportedProtocols : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_SupportedProtocols, PASN_Choice);
#endif
  public:
    H225_SupportedProtocols(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_nonStandardData,
      e_h310,
      e_h320,
      e_h321,
      e_h322,
      e_h323,
      e_h324,
      e_voice,
      e_t120_only,
      e_nonStandardProtocol,
      e_t38FaxAnnexbOnly,
      e_sip
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NonStandardParameter &() const;
#else
    operator H225_NonStandardParameter &();
    operator const H225_NonStandardParameter &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_H310Caps &() const;
#else
    operator H225_H310Caps &();
    operator const H225_H310Caps &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_H320Caps &() const;
#else
    operator H225_H320Caps &();
    operator const H225_H320Caps &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_H321Caps &() const;
#else
    operator H225_H321Caps &();
    operator const H225_H321Caps &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_H322Caps &() const;
#else
    operator H225_H322Caps &();
    operator const H225_H322Caps &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_H323Caps &() const;
#else
    operator H225_H323Caps &();
    operator const H225_H323Caps &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_H324Caps &() const;
#else
    operator H225_H324Caps &();
    operator const H225_H324Caps &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_VoiceCaps &() const;
#else
    operator H225_VoiceCaps &();
    operator const H225_VoiceCaps &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_T120OnlyCaps &() const;
#else
    operator H225_T120OnlyCaps &();
    operator const H225_T120OnlyCaps &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NonStandardProtocol &() const;
#else
    operator H225_NonStandardProtocol &();
    operator const H225_NonStandardProtocol &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_T38FaxAnnexbOnlyCaps &() const;
#else
    operator H225_T38FaxAnnexbOnlyCaps &();
    operator const H225_T38FaxAnnexbOnlyCaps &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SIPCaps &() const;
#else
    operator H225_SIPCaps &();
    operator const H225_SIPCaps &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// H221NonStandard
//

class H225_H221NonStandard : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H221NonStandard, PASN_Sequence);
#endif
  public:
    H225_H221NonStandard(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Integer m_t35CountryCode;
    PASN_Integer m_t35Extension;
    PASN_Integer m_manufacturerCode;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// TunnelledProtocolAlternateIdentifier
//

class H225_TunnelledProtocolAlternateIdentifier : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TunnelledProtocolAlternateIdentifier, PASN_Sequence);
#endif
  public:
    H225_TunnelledProtocolAlternateIdentifier(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_protocolVariant
    };

    PASN_IA5String m_protocolType;
    PASN_IA5String m_protocolVariant;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// NonStandardIdentifier
//

class H225_H221NonStandard;

class H225_NonStandardIdentifier : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_NonStandardIdentifier, PASN_Choice);
#endif
  public:
    H225_NonStandardIdentifier(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_object,
      e_h221NonStandard
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_H221NonStandard &() const;
#else
    operator H225_H221NonStandard &();
    operator const H225_H221NonStandard &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// AliasAddress
//

class H225_TransportAddress;
class H225_PartyNumber;
class H225_MobileUIM;
class H225_IsupNumber;

class H225_AliasAddress : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_AliasAddress, PASN_Choice);
#endif
  public:
    H225_AliasAddress(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_dialedDigits,
      e_h323_ID,
      e_url_ID,
      e_transportID,
      e_email_ID,
      e_partyNumber,
      e_mobileUIM,
      e_isupNumber
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_TransportAddress &() const;
#else
    operator H225_TransportAddress &();
    operator const H225_TransportAddress &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_PartyNumber &() const;
#else
    operator H225_PartyNumber &();
    operator const H225_PartyNumber &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_MobileUIM &() const;
#else
    operator H225_MobileUIM &();
    operator const H225_MobileUIM &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_IsupNumber &() const;
#else
    operator H225_IsupNumber &();
    operator const H225_IsupNumber &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// AddressPattern
//

class H225_AliasAddress;
class H225_AddressPattern_range;

class H225_AddressPattern : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_AddressPattern, PASN_Choice);
#endif
  public:
    H225_AddressPattern(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_wildcard,
      e_range
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_AliasAddress &() const;
#else
    operator H225_AliasAddress &();
    operator const H225_AliasAddress &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_AddressPattern_range &() const;
#else
    operator H225_AddressPattern_range &();
    operator const H225_AddressPattern_range &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// PartyNumber
//

class H225_PublicPartyNumber;
class H225_NumberDigits;
class H225_PrivatePartyNumber;

class H225_PartyNumber : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_PartyNumber, PASN_Choice);
#endif
  public:
    H225_PartyNumber(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_e164Number,
      e_dataPartyNumber,
      e_telexPartyNumber,
      e_privateNumber,
      e_nationalStandardPartyNumber
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_PublicPartyNumber &() const;
#else
    operator H225_PublicPartyNumber &();
    operator const H225_PublicPartyNumber &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NumberDigits &() const;
#else
    operator H225_NumberDigits &();
    operator const H225_NumberDigits &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_PrivatePartyNumber &() const;
#else
    operator H225_PrivatePartyNumber &();
    operator const H225_PrivatePartyNumber &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// NumberDigits
//

class H225_NumberDigits : public PASN_IA5String
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_NumberDigits, PASN_IA5String);
#endif
  public:
    H225_NumberDigits(unsigned tag = UniversalIA5String, TagClass tagClass = UniversalTagClass);

    H225_NumberDigits & operator=(const char * v);
    H225_NumberDigits & operator=(const PString & v);
    PObject * Clone() const;
};


//
// DisplayName
//

class H225_DisplayName : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_DisplayName, PASN_Sequence);
#endif
  public:
    H225_DisplayName(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_language
    };

    PASN_IA5String m_language;
    PASN_BMPString m_name;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// PublicTypeOfNumber
//

class H225_PublicTypeOfNumber : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_PublicTypeOfNumber, PASN_Choice);
#endif
  public:
    H225_PublicTypeOfNumber(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_unknown,
      e_internationalNumber,
      e_nationalNumber,
      e_networkSpecificNumber,
      e_subscriberNumber,
      e_abbreviatedNumber
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// PrivateTypeOfNumber
//

class H225_PrivateTypeOfNumber : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_PrivateTypeOfNumber, PASN_Choice);
#endif
  public:
    H225_PrivateTypeOfNumber(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_unknown,
      e_level2RegionalNumber,
      e_level1RegionalNumber,
      e_pISNSpecificNumber,
      e_localNumber,
      e_abbreviatedNumber
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// MobileUIM
//

class H225_ANSI_41_UIM;
class H225_GSM_UIM;

class H225_MobileUIM : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_MobileUIM, PASN_Choice);
#endif
  public:
    H225_MobileUIM(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_ansi_41_uim,
      e_gsm_uim
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ANSI_41_UIM &() const;
#else
    operator H225_ANSI_41_UIM &();
    operator const H225_ANSI_41_UIM &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_GSM_UIM &() const;
#else
    operator H225_GSM_UIM &();
    operator const H225_GSM_UIM &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// TBCD-STRING
//

class H225_TBCD_STRING : public PASN_IA5String
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TBCD_STRING, PASN_IA5String);
#endif
  public:
    H225_TBCD_STRING(unsigned tag = UniversalIA5String, TagClass tagClass = UniversalTagClass);

    H225_TBCD_STRING & operator=(const char * v);
    H225_TBCD_STRING & operator=(const PString & v);
    PObject * Clone() const;
};


//
// GSM-UIM
//

class H225_GSM_UIM : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GSM_UIM, PASN_Sequence);
#endif
  public:
    H225_GSM_UIM(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_imsi,
      e_tmsi,
      e_msisdn,
      e_imei,
      e_hplmn,
      e_vplmn
    };

    PASN_IA5String m_imsi;
    PASN_OctetString m_tmsi;
    PASN_IA5String m_msisdn;
    PASN_IA5String m_imei;
    PASN_IA5String m_hplmn;
    PASN_IA5String m_vplmn;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// IsupNumber
//

class H225_IsupPublicPartyNumber;
class H225_IsupDigits;
class H225_IsupPrivatePartyNumber;

class H225_IsupNumber : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_IsupNumber, PASN_Choice);
#endif
  public:
    H225_IsupNumber(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_e164Number,
      e_dataPartyNumber,
      e_telexPartyNumber,
      e_privateNumber,
      e_nationalStandardPartyNumber
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_IsupPublicPartyNumber &() const;
#else
    operator H225_IsupPublicPartyNumber &();
    operator const H225_IsupPublicPartyNumber &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_IsupDigits &() const;
#else
    operator H225_IsupDigits &();
    operator const H225_IsupDigits &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_IsupPrivatePartyNumber &() const;
#else
    operator H225_IsupPrivatePartyNumber &();
    operator const H225_IsupPrivatePartyNumber &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// NatureOfAddress
//

class H225_NatureOfAddress : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_NatureOfAddress, PASN_Choice);
#endif
  public:
    H225_NatureOfAddress(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_unknown,
      e_subscriberNumber,
      e_nationalNumber,
      e_internationalNumber,
      e_networkSpecificNumber,
      e_routingNumberNationalFormat,
      e_routingNumberNetworkSpecificFormat,
      e_routingNumberWithCalledDirectoryNumber
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// IsupDigits
//

class H225_IsupDigits : public PASN_IA5String
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_IsupDigits, PASN_IA5String);
#endif
  public:
    H225_IsupDigits(unsigned tag = UniversalIA5String, TagClass tagClass = UniversalTagClass);

    H225_IsupDigits & operator=(const char * v);
    H225_IsupDigits & operator=(const PString & v);
    PObject * Clone() const;
};


//
// ExtendedAliasAddress
//

class H225_ExtendedAliasAddress : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ExtendedAliasAddress, PASN_Sequence);
#endif
  public:
    H225_ExtendedAliasAddress(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_presentationIndicator,
      e_screeningIndicator
    };

    H225_AliasAddress m_address;
    H225_PresentationIndicator m_presentationIndicator;
    H225_ScreeningIndicator m_screeningIndicator;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UseSpecifiedTransport
//

class H225_UseSpecifiedTransport : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_UseSpecifiedTransport, PASN_Choice);
#endif
  public:
    H225_UseSpecifiedTransport(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_tcp,
      e_annexE,
      e_sctp
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// SecurityServiceMode
//

class H225_NonStandardParameter;

class H225_SecurityServiceMode : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_SecurityServiceMode, PASN_Choice);
#endif
  public:
    H225_SecurityServiceMode(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_nonStandard,
      e_none,
      e_default
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NonStandardParameter &() const;
#else
    operator H225_NonStandardParameter &();
    operator const H225_NonStandardParameter &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// SecurityErrors
//

class H225_SecurityErrors : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_SecurityErrors, PASN_Choice);
#endif
  public:
    H225_SecurityErrors(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_securityWrongSyncTime,
      e_securityReplay,
      e_securityWrongGeneralID,
      e_securityWrongSendersID,
      e_securityIntegrityFailed,
      e_securityWrongOID,
      e_securityDHmismatch,
      e_securityCertificateExpired,
      e_securityCertificateDateInvalid,
      e_securityCertificateRevoked,
      e_securityCertificateNotReadable,
      e_securityCertificateSignatureInvalid,
      e_securityCertificateMissing,
      e_securityCertificateIncomplete,
      e_securityUnsupportedCertificateAlgOID,
      e_securityUnknownCA
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// SecurityErrors2
//

class H225_SecurityErrors2 : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_SecurityErrors2, PASN_Choice);
#endif
  public:
    H225_SecurityErrors2(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_securityWrongSyncTime,
      e_securityReplay,
      e_securityWrongGeneralID,
      e_securityWrongSendersID,
      e_securityIntegrityFailed,
      e_securityWrongOID
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// H245Security
//

class H225_NonStandardParameter;
class H225_SecurityCapabilities;

class H225_H245Security : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H245Security, PASN_Choice);
#endif
  public:
    H225_H245Security(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_nonStandard,
      e_noSecurity,
      e_tls,
      e_ipsec
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NonStandardParameter &() const;
#else
    operator H225_NonStandardParameter &();
    operator const H225_NonStandardParameter &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SecurityCapabilities &() const;
#else
    operator H225_SecurityCapabilities &();
    operator const H225_SecurityCapabilities &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// Q954Details
//

class H225_Q954Details : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Q954Details, PASN_Sequence);
#endif
  public:
    H225_Q954Details(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Boolean m_conferenceCalling;
    PASN_Boolean m_threePartyService;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// GloballyUniqueID
//

class H225_GloballyUniqueID : public PASN_OctetString
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GloballyUniqueID, PASN_OctetString);
#endif
  public:
    H225_GloballyUniqueID(unsigned tag = UniversalOctetString, TagClass tagClass = UniversalTagClass);

    H225_GloballyUniqueID(const char * v);
    H225_GloballyUniqueID(const PString & v);
    H225_GloballyUniqueID(const PBYTEArray & v);

    H225_GloballyUniqueID & operator=(const char * v);
    H225_GloballyUniqueID & operator=(const PString & v);
    H225_GloballyUniqueID & operator=(const PBYTEArray & v);
    PObject * Clone() const;
};


//
// ConferenceIdentifier
//

class H225_ConferenceIdentifier : public H225_GloballyUniqueID
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ConferenceIdentifier, H225_GloballyUniqueID);
#endif
  public:
    H225_ConferenceIdentifier(unsigned tag = UniversalOctetString, TagClass tagClass = UniversalTagClass);

    H225_ConferenceIdentifier(const char * v);
    H225_ConferenceIdentifier(const PString & v);
    H225_ConferenceIdentifier(const PBYTEArray & v);

    H225_ConferenceIdentifier & operator=(const char * v);
    H225_ConferenceIdentifier & operator=(const PString & v);
    H225_ConferenceIdentifier & operator=(const PBYTEArray & v);
    PObject * Clone() const;
};


//
// RequestSeqNum
//

class H225_RequestSeqNum : public PASN_Integer
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RequestSeqNum, PASN_Integer);
#endif
  public:
    H225_RequestSeqNum(unsigned tag = UniversalInteger, TagClass tagClass = UniversalTagClass);

    H225_RequestSeqNum & operator=(int v);
    H225_RequestSeqNum & operator=(unsigned v);
    PObject * Clone() const;
};


//
// GatekeeperIdentifier
//

class H225_GatekeeperIdentifier : public PASN_BMPString
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GatekeeperIdentifier, PASN_BMPString);
#endif
  public:
    H225_GatekeeperIdentifier(unsigned tag = UniversalBMPString, TagClass tagClass = UniversalTagClass);

    H225_GatekeeperIdentifier & operator=(const char * v);
    H225_GatekeeperIdentifier & operator=(const PString & v);
    H225_GatekeeperIdentifier & operator=(const PWCharArray & v);
    H225_GatekeeperIdentifier & operator=(const PASN_BMPString & v);
    PObject * Clone() const;
};


//
// BandWidth
//

class H225_BandWidth : public PASN_Integer
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_BandWidth, PASN_Integer);
#endif
  public:
    H225_BandWidth(unsigned tag = UniversalInteger, TagClass tagClass = UniversalTagClass);

    H225_BandWidth & operator=(int v);
    H225_BandWidth & operator=(unsigned v);
    PObject * Clone() const;
};


//
// CallReferenceValue
//

class H225_CallReferenceValue : public PASN_Integer
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallReferenceValue, PASN_Integer);
#endif
  public:
    H225_CallReferenceValue(unsigned tag = UniversalInteger, TagClass tagClass = UniversalTagClass);

    H225_CallReferenceValue & operator=(int v);
    H225_CallReferenceValue & operator=(unsigned v);
    PObject * Clone() const;
};


//
// EndpointIdentifier
//

class H225_EndpointIdentifier : public PASN_BMPString
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_EndpointIdentifier, PASN_BMPString);
#endif
  public:
    H225_EndpointIdentifier(unsigned tag = UniversalBMPString, TagClass tagClass = UniversalTagClass);

    H225_EndpointIdentifier & operator=(const char * v);
    H225_EndpointIdentifier & operator=(const PString & v);
    H225_EndpointIdentifier & operator=(const PWCharArray & v);
    H225_EndpointIdentifier & operator=(const PASN_BMPString & v);
    PObject * Clone() const;
};


//
// ProtocolIdentifier
//

class H225_ProtocolIdentifier : public PASN_ObjectId
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ProtocolIdentifier, PASN_ObjectId);
#endif
  public:
    H225_ProtocolIdentifier(unsigned tag = UniversalObjectId, TagClass tagClass = UniversalTagClass);

    PObject * Clone() const;
};


//
// TimeToLive
//

class H225_TimeToLive : public PASN_Integer
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TimeToLive, PASN_Integer);
#endif
  public:
    H225_TimeToLive(unsigned tag = UniversalInteger, TagClass tagClass = UniversalTagClass);

    H225_TimeToLive & operator=(int v);
    H225_TimeToLive & operator=(unsigned v);
    PObject * Clone() const;
};


//
// H248PackagesDescriptor
//

class H225_H248PackagesDescriptor : public PASN_OctetString
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H248PackagesDescriptor, PASN_OctetString);
#endif
  public:
    H225_H248PackagesDescriptor(unsigned tag = UniversalOctetString, TagClass tagClass = UniversalTagClass);

    H225_H248PackagesDescriptor(const char * v);
    H225_H248PackagesDescriptor(const PString & v);
    H225_H248PackagesDescriptor(const PBYTEArray & v);

    H225_H248PackagesDescriptor & operator=(const char * v);
    H225_H248PackagesDescriptor & operator=(const PString & v);
    H225_H248PackagesDescriptor & operator=(const PBYTEArray & v);
    PObject * Clone() const;
};


//
// H248SignalsDescriptor
//

class H225_H248SignalsDescriptor : public PASN_OctetString
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H248SignalsDescriptor, PASN_OctetString);
#endif
  public:
    H225_H248SignalsDescriptor(unsigned tag = UniversalOctetString, TagClass tagClass = UniversalTagClass);

    H225_H248SignalsDescriptor(const char * v);
    H225_H248SignalsDescriptor(const PString & v);
    H225_H248SignalsDescriptor(const PBYTEArray & v);

    H225_H248SignalsDescriptor & operator=(const char * v);
    H225_H248SignalsDescriptor & operator=(const PString & v);
    H225_H248SignalsDescriptor & operator=(const PBYTEArray & v);
    PObject * Clone() const;
};


//
// CallIdentifier
//

class H225_CallIdentifier : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallIdentifier, PASN_Sequence);
#endif
  public:
    H225_CallIdentifier(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_GloballyUniqueID m_guid;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// EncryptIntAlg
//

class H225_NonStandardParameter;

class H225_EncryptIntAlg : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_EncryptIntAlg, PASN_Choice);
#endif
  public:
    H225_EncryptIntAlg(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_nonStandard,
      e_isoAlgorithm
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NonStandardParameter &() const;
#else
    operator H225_NonStandardParameter &();
    operator const H225_NonStandardParameter &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// NonIsoIntegrityMechanism
//

class H225_EncryptIntAlg;

class H225_NonIsoIntegrityMechanism : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_NonIsoIntegrityMechanism, PASN_Choice);
#endif
  public:
    H225_NonIsoIntegrityMechanism(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_hMAC_MD5,
      e_hMAC_iso10118_2_s,
      e_hMAC_iso10118_2_l,
      e_hMAC_iso10118_3
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_EncryptIntAlg &() const;
#else
    operator H225_EncryptIntAlg &();
    operator const H225_EncryptIntAlg &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// IntegrityMechanism
//

class H225_NonStandardParameter;
class H225_NonIsoIntegrityMechanism;

class H225_IntegrityMechanism : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_IntegrityMechanism, PASN_Choice);
#endif
  public:
    H225_IntegrityMechanism(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_nonStandard,
      e_digSig,
      e_iso9797,
      e_nonIsoIM
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NonStandardParameter &() const;
#else
    operator H225_NonStandardParameter &();
    operator const H225_NonStandardParameter &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NonIsoIntegrityMechanism &() const;
#else
    operator H225_NonIsoIntegrityMechanism &();
    operator const H225_NonIsoIntegrityMechanism &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ICV
//

class H225_ICV : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ICV, PASN_Sequence);
#endif
  public:
    H225_ICV(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_ObjectId m_algorithmOID;
    PASN_BitString m_icv;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// FastStartToken
//

class H225_FastStartToken : public H235_ClearToken
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_FastStartToken, H235_ClearToken);
#endif
  public:
    H225_FastStartToken(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    PObject * Clone() const;
};


//
// EncodedFastStartToken
//

class H225_EncodedFastStartToken : public PASN_OctetString
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_EncodedFastStartToken, PASN_OctetString);
#endif
  public:
    H225_EncodedFastStartToken(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    PBoolean DecodeSubType(H225_FastStartToken & obj) { return PASN_OctetString::DecodeSubType(obj); }
    void EncodeSubType(const H225_FastStartToken & obj) { PASN_OctetString::EncodeSubType(obj); } 

    PObject * Clone() const;
};


//
// CryptoH323Token
//

class H225_CryptoH323Token_cryptoEPPwdHash;
class H225_CryptoH323Token_cryptoGKPwdHash;
class H235_CryptoToken;

class H225_CryptoH323Token : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CryptoH323Token, PASN_Choice);
#endif
  public:
    H225_CryptoH323Token(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_cryptoEPPwdHash,
      e_cryptoGKPwdHash,
      e_cryptoEPPwdEncr,
      e_cryptoGKPwdEncr,
      e_cryptoEPCert,
      e_cryptoGKCert,
      e_cryptoFastStart,
      e_nestedcryptoToken
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_CryptoH323Token_cryptoEPPwdHash &() const;
#else
    operator H225_CryptoH323Token_cryptoEPPwdHash &();
    operator const H225_CryptoH323Token_cryptoEPPwdHash &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_CryptoH323Token_cryptoGKPwdHash &() const;
#else
    operator H225_CryptoH323Token_cryptoGKPwdHash &();
    operator const H225_CryptoH323Token_cryptoGKPwdHash &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H235_ENCRYPTED<H235_EncodedPwdCertToken> &() const;
#else
    operator H235_ENCRYPTED<H235_EncodedPwdCertToken> &();
    operator const H235_ENCRYPTED<H235_EncodedPwdCertToken> &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H235_SIGNED<H235_EncodedPwdCertToken> &() const;
#else
    operator H235_SIGNED<H235_EncodedPwdCertToken> &();
    operator const H235_SIGNED<H235_EncodedPwdCertToken> &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H235_SIGNED<H225_EncodedFastStartToken> &() const;
#else
    operator H235_SIGNED<H225_EncodedFastStartToken> &();
    operator const H235_SIGNED<H225_EncodedFastStartToken> &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H235_CryptoToken &() const;
#else
    operator H235_CryptoToken &();
    operator const H235_CryptoToken &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// CallLinkage
//

class H225_CallLinkage : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallLinkage, PASN_Sequence);
#endif
  public:
    H225_CallLinkage(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_globalCallId,
      e_threadId
    };

    H225_GloballyUniqueID m_globalCallId;
    H225_GloballyUniqueID m_threadId;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CapacityReportingCapability
//

class H225_CapacityReportingCapability : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CapacityReportingCapability, PASN_Sequence);
#endif
  public:
    H225_CapacityReportingCapability(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Boolean m_canReportCallCapacity;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CarrierInfo
//

class H225_CarrierInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CarrierInfo, PASN_Sequence);
#endif
  public:
    H225_CarrierInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_carrierIdentificationCode,
      e_carrierName
    };

    PASN_OctetString m_carrierIdentificationCode;
    PASN_IA5String m_carrierName;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ServiceControlDescriptor
//

class H225_H248SignalsDescriptor;
class H225_NonStandardParameter;
class H225_CallCreditServiceControl;

class H225_ServiceControlDescriptor : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ServiceControlDescriptor, PASN_Choice);
#endif
  public:
    H225_ServiceControlDescriptor(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_url,
      e_signal,
      e_nonStandard,
      e_callCreditServiceControl
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_H248SignalsDescriptor &() const;
#else
    operator H225_H248SignalsDescriptor &();
    operator const H225_H248SignalsDescriptor &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NonStandardParameter &() const;
#else
    operator H225_NonStandardParameter &();
    operator const H225_NonStandardParameter &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_CallCreditServiceControl &() const;
#else
    operator H225_CallCreditServiceControl &();
    operator const H225_CallCreditServiceControl &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// CallTerminationCause
//

class H225_ReleaseCompleteReason;

class H225_CallTerminationCause : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallTerminationCause, PASN_Choice);
#endif
  public:
    H225_CallTerminationCause(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_releaseCompleteReason,
      e_releaseCompleteCauseIE
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ReleaseCompleteReason &() const;
#else
    operator H225_ReleaseCompleteReason &();
    operator const H225_ReleaseCompleteReason &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// CallCreditCapability
//

class H225_CallCreditCapability : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallCreditCapability, PASN_Sequence);
#endif
  public:
    H225_CallCreditCapability(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_canDisplayAmountString,
      e_canEnforceDurationLimit
    };

    PASN_Boolean m_canDisplayAmountString;
    PASN_Boolean m_canEnforceDurationLimit;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// GenericIdentifier
//

class H225_GloballyUniqueID;

class H225_GenericIdentifier : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GenericIdentifier, PASN_Choice);
#endif
  public:
    H225_GenericIdentifier(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_standard,
      e_oid,
      e_nonStandard
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_GloballyUniqueID &() const;
#else
    operator H225_GloballyUniqueID &();
    operator const H225_GloballyUniqueID &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// Content
//

class H225_GenericIdentifier;
class H225_AliasAddress;
class H225_TransportAddress;
class H225_ArrayOf_EnumeratedParameter;
class H225_ArrayOf_GenericData;

class H225_Content : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Content, PASN_Choice);
#endif
  public:
    H225_Content(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_raw,
      e_text,
      e_unicode,
      e_bool,
      e_number8,
      e_number16,
      e_number32,
      e_id,
      e_alias,
      e_transport,
      e_compound,
      e_nested
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_GenericIdentifier &() const;
#else
    operator H225_GenericIdentifier &();
    operator const H225_GenericIdentifier &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_AliasAddress &() const;
#else
    operator H225_AliasAddress &();
    operator const H225_AliasAddress &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_TransportAddress &() const;
#else
    operator H225_TransportAddress &();
    operator const H225_TransportAddress &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ArrayOf_EnumeratedParameter &() const;
#else
    operator H225_ArrayOf_EnumeratedParameter &();
    operator const H225_ArrayOf_EnumeratedParameter &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ArrayOf_GenericData &() const;
#else
    operator H225_ArrayOf_GenericData &();
    operator const H225_ArrayOf_GenericData &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// TransportChannelInfo
//

class H225_TransportChannelInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TransportChannelInfo, PASN_Sequence);
#endif
  public:
    H225_TransportChannelInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_sendAddress,
      e_recvAddress
    };

    H225_TransportAddress m_sendAddress;
    H225_TransportAddress m_recvAddress;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RehomingModel
//

class H225_RehomingModel : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RehomingModel, PASN_Choice);
#endif
  public:
    H225_RehomingModel(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_gatekeeperBased,
      e_endpointBased
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// RasMessage
//

class H225_GatekeeperRequest;
class H225_GatekeeperConfirm;
class H225_GatekeeperReject;
class H225_RegistrationRequest;
class H225_RegistrationConfirm;
class H225_RegistrationReject;
class H225_UnregistrationRequest;
class H225_UnregistrationConfirm;
class H225_UnregistrationReject;
class H225_AdmissionRequest;
class H225_AdmissionConfirm;
class H225_AdmissionReject;
class H225_BandwidthRequest;
class H225_BandwidthConfirm;
class H225_BandwidthReject;
class H225_DisengageRequest;
class H225_DisengageConfirm;
class H225_DisengageReject;
class H225_LocationRequest;
class H225_LocationConfirm;
class H225_LocationReject;
class H225_InfoRequest;
class H225_InfoRequestResponse;
class H225_NonStandardMessage;
class H225_UnknownMessageResponse;
class H225_RequestInProgress;
class H225_ResourcesAvailableIndicate;
class H225_ResourcesAvailableConfirm;
class H225_InfoRequestAck;
class H225_InfoRequestNak;
class H225_ServiceControlIndication;
class H225_ServiceControlResponse;
class H225_ArrayOf_AdmissionConfirm;

class H225_RasMessage : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RasMessage, PASN_Choice);
#endif
  public:
    H225_RasMessage(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_gatekeeperRequest,
      e_gatekeeperConfirm,
      e_gatekeeperReject,
      e_registrationRequest,
      e_registrationConfirm,
      e_registrationReject,
      e_unregistrationRequest,
      e_unregistrationConfirm,
      e_unregistrationReject,
      e_admissionRequest,
      e_admissionConfirm,
      e_admissionReject,
      e_bandwidthRequest,
      e_bandwidthConfirm,
      e_bandwidthReject,
      e_disengageRequest,
      e_disengageConfirm,
      e_disengageReject,
      e_locationRequest,
      e_locationConfirm,
      e_locationReject,
      e_infoRequest,
      e_infoRequestResponse,
      e_nonStandardMessage,
      e_unknownMessageResponse,
      e_requestInProgress,
      e_resourcesAvailableIndicate,
      e_resourcesAvailableConfirm,
      e_infoRequestAck,
      e_infoRequestNak,
      e_serviceControlIndication,
      e_serviceControlResponse,
      e_admissionConfirmSequence
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_GatekeeperRequest &() const;
#else
    operator H225_GatekeeperRequest &();
    operator const H225_GatekeeperRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_GatekeeperConfirm &() const;
#else
    operator H225_GatekeeperConfirm &();
    operator const H225_GatekeeperConfirm &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_GatekeeperReject &() const;
#else
    operator H225_GatekeeperReject &();
    operator const H225_GatekeeperReject &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_RegistrationRequest &() const;
#else
    operator H225_RegistrationRequest &();
    operator const H225_RegistrationRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_RegistrationConfirm &() const;
#else
    operator H225_RegistrationConfirm &();
    operator const H225_RegistrationConfirm &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_RegistrationReject &() const;
#else
    operator H225_RegistrationReject &();
    operator const H225_RegistrationReject &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_UnregistrationRequest &() const;
#else
    operator H225_UnregistrationRequest &();
    operator const H225_UnregistrationRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_UnregistrationConfirm &() const;
#else
    operator H225_UnregistrationConfirm &();
    operator const H225_UnregistrationConfirm &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_UnregistrationReject &() const;
#else
    operator H225_UnregistrationReject &();
    operator const H225_UnregistrationReject &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_AdmissionRequest &() const;
#else
    operator H225_AdmissionRequest &();
    operator const H225_AdmissionRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_AdmissionConfirm &() const;
#else
    operator H225_AdmissionConfirm &();
    operator const H225_AdmissionConfirm &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_AdmissionReject &() const;
#else
    operator H225_AdmissionReject &();
    operator const H225_AdmissionReject &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_BandwidthRequest &() const;
#else
    operator H225_BandwidthRequest &();
    operator const H225_BandwidthRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_BandwidthConfirm &() const;
#else
    operator H225_BandwidthConfirm &();
    operator const H225_BandwidthConfirm &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_BandwidthReject &() const;
#else
    operator H225_BandwidthReject &();
    operator const H225_BandwidthReject &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_DisengageRequest &() const;
#else
    operator H225_DisengageRequest &();
    operator const H225_DisengageRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_DisengageConfirm &() const;
#else
    operator H225_DisengageConfirm &();
    operator const H225_DisengageConfirm &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_DisengageReject &() const;
#else
    operator H225_DisengageReject &();
    operator const H225_DisengageReject &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_LocationRequest &() const;
#else
    operator H225_LocationRequest &();
    operator const H225_LocationRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_LocationConfirm &() const;
#else
    operator H225_LocationConfirm &();
    operator const H225_LocationConfirm &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_LocationReject &() const;
#else
    operator H225_LocationReject &();
    operator const H225_LocationReject &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_InfoRequest &() const;
#else
    operator H225_InfoRequest &();
    operator const H225_InfoRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_InfoRequestResponse &() const;
#else
    operator H225_InfoRequestResponse &();
    operator const H225_InfoRequestResponse &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NonStandardMessage &() const;
#else
    operator H225_NonStandardMessage &();
    operator const H225_NonStandardMessage &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_UnknownMessageResponse &() const;
#else
    operator H225_UnknownMessageResponse &();
    operator const H225_UnknownMessageResponse &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_RequestInProgress &() const;
#else
    operator H225_RequestInProgress &();
    operator const H225_RequestInProgress &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ResourcesAvailableIndicate &() const;
#else
    operator H225_ResourcesAvailableIndicate &();
    operator const H225_ResourcesAvailableIndicate &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ResourcesAvailableConfirm &() const;
#else
    operator H225_ResourcesAvailableConfirm &();
    operator const H225_ResourcesAvailableConfirm &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_InfoRequestAck &() const;
#else
    operator H225_InfoRequestAck &();
    operator const H225_InfoRequestAck &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_InfoRequestNak &() const;
#else
    operator H225_InfoRequestNak &();
    operator const H225_InfoRequestNak &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ServiceControlIndication &() const;
#else
    operator H225_ServiceControlIndication &();
    operator const H225_ServiceControlIndication &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ServiceControlResponse &() const;
#else
    operator H225_ServiceControlResponse &();
    operator const H225_ServiceControlResponse &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ArrayOf_AdmissionConfirm &() const;
#else
    operator H225_ArrayOf_AdmissionConfirm &();
    operator const H225_ArrayOf_AdmissionConfirm &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// GatekeeperRejectReason
//

class H225_SecurityErrors;

class H225_GatekeeperRejectReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GatekeeperRejectReason, PASN_Choice);
#endif
  public:
    H225_GatekeeperRejectReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_resourceUnavailable,
      e_terminalExcluded,
      e_invalidRevision,
      e_undefinedReason,
      e_securityDenial,
      e_genericDataReason,
      e_neededFeatureNotSupported,
      e_securityError
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SecurityErrors &() const;
#else
    operator H225_SecurityErrors &();
    operator const H225_SecurityErrors &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// RegistrationRejectReason
//

class H225_ArrayOf_AliasAddress;
class H225_RegistrationRejectReason_invalidTerminalAliases;
class H225_SecurityErrors;

class H225_RegistrationRejectReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RegistrationRejectReason, PASN_Choice);
#endif
  public:
    H225_RegistrationRejectReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_discoveryRequired,
      e_invalidRevision,
      e_invalidCallSignalAddress,
      e_invalidRASAddress,
      e_duplicateAlias,
      e_invalidTerminalType,
      e_undefinedReason,
      e_transportNotSupported,
      e_transportQOSNotSupported,
      e_resourceUnavailable,
      e_invalidAlias,
      e_securityDenial,
      e_fullRegistrationRequired,
      e_additiveRegistrationNotSupported,
      e_invalidTerminalAliases,
      e_genericDataReason,
      e_neededFeatureNotSupported,
      e_securityError,
      e_registerWithAssignedGK
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ArrayOf_AliasAddress &() const;
#else
    operator H225_ArrayOf_AliasAddress &();
    operator const H225_ArrayOf_AliasAddress &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_RegistrationRejectReason_invalidTerminalAliases &() const;
#else
    operator H225_RegistrationRejectReason_invalidTerminalAliases &();
    operator const H225_RegistrationRejectReason_invalidTerminalAliases &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SecurityErrors &() const;
#else
    operator H225_SecurityErrors &();
    operator const H225_SecurityErrors &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// UnregRequestReason
//

class H225_SecurityErrors2;

class H225_UnregRequestReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_UnregRequestReason, PASN_Choice);
#endif
  public:
    H225_UnregRequestReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_reregistrationRequired,
      e_ttlExpired,
      e_securityDenial,
      e_undefinedReason,
      e_maintenance,
      e_securityError,
      e_registerWithAssignedGK
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SecurityErrors2 &() const;
#else
    operator H225_SecurityErrors2 &();
    operator const H225_SecurityErrors2 &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// UnregRejectReason
//

class H225_SecurityErrors2;

class H225_UnregRejectReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_UnregRejectReason, PASN_Choice);
#endif
  public:
    H225_UnregRejectReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_notCurrentlyRegistered,
      e_callInProgress,
      e_undefinedReason,
      e_permissionDenied,
      e_securityDenial,
      e_securityError
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SecurityErrors2 &() const;
#else
    operator H225_SecurityErrors2 &();
    operator const H225_SecurityErrors2 &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// CallType
//

class H225_CallType : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallType, PASN_Choice);
#endif
  public:
    H225_CallType(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_pointToPoint,
      e_oneToN,
      e_nToOne,
      e_nToN
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// CallModel
//

class H225_CallModel : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallModel, PASN_Choice);
#endif
  public:
    H225_CallModel(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_direct,
      e_gatekeeperRouted
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// TransportQOS
//

class H225_ArrayOf_QOSCapability;

class H225_TransportQOS : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TransportQOS, PASN_Choice);
#endif
  public:
    H225_TransportQOS(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_endpointControlled,
      e_gatekeeperControlled,
      e_noControl,
      e_qOSCapabilities
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ArrayOf_QOSCapability &() const;
#else
    operator H225_ArrayOf_QOSCapability &();
    operator const H225_ArrayOf_QOSCapability &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// UUIEsRequested
//

class H225_UUIEsRequested : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_UUIEsRequested, PASN_Sequence);
#endif
  public:
    H225_UUIEsRequested(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_status,
      e_statusInquiry,
      e_setupAcknowledge,
      e_notify
    };

    PASN_Boolean m_setup;
    PASN_Boolean m_callProceeding;
    PASN_Boolean m_connect;
    PASN_Boolean m_alerting;
    PASN_Boolean m_information;
    PASN_Boolean m_releaseComplete;
    PASN_Boolean m_facility;
    PASN_Boolean m_progress;
    PASN_Boolean m_empty;
    PASN_Boolean m_status;
    PASN_Boolean m_statusInquiry;
    PASN_Boolean m_setupAcknowledge;
    PASN_Boolean m_notify;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AdmissionRejectReason
//

class H225_ArrayOf_PartyNumber;
class H225_SecurityErrors2;

class H225_AdmissionRejectReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_AdmissionRejectReason, PASN_Choice);
#endif
  public:
    H225_AdmissionRejectReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_calledPartyNotRegistered,
      e_invalidPermission,
      e_requestDenied,
      e_undefinedReason,
      e_callerNotRegistered,
      e_routeCallToGatekeeper,
      e_invalidEndpointIdentifier,
      e_resourceUnavailable,
      e_securityDenial,
      e_qosControlNotSupported,
      e_incompleteAddress,
      e_aliasesInconsistent,
      e_routeCallToSCN,
      e_exceedsCallCapacity,
      e_collectDestination,
      e_collectPIN,
      e_genericDataReason,
      e_neededFeatureNotSupported,
      e_securityErrors,
      e_securityDHmismatch,
      e_noRouteToDestination,
      e_unallocatedNumber,
      e_registerWithAssignedGK
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ArrayOf_PartyNumber &() const;
#else
    operator H225_ArrayOf_PartyNumber &();
    operator const H225_ArrayOf_PartyNumber &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SecurityErrors2 &() const;
#else
    operator H225_SecurityErrors2 &();
    operator const H225_SecurityErrors2 &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// BandRejectReason
//

class H225_SecurityErrors2;

class H225_BandRejectReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_BandRejectReason, PASN_Choice);
#endif
  public:
    H225_BandRejectReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_notBound,
      e_invalidConferenceID,
      e_invalidPermission,
      e_insufficientResources,
      e_invalidRevision,
      e_undefinedReason,
      e_securityDenial,
      e_securityError
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SecurityErrors2 &() const;
#else
    operator H225_SecurityErrors2 &();
    operator const H225_SecurityErrors2 &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// LocationRejectReason
//

class H225_ArrayOf_PartyNumber;
class H225_SecurityErrors2;

class H225_LocationRejectReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_LocationRejectReason, PASN_Choice);
#endif
  public:
    H225_LocationRejectReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_notRegistered,
      e_invalidPermission,
      e_requestDenied,
      e_undefinedReason,
      e_securityDenial,
      e_aliasesInconsistent,
      e_routeCalltoSCN,
      e_resourceUnavailable,
      e_genericDataReason,
      e_neededFeatureNotSupported,
      e_hopCountExceeded,
      e_incompleteAddress,
      e_securityError,
      e_securityDHmismatch,
      e_noRouteToDestination,
      e_unallocatedNumber
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ArrayOf_PartyNumber &() const;
#else
    operator H225_ArrayOf_PartyNumber &();
    operator const H225_ArrayOf_PartyNumber &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SecurityErrors2 &() const;
#else
    operator H225_SecurityErrors2 &();
    operator const H225_SecurityErrors2 &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// DisengageReason
//

class H225_DisengageReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_DisengageReason, PASN_Choice);
#endif
  public:
    H225_DisengageReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_forcedDrop,
      e_normalDrop,
      e_undefinedReason
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// DisengageRejectReason
//

class H225_SecurityErrors2;

class H225_DisengageRejectReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_DisengageRejectReason, PASN_Choice);
#endif
  public:
    H225_DisengageRejectReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_notRegistered,
      e_requestToDropOther,
      e_securityDenial,
      e_securityError
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SecurityErrors2 &() const;
#else
    operator H225_SecurityErrors2 &();
    operator const H225_SecurityErrors2 &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// InfoRequestResponseStatus
//

class H225_InfoRequestResponseStatus : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_InfoRequestResponseStatus, PASN_Choice);
#endif
  public:
    H225_InfoRequestResponseStatus(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_complete,
      e_incomplete,
      e_segment,
      e_invalidCall
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// InfoRequestNakReason
//

class H225_SecurityErrors2;

class H225_InfoRequestNakReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_InfoRequestNakReason, PASN_Choice);
#endif
  public:
    H225_InfoRequestNakReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_notRegistered,
      e_securityDenial,
      e_undefinedReason,
      e_securityError
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SecurityErrors2 &() const;
#else
    operator H225_SecurityErrors2 &();
    operator const H225_SecurityErrors2 &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// H323-UserInformation_user-data
//

class H225_H323_UserInformation_user_data : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H323_UserInformation_user_data, PASN_Sequence);
#endif
  public:
    H225_H323_UserInformation_user_data(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Integer m_protocol_discriminator;
    PASN_OctetString m_user_information;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// H323-UU-PDU_h323-message-body
//

class H225_Setup_UUIE;
class H225_CallProceeding_UUIE;
class H225_Connect_UUIE;
class H225_Alerting_UUIE;
class H225_Information_UUIE;
class H225_ReleaseComplete_UUIE;
class H225_Facility_UUIE;
class H225_Progress_UUIE;
class H225_Status_UUIE;
class H225_StatusInquiry_UUIE;
class H225_SetupAcknowledge_UUIE;
class H225_Notify_UUIE;

class H225_H323_UU_PDU_h323_message_body : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H323_UU_PDU_h323_message_body, PASN_Choice);
#endif
  public:
    H225_H323_UU_PDU_h323_message_body(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_setup,
      e_callProceeding,
      e_connect,
      e_alerting,
      e_information,
      e_releaseComplete,
      e_facility,
      e_progress,
      e_empty,
      e_status,
      e_statusInquiry,
      e_setupAcknowledge,
      e_notify
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_Setup_UUIE &() const;
#else
    operator H225_Setup_UUIE &();
    operator const H225_Setup_UUIE &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_CallProceeding_UUIE &() const;
#else
    operator H225_CallProceeding_UUIE &();
    operator const H225_CallProceeding_UUIE &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_Connect_UUIE &() const;
#else
    operator H225_Connect_UUIE &();
    operator const H225_Connect_UUIE &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_Alerting_UUIE &() const;
#else
    operator H225_Alerting_UUIE &();
    operator const H225_Alerting_UUIE &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_Information_UUIE &() const;
#else
    operator H225_Information_UUIE &();
    operator const H225_Information_UUIE &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_ReleaseComplete_UUIE &() const;
#else
    operator H225_ReleaseComplete_UUIE &();
    operator const H225_ReleaseComplete_UUIE &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_Facility_UUIE &() const;
#else
    operator H225_Facility_UUIE &();
    operator const H225_Facility_UUIE &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_Progress_UUIE &() const;
#else
    operator H225_Progress_UUIE &();
    operator const H225_Progress_UUIE &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_Status_UUIE &() const;
#else
    operator H225_Status_UUIE &();
    operator const H225_Status_UUIE &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_StatusInquiry_UUIE &() const;
#else
    operator H225_StatusInquiry_UUIE &();
    operator const H225_StatusInquiry_UUIE &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_SetupAcknowledge_UUIE &() const;
#else
    operator H225_SetupAcknowledge_UUIE &();
    operator const H225_SetupAcknowledge_UUIE &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_Notify_UUIE &() const;
#else
    operator H225_Notify_UUIE &();
    operator const H225_Notify_UUIE &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ArrayOf_PASN_OctetString
//

class H225_ArrayOf_PASN_OctetString : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_PASN_OctetString, PASN_Array);
#endif
  public:
    H225_ArrayOf_PASN_OctetString(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_OctetString & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_NonStandardParameter
//

class H225_NonStandardParameter;

class H225_ArrayOf_NonStandardParameter : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_NonStandardParameter, PASN_Array);
#endif
  public:
    H225_ArrayOf_NonStandardParameter(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_NonStandardParameter & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_GenericData
//

class H225_GenericData;

class H225_ArrayOf_GenericData : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_GenericData, PASN_Array);
#endif
  public:
    H225_ArrayOf_GenericData(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_GenericData & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_ClearToken
//

class H235_ClearToken;

class H225_ArrayOf_ClearToken : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_ClearToken, PASN_Array);
#endif
  public:
    H225_ArrayOf_ClearToken(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H235_ClearToken & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_CryptoH323Token
//

class H225_CryptoH323Token;

class H225_ArrayOf_CryptoH323Token : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_CryptoH323Token, PASN_Array);
#endif
  public:
    H225_ArrayOf_CryptoH323Token(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_CryptoH323Token & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_AliasAddress
//

class H225_AliasAddress;

class H225_ArrayOf_AliasAddress : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_AliasAddress, PASN_Array);
#endif
  public:
    H225_ArrayOf_AliasAddress(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_AliasAddress & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_ServiceControlSession
//

class H225_ServiceControlSession;

class H225_ArrayOf_ServiceControlSession : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_ServiceControlSession, PASN_Array);
#endif
  public:
    H225_ArrayOf_ServiceControlSession(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_ServiceControlSession & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_DisplayName
//

class H225_DisplayName;

class H225_ArrayOf_DisplayName : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_DisplayName, PASN_Array);
#endif
  public:
    H225_ArrayOf_DisplayName(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_DisplayName & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// Connect-UUIE_language
//

class H225_Connect_UUIE_language : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Connect_UUIE_language, PASN_Array);
#endif
  public:
    H225_Connect_UUIE_language(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_IA5String & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_CallReferenceValue
//

class H225_CallReferenceValue;

class H225_ArrayOf_CallReferenceValue : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_CallReferenceValue, PASN_Array);
#endif
  public:
    H225_ArrayOf_CallReferenceValue(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_CallReferenceValue & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// Setup-UUIE_conferenceGoal
//

class H225_Setup_UUIE_conferenceGoal : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Setup_UUIE_conferenceGoal, PASN_Choice);
#endif
  public:
    H225_Setup_UUIE_conferenceGoal(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_create,
      e_join,
      e_invite,
      e_capability_negotiation,
      e_callIndependentSupplementaryService
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ArrayOf_H245Security
//

class H225_H245Security;

class H225_ArrayOf_H245Security : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_H245Security, PASN_Array);
#endif
  public:
    H225_ArrayOf_H245Security(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_H245Security & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// Setup-UUIE_connectionParameters
//

class H225_Setup_UUIE_connectionParameters : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Setup_UUIE_connectionParameters, PASN_Sequence);
#endif
  public:
    H225_Setup_UUIE_connectionParameters(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_ScnConnectionType m_connectionType;
    PASN_Integer m_numberOfScnConnections;
    H225_ScnConnectionAggregation m_connectionAggregation;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// Setup-UUIE_language
//

class H225_Setup_UUIE_language : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Setup_UUIE_language, PASN_Array);
#endif
  public:
    H225_Setup_UUIE_language(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_IA5String & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_SupportedProtocols
//

class H225_SupportedProtocols;

class H225_ArrayOf_SupportedProtocols : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_SupportedProtocols, PASN_Array);
#endif
  public:
    H225_ArrayOf_SupportedProtocols(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_SupportedProtocols & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_FeatureDescriptor
//

class H225_FeatureDescriptor;

class H225_ArrayOf_FeatureDescriptor : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_FeatureDescriptor, PASN_Array);
#endif
  public:
    H225_ArrayOf_FeatureDescriptor(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_FeatureDescriptor & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_ExtendedAliasAddress
//

class H225_ExtendedAliasAddress;

class H225_ArrayOf_ExtendedAliasAddress : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_ExtendedAliasAddress, PASN_Array);
#endif
  public:
    H225_ArrayOf_ExtendedAliasAddress(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_ExtendedAliasAddress & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_ConferenceList
//

class H225_ConferenceList;

class H225_ArrayOf_ConferenceList : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_ConferenceList, PASN_Array);
#endif
  public:
    H225_ArrayOf_ConferenceList(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_ConferenceList & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// TransportAddress_ipAddress
//

class H225_TransportAddress_ipAddress : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TransportAddress_ipAddress, PASN_Sequence);
#endif
  public:
    H225_TransportAddress_ipAddress(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_OctetString m_ip;
    PASN_Integer m_port;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// TransportAddress_ipxAddress
//

class H225_TransportAddress_ipxAddress : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TransportAddress_ipxAddress, PASN_Sequence);
#endif
  public:
    H225_TransportAddress_ipxAddress(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_OctetString m_node;
    PASN_OctetString m_netnum;
    PASN_OctetString m_port;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// TransportAddress_ip6Address
//

class H225_TransportAddress_ip6Address : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TransportAddress_ip6Address, PASN_Sequence);
#endif
  public:
    H225_TransportAddress_ip6Address(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_OctetString m_ip;
    PASN_Integer m_port;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ArrayOf_TunnelledProtocol
//

class H225_TunnelledProtocol;

class H225_ArrayOf_TunnelledProtocol : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_TunnelledProtocol, PASN_Array);
#endif
  public:
    H225_ArrayOf_TunnelledProtocol(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_TunnelledProtocol & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_DataRate
//

class H225_DataRate;

class H225_ArrayOf_DataRate : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_DataRate, PASN_Array);
#endif
  public:
    H225_ArrayOf_DataRate(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_DataRate & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_SupportedPrefix
//

class H225_SupportedPrefix;

class H225_ArrayOf_SupportedPrefix : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_SupportedPrefix, PASN_Array);
#endif
  public:
    H225_ArrayOf_SupportedPrefix(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_SupportedPrefix & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// TunnelledProtocol_id
//

class H225_TunnelledProtocolAlternateIdentifier;

class H225_TunnelledProtocol_id : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TunnelledProtocol_id, PASN_Choice);
#endif
  public:
    H225_TunnelledProtocol_id(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_tunnelledProtocolObjectID,
      e_tunnelledProtocolAlternateID
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_TunnelledProtocolAlternateIdentifier &() const;
#else
    operator H225_TunnelledProtocolAlternateIdentifier &();
    operator const H225_TunnelledProtocolAlternateIdentifier &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// AddressPattern_range
//

class H225_AddressPattern_range : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_AddressPattern_range, PASN_Sequence);
#endif
  public:
    H225_AddressPattern_range(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_PartyNumber m_startOfRange;
    H225_PartyNumber m_endOfRange;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ANSI-41-UIM_system-id
//

class H225_ANSI_41_UIM_system_id : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ANSI_41_UIM_system_id, PASN_Choice);
#endif
  public:
    H225_ANSI_41_UIM_system_id(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_sid,
      e_mid
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ArrayOf_TransportAddress
//

class H225_TransportAddress;

class H225_ArrayOf_TransportAddress : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_TransportAddress, PASN_Array);
#endif
  public:
    H225_ArrayOf_TransportAddress(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_TransportAddress & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_AlternateGK
//

class H225_AlternateGK;

class H225_ArrayOf_AlternateGK : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_AlternateGK, PASN_Array);
#endif
  public:
    H225_ArrayOf_AlternateGK(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_AlternateGK & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// CryptoH323Token_cryptoEPPwdHash
//

class H225_CryptoH323Token_cryptoEPPwdHash : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CryptoH323Token_cryptoEPPwdHash, PASN_Sequence);
#endif
  public:
    H225_CryptoH323Token_cryptoEPPwdHash(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_AliasAddress m_alias;
    H235_TimeStamp m_timeStamp;
    H235_HASHED<H235_EncodedPwdCertToken> m_token;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CryptoH323Token_cryptoGKPwdHash
//

class H225_CryptoH323Token_cryptoGKPwdHash : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CryptoH323Token_cryptoGKPwdHash, PASN_Sequence);
#endif
  public:
    H225_CryptoH323Token_cryptoGKPwdHash(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_GatekeeperIdentifier m_gatekeeperId;
    H235_TimeStamp m_timeStamp;
    H235_HASHED<H235_EncodedPwdCertToken> m_token;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CapacityReportingSpecification_when
//

class H225_CapacityReportingSpecification_when : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CapacityReportingSpecification_when, PASN_Sequence);
#endif
  public:
    H225_CapacityReportingSpecification_when(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_callStart,
      e_callEnd
    };

    PASN_Null m_callStart;
    PASN_Null m_callEnd;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ArrayOf_CallsAvailable
//

class H225_CallsAvailable;

class H225_ArrayOf_CallsAvailable : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_CallsAvailable, PASN_Array);
#endif
  public:
    H225_ArrayOf_CallsAvailable(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_CallsAvailable & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// CicInfo_cic
//

class H225_CicInfo_cic : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CicInfo_cic, PASN_Array);
#endif
  public:
    H225_CicInfo_cic(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_OctetString & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// GroupID_member
//

class H225_GroupID_member : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GroupID_member, PASN_Array);
#endif
  public:
    H225_GroupID_member(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_Integer & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ServiceControlSession_reason
//

class H225_ServiceControlSession_reason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ServiceControlSession_reason, PASN_Choice);
#endif
  public:
    H225_ServiceControlSession_reason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_open,
      e_refresh,
      e_close
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// RasUsageSpecification_when
//

class H225_RasUsageSpecification_when : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RasUsageSpecification_when, PASN_Sequence);
#endif
  public:
    H225_RasUsageSpecification_when(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_start,
      e_end,
      e_inIrr
    };

    PASN_Null m_start;
    PASN_Null m_end;
    PASN_Null m_inIrr;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RasUsageSpecification_callStartingPoint
//

class H225_RasUsageSpecification_callStartingPoint : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RasUsageSpecification_callStartingPoint, PASN_Sequence);
#endif
  public:
    H225_RasUsageSpecification_callStartingPoint(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_alerting,
      e_connect
    };

    PASN_Null m_alerting;
    PASN_Null m_connect;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CallCreditServiceControl_billingMode
//

class H225_CallCreditServiceControl_billingMode : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallCreditServiceControl_billingMode, PASN_Choice);
#endif
  public:
    H225_CallCreditServiceControl_billingMode(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_credit,
      e_debit
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// CallCreditServiceControl_callStartingPoint
//

class H225_CallCreditServiceControl_callStartingPoint : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallCreditServiceControl_callStartingPoint, PASN_Choice);
#endif
  public:
    H225_CallCreditServiceControl_callStartingPoint(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_alerting,
      e_connect
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ArrayOf_EnumeratedParameter
//

class H225_EnumeratedParameter;

class H225_ArrayOf_EnumeratedParameter : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_EnumeratedParameter, PASN_Array);
#endif
  public:
    H225_ArrayOf_EnumeratedParameter(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_EnumeratedParameter & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// RTPSession_associatedSessionIds
//

class H225_RTPSession_associatedSessionIds : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RTPSession_associatedSessionIds, PASN_Array);
#endif
  public:
    H225_RTPSession_associatedSessionIds(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_Integer & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_AdmissionConfirm
//

class H225_AdmissionConfirm;

class H225_ArrayOf_AdmissionConfirm : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_AdmissionConfirm, PASN_Array);
#endif
  public:
    H225_ArrayOf_AdmissionConfirm(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_AdmissionConfirm & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_Endpoint
//

class H225_Endpoint;

class H225_ArrayOf_Endpoint : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_Endpoint, PASN_Array);
#endif
  public:
    H225_ArrayOf_Endpoint(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_Endpoint & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_AuthenticationMechanism
//

class H235_AuthenticationMechanism;

class H225_ArrayOf_AuthenticationMechanism : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_AuthenticationMechanism, PASN_Array);
#endif
  public:
    H225_ArrayOf_AuthenticationMechanism(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H235_AuthenticationMechanism & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_PASN_ObjectId
//

class H225_ArrayOf_PASN_ObjectId : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_PASN_ObjectId, PASN_Array);
#endif
  public:
    H225_ArrayOf_PASN_ObjectId(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_ObjectId & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_IntegrityMechanism
//

class H225_IntegrityMechanism;

class H225_ArrayOf_IntegrityMechanism : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_IntegrityMechanism, PASN_Array);
#endif
  public:
    H225_ArrayOf_IntegrityMechanism(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_IntegrityMechanism & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_AddressPattern
//

class H225_AddressPattern;

class H225_ArrayOf_AddressPattern : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_AddressPattern, PASN_Array);
#endif
  public:
    H225_ArrayOf_AddressPattern(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_AddressPattern & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_H248PackagesDescriptor
//

class H225_H248PackagesDescriptor;

class H225_ArrayOf_H248PackagesDescriptor : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_H248PackagesDescriptor, PASN_Array);
#endif
  public:
    H225_ArrayOf_H248PackagesDescriptor(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_H248PackagesDescriptor & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// RegistrationRequest_language
//

class H225_RegistrationRequest_language : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RegistrationRequest_language, PASN_Array);
#endif
  public:
    H225_RegistrationRequest_language(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_IA5String & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_RasUsageSpecification
//

class H225_RasUsageSpecification;

class H225_ArrayOf_RasUsageSpecification : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_RasUsageSpecification, PASN_Array);
#endif
  public:
    H225_ArrayOf_RasUsageSpecification(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_RasUsageSpecification & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// RegistrationConfirm_language
//

class H225_RegistrationConfirm_language : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RegistrationConfirm_language, PASN_Array);
#endif
  public:
    H225_RegistrationConfirm_language(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_IA5String & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// RegistrationRejectReason_invalidTerminalAliases
//

class H225_RegistrationRejectReason_invalidTerminalAliases : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RegistrationRejectReason_invalidTerminalAliases, PASN_Sequence);
#endif
  public:
    H225_RegistrationRejectReason_invalidTerminalAliases(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_terminalAlias,
      e_terminalAliasPattern,
      e_supportedPrefixes
    };

    H225_ArrayOf_AliasAddress m_terminalAlias;
    H225_ArrayOf_AddressPattern m_terminalAliasPattern;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ArrayOf_QOSCapability
//

class H245_QOSCapability;

class H225_ArrayOf_QOSCapability : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_QOSCapability, PASN_Array);
#endif
  public:
    H225_ArrayOf_QOSCapability(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H245_QOSCapability & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// AdmissionConfirm_language
//

class H225_AdmissionConfirm_language : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_AdmissionConfirm_language, PASN_Array);
#endif
  public:
    H225_AdmissionConfirm_language(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_IA5String & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_PartyNumber
//

class H225_PartyNumber;

class H225_ArrayOf_PartyNumber : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_PartyNumber, PASN_Array);
#endif
  public:
    H225_ArrayOf_PartyNumber(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_PartyNumber & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_BandwidthDetails
//

class H225_BandwidthDetails;

class H225_ArrayOf_BandwidthDetails : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_BandwidthDetails, PASN_Array);
#endif
  public:
    H225_ArrayOf_BandwidthDetails(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_BandwidthDetails & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// LocationRequest_language
//

class H225_LocationRequest_language : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_LocationRequest_language, PASN_Array);
#endif
  public:
    H225_LocationRequest_language(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_IA5String & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// LocationConfirm_language
//

class H225_LocationConfirm_language : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_LocationConfirm_language, PASN_Array);
#endif
  public:
    H225_LocationConfirm_language(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_IA5String & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// InfoRequestResponse_perCallInfo
//

class H225_InfoRequestResponse_perCallInfo_subtype;

class H225_InfoRequestResponse_perCallInfo : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_InfoRequestResponse_perCallInfo, PASN_Array);
#endif
  public:
    H225_InfoRequestResponse_perCallInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_InfoRequestResponse_perCallInfo_subtype & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ServiceControlIndication_callSpecific
//

class H225_ServiceControlIndication_callSpecific : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ServiceControlIndication_callSpecific, PASN_Sequence);
#endif
  public:
    H225_ServiceControlIndication_callSpecific(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_CallIdentifier m_callIdentifier;
    H225_ConferenceIdentifier m_conferenceID;
    PASN_Boolean m_answeredCall;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ServiceControlResponse_result
//

class H225_ServiceControlResponse_result : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ServiceControlResponse_result, PASN_Choice);
#endif
  public:
    H225_ServiceControlResponse_result(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_started,
      e_failed,
      e_stopped,
      e_notAvailable,
      e_neededFeatureNotSupported
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// TransportAddress_ipSourceRoute_route
//

class H225_TransportAddress_ipSourceRoute_route : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TransportAddress_ipSourceRoute_route, PASN_Array);
#endif
  public:
    H225_TransportAddress_ipSourceRoute_route(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_OctetString & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// TransportAddress_ipSourceRoute_routing
//

class H225_TransportAddress_ipSourceRoute_routing : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TransportAddress_ipSourceRoute_routing, PASN_Choice);
#endif
  public:
    H225_TransportAddress_ipSourceRoute_routing(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_strict,
      e_loose
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ArrayOf_RTPSession
//

class H225_RTPSession;

class H225_ArrayOf_RTPSession : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_RTPSession, PASN_Array);
#endif
  public:
    H225_ArrayOf_RTPSession(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_RTPSession & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_TransportChannelInfo
//

class H225_TransportChannelInfo;

class H225_ArrayOf_TransportChannelInfo : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_TransportChannelInfo, PASN_Array);
#endif
  public:
    H225_ArrayOf_TransportChannelInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_TransportChannelInfo & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_ConferenceIdentifier
//

class H225_ConferenceIdentifier;

class H225_ArrayOf_ConferenceIdentifier : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ArrayOf_ConferenceIdentifier, PASN_Array);
#endif
  public:
    H225_ArrayOf_ConferenceIdentifier(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_ConferenceIdentifier & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// InfoRequestResponse_perCallInfo_subtype_pdu
//

class H225_InfoRequestResponse_perCallInfo_subtype_pdu_subtype;

class H225_InfoRequestResponse_perCallInfo_subtype_pdu : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_InfoRequestResponse_perCallInfo_subtype_pdu, PASN_Array);
#endif
  public:
    H225_InfoRequestResponse_perCallInfo_subtype_pdu(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_InfoRequestResponse_perCallInfo_subtype_pdu_subtype & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// Status-UUIE
//

class H225_Status_UUIE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Status_UUIE, PASN_Sequence);
#endif
  public:
    H225_Status_UUIE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_tokens,
      e_cryptoTokens
    };

    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_CallIdentifier m_callIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// StatusInquiry-UUIE
//

class H225_StatusInquiry_UUIE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_StatusInquiry_UUIE, PASN_Sequence);
#endif
  public:
    H225_StatusInquiry_UUIE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_tokens,
      e_cryptoTokens
    };

    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_CallIdentifier m_callIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// SetupAcknowledge-UUIE
//

class H225_SetupAcknowledge_UUIE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_SetupAcknowledge_UUIE, PASN_Sequence);
#endif
  public:
    H225_SetupAcknowledge_UUIE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_tokens,
      e_cryptoTokens
    };

    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_CallIdentifier m_callIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// VendorIdentifier
//

class H225_VendorIdentifier : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_VendorIdentifier, PASN_Sequence);
#endif
  public:
    H225_VendorIdentifier(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_productId,
      e_versionId,
      e_enterpriseNumber
    };

    H225_H221NonStandard m_vendor;
    PASN_OctetString m_productId;
    PASN_OctetString m_versionId;
    PASN_ObjectId m_enterpriseNumber;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// TunnelledProtocol
//

class H225_TunnelledProtocol : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TunnelledProtocol, PASN_Sequence);
#endif
  public:
    H225_TunnelledProtocol(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_subIdentifier
    };

    H225_TunnelledProtocol_id m_id;
    PASN_IA5String m_subIdentifier;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// NonStandardParameter
//

class H225_NonStandardParameter : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_NonStandardParameter, PASN_Sequence);
#endif
  public:
    H225_NonStandardParameter(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_NonStandardIdentifier m_nonStandardIdentifier;
    PASN_OctetString m_data;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// PublicPartyNumber
//

class H225_PublicPartyNumber : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_PublicPartyNumber, PASN_Sequence);
#endif
  public:
    H225_PublicPartyNumber(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_PublicTypeOfNumber m_publicTypeOfNumber;
    H225_NumberDigits m_publicNumberDigits;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// PrivatePartyNumber
//

class H225_PrivatePartyNumber : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_PrivatePartyNumber, PASN_Sequence);
#endif
  public:
    H225_PrivatePartyNumber(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_PrivateTypeOfNumber m_privateTypeOfNumber;
    H225_NumberDigits m_privateNumberDigits;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ANSI-41-UIM
//

class H225_ANSI_41_UIM : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ANSI_41_UIM, PASN_Sequence);
#endif
  public:
    H225_ANSI_41_UIM(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_imsi,
      e_min,
      e_mdn,
      e_msisdn,
      e_esn,
      e_mscid,
      e_systemMyTypeCode,
      e_systemAccessType,
      e_qualificationInformationCode,
      e_sesn,
      e_soc
    };

    PASN_IA5String m_imsi;
    PASN_IA5String m_min;
    PASN_IA5String m_mdn;
    PASN_IA5String m_msisdn;
    PASN_IA5String m_esn;
    PASN_IA5String m_mscid;
    H225_ANSI_41_UIM_system_id m_system_id;
    PASN_OctetString m_systemMyTypeCode;
    PASN_OctetString m_systemAccessType;
    PASN_OctetString m_qualificationInformationCode;
    PASN_IA5String m_sesn;
    PASN_IA5String m_soc;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// IsupPublicPartyNumber
//

class H225_IsupPublicPartyNumber : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_IsupPublicPartyNumber, PASN_Sequence);
#endif
  public:
    H225_IsupPublicPartyNumber(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_NatureOfAddress m_natureOfAddress;
    H225_IsupDigits m_address;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// IsupPrivatePartyNumber
//

class H225_IsupPrivatePartyNumber : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_IsupPrivatePartyNumber, PASN_Sequence);
#endif
  public:
    H225_IsupPrivatePartyNumber(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_PrivateTypeOfNumber m_privateTypeOfNumber;
    H225_IsupDigits m_address;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AlternateTransportAddresses
//

class H225_AlternateTransportAddresses : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_AlternateTransportAddresses, PASN_Sequence);
#endif
  public:
    H225_AlternateTransportAddresses(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_annexE,
      e_sctp
    };

    H225_ArrayOf_TransportAddress m_annexE;
    H225_ArrayOf_TransportAddress m_sctp;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AlternateGK
//

class H225_AlternateGK : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_AlternateGK, PASN_Sequence);
#endif
  public:
    H225_AlternateGK(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_gatekeeperIdentifier
    };

    H225_TransportAddress m_rasAddress;
    H225_GatekeeperIdentifier m_gatekeeperIdentifier;
    PASN_Boolean m_needToRegister;
    PASN_Integer m_priority;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AltGKInfo
//

class H225_AltGKInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_AltGKInfo, PASN_Sequence);
#endif
  public:
    H225_AltGKInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_ArrayOf_AlternateGK m_alternateGatekeeper;
    PASN_Boolean m_altGKisPermanent;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// SecurityCapabilities
//

class H225_SecurityCapabilities : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_SecurityCapabilities, PASN_Sequence);
#endif
  public:
    H225_SecurityCapabilities(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandard
    };

    H225_NonStandardParameter m_nonStandard;
    H225_SecurityServiceMode m_encryption;
    H225_SecurityServiceMode m_authenticaton;
    H225_SecurityServiceMode m_integrity;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// QseriesOptions
//

class H225_QseriesOptions : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_QseriesOptions, PASN_Sequence);
#endif
  public:
    H225_QseriesOptions(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Boolean m_q932Full;
    PASN_Boolean m_q951Full;
    PASN_Boolean m_q952Full;
    PASN_Boolean m_q953Full;
    PASN_Boolean m_q955Full;
    PASN_Boolean m_q956Full;
    PASN_Boolean m_q957Full;
    H225_Q954Details m_q954Info;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// DataRate
//

class H225_DataRate : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_DataRate, PASN_Sequence);
#endif
  public:
    H225_DataRate(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_channelMultiplier
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_BandWidth m_channelRate;
    PASN_Integer m_channelMultiplier;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// SupportedPrefix
//

class H225_SupportedPrefix : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_SupportedPrefix, PASN_Sequence);
#endif
  public:
    H225_SupportedPrefix(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_AliasAddress m_prefix;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CapacityReportingSpecification
//

class H225_CapacityReportingSpecification : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CapacityReportingSpecification, PASN_Sequence);
#endif
  public:
    H225_CapacityReportingSpecification(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_CapacityReportingSpecification_when m_when;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CallCapacityInfo
//

class H225_CallCapacityInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallCapacityInfo, PASN_Sequence);
#endif
  public:
    H225_CallCapacityInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_voiceGwCallsAvailable,
      e_h310GwCallsAvailable,
      e_h320GwCallsAvailable,
      e_h321GwCallsAvailable,
      e_h322GwCallsAvailable,
      e_h323GwCallsAvailable,
      e_h324GwCallsAvailable,
      e_t120OnlyGwCallsAvailable,
      e_t38FaxAnnexbOnlyGwCallsAvailable,
      e_terminalCallsAvailable,
      e_mcuCallsAvailable,
      e_sipGwCallsAvailable
    };

    H225_ArrayOf_CallsAvailable m_voiceGwCallsAvailable;
    H225_ArrayOf_CallsAvailable m_h310GwCallsAvailable;
    H225_ArrayOf_CallsAvailable m_h320GwCallsAvailable;
    H225_ArrayOf_CallsAvailable m_h321GwCallsAvailable;
    H225_ArrayOf_CallsAvailable m_h322GwCallsAvailable;
    H225_ArrayOf_CallsAvailable m_h323GwCallsAvailable;
    H225_ArrayOf_CallsAvailable m_h324GwCallsAvailable;
    H225_ArrayOf_CallsAvailable m_t120OnlyGwCallsAvailable;
    H225_ArrayOf_CallsAvailable m_t38FaxAnnexbOnlyGwCallsAvailable;
    H225_ArrayOf_CallsAvailable m_terminalCallsAvailable;
    H225_ArrayOf_CallsAvailable m_mcuCallsAvailable;
    H225_ArrayOf_CallsAvailable m_sipGwCallsAvailable;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CallsAvailable
//

class H225_CallsAvailable : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallsAvailable, PASN_Sequence);
#endif
  public:
    H225_CallsAvailable(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_group,
      e_carrier
    };

    PASN_Integer m_calls;
    PASN_IA5String m_group;
    H225_CarrierInfo m_carrier;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CicInfo
//

class H225_CicInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CicInfo, PASN_Sequence);
#endif
  public:
    H225_CicInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_CicInfo_cic m_cic;
    PASN_OctetString m_pointCode;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// GroupID
//

class H225_GroupID : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GroupID, PASN_Sequence);
#endif
  public:
    H225_GroupID(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_member
    };

    H225_GroupID_member m_member;
    PASN_IA5String m_group;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ServiceControlSession
//

class H225_ServiceControlSession : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ServiceControlSession, PASN_Sequence);
#endif
  public:
    H225_ServiceControlSession(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_contents
    };

    PASN_Integer m_sessionId;
    H225_ServiceControlDescriptor m_contents;
    H225_ServiceControlSession_reason m_reason;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RasUsageInfoTypes
//

class H225_RasUsageInfoTypes : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RasUsageInfoTypes, PASN_Sequence);
#endif
  public:
    H225_RasUsageInfoTypes(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_startTime,
      e_endTime,
      e_terminationCause
    };

    H225_ArrayOf_NonStandardParameter m_nonStandardUsageTypes;
    PASN_Null m_startTime;
    PASN_Null m_endTime;
    PASN_Null m_terminationCause;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RasUsageSpecification
//

class H225_RasUsageSpecification : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RasUsageSpecification, PASN_Sequence);
#endif
  public:
    H225_RasUsageSpecification(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_callStartingPoint
    };

    H225_RasUsageSpecification_when m_when;
    H225_RasUsageSpecification_callStartingPoint m_callStartingPoint;
    H225_RasUsageInfoTypes m_required;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RasUsageInformation
//

class H225_RasUsageInformation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RasUsageInformation, PASN_Sequence);
#endif
  public:
    H225_RasUsageInformation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_alertingTime,
      e_connectTime,
      e_endTime
    };

    H225_ArrayOf_NonStandardParameter m_nonStandardUsageFields;
    H235_TimeStamp m_alertingTime;
    H235_TimeStamp m_connectTime;
    H235_TimeStamp m_endTime;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// BandwidthDetails
//

class H225_BandwidthDetails : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_BandwidthDetails, PASN_Sequence);
#endif
  public:
    H225_BandwidthDetails(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Boolean m_sender;
    PASN_Boolean m_multicast;
    H225_BandWidth m_bandwidth;
    H225_TransportChannelInfo m_rtcpAddresses;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CallCreditServiceControl
//

class H225_CallCreditServiceControl : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallCreditServiceControl, PASN_Sequence);
#endif
  public:
    H225_CallCreditServiceControl(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_amountString,
      e_billingMode,
      e_callDurationLimit,
      e_enforceCallDurationLimit,
      e_callStartingPoint
    };

    PASN_BMPString m_amountString;
    H225_CallCreditServiceControl_billingMode m_billingMode;
    PASN_Integer m_callDurationLimit;
    PASN_Boolean m_enforceCallDurationLimit;
    H225_CallCreditServiceControl_callStartingPoint m_callStartingPoint;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// GenericData
//

class H225_GenericData : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GenericData, PASN_Sequence);
#endif
  public:
    H225_GenericData(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_parameters
    };

    H225_GenericIdentifier m_id;
    H225_ArrayOf_EnumeratedParameter m_parameters;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// EnumeratedParameter
//

class H225_EnumeratedParameter : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_EnumeratedParameter, PASN_Sequence);
#endif
  public:
    H225_EnumeratedParameter(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_content
    };

    H225_GenericIdentifier m_id;
    H225_Content m_content;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// FeatureSet
//

class H225_FeatureSet : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_FeatureSet, PASN_Sequence);
#endif
  public:
    H225_FeatureSet(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_neededFeatures,
      e_desiredFeatures,
      e_supportedFeatures
    };

    PASN_Boolean m_replacementFeatureSet;
    H225_ArrayOf_FeatureDescriptor m_neededFeatures;
    H225_ArrayOf_FeatureDescriptor m_desiredFeatures;
    H225_ArrayOf_FeatureDescriptor m_supportedFeatures;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RTPSession
//

class H225_RTPSession : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RTPSession, PASN_Sequence);
#endif
  public:
    H225_RTPSession(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_multicast,
      e_bandwidth
    };

    H225_TransportChannelInfo m_rtpAddress;
    H225_TransportChannelInfo m_rtcpAddress;
    PASN_PrintableString m_cname;
    PASN_Integer m_ssrc;
    PASN_Integer m_sessionId;
    H225_RTPSession_associatedSessionIds m_associatedSessionIds;
    PASN_Null m_multicast;
    H225_BandWidth m_bandwidth;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// GatekeeperConfirm
//

class H225_GatekeeperConfirm : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GatekeeperConfirm, PASN_Sequence);
#endif
  public:
    H225_GatekeeperConfirm(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_gatekeeperIdentifier,
      e_alternateGatekeeper,
      e_authenticationMode,
      e_tokens,
      e_cryptoTokens,
      e_algorithmOID,
      e_integrity,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData,
      e_assignedGatekeeper,
      e_rehomingModel
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_NonStandardParameter m_nonStandardData;
    H225_GatekeeperIdentifier m_gatekeeperIdentifier;
    H225_TransportAddress m_rasAddress;
    H225_ArrayOf_AlternateGK m_alternateGatekeeper;
    H235_AuthenticationMechanism m_authenticationMode;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    PASN_ObjectId m_algorithmOID;
    H225_ArrayOf_IntegrityMechanism m_integrity;
    H225_ICV m_integrityCheckValue;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;
    H225_AlternateGK m_assignedGatekeeper;
    H225_RehomingModel m_rehomingModel;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// GatekeeperReject
//

class H225_GatekeeperReject : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GatekeeperReject, PASN_Sequence);
#endif
  public:
    H225_GatekeeperReject(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_gatekeeperIdentifier,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_NonStandardParameter m_nonStandardData;
    H225_GatekeeperIdentifier m_gatekeeperIdentifier;
    H225_GatekeeperRejectReason m_rejectReason;
    H225_AltGKInfo m_altGKInfo;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RegistrationReject
//

class H225_RegistrationReject : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RegistrationReject, PASN_Sequence);
#endif
  public:
    H225_RegistrationReject(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_gatekeeperIdentifier,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData,
      e_assignedGatekeeper
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_NonStandardParameter m_nonStandardData;
    H225_RegistrationRejectReason m_rejectReason;
    H225_GatekeeperIdentifier m_gatekeeperIdentifier;
    H225_AltGKInfo m_altGKInfo;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;
    H225_AlternateGK m_assignedGatekeeper;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UnregistrationRequest
//

class H225_UnregistrationRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_UnregistrationRequest, PASN_Sequence);
#endif
  public:
    H225_UnregistrationRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_endpointAlias,
      e_nonStandardData,
      e_endpointIdentifier,
      e_alternateEndpoints,
      e_gatekeeperIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_reason,
      e_endpointAliasPattern,
      e_supportedPrefixes,
      e_alternateGatekeeper,
      e_genericData,
      e_assignedGatekeeper
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_ArrayOf_TransportAddress m_callSignalAddress;
    H225_ArrayOf_AliasAddress m_endpointAlias;
    H225_NonStandardParameter m_nonStandardData;
    H225_EndpointIdentifier m_endpointIdentifier;
    H225_ArrayOf_Endpoint m_alternateEndpoints;
    H225_GatekeeperIdentifier m_gatekeeperIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_UnregRequestReason m_reason;
    H225_ArrayOf_AddressPattern m_endpointAliasPattern;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;
    H225_ArrayOf_AlternateGK m_alternateGatekeeper;
    H225_ArrayOf_GenericData m_genericData;
    H225_AlternateGK m_assignedGatekeeper;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UnregistrationConfirm
//

class H225_UnregistrationConfirm : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_UnregistrationConfirm, PASN_Sequence);
#endif
  public:
    H225_UnregistrationConfirm(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_genericData,
      e_assignedGatekeeper
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_ArrayOf_GenericData m_genericData;
    H225_AlternateGK m_assignedGatekeeper;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UnregistrationReject
//

class H225_UnregistrationReject : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_UnregistrationReject, PASN_Sequence);
#endif
  public:
    H225_UnregistrationReject(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_genericData
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_UnregRejectReason m_rejectReason;
    H225_NonStandardParameter m_nonStandardData;
    H225_AltGKInfo m_altGKInfo;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AdmissionReject
//

class H225_AdmissionReject : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_AdmissionReject, PASN_Sequence);
#endif
  public:
    H225_AdmissionReject(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_callSignalAddress,
      e_integrityCheckValue,
      e_serviceControl,
      e_featureSet,
      e_genericData,
      e_assignedGatekeeper
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_AdmissionRejectReason m_rejectReason;
    H225_NonStandardParameter m_nonStandardData;
    H225_AltGKInfo m_altGKInfo;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ArrayOf_TransportAddress m_callSignalAddress;
    H225_ICV m_integrityCheckValue;
    H225_ArrayOf_ServiceControlSession m_serviceControl;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;
    H225_AlternateGK m_assignedGatekeeper;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// BandwidthReject
//

class H225_BandwidthReject : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_BandwidthReject, PASN_Sequence);
#endif
  public:
    H225_BandwidthReject(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_genericData
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_BandRejectReason m_rejectReason;
    H225_BandWidth m_allowedBandWidth;
    H225_NonStandardParameter m_nonStandardData;
    H225_AltGKInfo m_altGKInfo;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// LocationReject
//

class H225_LocationReject : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_LocationReject, PASN_Sequence);
#endif
  public:
    H225_LocationReject(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData,
      e_serviceControl
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_LocationRejectReason m_rejectReason;
    H225_NonStandardParameter m_nonStandardData;
    H225_AltGKInfo m_altGKInfo;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;
    H225_ArrayOf_ServiceControlSession m_serviceControl;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// DisengageReject
//

class H225_DisengageReject : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_DisengageReject, PASN_Sequence);
#endif
  public:
    H225_DisengageReject(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_genericData
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_DisengageRejectReason m_rejectReason;
    H225_NonStandardParameter m_nonStandardData;
    H225_AltGKInfo m_altGKInfo;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// InfoRequest
//

class H225_InfoRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_InfoRequest, PASN_Sequence);
#endif
  public:
    H225_InfoRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_replyAddress,
      e_callIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_uuiesRequested,
      e_callLinkage,
      e_usageInfoRequested,
      e_segmentedResponseSupported,
      e_nextSegmentRequested,
      e_capacityInfoRequested,
      e_genericData,
      e_assignedGatekeeper
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_CallReferenceValue m_callReferenceValue;
    H225_NonStandardParameter m_nonStandardData;
    H225_TransportAddress m_replyAddress;
    H225_CallIdentifier m_callIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_UUIEsRequested m_uuiesRequested;
    H225_CallLinkage m_callLinkage;
    H225_RasUsageInfoTypes m_usageInfoRequested;
    PASN_Null m_segmentedResponseSupported;
    PASN_Integer m_nextSegmentRequested;
    PASN_Null m_capacityInfoRequested;
    H225_ArrayOf_GenericData m_genericData;
    H225_AlternateGK m_assignedGatekeeper;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// InfoRequestAck
//

class H225_InfoRequestAck : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_InfoRequestAck, PASN_Sequence);
#endif
  public:
    H225_InfoRequestAck(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// InfoRequestNak
//

class H225_InfoRequestNak : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_InfoRequestNak, PASN_Sequence);
#endif
  public:
    H225_InfoRequestNak(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_NonStandardParameter m_nonStandardData;
    H225_InfoRequestNakReason m_nakReason;
    H225_AltGKInfo m_altGKInfo;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// NonStandardMessage
//

class H225_NonStandardMessage : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_NonStandardMessage, PASN_Sequence);
#endif
  public:
    H225_NonStandardMessage(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UnknownMessageResponse
//

class H225_UnknownMessageResponse : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_UnknownMessageResponse, PASN_Sequence);
#endif
  public:
    H225_UnknownMessageResponse(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_messageNotUnderstood
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    PASN_OctetString m_messageNotUnderstood;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RequestInProgress
//

class H225_RequestInProgress : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RequestInProgress, PASN_Sequence);
#endif
  public:
    H225_RequestInProgress(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    PASN_Integer m_delay;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ResourcesAvailableConfirm
//

class H225_ResourcesAvailableConfirm : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ResourcesAvailableConfirm, PASN_Sequence);
#endif
  public:
    H225_ResourcesAvailableConfirm(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_genericData
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ServiceControlIndication
//

class H225_ServiceControlIndication : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ServiceControlIndication, PASN_Sequence);
#endif
  public:
    H225_ServiceControlIndication(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_endpointIdentifier,
      e_callSpecific,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_ServiceControlSession m_serviceControl;
    H225_EndpointIdentifier m_endpointIdentifier;
    H225_ServiceControlIndication_callSpecific m_callSpecific;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ServiceControlResponse
//

class H225_ServiceControlResponse : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ServiceControlResponse, PASN_Sequence);
#endif
  public:
    H225_ServiceControlResponse(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_result,
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_ServiceControlResponse_result m_result;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// H323-UU-PDU_tunnelledSignallingMessage
//

class H225_H323_UU_PDU_tunnelledSignallingMessage : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H323_UU_PDU_tunnelledSignallingMessage, PASN_Sequence);
#endif
  public:
    H225_H323_UU_PDU_tunnelledSignallingMessage(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_tunnellingRequired,
      e_nonStandardData
    };

    H225_TunnelledProtocol m_tunnelledProtocolID;
    H225_ArrayOf_PASN_OctetString m_messageContent;
    PASN_Null m_tunnellingRequired;
    H225_NonStandardParameter m_nonStandardData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// TransportAddress_ipSourceRoute
//

class H225_TransportAddress_ipSourceRoute : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TransportAddress_ipSourceRoute, PASN_Sequence);
#endif
  public:
    H225_TransportAddress_ipSourceRoute(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_OctetString m_ip;
    PASN_Integer m_port;
    H225_TransportAddress_ipSourceRoute_route m_route;
    H225_TransportAddress_ipSourceRoute_routing m_routing;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RegistrationConfirm_preGrantedARQ
//

class H225_RegistrationConfirm_preGrantedARQ : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RegistrationConfirm_preGrantedARQ, PASN_Sequence);
#endif
  public:
    H225_RegistrationConfirm_preGrantedARQ(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_irrFrequencyInCall,
      e_totalBandwidthRestriction,
      e_alternateTransportAddresses,
      e_useSpecifiedTransport
    };

    PASN_Boolean m_makeCall;
    PASN_Boolean m_useGKCallSignalAddressToMakeCall;
    PASN_Boolean m_answerCall;
    PASN_Boolean m_useGKCallSignalAddressToAnswer;
    PASN_Integer m_irrFrequencyInCall;
    H225_BandWidth m_totalBandwidthRestriction;
    H225_AlternateTransportAddresses m_alternateTransportAddresses;
    H225_UseSpecifiedTransport m_useSpecifiedTransport;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// StimulusControl
//

class H225_StimulusControl : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_StimulusControl, PASN_Sequence);
#endif
  public:
    H225_StimulusControl(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandard,
      e_isText,
      e_h248Message
    };

    H225_NonStandardParameter m_nonStandard;
    PASN_Null m_isText;
    PASN_OctetString m_h248Message;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ConferenceList
//

class H225_ConferenceList : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ConferenceList, PASN_Sequence);
#endif
  public:
    H225_ConferenceList(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_conferenceID,
      e_conferenceAlias,
      e_nonStandardData
    };

    H225_ConferenceIdentifier m_conferenceID;
    H225_AliasAddress m_conferenceAlias;
    H225_NonStandardParameter m_nonStandardData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// GatewayInfo
//

class H225_GatewayInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GatewayInfo, PASN_Sequence);
#endif
  public:
    H225_GatewayInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_protocol,
      e_nonStandardData
    };

    H225_ArrayOf_SupportedProtocols m_protocol;
    H225_NonStandardParameter m_nonStandardData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// H310Caps
//

class H225_H310Caps : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H310Caps, PASN_Sequence);
#endif
  public:
    H225_H310Caps(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_dataRatesSupported,
      e_supportedPrefixes
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_DataRate m_dataRatesSupported;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// H320Caps
//

class H225_H320Caps : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H320Caps, PASN_Sequence);
#endif
  public:
    H225_H320Caps(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_dataRatesSupported,
      e_supportedPrefixes
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_DataRate m_dataRatesSupported;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// H321Caps
//

class H225_H321Caps : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H321Caps, PASN_Sequence);
#endif
  public:
    H225_H321Caps(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_dataRatesSupported,
      e_supportedPrefixes
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_DataRate m_dataRatesSupported;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// H322Caps
//

class H225_H322Caps : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H322Caps, PASN_Sequence);
#endif
  public:
    H225_H322Caps(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_dataRatesSupported,
      e_supportedPrefixes
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_DataRate m_dataRatesSupported;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// H323Caps
//

class H225_H323Caps : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H323Caps, PASN_Sequence);
#endif
  public:
    H225_H323Caps(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_dataRatesSupported,
      e_supportedPrefixes
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_DataRate m_dataRatesSupported;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// H324Caps
//

class H225_H324Caps : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H324Caps, PASN_Sequence);
#endif
  public:
    H225_H324Caps(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_dataRatesSupported,
      e_supportedPrefixes
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_DataRate m_dataRatesSupported;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// VoiceCaps
//

class H225_VoiceCaps : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_VoiceCaps, PASN_Sequence);
#endif
  public:
    H225_VoiceCaps(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_dataRatesSupported,
      e_supportedPrefixes
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_DataRate m_dataRatesSupported;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// T120OnlyCaps
//

class H225_T120OnlyCaps : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_T120OnlyCaps, PASN_Sequence);
#endif
  public:
    H225_T120OnlyCaps(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_dataRatesSupported,
      e_supportedPrefixes
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_DataRate m_dataRatesSupported;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// NonStandardProtocol
//

class H225_NonStandardProtocol : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_NonStandardProtocol, PASN_Sequence);
#endif
  public:
    H225_NonStandardProtocol(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_dataRatesSupported
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_DataRate m_dataRatesSupported;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// T38FaxAnnexbOnlyCaps
//

class H225_T38FaxAnnexbOnlyCaps : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_T38FaxAnnexbOnlyCaps, PASN_Sequence);
#endif
  public:
    H225_T38FaxAnnexbOnlyCaps(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_dataRatesSupported
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_DataRate m_dataRatesSupported;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;
    H245_DataProtocolCapability m_t38FaxProtocol;
    H245_T38FaxProfile m_t38FaxProfile;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// SIPCaps
//

class H225_SIPCaps : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_SIPCaps, PASN_Sequence);
#endif
  public:
    H225_SIPCaps(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_dataRatesSupported,
      e_supportedPrefixes
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_DataRate m_dataRatesSupported;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// McuInfo
//

class H225_McuInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_McuInfo, PASN_Sequence);
#endif
  public:
    H225_McuInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_protocol
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_SupportedProtocols m_protocol;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// TerminalInfo
//

class H225_TerminalInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_TerminalInfo, PASN_Sequence);
#endif
  public:
    H225_TerminalInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData
    };

    H225_NonStandardParameter m_nonStandardData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// GatekeeperInfo
//

class H225_GatekeeperInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GatekeeperInfo, PASN_Sequence);
#endif
  public:
    H225_GatekeeperInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData
    };

    H225_NonStandardParameter m_nonStandardData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// FeatureDescriptor
//

class H225_FeatureDescriptor : public H225_GenericData
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_FeatureDescriptor, H225_GenericData);
#endif
  public:
    H225_FeatureDescriptor(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PObject * Clone() const;
};


//
// CallCapacity
//

class H225_CallCapacity : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallCapacity, PASN_Sequence);
#endif
  public:
    H225_CallCapacity(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_maximumCallCapacity,
      e_currentCallCapacity
    };

    H225_CallCapacityInfo m_maximumCallCapacity;
    H225_CallCapacityInfo m_currentCallCapacity;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CircuitIdentifier
//

class H225_CircuitIdentifier : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CircuitIdentifier, PASN_Sequence);
#endif
  public:
    H225_CircuitIdentifier(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_cic,
      e_group,
      e_carrier
    };

    H225_CicInfo m_cic;
    H225_GroupID m_group;
    H225_CarrierInfo m_carrier;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RegistrationConfirm
//

class H225_RegistrationConfirm : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RegistrationConfirm, PASN_Sequence);
#endif
  public:
    H225_RegistrationConfirm(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_terminalAlias,
      e_gatekeeperIdentifier,
      e_alternateGatekeeper,
      e_timeToLive,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_willRespondToIRR,
      e_preGrantedARQ,
      e_maintainConnection,
      e_serviceControl,
      e_supportsAdditiveRegistration,
      e_terminalAliasPattern,
      e_supportedPrefixes,
      e_usageSpec,
      e_featureServerAlias,
      e_capacityReportingSpec,
      e_featureSet,
      e_genericData,
      e_assignedGatekeeper,
      e_rehomingModel,
      e_transportQOS,
      e_language
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_TransportAddress m_callSignalAddress;
    H225_ArrayOf_AliasAddress m_terminalAlias;
    H225_GatekeeperIdentifier m_gatekeeperIdentifier;
    H225_EndpointIdentifier m_endpointIdentifier;
    H225_ArrayOf_AlternateGK m_alternateGatekeeper;
    H225_TimeToLive m_timeToLive;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    PASN_Boolean m_willRespondToIRR;
    H225_RegistrationConfirm_preGrantedARQ m_preGrantedARQ;
    PASN_Boolean m_maintainConnection;
    H225_ArrayOf_ServiceControlSession m_serviceControl;
    PASN_Null m_supportsAdditiveRegistration;
    H225_ArrayOf_AddressPattern m_terminalAliasPattern;
    H225_ArrayOf_SupportedPrefix m_supportedPrefixes;
    H225_ArrayOf_RasUsageSpecification m_usageSpec;
    H225_AliasAddress m_featureServerAlias;
    H225_CapacityReportingSpecification m_capacityReportingSpec;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;
    H225_AlternateGK m_assignedGatekeeper;
    H225_RehomingModel m_rehomingModel;
    H225_TransportQOS m_transportQOS;
    H225_RegistrationConfirm_language m_language;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// BandwidthRequest
//

class H225_BandwidthRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_BandwidthRequest, PASN_Sequence);
#endif
  public:
    H225_BandwidthRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_callType,
      e_nonStandardData,
      e_callIdentifier,
      e_gatekeeperIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_answeredCall,
      e_callLinkage,
      e_capacity,
      e_usageInformation,
      e_bandwidthDetails,
      e_genericData,
      e_transportQOS
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_EndpointIdentifier m_endpointIdentifier;
    H225_ConferenceIdentifier m_conferenceID;
    H225_CallReferenceValue m_callReferenceValue;
    H225_CallType m_callType;
    H225_BandWidth m_bandWidth;
    H225_NonStandardParameter m_nonStandardData;
    H225_CallIdentifier m_callIdentifier;
    H225_GatekeeperIdentifier m_gatekeeperIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    PASN_Boolean m_answeredCall;
    H225_CallLinkage m_callLinkage;
    H225_CallCapacity m_capacity;
    H225_RasUsageInformation m_usageInformation;
    H225_ArrayOf_BandwidthDetails m_bandwidthDetails;
    H225_ArrayOf_GenericData m_genericData;
    H225_TransportQOS m_transportQOS;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// BandwidthConfirm
//

class H225_BandwidthConfirm : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_BandwidthConfirm, PASN_Sequence);
#endif
  public:
    H225_BandwidthConfirm(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_capacity,
      e_genericData,
      e_transportQOS
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_BandWidth m_bandWidth;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_CallCapacity m_capacity;
    H225_ArrayOf_GenericData m_genericData;
    H225_TransportQOS m_transportQOS;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ResourcesAvailableIndicate
//

class H225_ResourcesAvailableIndicate : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ResourcesAvailableIndicate, PASN_Sequence);
#endif
  public:
    H225_ResourcesAvailableIndicate(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_capacity,
      e_genericData
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_NonStandardParameter m_nonStandardData;
    H225_EndpointIdentifier m_endpointIdentifier;
    H225_ArrayOf_SupportedProtocols m_protocols;
    PASN_Boolean m_almostOutOfResources;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_CallCapacity m_capacity;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// H323-UU-PDU
//

class H225_H323_UU_PDU : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H323_UU_PDU, PASN_Sequence);
#endif
  public:
    H225_H323_UU_PDU(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_h4501SupplementaryService,
      e_h245Tunneling,
      e_h245Control,
      e_nonStandardControl,
      e_callLinkage,
      e_tunnelledSignallingMessage,
      e_provisionalRespToH245Tunneling,
      e_stimulusControl,
      e_genericData
    };

    H225_H323_UU_PDU_h323_message_body m_h323_message_body;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_PASN_OctetString m_h4501SupplementaryService;
    PASN_Boolean m_h245Tunneling;
    H225_ArrayOf_PASN_OctetString m_h245Control;
    H225_ArrayOf_NonStandardParameter m_nonStandardControl;
    H225_CallLinkage m_callLinkage;
    H225_H323_UU_PDU_tunnelledSignallingMessage m_tunnelledSignallingMessage;
    PASN_Null m_provisionalRespToH245Tunneling;
    H225_StimulusControl m_stimulusControl;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// EndpointType
//

class H225_EndpointType : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_EndpointType, PASN_Sequence);
#endif
  public:
    H225_EndpointType(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_vendor,
      e_gatekeeper,
      e_gateway,
      e_mcu,
      e_terminal,
      e_set,
      e_supportedTunnelledProtocols
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_VendorIdentifier m_vendor;
    H225_GatekeeperInfo m_gatekeeper;
    H225_GatewayInfo m_gateway;
    H225_McuInfo m_mcu;
    H225_TerminalInfo m_terminal;
    PASN_Boolean m_mc;
    PASN_Boolean m_undefinedNode;
    PASN_BitString m_set;
    H225_ArrayOf_TunnelledProtocol m_supportedTunnelledProtocols;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CircuitInfo
//

class H225_CircuitInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CircuitInfo, PASN_Sequence);
#endif
  public:
    H225_CircuitInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_sourceCircuitID,
      e_destinationCircuitID,
      e_genericData
    };

    H225_CircuitIdentifier m_sourceCircuitID;
    H225_CircuitIdentifier m_destinationCircuitID;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// GatekeeperRequest
//

class H225_GatekeeperRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_GatekeeperRequest, PASN_Sequence);
#endif
  public:
    H225_GatekeeperRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_gatekeeperIdentifier,
      e_callServices,
      e_endpointAlias,
      e_alternateEndpoints,
      e_tokens,
      e_cryptoTokens,
      e_authenticationCapability,
      e_algorithmOIDs,
      e_integrity,
      e_integrityCheckValue,
      e_supportsAltGK,
      e_featureSet,
      e_genericData,
      e_supportsAssignedGK,
      e_assignedGatekeeper
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_NonStandardParameter m_nonStandardData;
    H225_TransportAddress m_rasAddress;
    H225_EndpointType m_endpointType;
    H225_GatekeeperIdentifier m_gatekeeperIdentifier;
    H225_QseriesOptions m_callServices;
    H225_ArrayOf_AliasAddress m_endpointAlias;
    H225_ArrayOf_Endpoint m_alternateEndpoints;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ArrayOf_AuthenticationMechanism m_authenticationCapability;
    H225_ArrayOf_PASN_ObjectId m_algorithmOIDs;
    H225_ArrayOf_IntegrityMechanism m_integrity;
    H225_ICV m_integrityCheckValue;
    PASN_Null m_supportsAltGK;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;
    PASN_Boolean m_supportsAssignedGK;
    H225_AlternateGK m_assignedGatekeeper;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RegistrationRequest
//

class H225_RegistrationRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_RegistrationRequest, PASN_Sequence);
#endif
  public:
    H225_RegistrationRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_terminalAlias,
      e_gatekeeperIdentifier,
      e_alternateEndpoints,
      e_timeToLive,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_keepAlive,
      e_endpointIdentifier,
      e_willSupplyUUIEs,
      e_maintainConnection,
      e_alternateTransportAddresses,
      e_additiveRegistration,
      e_terminalAliasPattern,
      e_supportsAltGK,
      e_usageReportingCapability,
      e_multipleCalls,
      e_supportedH248Packages,
      e_callCreditCapability,
      e_capacityReportingCapability,
      e_capacity,
      e_featureSet,
      e_genericData,
      e_restart,
      e_supportsACFSequences,
      e_supportsAssignedGK,
      e_assignedGatekeeper,
      e_transportQOS,
      e_language
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_NonStandardParameter m_nonStandardData;
    PASN_Boolean m_discoveryComplete;
    H225_ArrayOf_TransportAddress m_callSignalAddress;
    H225_ArrayOf_TransportAddress m_rasAddress;
    H225_EndpointType m_terminalType;
    H225_ArrayOf_AliasAddress m_terminalAlias;
    H225_GatekeeperIdentifier m_gatekeeperIdentifier;
    H225_VendorIdentifier m_endpointVendor;
    H225_ArrayOf_Endpoint m_alternateEndpoints;
    H225_TimeToLive m_timeToLive;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    PASN_Boolean m_keepAlive;
    H225_EndpointIdentifier m_endpointIdentifier;
    PASN_Boolean m_willSupplyUUIEs;
    PASN_Boolean m_maintainConnection;
    H225_AlternateTransportAddresses m_alternateTransportAddresses;
    PASN_Null m_additiveRegistration;
    H225_ArrayOf_AddressPattern m_terminalAliasPattern;
    PASN_Null m_supportsAltGK;
    H225_RasUsageInfoTypes m_usageReportingCapability;
    PASN_Boolean m_multipleCalls;
    H225_ArrayOf_H248PackagesDescriptor m_supportedH248Packages;
    H225_CallCreditCapability m_callCreditCapability;
    H225_CapacityReportingCapability m_capacityReportingCapability;
    H225_CallCapacity m_capacity;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;
    PASN_Null m_restart;
    PASN_Null m_supportsACFSequences;
    PASN_Boolean m_supportsAssignedGK;
    H225_AlternateGK m_assignedGatekeeper;
    H225_TransportQOS m_transportQOS;
    H225_RegistrationRequest_language m_language;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AdmissionRequest
//

class H225_AdmissionRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_AdmissionRequest, PASN_Sequence);
#endif
  public:
    H225_AdmissionRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_callModel,
      e_destinationInfo,
      e_destCallSignalAddress,
      e_destExtraCallInfo,
      e_srcCallSignalAddress,
      e_nonStandardData,
      e_callServices,
      e_canMapAlias,
      e_callIdentifier,
      e_srcAlternatives,
      e_destAlternatives,
      e_gatekeeperIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_transportQOS,
      e_willSupplyUUIEs,
      e_callLinkage,
      e_gatewayDataRate,
      e_capacity,
      e_circuitInfo,
      e_desiredProtocols,
      e_desiredTunnelledProtocol,
      e_featureSet,
      e_genericData,
      e_canMapSrcAlias
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_CallType m_callType;
    H225_CallModel m_callModel;
    H225_EndpointIdentifier m_endpointIdentifier;
    H225_ArrayOf_AliasAddress m_destinationInfo;
    H225_TransportAddress m_destCallSignalAddress;
    H225_ArrayOf_AliasAddress m_destExtraCallInfo;
    H225_ArrayOf_AliasAddress m_srcInfo;
    H225_TransportAddress m_srcCallSignalAddress;
    H225_BandWidth m_bandWidth;
    H225_CallReferenceValue m_callReferenceValue;
    H225_NonStandardParameter m_nonStandardData;
    H225_QseriesOptions m_callServices;
    H225_ConferenceIdentifier m_conferenceID;
    PASN_Boolean m_activeMC;
    PASN_Boolean m_answerCall;
    PASN_Boolean m_canMapAlias;
    H225_CallIdentifier m_callIdentifier;
    H225_ArrayOf_Endpoint m_srcAlternatives;
    H225_ArrayOf_Endpoint m_destAlternatives;
    H225_GatekeeperIdentifier m_gatekeeperIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_TransportQOS m_transportQOS;
    PASN_Boolean m_willSupplyUUIEs;
    H225_CallLinkage m_callLinkage;
    H225_DataRate m_gatewayDataRate;
    H225_CallCapacity m_capacity;
    H225_CircuitInfo m_circuitInfo;
    H225_ArrayOf_SupportedProtocols m_desiredProtocols;
    H225_TunnelledProtocol m_desiredTunnelledProtocol;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;
    PASN_Boolean m_canMapSrcAlias;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AdmissionConfirm
//

class H225_AdmissionConfirm : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_AdmissionConfirm, PASN_Sequence);
#endif
  public:
    H225_AdmissionConfirm(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_irrFrequency,
      e_nonStandardData,
      e_destinationInfo,
      e_destExtraCallInfo,
      e_destinationType,
      e_remoteExtensionAddress,
      e_alternateEndpoints,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_transportQOS,
      e_willRespondToIRR,
      e_uuiesRequested,
      e_language,
      e_alternateTransportAddresses,
      e_useSpecifiedTransport,
      e_circuitInfo,
      e_usageSpec,
      e_supportedProtocols,
      e_serviceControl,
      e_multipleCalls,
      e_featureSet,
      e_genericData,
      e_modifiedSrcInfo,
      e_assignedGatekeeper
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_BandWidth m_bandWidth;
    H225_CallModel m_callModel;
    H225_TransportAddress m_destCallSignalAddress;
    PASN_Integer m_irrFrequency;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_AliasAddress m_destinationInfo;
    H225_ArrayOf_AliasAddress m_destExtraCallInfo;
    H225_EndpointType m_destinationType;
    H225_ArrayOf_AliasAddress m_remoteExtensionAddress;
    H225_ArrayOf_Endpoint m_alternateEndpoints;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_TransportQOS m_transportQOS;
    PASN_Boolean m_willRespondToIRR;
    H225_UUIEsRequested m_uuiesRequested;
    H225_AdmissionConfirm_language m_language;
    H225_AlternateTransportAddresses m_alternateTransportAddresses;
    H225_UseSpecifiedTransport m_useSpecifiedTransport;
    H225_CircuitInfo m_circuitInfo;
    H225_ArrayOf_RasUsageSpecification m_usageSpec;
    H225_ArrayOf_SupportedProtocols m_supportedProtocols;
    H225_ArrayOf_ServiceControlSession m_serviceControl;
    PASN_Boolean m_multipleCalls;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;
    H225_ArrayOf_AliasAddress m_modifiedSrcInfo;
    H225_AlternateGK m_assignedGatekeeper;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// LocationRequest
//

class H225_LocationRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_LocationRequest, PASN_Sequence);
#endif
  public:
    H225_LocationRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_endpointIdentifier,
      e_nonStandardData,
      e_sourceInfo,
      e_canMapAlias,
      e_gatekeeperIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_desiredProtocols,
      e_desiredTunnelledProtocol,
      e_featureSet,
      e_genericData,
      e_hopCount,
      e_circuitInfo,
      e_callIdentifier,
      e_bandWidth,
      e_sourceEndpointInfo,
      e_canMapSrcAlias,
      e_language
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_EndpointIdentifier m_endpointIdentifier;
    H225_ArrayOf_AliasAddress m_destinationInfo;
    H225_NonStandardParameter m_nonStandardData;
    H225_TransportAddress m_replyAddress;
    H225_ArrayOf_AliasAddress m_sourceInfo;
    PASN_Boolean m_canMapAlias;
    H225_GatekeeperIdentifier m_gatekeeperIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_ArrayOf_SupportedProtocols m_desiredProtocols;
    H225_TunnelledProtocol m_desiredTunnelledProtocol;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;
    PASN_Integer m_hopCount;
    H225_CircuitInfo m_circuitInfo;
    H225_CallIdentifier m_callIdentifier;
    H225_BandWidth m_bandWidth;
    H225_ArrayOf_AliasAddress m_sourceEndpointInfo;
    PASN_Boolean m_canMapSrcAlias;
    H225_LocationRequest_language m_language;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// LocationConfirm
//

class H225_LocationConfirm : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_LocationConfirm, PASN_Sequence);
#endif
  public:
    H225_LocationConfirm(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_destinationInfo,
      e_destExtraCallInfo,
      e_destinationType,
      e_remoteExtensionAddress,
      e_alternateEndpoints,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_alternateTransportAddresses,
      e_supportedProtocols,
      e_multipleCalls,
      e_featureSet,
      e_genericData,
      e_circuitInfo,
      e_serviceControl,
      e_modifiedSrcInfo,
      e_bandWidth,
      e_language
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_TransportAddress m_callSignalAddress;
    H225_TransportAddress m_rasAddress;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_AliasAddress m_destinationInfo;
    H225_ArrayOf_AliasAddress m_destExtraCallInfo;
    H225_EndpointType m_destinationType;
    H225_ArrayOf_AliasAddress m_remoteExtensionAddress;
    H225_ArrayOf_Endpoint m_alternateEndpoints;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_AlternateTransportAddresses m_alternateTransportAddresses;
    H225_ArrayOf_SupportedProtocols m_supportedProtocols;
    PASN_Boolean m_multipleCalls;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_GenericData m_genericData;
    H225_CircuitInfo m_circuitInfo;
    H225_ArrayOf_ServiceControlSession m_serviceControl;
    H225_ArrayOf_AliasAddress m_modifiedSrcInfo;
    H225_BandWidth m_bandWidth;
    H225_LocationConfirm_language m_language;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// DisengageRequest
//

class H225_DisengageRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_DisengageRequest, PASN_Sequence);
#endif
  public:
    H225_DisengageRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_callIdentifier,
      e_gatekeeperIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_answeredCall,
      e_callLinkage,
      e_capacity,
      e_circuitInfo,
      e_usageInformation,
      e_terminationCause,
      e_serviceControl,
      e_genericData
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_EndpointIdentifier m_endpointIdentifier;
    H225_ConferenceIdentifier m_conferenceID;
    H225_CallReferenceValue m_callReferenceValue;
    H225_DisengageReason m_disengageReason;
    H225_NonStandardParameter m_nonStandardData;
    H225_CallIdentifier m_callIdentifier;
    H225_GatekeeperIdentifier m_gatekeeperIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    PASN_Boolean m_answeredCall;
    H225_CallLinkage m_callLinkage;
    H225_CallCapacity m_capacity;
    H225_CircuitInfo m_circuitInfo;
    H225_RasUsageInformation m_usageInformation;
    H225_CallTerminationCause m_terminationCause;
    H225_ArrayOf_ServiceControlSession m_serviceControl;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// DisengageConfirm
//

class H225_DisengageConfirm : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_DisengageConfirm, PASN_Sequence);
#endif
  public:
    H225_DisengageConfirm(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_capacity,
      e_circuitInfo,
      e_usageInformation,
      e_genericData,
      e_assignedGatekeeper
    };

    H225_RequestSeqNum m_requestSeqNum;
    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    H225_CallCapacity m_capacity;
    H225_CircuitInfo m_circuitInfo;
    H225_RasUsageInformation m_usageInformation;
    H225_ArrayOf_GenericData m_genericData;
    H225_AlternateGK m_assignedGatekeeper;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// InfoRequestResponse
//

class H225_InfoRequestResponse : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_InfoRequestResponse, PASN_Sequence);
#endif
  public:
    H225_InfoRequestResponse(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_endpointAlias,
      e_perCallInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_needResponse,
      e_capacity,
      e_irrStatus,
      e_unsolicited,
      e_genericData
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_RequestSeqNum m_requestSeqNum;
    H225_EndpointType m_endpointType;
    H225_EndpointIdentifier m_endpointIdentifier;
    H225_TransportAddress m_rasAddress;
    H225_ArrayOf_TransportAddress m_callSignalAddress;
    H225_ArrayOf_AliasAddress m_endpointAlias;
    H225_InfoRequestResponse_perCallInfo m_perCallInfo;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ICV m_integrityCheckValue;
    PASN_Boolean m_needResponse;
    H225_CallCapacity m_capacity;
    H225_InfoRequestResponseStatus m_irrStatus;
    PASN_Boolean m_unsolicited;
    H225_ArrayOf_GenericData m_genericData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// InfoRequestResponse_perCallInfo_subtype
//

class H225_InfoRequestResponse_perCallInfo_subtype : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_InfoRequestResponse_perCallInfo_subtype, PASN_Sequence);
#endif
  public:
    H225_InfoRequestResponse_perCallInfo_subtype(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_originator,
      e_audio,
      e_video,
      e_data,
      e_callIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_substituteConfIDs,
      e_pdu,
      e_callLinkage,
      e_usageInformation,
      e_circuitInfo
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_CallReferenceValue m_callReferenceValue;
    H225_ConferenceIdentifier m_conferenceID;
    PASN_Boolean m_originator;
    H225_ArrayOf_RTPSession m_audio;
    H225_ArrayOf_RTPSession m_video;
    H225_ArrayOf_TransportChannelInfo m_data;
    H225_TransportChannelInfo m_h245;
    H225_TransportChannelInfo m_callSignaling;
    H225_CallType m_callType;
    H225_BandWidth m_bandWidth;
    H225_CallModel m_callModel;
    H225_CallIdentifier m_callIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ArrayOf_ConferenceIdentifier m_substituteConfIDs;
    H225_InfoRequestResponse_perCallInfo_subtype_pdu m_pdu;
    H225_CallLinkage m_callLinkage;
    H225_RasUsageInformation m_usageInformation;
    H225_CircuitInfo m_circuitInfo;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// InfoRequestResponse_perCallInfo_subtype_pdu_subtype
//

class H225_InfoRequestResponse_perCallInfo_subtype_pdu_subtype : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_InfoRequestResponse_perCallInfo_subtype_pdu_subtype, PASN_Sequence);
#endif
  public:
    H225_InfoRequestResponse_perCallInfo_subtype_pdu_subtype(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_H323_UU_PDU m_h323pdu;
    PASN_Boolean m_sent;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// H323-UserInformation
//

class H225_H323_UserInformation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_H323_UserInformation, PASN_Sequence);
#endif
  public:
    H225_H323_UserInformation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_user_data
    };

    H225_H323_UU_PDU m_h323_uu_pdu;
    H225_H323_UserInformation_user_data m_user_data;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// Alerting-UUIE
//

class H225_Alerting_UUIE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Alerting_UUIE, PASN_Sequence);
#endif
  public:
    H225_Alerting_UUIE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_h245Address,
      e_callIdentifier,
      e_h245SecurityMode,
      e_tokens,
      e_cryptoTokens,
      e_fastStart,
      e_multipleCalls,
      e_maintainConnection,
      e_alertingAddress,
      e_presentationIndicator,
      e_screeningIndicator,
      e_fastConnectRefused,
      e_serviceControl,
      e_capacity,
      e_featureSet,
      e_displayName
    };

    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_EndpointType m_destinationInfo;
    H225_TransportAddress m_h245Address;
    H225_CallIdentifier m_callIdentifier;
    H225_H245Security m_h245SecurityMode;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ArrayOf_PASN_OctetString m_fastStart;
    PASN_Boolean m_multipleCalls;
    PASN_Boolean m_maintainConnection;
    H225_ArrayOf_AliasAddress m_alertingAddress;
    H225_PresentationIndicator m_presentationIndicator;
    H225_ScreeningIndicator m_screeningIndicator;
    PASN_Null m_fastConnectRefused;
    H225_ArrayOf_ServiceControlSession m_serviceControl;
    H225_CallCapacity m_capacity;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_DisplayName m_displayName;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// CallProceeding-UUIE
//

class H225_CallProceeding_UUIE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_CallProceeding_UUIE, PASN_Sequence);
#endif
  public:
    H225_CallProceeding_UUIE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_h245Address,
      e_callIdentifier,
      e_h245SecurityMode,
      e_tokens,
      e_cryptoTokens,
      e_fastStart,
      e_multipleCalls,
      e_maintainConnection,
      e_fastConnectRefused,
      e_featureSet
    };

    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_EndpointType m_destinationInfo;
    H225_TransportAddress m_h245Address;
    H225_CallIdentifier m_callIdentifier;
    H225_H245Security m_h245SecurityMode;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ArrayOf_PASN_OctetString m_fastStart;
    PASN_Boolean m_multipleCalls;
    PASN_Boolean m_maintainConnection;
    PASN_Null m_fastConnectRefused;
    H225_FeatureSet m_featureSet;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// Connect-UUIE
//

class H225_Connect_UUIE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Connect_UUIE, PASN_Sequence);
#endif
  public:
    H225_Connect_UUIE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_h245Address,
      e_callIdentifier,
      e_h245SecurityMode,
      e_tokens,
      e_cryptoTokens,
      e_fastStart,
      e_multipleCalls,
      e_maintainConnection,
      e_language,
      e_connectedAddress,
      e_presentationIndicator,
      e_screeningIndicator,
      e_fastConnectRefused,
      e_serviceControl,
      e_capacity,
      e_featureSet,
      e_displayName
    };

    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_TransportAddress m_h245Address;
    H225_EndpointType m_destinationInfo;
    H225_ConferenceIdentifier m_conferenceID;
    H225_CallIdentifier m_callIdentifier;
    H225_H245Security m_h245SecurityMode;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ArrayOf_PASN_OctetString m_fastStart;
    PASN_Boolean m_multipleCalls;
    PASN_Boolean m_maintainConnection;
    H225_Connect_UUIE_language m_language;
    H225_ArrayOf_AliasAddress m_connectedAddress;
    H225_PresentationIndicator m_presentationIndicator;
    H225_ScreeningIndicator m_screeningIndicator;
    PASN_Null m_fastConnectRefused;
    H225_ArrayOf_ServiceControlSession m_serviceControl;
    H225_CallCapacity m_capacity;
    H225_FeatureSet m_featureSet;
    H225_ArrayOf_DisplayName m_displayName;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// Information-UUIE
//

class H225_Information_UUIE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Information_UUIE, PASN_Sequence);
#endif
  public:
    H225_Information_UUIE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_callIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_fastStart,
      e_fastConnectRefused,
      e_circuitInfo
    };

    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_CallIdentifier m_callIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ArrayOf_PASN_OctetString m_fastStart;
    PASN_Null m_fastConnectRefused;
    H225_CircuitInfo m_circuitInfo;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ReleaseComplete-UUIE
//

class H225_ReleaseComplete_UUIE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_ReleaseComplete_UUIE, PASN_Sequence);
#endif
  public:
    H225_ReleaseComplete_UUIE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_reason,
      e_callIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_busyAddress,
      e_presentationIndicator,
      e_screeningIndicator,
      e_capacity,
      e_serviceControl,
      e_featureSet,
      e_destinationInfo,
      e_displayName
    };

    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_ReleaseCompleteReason m_reason;
    H225_CallIdentifier m_callIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ArrayOf_AliasAddress m_busyAddress;
    H225_PresentationIndicator m_presentationIndicator;
    H225_ScreeningIndicator m_screeningIndicator;
    H225_CallCapacity m_capacity;
    H225_ArrayOf_ServiceControlSession m_serviceControl;
    H225_FeatureSet m_featureSet;
    H225_EndpointType m_destinationInfo;
    H225_ArrayOf_DisplayName m_displayName;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// Setup-UUIE
//

class H225_Setup_UUIE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Setup_UUIE, PASN_Sequence);
#endif
  public:
    H225_Setup_UUIE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_h245Address,
      e_sourceAddress,
      e_destinationAddress,
      e_destCallSignalAddress,
      e_destExtraCallInfo,
      e_destExtraCRV,
      e_callServices,
      e_sourceCallSignalAddress,
      e_remoteExtensionAddress,
      e_callIdentifier,
      e_h245SecurityCapability,
      e_tokens,
      e_cryptoTokens,
      e_fastStart,
      e_mediaWaitForConnect,
      e_canOverlapSend,
      e_endpointIdentifier,
      e_multipleCalls,
      e_maintainConnection,
      e_connectionParameters,
      e_language,
      e_presentationIndicator,
      e_screeningIndicator,
      e_serviceControl,
      e_symmetricOperationRequired,
      e_capacity,
      e_circuitInfo,
      e_desiredProtocols,
      e_neededFeatures,
      e_desiredFeatures,
      e_supportedFeatures,
      e_parallelH245Control,
      e_additionalSourceAddresses,
      e_hopCount,
      e_displayName
    };

    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_TransportAddress m_h245Address;
    H225_ArrayOf_AliasAddress m_sourceAddress;
    H225_EndpointType m_sourceInfo;
    H225_ArrayOf_AliasAddress m_destinationAddress;
    H225_TransportAddress m_destCallSignalAddress;
    H225_ArrayOf_AliasAddress m_destExtraCallInfo;
    H225_ArrayOf_CallReferenceValue m_destExtraCRV;
    PASN_Boolean m_activeMC;
    H225_ConferenceIdentifier m_conferenceID;
    H225_Setup_UUIE_conferenceGoal m_conferenceGoal;
    H225_QseriesOptions m_callServices;
    H225_CallType m_callType;
    H225_TransportAddress m_sourceCallSignalAddress;
    H225_AliasAddress m_remoteExtensionAddress;
    H225_CallIdentifier m_callIdentifier;
    H225_ArrayOf_H245Security m_h245SecurityCapability;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ArrayOf_PASN_OctetString m_fastStart;
    PASN_Boolean m_mediaWaitForConnect;
    PASN_Boolean m_canOverlapSend;
    H225_EndpointIdentifier m_endpointIdentifier;
    PASN_Boolean m_multipleCalls;
    PASN_Boolean m_maintainConnection;
    H225_Setup_UUIE_connectionParameters m_connectionParameters;
    H225_Setup_UUIE_language m_language;
    H225_PresentationIndicator m_presentationIndicator;
    H225_ScreeningIndicator m_screeningIndicator;
    H225_ArrayOf_ServiceControlSession m_serviceControl;
    PASN_Null m_symmetricOperationRequired;
    H225_CallCapacity m_capacity;
    H225_CircuitInfo m_circuitInfo;
    H225_ArrayOf_SupportedProtocols m_desiredProtocols;
    H225_ArrayOf_FeatureDescriptor m_neededFeatures;
    H225_ArrayOf_FeatureDescriptor m_desiredFeatures;
    H225_ArrayOf_FeatureDescriptor m_supportedFeatures;
    H225_ArrayOf_PASN_OctetString m_parallelH245Control;
    H225_ArrayOf_ExtendedAliasAddress m_additionalSourceAddresses;
    PASN_Integer m_hopCount;
    H225_ArrayOf_DisplayName m_displayName;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// Facility-UUIE
//

class H225_Facility_UUIE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Facility_UUIE, PASN_Sequence);
#endif
  public:
    H225_Facility_UUIE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_alternativeAddress,
      e_alternativeAliasAddress,
      e_conferenceID,
      e_callIdentifier,
      e_destExtraCallInfo,
      e_remoteExtensionAddress,
      e_tokens,
      e_cryptoTokens,
      e_conferences,
      e_h245Address,
      e_fastStart,
      e_multipleCalls,
      e_maintainConnection,
      e_fastConnectRefused,
      e_serviceControl,
      e_circuitInfo,
      e_featureSet,
      e_destinationInfo,
      e_h245SecurityMode
    };

    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_TransportAddress m_alternativeAddress;
    H225_ArrayOf_AliasAddress m_alternativeAliasAddress;
    H225_ConferenceIdentifier m_conferenceID;
    H225_FacilityReason m_reason;
    H225_CallIdentifier m_callIdentifier;
    H225_ArrayOf_AliasAddress m_destExtraCallInfo;
    H225_AliasAddress m_remoteExtensionAddress;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ArrayOf_ConferenceList m_conferences;
    H225_TransportAddress m_h245Address;
    H225_ArrayOf_PASN_OctetString m_fastStart;
    PASN_Boolean m_multipleCalls;
    PASN_Boolean m_maintainConnection;
    PASN_Null m_fastConnectRefused;
    H225_ArrayOf_ServiceControlSession m_serviceControl;
    H225_CircuitInfo m_circuitInfo;
    H225_FeatureSet m_featureSet;
    H225_EndpointType m_destinationInfo;
    H225_H245Security m_h245SecurityMode;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// Progress-UUIE
//

class H225_Progress_UUIE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Progress_UUIE, PASN_Sequence);
#endif
  public:
    H225_Progress_UUIE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_h245Address,
      e_h245SecurityMode,
      e_tokens,
      e_cryptoTokens,
      e_fastStart,
      e_multipleCalls,
      e_maintainConnection,
      e_fastConnectRefused
    };

    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_EndpointType m_destinationInfo;
    H225_TransportAddress m_h245Address;
    H225_CallIdentifier m_callIdentifier;
    H225_H245Security m_h245SecurityMode;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ArrayOf_PASN_OctetString m_fastStart;
    PASN_Boolean m_multipleCalls;
    PASN_Boolean m_maintainConnection;
    PASN_Null m_fastConnectRefused;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// Notify-UUIE
//

class H225_Notify_UUIE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Notify_UUIE, PASN_Sequence);
#endif
  public:
    H225_Notify_UUIE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_tokens,
      e_cryptoTokens,
      e_connectedAddress,
      e_presentationIndicator,
      e_screeningIndicator,
      e_destinationInfo,
      e_displayName
    };

    H225_ProtocolIdentifier m_protocolIdentifier;
    H225_CallIdentifier m_callIdentifier;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    H225_ArrayOf_AliasAddress m_connectedAddress;
    H225_PresentationIndicator m_presentationIndicator;
    H225_ScreeningIndicator m_screeningIndicator;
    H225_EndpointType m_destinationInfo;
    H225_ArrayOf_DisplayName m_displayName;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// Endpoint
//

class H225_Endpoint : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H225_Endpoint, PASN_Sequence);
#endif
  public:
    H225_Endpoint(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_nonStandardData,
      e_aliasAddress,
      e_callSignalAddress,
      e_rasAddress,
      e_endpointType,
      e_tokens,
      e_cryptoTokens,
      e_priority,
      e_remoteExtensionAddress,
      e_destExtraCallInfo,
      e_alternateTransportAddresses,
      e_circuitInfo,
      e_featureSet
    };

    H225_NonStandardParameter m_nonStandardData;
    H225_ArrayOf_AliasAddress m_aliasAddress;
    H225_ArrayOf_TransportAddress m_callSignalAddress;
    H225_ArrayOf_TransportAddress m_rasAddress;
    H225_EndpointType m_endpointType;
    H225_ArrayOf_ClearToken m_tokens;
    H225_ArrayOf_CryptoH323Token m_cryptoTokens;
    PASN_Integer m_priority;
    H225_ArrayOf_AliasAddress m_remoteExtensionAddress;
    H225_ArrayOf_AliasAddress m_destExtraCallInfo;
    H225_AlternateTransportAddresses m_alternateTransportAddresses;
    H225_CircuitInfo m_circuitInfo;
    H225_FeatureSet m_featureSet;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


#endif // __H225_H

#endif // if ! H323_DISABLE_H225


// End of h225.h
