'\"
'\" Generated from file 'switched\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "switched" n 2\&.2\&.1 tcllib "Simple Tcl Only Object Oriented Programming"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
switched \- switch/option management\&.
.SH SYNOPSIS
package require \fBTcl  8\&.3\fR
.sp
package require \fBswitched  ?2\&.2\&.1?\fR
.sp
\fB<switched>\fR \fBcomplete\fR \fIthis\fR
.sp
\fB<switched>\fR \fBoptions\fR \fIthis\fR
.sp
\fB<switched>\fR \fBset-\fBoption\fR\fR \fIthis\fR \fIvalue\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBswitched\fR class serves as base class for user classes with
switch / option configuration procedures\&. It provides facilities for
managing options through a simple interface\&.
.PP
For example:
.CS


set vehicle [new car -length 4\&.5 -width 2 -power 100 -fuel diesel]
puts "my car was running on [switched::cget $vehicle -fuel]"
switched::configure $vehicle -power 40 -fuel electricity
puts "but is now running on clean [switched::cget $vehicle -fuel]"

.CE
.PP
Of course, as you might have guessed, the \fBcar\fR class is
derived from the \fBswitched\fR class\&. Let us see how it works:
.CS


class car {
    proc car {this args} switched {$args} {
        # car specific initialization code here
        switched::complete $this
    }
    \&.\&.\&.
}

.CE
.PP
The switched class constructor takes the optional configuration
option / value pairs as parameters\&.
The switched class layer then completely manages the switched options:
it checks their validity, stores their values and provides a clean
interface to the user layer configuration setting procedures\&.
.PP
The switched class members available to the programmer are:
.TP
\fB<switched>\fR \fBcomplete\fR \fIthis\fR
This procedure is used to tell the switched layer that the derived
class object (a car in the examples) is completely built\&.
At that time, the initial configuration of the switched object occurs,
using default option values (see procedure \fBoptions\fR)
eventually overridden by construction time values, passed at the time
of the \fBnew\fR operator invocation\&.
This procedure must be called only once, usually around or at the end
of the derived class constructor\&.
(\fINote\fR: Also check the \fBcomplete\fR data member later in this
chapter)\&.
.TP
\fB<switched>\fR \fBoptions\fR \fIthis\fR
This procedure must return the configuration description for
\fIall\fR options that the switched object will accept\&.
It is a pure virtual member procedure and therefore its implementation
is \fImandatory\fR in the derived class layer\&.
The procedure must return a list of lists\&.
Each list pertains to a single option and is composed of the switch
name, the default value for the option and an optional initial value\&.
For example:
.sp
.CS


class car {
    \&.\&.\&.
    proc options {this} {
        return [list [list -fuel petrol petrol] [list -length {} {}] [list -power {} {}] [list -width {} {}] ]
    }
    proc set-fuel {this value} {
        \&.\&.\&.
    }
    \&.\&.\&.
}

.CE
.sp
In this case, 4 options are specified:
\fBfuel\fR, \fBlength\fR, \fBpower\fR and \fBwidth\fR\&.
The default and initial values for the \fBfuel\fR option are
identical and set to \fBpetrol\fR\&.
For the other options, values are all empty\&.
.sp
For each option, there must be a corresponding
\fBset-\fBoption\fR\fR procedure defined in the derived class
layer\&.
For example, since we defined a \fBfuel\fR option, there is a
\fBset-fuel\fR procedure in the car class\&.
The parameters always are the object identifier (since this is not a
static procedure, but rather a dynamically defined virtual one),
followed by the new value for the option\&.
A \fBset-\fBoption\fR\fR procedure is only invoked if the new
value differs from the current one (a caching scheme for improving
performance), or if there is no initial value set in the
\fBoptions\fR procedure for that option\&.
.sp
In this procedure, if the initial value differs from the
default value or is omitted, then initial configuration is forced and
the corresponding \fBset-\fBoption\fR\fR procedure is invoked by
the switched \fBcomplete\fR procedure located at the end of the
derived class constructor\&.
For example:
.CS


class car {
    \&.\&.\&.
    proc options {this} {
        return [list [list -fuel petrol] [list -length {} {}] [list -power 100 50] [list -width {} {}] ]
    }
    \&.\&.\&.
}

.CE
.IP
In this case, configuration is forced on the \fBfuel\fR and
\fBpower\fR options, that is the corresponding
\fBset-\fBoption\fR\fR procedures will be invoked when the
switched object is constructed (see \fBset-\fBoption\fR\fR
procedures documentation below)\&.
.sp
For the \fBfuel\fR option, since there is no initial value,
the \fBset-\fBfuel\fR\fR procedure is called with the default
value (\fBpetrol\fR) as argument\&.
For the \fBpower\fR option, since the initial value differs from
the default value, the \fBset-\fBpower\fR\fR procedure is called
with the initial value as argument (\fB50\fR)\&.
.sp
For the other options, since the initial values (last elements
of the option lists) are identical to their default values, the
corresponding \fBset-\fBoption\fR\fR procedures will not be
invoked\&. It is the programmer's responsibility to insure that the
initial option values are correct\&.
.TP
\fB<switched>\fR \fBset-\fBoption\fR\fR \fIthis\fR \fIvalue\fR
These procedures may be viewed as dynamic virtual functions\&.
There must be one implementation per supported option, as returned by
the \fBoptions\fR procedure\&.
For example:
.CS


class car {
    \&.\&.\&.
    proc options {this} {
        return [list \&.\&.\&.
            [list -width {} {}] ]
    }
    \&.\&.\&.
    proc set-width {this value} {
        \&.\&.\&.
    }
    \&.\&.\&.
}

.CE
.IP
Since the \fB-width\fR option was listed in the \fBoptions\fR
procedure, a \fBset-width\fR procedure implementation is provided, which
of course would proceed to set the width of the car (and would modify
the looks of a graphical representation, for example)\&.
.sp
As you add a supported \fBoption\fR in the list returned by
the \fBoptions\fR procedure, the corresponding
\fBset-\fBoption\fR\fR procedure may be called as soon as the
switched object is complete, which occurs when the switched level
\fBcomplete\fR procedure is invoked\&.
For example:
.sp
.CS


class car {
    proc car {this args} switched {args} {
        \&.\&.\&.
        switched::complete $this
   }
    \&.\&.\&.
    proc options {this} {
        return [list [list -fuel petrol] [list -length 4\&.5] [list -power 350] [list -width 1\&.8] ]
    }
    proc set-fuel {this value} {
        \&.\&.\&.
    }
    proc set-length {this value} {
        \&.\&.\&.
    }
    proc set-power {this value} {
        \&.\&.\&.
    }
    proc set-width {this value} {
        \&.\&.\&.
    }
}

new car

.CE
.sp
In this case, a new car is created with no options, which
causes the car constructor to be called, which in turns calls the
switched level \fBcomplete\fR procedure after the car object layer
is completely initialized\&.
At this point, since there are no initial values in any option list in
the options procedure, the \fBset-fuel\fR procedure is called with
its default value of \fBpetrol\fR as parameter, followed by the
\fBset-length\fR call with \fB4\&.5\fR value, \fBset-power\fR
with \fB350\fR value and finally with \fBset-width\fR with
\fB1\&.8\fR as parameter\&.
This is a good way to test the \fBset-\fBoption\fR\fR procedures
when debugging, and when done, just fill-in the initial option values\&.
.sp
The switched layer checks that an option is valid (that is,
listed in the \fBoptions\fR procedure) but obviously does not check
the validity of the value passed to the \fBset-\fBoption\fR\fR
procedure, which should throw an error (for example by using the Tcl
error command) if the value is invalid\&.
.sp
The switched layer also keeps track of the options current
values, so that a \fBset-\fBoption\fR\fR procedure is called
only when the corresponding option value passed as parameter is
different from the current value (see  data members
description)\&.
.TP
.sp
The  data member is an options current value\&.
There is one for each option listed in the options procedure\&. It is a
read-only value which the switched layer checks against when an option
is changed\&.
It is rarely used at the layer derived from switched, except in the
few cases, such as in the following example:
.sp
.CS


\&.\&.\&.
proc car::options {this} {
    return {
        \&.\&.\&.
        {-manufacturer {} {}}
        \&.\&.\&.
    }
}

proc car::set-manufacturer {this value} {}

proc car::printData {this} {
    puts "manufacturer: $switched::($this,-manufacturer)"
    \&.\&.\&.
}

.CE
.sp
In this case, the manufacturer's name is stored at the switched
layer level (this is why the set-manufacturer procedure has nothing to
do) and later retrieved in the printData procedure\&.
.TP
.sp
The  data member (not to be confused with
the \fBcomplete\fR procedure) is a boolean\&.
Its initial value is \fBfalse\fR and it is set to \fBtrue\fR at
the very end of the switched \fBcomplete\fR procedure\&.
It becomes useful when some options should be set at construction time
only and not dynamically, as the following example shows:
.sp
.CS


proc car::set-width {this value} {
    if {$switched::($this,complete)} {
        error {option -width cannot be set dynamically}
    }
    \&.\&.\&.
}

.CE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIstooop\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
C++, class, object, object oriented
.SH CATEGORY
Programming tools