/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.TextUI;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.gui.JAttributeTextArea;
import org.jhotdraw.gui.JAttributeTextField;
import org.jhotdraw.gui.event.FigureAttributeEditorHandler;
import org.jhotdraw.gui.event.SelectionComponentDisplayer;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.gui.plaf.palette.PaletteLabelUI;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.util.ResourceBundleUtil;

public class LinkToolBar
extends AbstractToolBar {
    private SelectionComponentDisplayer displayer;
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");

    public LinkToolBar() {
        this.setName(this.labels.getString(this.getID() + ".toolbar"));
        this.setDisclosureStateCount(3);
    }

    @Override
    public void setEditor(DrawingEditor drawingEditor) {
        DrawingEditor drawingEditor2 = this.getEditor();
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(drawingEditor);
        if (drawingEditor != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this);
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int n) {
        JPanel jPanel = null;
        switch (n) {
            case 1: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setLayout(new GridBagLayout());
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                JLabel jLabel = new JLabel();
                jLabel.setUI((LabelUI)PaletteLabelUI.createUI(jLabel));
                jLabel.setToolTipText(this.labels.getString("attribute.figureLink.toolTipText"));
                jLabel.setText(this.labels.getString("attribute.figureLink.text"));
                jLabel.setFont(PaletteLookAndFeel.getInstance().getFont("SmallSystemFont"));
                JScrollPane jScrollPane = new JScrollPane();
                JAttributeTextArea jAttributeTextArea = new JAttributeTextArea();
                jLabel.setLabelFor(jAttributeTextArea);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.insets = new Insets(-2, 0, -2, 0);
                gridBagConstraints.anchor = 16;
                gridBagConstraints.gridwidth = 0;
                jPanel.add((Component)jLabel, gridBagConstraints);
                jScrollPane.setHorizontalScrollBarPolicy(31);
                jScrollPane.setVerticalScrollBarPolicy(20);
                jScrollPane.putClientProperty("JComponent.sizeVariant", "small");
                jScrollPane.setBorder(PaletteLookAndFeel.getInstance().getBorder("ScrollPane.border"));
                jAttributeTextArea.setToolTipText(this.labels.getString("attribute.figureLink.toolTipText"));
                jAttributeTextArea.setColumns(8);
                jAttributeTextArea.setLineWrap(true);
                jAttributeTextArea.setRows(2);
                jAttributeTextArea.setWrapStyleWord(true);
                jAttributeTextArea.setFont(PaletteLookAndFeel.getInstance().getFont("SmallSystemFont"));
                jAttributeTextArea.setFormatterFactory(new DefaultFormatterFactory(new DefaultFormatter()));
                this.disposables.add(new FigureAttributeEditorHandler<String>(SVGAttributeKeys.LINK, jAttributeTextArea, this.editor, false));
                jScrollPane.setViewportView(jAttributeTextArea);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.fill = 1;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                jPanel.add((Component)jScrollPane, gridBagConstraints);
                JLabel jLabel2 = new JLabel();
                jLabel2.setUI((LabelUI)PaletteLabelUI.createUI(jLabel2));
                jLabel2.setToolTipText(this.labels.getString("attribute.figureLinkTarget.toolTipText"));
                jLabel2.setText(this.labels.getString("attribute.figureLinkTarget.text"));
                JAttributeTextField jAttributeTextField = new JAttributeTextField();
                jLabel2.setLabelFor(jAttributeTextField);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 23;
                jPanel.add((Component)jLabel2, gridBagConstraints);
                jAttributeTextField.setToolTipText(this.labels.getString("attribute.figureLinkTarget.toolTipText"));
                jAttributeTextField.setColumns(4);
                jAttributeTextField.setFormatterFactory(new DefaultFormatterFactory(new DefaultFormatter()));
                jAttributeTextField.setUI((TextUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField));
                this.disposables.add(new FigureAttributeEditorHandler<String>(SVGAttributeKeys.LINK_TARGET, jAttributeTextField, this.editor, false));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 23;
                jPanel.add(jAttributeTextField, gridBagConstraints);
                break;
            }
            case 2: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setLayout(new GridBagLayout());
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                JScrollPane jScrollPane = new JScrollPane();
                JAttributeTextArea jAttributeTextArea = new JAttributeTextArea();
                jScrollPane.setHorizontalScrollBarPolicy(31);
                jScrollPane.setVerticalScrollBarPolicy(20);
                jScrollPane.putClientProperty("JComponent.sizeVariant", "small");
                jScrollPane.setBorder(PaletteLookAndFeel.getInstance().getBorder("ScrollPane.border"));
                jAttributeTextArea.setToolTipText(this.labels.getString("attribute.figureLink.toolTipText"));
                jAttributeTextArea.setColumns(12);
                jAttributeTextArea.setLineWrap(true);
                jAttributeTextArea.setRows(2);
                jAttributeTextArea.setWrapStyleWord(true);
                jAttributeTextArea.setFont(PaletteLookAndFeel.getInstance().getFont("SmallSystemFont"));
                jAttributeTextArea.setFormatterFactory(new DefaultFormatterFactory(new DefaultFormatter()));
                this.disposables.add(new FigureAttributeEditorHandler<String>(SVGAttributeKeys.LINK, jAttributeTextArea, this.editor, false));
                jScrollPane.setViewportView(jAttributeTextArea);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.fill = 1;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                jPanel.add((Component)jScrollPane, gridBagConstraints);
                JLabel jLabel = new JLabel();
                jLabel.setUI((LabelUI)PaletteLabelUI.createUI(jLabel));
                jLabel.setToolTipText(this.labels.getString("attribute.figureLinkTarget.toolTipText"));
                jLabel.setText(this.labels.getString("attribute.figureLinkTarget.text"));
                JAttributeTextField jAttributeTextField = new JAttributeTextField();
                jLabel.setLabelFor(jAttributeTextField);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 23;
                jPanel.add((Component)jLabel, gridBagConstraints);
                jAttributeTextField.setToolTipText(this.labels.getString("attribute.figureLinkTarget.toolTipText"));
                jAttributeTextField.setColumns(7);
                jAttributeTextField.setFormatterFactory(new DefaultFormatterFactory(new DefaultFormatter()));
                jAttributeTextField.setUI((TextUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField));
                this.disposables.add(new FigureAttributeEditorHandler<String>(SVGAttributeKeys.LINK_TARGET, jAttributeTextField, this.editor, true));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 23;
                jPanel.add(jAttributeTextField, gridBagConstraints);
            }
        }
        return jPanel;
    }

    @Override
    protected String getID() {
        return "link";
    }

    private void initComponents() {
    }
}

