/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mondrianinput;

import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mondrianinput.MondrianData;
import org.pentaho.di.trans.steps.mondrianinput.MondrianHelper;
import org.pentaho.di.trans.steps.mondrianinput.MondrianInputMeta;

public class MondrianInput
extends BaseStep
implements StepInterface {
    private MondrianInputMeta meta;
    private MondrianData data;

    public MondrianInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first) {
            this.first = false;
            String mdx = this.meta.getSQL();
            if (this.meta.isVariableReplacementActive()) {
                mdx = this.environmentSubstitute(this.meta.getSQL());
            }
            this.data.mondrianHelper = new MondrianHelper(this.meta.getDatabaseMeta(), this.meta.getCatalog(), mdx, this);
            this.data.mondrianHelper.openQuery();
            this.data.mondrianHelper.createRectangularOutput();
            this.data.outputRowMeta = this.data.mondrianHelper.getOutputRowMeta().clone();
            this.data.rowNumber = 0;
        }
        if (this.data.rowNumber >= this.data.mondrianHelper.getRows().size()) {
            this.setOutputDone();
            return false;
        }
        List<Object> row = this.data.mondrianHelper.getRows().get(this.data.rowNumber++);
        Object[] outputRowData = RowDataUtil.allocateRowData((int)row.size());
        for (int i = 0; i < row.size(); ++i) {
            outputRowData[i] = row.get(i);
        }
        this.putRow(this.data.outputRowMeta, outputRowData);
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.log.isBasic()) {
            this.logBasic("Finished reading query, closing connection.");
        }
        this.data.mondrianHelper.close();
        super.dispose(smi, sdi);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MondrianInputMeta)smi;
        this.data = (MondrianData)sdi;
        return super.init(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

