/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.dbtree.DBTreeModel;
import ca.sqlpower.architect.swingui.olap.CubeEditPanel;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLDatabaseMapping;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRoot;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.SwingWorkerRegistry;
import ca.sqlpower.swingui.query.SQLQueryUIComponents;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

class ViewEntryPanel
implements DataEntryPanel {
    private JSplitPane splitPane;
    private RSyntaxTextArea queryArea;
    private SQLQueryUIComponents queryComponents;
    private final CubeEditPanel cubeEditPanel;

    public ViewEntryPanel(ArchitectSwingSession session, SQLDatabase db, CubeEditPanel cubeEditPanel) {
        DBTreeModel treeModel;
        DBTree tree;
        this.cubeEditPanel = cubeEditPanel;
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref, 5dlu:grow, pref, 3dlu, pref", "pref, fill:pref:grow"));
        this.queryComponents = new SQLQueryUIComponents((SwingWorkerRegistry)session, session.getDataSources(), (SQLDatabaseMapping)session, (JComponent)builder.getPanel());
        this.queryComponents.getRowLimitSpinner().setValue(1000);
        this.queryComponents.getDatabaseComboBox().setSelectedItem(db.getDataSource());
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.queryComponents.getPrevQueryButton());
        toolbar.add(this.queryComponents.getNextQueryButton());
        toolbar.addSeparator();
        toolbar.add(this.queryComponents.getExecuteButton());
        toolbar.add(this.queryComponents.getStopButton());
        toolbar.add(this.queryComponents.getClearButton());
        toolbar.addSeparator();
        toolbar.add(this.queryComponents.getUndoButton());
        toolbar.add(this.queryComponents.getRedoButton());
        toolbar.addSeparator();
        toolbar.add(new JLabel(db.getName()));
        builder.append((Component)toolbar);
        builder.append("Row Limit", (Component)this.queryComponents.getRowLimitSpinner());
        builder.nextLine();
        this.queryArea = this.queryComponents.getQueryArea();
        builder.append((Component)new JScrollPane((Component)this.queryArea), 5);
        this.queryArea.setText(cubeEditPanel.getSelectText());
        JSplitPane rightSplitPane = new JSplitPane(0);
        rightSplitPane.setTopComponent(builder.getPanel());
        rightSplitPane.setBottomComponent(this.queryComponents.getResultTabPane());
        rightSplitPane.setPreferredSize(new Dimension((int)Math.max(400.0, rightSplitPane.getPreferredSize().getWidth()), (int)Math.max(500.0, rightSplitPane.getPreferredSize().getHeight())));
        rightSplitPane.setResizeWeight(0.5);
        SQLObjectRoot root = new SQLObjectRoot();
        try {
            root.addChild((SQLObject)db);
            tree = new DBTree(session);
            treeModel = new DBTreeModel(root, tree);
        }
        catch (SQLObjectException e) {
            throw new RuntimeException(e);
        }
        tree.setModel(treeModel);
        tree.setPopupMenuEnabled(false);
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(tree);
        this.splitPane.setRightComponent(rightSplitPane);
        this.splitPane.setResizeWeight(0.2);
    }

    public boolean applyChanges() {
        this.cubeEditPanel.setSelectText(this.queryArea.getText());
        this.cleanup();
        return true;
    }

    public void discardChanges() {
        this.cleanup();
    }

    private void cleanup() {
        this.queryComponents.closingDialogOwner();
    }

    public JComponent getPanel() {
        return this.splitPane;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }
}

