/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.timespec;

import java.time.Instant;
import org.rrd4j.core.timespec.TimeScanner;
import org.rrd4j.core.timespec.TimeSpec;
import org.rrd4j.core.timespec.TimeToken;

public class TimeParser {
    private static final int PREVIOUS_OP = -1;
    TimeToken token;
    TimeScanner scanner;
    TimeSpec spec;
    int op = 21;
    int prev_multiplier = -1;

    public TimeParser(String dateString) {
        this.scanner = new TimeScanner(dateString);
        this.spec = new TimeSpec(dateString);
    }

    private void expectToken(int desired, String errorMessage) {
        this.token = this.scanner.nextToken();
        if (this.token.token_id != desired) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void plusMinus(int doop) {
        if (doop >= 0) {
            this.op = doop;
            this.expectToken(20, "There should be number after " + (this.op == 21 ? (char)'+' : '-'));
            this.prev_multiplier = -1;
        }
        int delta = Integer.parseInt(this.token.value);
        this.token = this.scanner.nextToken();
        if (this.token.token_id == 19) {
            switch (this.prev_multiplier) {
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    this.token = this.scanner.resolveMonthsMinutes(17);
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    this.token = this.scanner.resolveMonthsMinutes(13);
                    break;
                }
                default: {
                    this.token = delta < 6 ? this.scanner.resolveMonthsMinutes(17) : this.scanner.resolveMonthsMinutes(13);
                }
            }
        }
        this.prev_multiplier = this.token.token_id;
        delta *= this.op == 21 ? 1 : -1;
        switch (this.token.token_id) {
            case 18: {
                this.spec.dyear += delta;
                return;
            }
            case 17: {
                this.spec.dmonth += delta;
                return;
            }
            case 16: {
                delta *= 7;
            }
            case 15: {
                this.spec.dday += delta;
                return;
            }
            case 14: {
                this.spec.dhour += delta;
                return;
            }
            case 13: {
                this.spec.dmin += delta;
                return;
            }
        }
        this.spec.dsec += delta;
    }

    private void timeOfDay() {
        int hour = 0;
        int minute = 0;
        this.scanner.saveState();
        if (this.token.value.length() > 2) {
            return;
        }
        hour = Integer.parseInt(this.token.value);
        this.token = this.scanner.nextToken();
        if (this.token.token_id == 25) {
            this.token = this.scanner.restoreState();
            return;
        }
        if (this.token.token_id == 24 || this.token.token_id == 23) {
            this.expectToken(20, "Parsing HH:MM or HH.MM syntax, expecting MM as number, got none");
            minute = Integer.parseInt(this.token.value);
            if (minute > 59) {
                throw new IllegalArgumentException("Parsing HH:MM or HH.MM syntax, got MM = " + minute + " (>59!)");
            }
            this.token = this.scanner.nextToken();
            if (this.token.token_id == 23) {
                this.token = this.scanner.restoreState();
                return;
            }
        }
        if (this.token.token_id == 5 || this.token.token_id == 4) {
            if (hour > 12) {
                throw new IllegalArgumentException("There cannot be more than 12 AM or PM hours");
            }
            if (this.token.token_id == 4) {
                if (hour != 12) {
                    hour += 12;
                }
            } else if (hour == 12) {
                hour = 0;
            }
            this.token = this.scanner.nextToken();
        } else if (hour > 23) {
            this.token = this.scanner.restoreState();
            return;
        }
        this.spec.hour = hour;
        this.spec.min = minute;
        this.spec.sec = 0;
        if (this.spec.hour == 24) {
            this.spec.hour = 0;
            ++this.spec.day;
        }
    }

    private void assignDate(long mday, long mon, long year) {
        if (year >= 0L && year < 38L) {
            year += 2000L;
        } else if (year >= 38L && year <= 99L) {
            year += 1900L;
        }
        this.spec.year = (int)year;
        this.spec.month = (int)mon;
        this.spec.day = (int)mday;
    }

    private void day() {
        long mday = 0L;
        long wday = 0L;
        long mon = 0L;
        long year = this.spec.year;
        switch (this.token.token_id) {
            case 6: {
                --this.spec.day;
            }
            case 7: {
                this.token = this.scanner.nextToken();
                break;
            }
            case 8: {
                ++this.spec.day;
                this.token = this.scanner.nextToken();
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                mon = this.token.token_id - 28;
                this.expectToken(20, "the day of the month should follow month name");
                mday = Long.parseLong(this.token.value);
                this.token = this.scanner.nextToken();
                if (this.token.token_id == 20) {
                    year = Long.parseLong(this.token.value);
                    this.token = this.scanner.nextToken();
                } else {
                    year = this.spec.year;
                }
                this.assignDate(mday, mon, year);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                wday = this.token.token_id - 40;
                this.spec.day = (int)((long)this.spec.day + (wday - (long)this.spec.wday));
                this.token = this.scanner.nextToken();
                break;
            }
            case 20: {
                mon = Long.parseLong(this.token.value);
                if (mon > 315360000L) {
                    this.spec.localtime(mon);
                    this.token = this.scanner.nextToken();
                    break;
                }
                if (mon > 19000101L && mon < 24000101L) {
                    year = mon / 10000L;
                    mday = mon % 100L;
                    mon = mon / 100L % 100L;
                    this.token = this.scanner.nextToken();
                } else {
                    this.token = this.scanner.nextToken();
                    if (mon <= 31L && (this.token.token_id == 25 || this.token.token_id == 23)) {
                        int sep = this.token.token_id;
                        this.expectToken(20, "there should be " + (sep == 23 ? "month" : "day") + " number after " + (sep == 23 ? (char)'.' : '/'));
                        mday = Long.parseLong(this.token.value);
                        this.token = this.scanner.nextToken();
                        if (this.token.token_id == sep) {
                            this.expectToken(20, "there should be year number after " + (sep == 23 ? (char)'.' : '/'));
                            year = Long.parseLong(this.token.value);
                            this.token = this.scanner.nextToken();
                        }
                        if (sep == 23) {
                            long x = mday;
                            mday = mon;
                            mon = x;
                        }
                    }
                }
                if (--mon < 0L || mon > 11L) {
                    throw new IllegalArgumentException("Did you really mean month " + (mon + 1L));
                }
                if (mday < 1L || mday > 31L) {
                    throw new IllegalArgumentException("I'm afraid that " + mday + " is not a valid day of the month");
                }
                this.assignDate(mday, mon, year);
            }
        }
    }

    public TimeSpec parse() {
        long now = Instant.now().getEpochSecond();
        int hr = 0;
        this.spec.localtime(now);
        this.token = this.scanner.nextToken();
        switch (this.token.token_id) {
            case 21: 
            case 22: {
                break;
            }
            case 10: {
                this.spec.type = 1;
            }
            case 11: {
                if (this.spec.type != 1) {
                    this.spec.type = 2;
                }
                this.spec.sec = 0;
                this.spec.min = 0;
                this.spec.hour = 0;
                this.spec.day = 0;
                this.spec.month = 0;
                this.spec.year = 0;
            }
            case 9: {
                int time_reference = this.token.token_id;
                this.token = this.scanner.nextToken();
                if (this.token.token_id == 21 || this.token.token_id == 22) break;
                if (time_reference != 9) {
                    throw new IllegalArgumentException("Words 'start' or 'end' MUST be followed by +|- offset");
                }
                if (this.token.token_id == -1) break;
                throw new IllegalArgumentException("If 'now' is followed by a token it must be +|- offset");
            }
            case 20: {
                this.timeOfDay();
            }
            case 6: 
            case 7: 
            case 8: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                this.day();
                if (this.token.token_id != 20) break;
                this.timeOfDay();
                break;
            }
            case 3: {
                hr += 4;
            }
            case 2: {
                hr += 12;
            }
            case 1: {
                this.spec.hour = hr;
                this.spec.min = 0;
                this.spec.sec = 0;
                this.token = this.scanner.nextToken();
                this.day();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unparsable time: " + this.token.value);
            }
        }
        if (this.token.token_id == 21 || this.token.token_id == 22) {
            this.scanner.setContext(false);
            while (this.token.token_id == 21 || this.token.token_id == 22 || this.token.token_id == 20) {
                if (this.token.token_id == 20) {
                    this.plusMinus(-1);
                } else {
                    this.plusMinus(this.token.token_id);
                }
                this.token = this.scanner.nextToken();
            }
        }
        if (this.token.token_id != -1) {
            throw new IllegalArgumentException("Unparsable trailing text: " + this.token.value);
        }
        return this.spec;
    }
}

