/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.util.CompilableFunction;
import java.util.Set;

public class GetPrototypeFromConstructorNode
extends JavaScriptNode {
    private final CompilableFunction<JSRealm, DynamicObject> intrinsicDefaultProto;
    @Node.Child
    private JavaScriptNode constructorNode;
    @Node.Child
    private PropertyGetNode getPrototypeNode;
    @Node.Child
    private IsJSObjectNode isObjectNode;

    protected GetPrototypeFromConstructorNode(JSContext context, JavaScriptNode constructorNode, CompilableFunction<JSRealm, DynamicObject> intrinsicDefaultProto) {
        this.constructorNode = constructorNode;
        this.intrinsicDefaultProto = intrinsicDefaultProto;
        this.getPrototypeNode = PropertyGetNode.create("prototype", false, context);
        this.isObjectNode = IsJSObjectNode.create();
    }

    public static GetPrototypeFromConstructorNode create(JSContext context, JavaScriptNode constructorNode, CompilableFunction<JSRealm, DynamicObject> intrinsicDefaultProto) {
        return new GetPrototypeFromConstructorNode(context, constructorNode, intrinsicDefaultProto);
    }

    public DynamicObject execute(VirtualFrame frame) {
        Object constructor = this.constructorNode.execute(frame);
        return this.executeWithConstructor((DynamicObject)constructor);
    }

    public DynamicObject executeWithConstructor(DynamicObject constructor) {
        assert (JSRuntime.isCallable(constructor));
        Object proto = this.getPrototypeNode.getValue(constructor);
        if (this.isObjectNode.executeBoolean(proto)) {
            assert (JSRuntime.isObject(proto));
            return (DynamicObject)proto;
        }
        JSRealm realm = JSRuntime.getFunctionRealm((Object)constructor, this.getPrototypeNode.getContext());
        return (DynamicObject)this.intrinsicDefaultProto.apply(realm);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == DynamicObject.class;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new GetPrototypeFromConstructorNode(this.getPrototypeNode.getContext(), GetPrototypeFromConstructorNode.cloneUninitialized(this.constructorNode, materializedTags), this.intrinsicDefaultProto);
    }
}

