/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.modules.maven.j2ee.utils.Server;

public final class ServerUtils {
    private ServerUtils() {
    }

    public static void setServer(Project project, Server server) {
        if (server == Server.NO_SERVER_SELECTED) {
            MavenProjectSupport.setServerID(project, null);
            JavaEEProjectSettings.setServerInstanceID((Project)project, null);
        } else {
            MavenProjectSupport.setServerID(project, server.getServerID());
            JavaEEProjectSettings.setServerInstanceID((Project)project, (String)server.getServerInstanceID());
        }
    }

    public static Server findServer(Project project) {
        String instanceID;
        J2eeModule.Type moduleType = ServerUtils.getModuleType(project);
        try {
            instanceID = JavaEEProjectSettings.getServerInstanceID((Project)project);
        }
        catch (UnsupportedOperationException exception) {
            instanceID = null;
        }
        if (instanceID != null) {
            Server server = ServerUtils.findServerByInstance(moduleType, instanceID);
            if (server != null) {
                return server;
            }
            return new Server(instanceID);
        }
        String serverID = MavenProjectSupport.readServerID(project);
        if (serverID != null) {
            Server server = ServerUtils.findServerByType(moduleType, serverID);
            if (server != null) {
                return server;
            }
            return new Server(null, serverID);
        }
        return Server.NO_SERVER_SELECTED;
    }

    private static J2eeModule.Type getModuleType(Project project) {
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (moduleProvider != null && moduleProvider.getJ2eeModule() != null) {
            return moduleProvider.getJ2eeModule().getType();
        }
        return null;
    }

    private static Server findServerByInstance(J2eeModule.Type moduleType, String instanceId) {
        for (Server server : ServerUtils.findServersFor(moduleType)) {
            if (!instanceId.equals(server.getServerInstanceID())) continue;
            return server;
        }
        return null;
    }

    private static Server findServerByType(J2eeModule.Type moduleType, String serverId) {
        for (Server server : ServerUtils.findServersFor(moduleType)) {
            if (!serverId.equals(server.getServerID())) continue;
            return server;
        }
        return null;
    }

    public static List<Server> findServersFor(J2eeModule.Type moduleType) {
        return ServerUtils.convertToList(Deployment.getDefault().getServerInstanceIDs(Collections.singleton(moduleType)));
    }

    private static List<Server> convertToList(String[] serverInstanceIDs) {
        ArrayList<Server> servers = new ArrayList<Server>();
        for (String instanceID : serverInstanceIDs) {
            servers.add(new Server(instanceID));
        }
        Collections.sort(servers);
        servers.add(Server.NO_SERVER_SELECTED);
        return servers;
    }
}

