/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.phpmodule;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.phpmodule.Bundle;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public interface PhpModuleGenerator {
    @NonNull
    public PhpModule createModule(@NonNull CreateProperties var1) throws IOException;

    public static final class CreatePropertiesValidator {
        private final ValidationResult result = new ValidationResult();

        @NonNull
        public ValidationResult getResult() {
            return this.result;
        }

        public CreatePropertiesValidator validate(@NonNull CreateProperties properties) {
            Parameters.notNull((CharSequence)"properties", (Object)properties);
            if (!StringUtils.hasText(properties.getName())) {
                this.result.addError(new ValidationResult.Message("name", Bundle.CreatePropertiesValidator_error_name()));
            }
            if (properties.getSourcesDirectory() == null) {
                this.result.addError(new ValidationResult.Message("sourcesDirectory", Bundle.CreatePropertiesValidator_error_sourcesDirectory()));
            }
            if (properties.getPhpVersion() == null) {
                this.result.addError(new ValidationResult.Message("phpVersion", Bundle.CreatePropertiesValidator_error_phpVersion()));
            }
            if (properties.getCharset() == null) {
                this.result.addError(new ValidationResult.Message("charset", Bundle.CreatePropertiesValidator_error_charset()));
            }
            return this;
        }
    }

    public static final class CreateProperties {
        private volatile String name;
        private volatile File sourcesDirectory;
        private volatile File projectDirectory;
        private volatile PhpVersion phpVersion;
        private volatile Charset charset;
        private volatile boolean autoconfigured;

        @CheckForNull
        public String getName() {
            return this.name;
        }

        public CreateProperties setName(@NonNull String name) {
            Parameters.notNull((CharSequence)"name", (Object)name);
            this.name = name;
            return this;
        }

        @CheckForNull
        public File getSourcesDirectory() {
            return this.sourcesDirectory;
        }

        public CreateProperties setSourcesDirectory(@NonNull File sourcesDirectory) {
            Parameters.notNull((CharSequence)"sourcesDirectory", (Object)sourcesDirectory);
            this.sourcesDirectory = FileUtil.normalizeFile((File)sourcesDirectory);
            return this;
        }

        @CheckForNull
        public File getProjectDirectory() {
            return this.projectDirectory;
        }

        public CreateProperties setProjectDirectory(@NullAllowed File projectDirectory) {
            if (projectDirectory != null) {
                projectDirectory = FileUtil.normalizeFile((File)projectDirectory);
            }
            this.projectDirectory = projectDirectory;
            return this;
        }

        @CheckForNull
        public PhpVersion getPhpVersion() {
            return this.phpVersion;
        }

        public CreateProperties setPhpVersion(PhpVersion phpVersion) {
            Parameters.notNull((CharSequence)"phpVersion", (Object)((Object)phpVersion));
            this.phpVersion = phpVersion;
            return this;
        }

        @CheckForNull
        public Charset getCharset() {
            return this.charset;
        }

        public CreateProperties setCharset(Charset charset) {
            Parameters.notNull((CharSequence)"charset", (Object)charset);
            this.charset = charset;
            return this;
        }

        public boolean isAutoconfigured() {
            return this.autoconfigured;
        }

        public CreateProperties setAutoconfigured(boolean autoconfigured) {
            this.autoconfigured = autoconfigured;
            return this;
        }
    }
}

