/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.spi.phpmodule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.spi.phpmodule.ImportantFilesImplementation;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class ImportantFilesSupport {
    private final FileObject directory;
    final List<String> fileNames;
    final FileChangeListener fileChangeListener = new FilesListener();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    private ImportantFilesSupport(FileObject directory, String ... fileNames) {
        assert (directory != null);
        assert (fileNames != null);
        this.directory = directory;
        this.fileNames = new CopyOnWriteArrayList<String>(fileNames);
    }

    public static ImportantFilesSupport create(FileObject directory, String ... fileNames) {
        Parameters.notNull((CharSequence)"directory", (Object)directory);
        Parameters.notNull((CharSequence)"fileNames", (Object)fileNames);
        ImportantFilesSupport support = new ImportantFilesSupport(directory, fileNames);
        directory.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)support.fileChangeListener, (Object)directory));
        return support;
    }

    public Collection<ImportantFilesImplementation.FileInfo> getFiles(@NullAllowed FileInfoCreator fileInfoCreator) {
        ArrayList<ImportantFilesImplementation.FileInfo> files = new ArrayList<ImportantFilesImplementation.FileInfo>();
        for (String name : this.fileNames) {
            FileObject fo = this.directory.getFileObject(name);
            if (fo == null) continue;
            ImportantFilesImplementation.FileInfo info = null;
            if (fileInfoCreator != null) {
                info = fileInfoCreator.create(fo);
            }
            if (info == null) {
                info = new ImportantFilesImplementation.FileInfo(fo);
            }
            files.add(info);
        }
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        return files;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private final class FilesListener
    extends FileChangeAdapter {
        private FilesListener() {
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.check(fe.getFile().getNameExt());
            this.check(fe.getName() + "." + fe.getExt());
        }

        public void fileDeleted(FileEvent fe) {
            this.check(fe.getFile().getNameExt());
        }

        public void fileDataCreated(FileEvent fe) {
            this.check(fe.getFile().getNameExt());
        }

        private void check(String filename) {
            if (ImportantFilesSupport.this.fileNames.contains(filename)) {
                ImportantFilesSupport.this.fireChange();
            }
        }
    }

    public static interface FileInfoCreator {
        @CheckForNull
        public ImportantFilesImplementation.FileInfo create(FileObject var1);
    }
}

