/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.tool;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.Preferences;
import jdk.jshell.JShell;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionControlProvider;
import jdk.jshell.spi.ExecutionEnv;
import org.netbeans.lib.nbjshell.NbExecutionControl;
import org.netbeans.modules.jshell.tool.Bundle;
import org.netbeans.modules.jshell.tool.IOContext;
import org.netbeans.modules.jshell.tool.JShellTool;
import org.openide.util.Lookup;

public class JShellLauncher
extends JShellTool {
    private String prefix = "";
    private ExecutionControlProvider execGen;
    private NbExecutionControl shellExecControl;
    private String classpath;

    public JShellLauncher(Preferences prefs, PrintStream cmdout, PrintStream cmderr, InputStream userin, PrintStream userout, PrintStream usererr, ExecutionControlProvider execEnv) {
        super(new ByteArrayInputStream(new byte[1]), cmdout, cmderr, cmderr, userin, userout, usererr, prefs, Collections.emptyMap(), Locale.getDefault());
        this.execGen = execEnv;
    }

    public String prompt(boolean continuation) {
        return this.feedback().getPrompt(this.currentNameSpace.tidNext());
    }

    public void start() {
        this.fluff("Welcome to the JShell NetBeans integration", new Object[0]);
        this.fluff("Type /help for help", new Object[0]);
        this.ensureLive();
        this.cmdout.append(this.prompt(false));
    }

    public void stop() {
        this.closeState();
    }

    public void evaluate(String command, boolean prompt) throws IOException {
        this.ensureLive();
        String trimmed = JShellLauncher.trimEnd(command);
        IOContextImpl ioImpl = new IOContextImpl(trimmed.isEmpty() ? null : trimmed);
        this.run(ioImpl);
        if (prompt) {
            if (ioImpl.promptAfter != null) {
                this.cmdout.append(ioImpl.promptAfter);
            } else {
                this.cmdout.append(this.prompt(!this.prefix.isEmpty()));
            }
        }
    }

    protected List<String> historyItems() {
        return Collections.emptyList();
    }

    @Override
    public boolean isLive() {
        return super.isLive();
    }

    public void ensureLive() {
        if (!this.isLive()) {
            this.resetState();
        }
    }

    public JShell getJShell() {
        this.initStartup();
        this.ensureLive();
        return this.state;
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.printSystemInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JShell createJShellInstance() {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            JShell ret;
            String s;
            Thread.currentThread().setContextClassLoader((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
            JShell.Builder b = this.makeBuilder();
            if (this.execGen != null) {
                b.executionEngine(new CaptureExecControl(this.execGen), null);
            }
            if ((s = System.getProperty("jshell.logging.properties")) != null) {
                b = b.remoteVMOptions(JShellLauncher.quote("-Djava.util.logging.config.file=" + s));
            }
            JShell jShell = ret = b.build();
            return jShell;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    public static String quote(String s) {
        if (s.indexOf(32) == -1) {
            return s;
        }
        return '\"' + s + '\"';
    }

    private void printSystemInfo() {
        NbExecutionControl ctrl = this.shellExecControl;
        Map<String, String> versionInfo = ctrl.commandVersionInfo();
        if (versionInfo == null || versionInfo.isEmpty()) {
            return;
        }
        this.hard("", new Object[0]);
        this.hard(Bundle.MSG_SystemInformation(), new Object[0]);
        String javaName = versionInfo.getOrDefault("java.vm.name", Bundle.MSG_MachineUnknown());
        String vmVersion = versionInfo.getOrDefault("java.vm.version", Bundle.MSG_VMVersionUnknown());
        String javaSpec = versionInfo.getOrDefault("java.runtime.version", Bundle.MSG_VersionUnknown());
        this.hard(Bundle.MSG_JavaVersion(javaSpec), new Object[0]);
        this.hard(Bundle.MSG_VirtualMachine(javaName, vmVersion), new Object[0]);
        String cpString = versionInfo.get("nb.class.path");
        String[] cpItems = cpString.split(":");
        if (cpItems.length > 0) {
            this.hard(Bundle.MSG_Classpath(), new Object[0]);
            for (String item : cpItems) {
                if (item.isEmpty()) continue;
                this.hard("\t%s", item);
            }
        }
        this.hard("", new Object[0]);
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    @Override
    public void closeState() {
        super.closeState();
    }

    protected NbExecutionControl execControlCreated(NbExecutionControl ctrl) {
        this.shellExecControl = ctrl;
        return ctrl;
    }

    protected NbExecutionControl execControl() {
        return this.shellExecControl;
    }

    class CaptureExecControl
    implements ExecutionControlProvider {
        private final ExecutionControlProvider delegate;

        public CaptureExecControl(ExecutionControlProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public String name() {
            return this.delegate.name();
        }

        @Override
        public Map<String, String> defaultParameters() {
            return this.delegate.defaultParameters();
        }

        @Override
        public ExecutionControl generate(ExecutionEnv ee, Map<String, String> map) throws Throwable {
            return JShellLauncher.this.execControlCreated((NbExecutionControl)this.delegate.generate(ee, map));
        }
    }

    private class IOContextImpl
    extends IOContext {
        private String str;
        private String promptAfter;

        public IOContextImpl(String str) {
            this.str = str;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public String readLine(String prompt, String prefix) throws IOException, IOContext.InputInterruptedException {
            if (this.str == null) {
                this.promptAfter = prompt;
                return null;
            }
            String s = this.str;
            this.str = null;
            return s;
        }

        @Override
        public boolean interactiveOutput() {
            return true;
        }

        @Override
        public Iterable<String> currentSessionHistory() {
            return JShellLauncher.this.historyItems();
        }

        @Override
        public boolean terminalEditorRunning() {
            return false;
        }

        @Override
        public void suspend() {
        }

        @Override
        public void resume() {
        }

        @Override
        public void beforeUserCode() {
        }

        @Override
        public void afterUserCode() {
        }

        @Override
        public void replaceLastHistoryEntry(String source) {
        }

        @Override
        public int readUserInput() throws IOException {
            return -1;
        }
    }
}

