/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbCollections;

public class EclipseUtils {
    private static final String TMP_NAME = "NB___TMP___ENOUGH___UNIQUE___CONSTANT___";

    public static boolean isRegularProject(String projectDir) {
        return projectDir != null && EclipseUtils.isRegularProject(new File(projectDir.trim()));
    }

    public static boolean isRegularProject(File projectDir) {
        return projectDir != null && FileUtil.toFileObject((File)FileUtil.normalizeFile((File)projectDir)) != null && projectDir.isDirectory() && new File(projectDir, ".project").isFile();
    }

    public static boolean isRegularWorkSpace(File workspaceDir) {
        assert (workspaceDir == null || workspaceDir.equals(FileUtil.normalizeFile((File)workspaceDir))) : "#137407 problem: " + workspaceDir + " vs. " + FileUtil.normalizeFile((File)workspaceDir);
        return workspaceDir != null && FileUtil.toFileObject((File)workspaceDir) != null && workspaceDir.isDirectory() && new File(workspaceDir, ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.jdt.core.prefs").isFile() && new File(workspaceDir, ".metadata/.plugins/org.eclipse.core.resources/.projects").isDirectory();
    }

    public static boolean isWritable(String projectDestination) {
        File tmpDir = new File(projectDestination.trim(), TMP_NAME + System.currentTimeMillis());
        if (tmpDir.mkdirs()) {
            tmpDir.delete();
            return true;
        }
        return false;
    }

    static Map<String, String> loadProperties(File file) throws IOException {
        Properties properties = new Properties();
        try (BufferedInputStream propsIS = new BufferedInputStream(new FileInputStream(file));){
            properties.load(propsIS);
        }
        return NbCollections.checkedMapByFilter((Map)properties, String.class, String.class, (boolean)true);
    }

    public static String[] splitVariable(String v) {
        int i = v.replace('\\', '/').indexOf(47);
        if (i == -1) {
            i = v.length();
        }
        return new String[]{v.substring(0, i), v.substring(i)};
    }

    public static String[] splitProject(String v) {
        assert (v.startsWith("/")) : v;
        int i = v.replace('\\', '/').indexOf(47, 1);
        if (i == -1) {
            i = v.length();
        }
        return new String[]{v.substring(1, i), v.substring(i)};
    }

    public static void tryLoad(Properties p, File base, String path) {
        if (base == null) {
            return;
        }
        File f = new File(base, path);
        EclipseUtils.tryLoad(p, f);
    }

    public static void tryLoad(Properties p, File f) {
        if (!f.isFile()) {
            return;
        }
        try (FileInputStream is = new FileInputStream(f);){
            p.load(is);
        }
        catch (IOException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
    }
}

