/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.util.EventObject;

public class SVNDiffSummary
extends EventObject {
    private static final long serialVersionUID = 1L;
    private SVNDiffKind diffKind;
    private boolean propsChanged;
    private int nodeKind;

    public SVNDiffSummary(String path, SVNDiffKind diffKind, boolean propsChanged, int nodeKind) {
        super(path);
        this.diffKind = diffKind;
        this.propsChanged = propsChanged;
        this.nodeKind = nodeKind;
    }

    public String getPath() {
        return (String)this.source;
    }

    public SVNDiffKind getDiffKind() {
        return this.diffKind;
    }

    public boolean propsChanged() {
        return this.propsChanged;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public String toString() {
        return this.getPath();
    }

    public static class SVNDiffKind {
        public static SVNDiffKind NORMAL = new SVNDiffKind(0);
        public static SVNDiffKind ADDED = new SVNDiffKind(1);
        public static SVNDiffKind MODIFIED = new SVNDiffKind(2);
        public static SVNDiffKind DELETED = new SVNDiffKind(3);
        private int kind;

        private SVNDiffKind(int kind) {
            this.kind = kind;
        }

        public static SVNDiffKind getInstance(int diffKind) throws IllegalArgumentException {
            switch (diffKind) {
                case 0: {
                    return NORMAL;
                }
                case 1: {
                    return ADDED;
                }
                case 2: {
                    return MODIFIED;
                }
                case 3: {
                    return DELETED;
                }
            }
            throw new IllegalArgumentException("Diff kind " + diffKind + " not recognized");
        }

        public boolean equals(Object diffKind) {
            return ((SVNDiffKind)diffKind).kind == this.kind;
        }

        public int hashCode() {
            return this.kind;
        }

        public String toString() {
            switch (this.kind) {
                case 0: {
                    return "normal";
                }
                case 1: {
                    return "added";
                }
                case 2: {
                    return "modified";
                }
                case 3: {
                    return "deleted";
                }
            }
            return "unknown";
        }
    }
}

