/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.Bundle;
import org.netbeans.modules.php.analysis.CodingStandardsFixerParams;
import org.netbeans.modules.php.analysis.commands.CodingStandardsFixer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.analysis.ui.analyzer.CodingStandardsFixerCustomizerPanel;
import org.netbeans.modules.php.analysis.util.AnalysisUtils;
import org.netbeans.modules.php.analysis.util.Mappers;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;

public final class CodingStandardsFixerAnalyzerImpl
implements Analyzer {
    private static final Logger LOGGER = Logger.getLogger(CodingStandardsFixerAnalyzerImpl.class.getName());
    private final Analyzer.Context context;
    private final AtomicBoolean cancelled = new AtomicBoolean();

    public CodingStandardsFixerAnalyzerImpl(Analyzer.Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends ErrorDescription> analyze() {
        Preferences settings = this.context.getSettings();
        if (settings != null && !settings.getBoolean("codingStandardsFixer.enabled", false)) {
            return Collections.emptyList();
        }
        CodingStandardsFixer codingStandardsFixer = this.getValidCodingStandardsFixer();
        if (codingStandardsFixer == null) {
            this.context.reportAnalysisProblem(Bundle.CodingStandardsFixerAnalyzerImpl_codingStandardsFixer_error(), (CharSequence)Bundle.CodingStandardsFixerAnalyzerImpl_codingStandardsFixer_error_description());
            return Collections.emptyList();
        }
        String version = this.getValidCodingStandardsFixerVersion();
        String level = this.getValidCodingStandardsFixerLevel();
        String config = this.getValidCodingStandardsFixerConfig();
        String options = this.getValidCodingStandardsFixerOptions();
        CodingStandardsFixerParams codingStandardsFixerParams = new CodingStandardsFixerParams().setVersion(version).setLevel(level).setConfig(config).setOptions(options);
        Scope scope = this.context.getScope();
        Map<FileObject, Integer> fileCount = AnalysisUtils.countPhpFiles(scope);
        int totalCount = 0;
        for (Integer count : fileCount.values()) {
            totalCount += count.intValue();
        }
        this.context.start(totalCount);
        try {
            Iterable<? extends ErrorDescription> iterable = this.doAnalyze(scope, codingStandardsFixer, codingStandardsFixerParams, fileCount);
            return iterable;
        }
        finally {
            this.context.finish();
        }
    }

    public boolean cancel() {
        this.cancelled.set(true);
        return true;
    }

    private Iterable<? extends ErrorDescription> doAnalyze(Scope scope, CodingStandardsFixer codingStandardsFixer, CodingStandardsFixerParams params, Map<FileObject, Integer> fileCount) {
        List<Result> results;
        ArrayList<Object> errors = new ArrayList<Object>();
        int progress = 0;
        codingStandardsFixer.startAnalyzeGroup();
        for (FileObject root : scope.getSourceRoots()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            results = codingStandardsFixer.analyze(params, root);
            if (results == null) {
                this.context.reportAnalysisProblem(Bundle.CodingStandardsFixerAnalyzerImpl_analyze_error(), (CharSequence)Bundle.CodingStandardsFixerAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results));
            this.context.progress(progress += fileCount.get(root).intValue());
        }
        for (FileObject file : scope.getFiles()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            results = codingStandardsFixer.analyze(params, file);
            if (results == null) {
                this.context.reportAnalysisProblem(Bundle.CodingStandardsFixerAnalyzerImpl_analyze_error(), (CharSequence)Bundle.CodingStandardsFixerAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results));
            this.context.progress(progress += fileCount.get(file).intValue());
        }
        for (NonRecursiveFolder nonRecursiveFolder : scope.getFolders()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            FileObject folder = nonRecursiveFolder.getFolder();
            List<Result> results2 = codingStandardsFixer.analyze(params, folder);
            if (results2 == null) {
                this.context.reportAnalysisProblem(Bundle.CodingStandardsFixerAnalyzerImpl_analyze_error(), (CharSequence)Bundle.CodingStandardsFixerAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results2));
            this.context.progress(progress += fileCount.get(folder).intValue());
        }
        return errors;
    }

    @CheckForNull
    private CodingStandardsFixer getValidCodingStandardsFixer() {
        Preferences settings = this.context.getSettings();
        String codingStandardsFixerPath = null;
        if (settings != null) {
            codingStandardsFixerPath = settings.get("codingStandardsFixer.path", null);
        }
        try {
            if (StringUtils.hasText(codingStandardsFixerPath)) {
                return CodingStandardsFixer.getCustom(codingStandardsFixerPath);
            }
            return CodingStandardsFixer.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }

    private String getValidCodingStandardsFixerVersion() {
        String codingStandardsFixerVersion = null;
        Preferences settings = this.context.getSettings();
        if (settings != null) {
            codingStandardsFixerVersion = settings.get("codingStandardsFixer.version", null);
        }
        if (codingStandardsFixerVersion == null) {
            codingStandardsFixerVersion = AnalysisOptions.getInstance().getCodingStandardsFixerVersion();
        }
        assert (codingStandardsFixerVersion != null);
        return codingStandardsFixerVersion;
    }

    @CheckForNull
    private String getValidCodingStandardsFixerLevel() {
        String codingStandardsFixerLevel = null;
        Preferences settings = this.context.getSettings();
        if (settings != null) {
            codingStandardsFixerLevel = settings.get("codingStandardsFixer.level", null);
        }
        if (codingStandardsFixerLevel == null) {
            codingStandardsFixerLevel = AnalysisOptions.getInstance().getCodingStandardsFixerLevel();
        }
        assert (codingStandardsFixerLevel != null);
        return codingStandardsFixerLevel;
    }

    @CheckForNull
    private String getValidCodingStandardsFixerConfig() {
        String codingStandardsFixerConfig = null;
        Preferences settings = this.context.getSettings();
        if (settings != null) {
            codingStandardsFixerConfig = settings.get("codingStandardsFixer.config", null);
        }
        if (codingStandardsFixerConfig == null) {
            codingStandardsFixerConfig = AnalysisOptions.getInstance().getCodingStandardsFixerConfig();
        }
        assert (codingStandardsFixerConfig != null);
        return codingStandardsFixerConfig;
    }

    @CheckForNull
    private String getValidCodingStandardsFixerOptions() {
        String codingStandardsFixerOptions = null;
        Preferences settings = this.context.getSettings();
        if (settings != null) {
            codingStandardsFixerOptions = settings.get("codingStandardsFixer.options", null);
        }
        if (codingStandardsFixerOptions == null) {
            codingStandardsFixerOptions = AnalysisOptions.getInstance().getCodingStandardsFixerOptions();
        }
        assert (codingStandardsFixerOptions != null);
        return codingStandardsFixerOptions;
    }

    public static final class CodingStandardsFixerAnalyzerFactory
    extends Analyzer.AnalyzerFactory {
        private static final String ICON_PATH = "org/netbeans/modules/php/analysis/ui/resources/coding-standards-fixer.png";

        public CodingStandardsFixerAnalyzerFactory() {
            super("PhpCodingStandardsFixer", Bundle.CodingStandardsFixerAnalyzerFactory_displayName(), ICON_PATH);
        }

        public Iterable<? extends Analyzer.WarningDescription> getWarnings() {
            return Collections.emptyList();
        }

        public Analyzer.CustomizerProvider<Void, CodingStandardsFixerCustomizerPanel> getCustomizerProvider() {
            return new Analyzer.CustomizerProvider<Void, CodingStandardsFixerCustomizerPanel>(){

                public Void initialize() {
                    return null;
                }

                public CodingStandardsFixerCustomizerPanel createComponent(Analyzer.CustomizerContext<Void, CodingStandardsFixerCustomizerPanel> context) {
                    return new CodingStandardsFixerCustomizerPanel(context);
                }
            };
        }

        public Analyzer createAnalyzer(Analyzer.Context context) {
            return new CodingStandardsFixerAnalyzerImpl(context);
        }
    }
}

