/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.modules.java.hints.ArithmeticUtilities;
import org.netbeans.modules.java.hints.bugs.NPECheck;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.suggestions.Bundle;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class IfToSwitchSupport {
    private final HintContext ctx;
    protected final CompilationInfo ci;
    private boolean controlVarNotNull;
    TreePath variable;
    private TypeMirror controlTypeMirror;
    private Map<TreePath, Object> duplicateLiterals = Collections.emptyMap();
    private Set<Object> seenLiterals;
    private List literals;
    List<BranchDescription> literal2Statement = new ArrayList<BranchDescription>();
    private TreePath nullBranch;
    TreePath c1;
    TreePath c2;

    public IfToSwitchSupport(HintContext ctx) {
        this.ctx = ctx;
        this.ci = ctx.getInfo();
    }

    public int getNumberOfBranches() {
        return this.literal2Statement.size();
    }

    public List<BranchDescription> getBranches() {
        return this.literal2Statement;
    }

    public boolean isControlNotNull() {
        return this.controlVarNotNull;
    }

    protected TypeMirror acceptArgType(TypeMirror controlType, TypeMirror argType) {
        if (this.ci.getTypes().isSameType(argType, controlType)) {
            return controlType;
        }
        if (this.ci.getTypes().isAssignable(argType, controlType)) {
            return controlType;
        }
        if (this.ci.getTypes().isAssignable(controlType, argType)) {
            return argType;
        }
        return null;
    }

    protected Object convert(Object o, TypeMirror m) {
        if (o instanceof EnumConst) {
            TypeMirror elM = ((EnumConst)o).constEl.asType();
            if (this.ci.getTypes().isSubtype(elM, m)) {
                return o;
            }
            return m;
        }
        return ArithmeticUtilities.implicitConversion(this.ci, o, m);
    }

    boolean addLiteral(Object l, TypeMirror commonType, TreePath litPath) {
        if (!this.ctx.getInfo().getTypes().isSameType(commonType, this.controlTypeMirror)) {
            HashSet<Object> newLiterals = new HashSet<Object>(this.seenLiterals.size());
            for (Object o : this.seenLiterals) {
                Object converted = this.convert(o, commonType);
                if (converted == null) {
                    return false;
                }
                newLiterals.add(converted);
            }
            this.seenLiterals = newLiterals;
        }
        this.literals.add(TreePathHandle.create((TreePath)litPath, (CompilationInfo)this.ctx.getInfo()));
        if (this.seenLiterals.contains(l)) {
            if (this.duplicateLiterals.isEmpty()) {
                this.duplicateLiterals = new LinkedHashMap<TreePath, Object>(3);
            }
            this.duplicateLiterals.put(litPath, l);
        } else {
            this.seenLiterals.add(l);
        }
        return true;
    }

    void reset() {
        if (!this.literals.isEmpty()) {
            this.literals = new ArrayList(2);
            this.duplicateLiterals = Collections.emptyMap();
            this.seenLiterals = new HashSet<Object>();
        }
    }

    protected void controlVariableNotNull() {
        this.controlVarNotNull = true;
    }

    protected void reportConstantAndLiteral(TreePath c1, TreePath c2) {
        this.c1 = c1;
        this.c2 = c2;
    }

    protected TreePath matches(TreePath test, boolean initial) {
        return null;
    }

    public TypeMirror getVariableMirror() {
        return this.controlTypeMirror;
    }

    protected TreePath matchesChainedItem(TreePath test, TreePath variable) {
        return null;
    }

    private boolean isRealValue(Object o) {
        return ArithmeticUtilities.isNull(o) || o instanceof EnumConst || ArithmeticUtilities.isRealValue(o);
    }

    protected Object evalConstant(TreePath path) {
        TypeMirror m = this.ci.getTrees().getTypeMirror(path);
        if (m != null && m.getKind() != TypeKind.DECLARED) {
            return ArithmeticUtilities.compute(this.ci, path, true, true);
        }
        Element e = this.ci.getTrees().getElement(path);
        if (e != null && e.getKind() == ElementKind.ENUM_CONSTANT) {
            return new EnumConst(e);
        }
        return null;
    }

    public boolean process(TreePath initCond) {
        Iterable<? extends TreePath> split = IfToSwitchSupport.linearizeOrs(initCond);
        TreePath body = (TreePath)this.ctx.getVariables().get("$body");
        if (body == null) {
            return false;
        }
        if (!this.start(split, body)) {
            return false;
        }
        this.controlVarNotNull |= this.controlTypeMirror.getKind().isPrimitive() || NPECheck.isSafeToDereference(this.ci, this.variable);
        this.literal2Statement.add(new BranchDescription(this.literals, TreePathHandle.create((TreePath)body, (CompilationInfo)this.ctx.getInfo())));
        TreePath ifPath = body.getParentPath();
        StatementTree e = ((IfTree)ifPath.getLeaf()).getElseStatement();
        while (e != null && e.getKind() == Tree.Kind.IF) {
            this.literals = new ArrayList();
            ifPath = new TreePath(ifPath, e);
            IfTree it = (IfTree)ifPath.getLeaf();
            this.literals = new LinkedList();
            TreePath lastCondition = new TreePath(ifPath, it.getCondition());
            for (TreePath treePath : IfToSwitchSupport.linearizeOrs(lastCondition)) {
                TypeMirror common;
                TreePath constPath = this.matchesChainedItem(treePath, this.variable);
                if (constPath == null) {
                    return false;
                }
                Object o = this.evalConstant(constPath);
                TypeMirror constType = this.ctx.getInfo().getTrees().getTypeMirror(constPath);
                boolean isNull = constType != null && constType.getKind() == TypeKind.NULL;
                TypeMirror typeMirror = common = isNull ? this.controlTypeMirror : this.acceptArgType(this.controlTypeMirror, constType);
                if (isNull) {
                    this.nullBranch = new TreePath(ifPath, it.getThenStatement());
                }
                if (!this.isRealValue(o) || common == null) {
                    return false;
                }
                if (this.addLiteral(this.convert(o, common), common, constPath)) continue;
                return false;
            }
            this.literal2Statement.add(new BranchDescription(this.literals, TreePathHandle.create((TreePath)new TreePath(ifPath, it.getThenStatement()), (CompilationInfo)this.ctx.getInfo())));
            e = it.getElseStatement();
        }
        if (e != null) {
            TreePath defPath = new TreePath(ifPath, e);
            this.literal2Statement.add(new BranchDescription(null, TreePathHandle.create((TreePath)defPath, (CompilationInfo)this.ci)));
            if (!this.controlVarNotNull && this.nullBranch == null) {
                this.nullBranch = defPath;
            }
        }
        return true;
    }

    boolean start(Iterable<? extends TreePath> conds, TreePath ifBody) {
        Iterator<? extends TreePath> iter = conds.iterator();
        TreePath first = iter.next();
        TreePath constPath = this.matches(first, true);
        if (constPath == null) {
            return false;
        }
        this.literals = new LinkedList();
        this.seenLiterals = new HashSet<Object>();
        Object c = this.evalConstant(this.c1);
        if (this.isRealValue(c)) {
            this.variable = this.c2;
            this.controlTypeMirror = this.ci.getTrees().getTypeMirror(this.c2);
            constPath = this.c1;
        } else {
            c = this.evalConstant(this.c2);
            if (this.isRealValue(c)) {
                this.variable = this.c1;
                constPath = this.c2;
            } else {
                return false;
            }
        }
        if (this.variable.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
            this.controlVarNotNull = true;
        }
        TypeMirror constType = this.ci.getTrees().getTypeMirror(this.c1);
        this.controlTypeMirror = this.ctx.getInfo().getTrees().getTypeMirror(this.variable);
        if (!Utilities.isValidType(this.controlTypeMirror)) {
            return false;
        }
        TypeMirror common = this.acceptArgType(this.controlTypeMirror, constType);
        if (common == null) {
            return false;
        }
        if (ArithmeticUtilities.isNull(c)) {
            this.nullBranch = ifBody;
        }
        if (!this.addLiteral(this.convert(c, constType), common, constPath)) {
            return false;
        }
        while (iter.hasNext()) {
            TreePath lt = this.matchesChainedItem(iter.next(), this.variable);
            if (lt == null) {
                return false;
            }
            Object o = this.evalConstant(lt);
            if (!ArithmeticUtilities.isRealValue(o)) {
                return false;
            }
            constType = this.ci.getTrees().getTypeMirror(lt);
            common = this.acceptArgType(this.controlTypeMirror, constType);
            if (common == null) {
                return false;
            }
            if (!this.addLiteral(this.convert(o, constType), common, lt)) {
                return false;
            }
            if (!ArithmeticUtilities.isNull(o)) continue;
            this.nullBranch = ifBody;
        }
        return true;
    }

    private static Iterable<? extends TreePath> linearizeOrs(TreePath cond) {
        LinkedList<TreePath> result = new LinkedList<TreePath>();
        while (cond.getLeaf().getKind() == Tree.Kind.CONDITIONAL_OR || cond.getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
            if (cond.getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
                cond = new TreePath(cond, ((ParenthesizedTree)cond.getLeaf()).getExpression());
                continue;
            }
            BinaryTree bt = (BinaryTree)cond.getLeaf();
            result.add(new TreePath(cond, bt.getRightOperand()));
            cond = new TreePath(cond, bt.getLeftOperand());
        }
        result.add(cond);
        Collections.reverse(result);
        return result;
    }

    public Map<TreePath, Object> getDuplicateConstants() {
        return this.duplicateLiterals;
    }

    public boolean containsDuplicateConstants() {
        return !this.duplicateLiterals.isEmpty();
    }

    public JavaFix createFix(String fixLabel, boolean alwaysDefault) {
        TreePathHandle nHandle = this.nullBranch == null ? null : TreePathHandle.create((TreePath)this.nullBranch, (CompilationInfo)this.ctx.getInfo());
        ConvertToSwitch fix = new ConvertToSwitch(this.ctx.getInfo(), this.ctx.getPath(), TreePathHandle.create((TreePath)this.variable, (CompilationInfo)this.ctx.getInfo()), nHandle, this.literal2Statement, this.isControlNotNull(), fixLabel);
        if (alwaysDefault) {
            fix.addDefaultAlways();
        }
        return fix;
    }

    public static final class ConvertToSwitch
    extends JavaFix {
        private final TreePathHandle value;
        private final List<BranchDescription> literal2Statement;
        private final String label;
        private boolean alwaysCreateDefault;
        private boolean varNotNull;
        private Set<Tree> ifSeen = new HashSet<Tree>();
        private boolean enumType;
        private final TreePathHandle nullBranch;

        public ConvertToSwitch(CompilationInfo info, TreePath create, TreePathHandle value, TreePathHandle nullBranch, List<BranchDescription> literal2Statement, boolean varNotNull, String label) {
            super(info, create);
            this.value = value;
            this.literal2Statement = literal2Statement;
            this.varNotNull = varNotNull;
            this.label = label;
            this.nullBranch = nullBranch;
        }

        public void addDefaultAlways() {
            this.alwaysCreateDefault = true;
        }

        public String getText() {
            return this.label;
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath it = ctx.getPath();
            TreeMaker make = copy.getTreeMaker();
            LinkedList<CaseTree> cases = new LinkedList<CaseTree>();
            ArrayList<TreePath> resolved = new ArrayList<TreePath>(this.literal2Statement.size());
            IdentityHashMap<TreePath, Set<Name>> catch2Declared = new IdentityHashMap<TreePath, Set<Name>>();
            IdentityHashMap<TreePath, Set<Name>> catch2Used = new IdentityHashMap<TreePath, Set<Name>>();
            IdentityHashMap<BreakTree, StatementTree> break2Target = new IdentityHashMap<BreakTree, StatementTree>();
            TreePath value = this.value.resolve((CompilationInfo)copy);
            TreePath nullBranchResolved = null;
            if (value == null) {
                return;
            }
            TypeMirror valType = copy.getTrees().getTypeMirror(value);
            if (!Utilities.isValidType(valType)) {
                return;
            }
            if (!(this.nullBranch == null || (nullBranchResolved = this.nullBranch.resolve((CompilationInfo)copy)) != null && nullBranchResolved.getLeaf() instanceof StatementTree)) {
                return;
            }
            this.enumType = valType.getKind() == TypeKind.DECLARED && ((DeclaredType)valType).asElement().getKind() == ElementKind.ENUM;
            boolean defaultPresent = false;
            for (BranchDescription branchDescription : this.literal2Statement) {
                TreePath s = branchDescription.path.resolve((CompilationInfo)copy);
                if (s == null) {
                    return;
                }
                resolved.add(s);
                catch2Declared.put(s, this.declaredVariables(s));
                catch2Used.put(s, this.usedVariables((CompilationInfo)copy, s, break2Target));
                if (branchDescription.literals != null) continue;
                defaultPresent = true;
            }
            Iterator branchPaths = resolved.iterator();
            for (BranchDescription d : this.literal2Statement) {
                if (!this.addCase(copy, d, (TreePath)branchPaths.next(), cases, catch2Declared, catch2Used)) continue;
                return;
            }
            if (!defaultPresent && this.alwaysCreateDefault) {
                this.addCase(copy, new BranchDescription(null, null), null, cases, catch2Declared, catch2Used);
            }
            this.varNotNull |= NPECheck.isSafeToDereference((CompilationInfo)copy, value);
            SwitchTree switchTree = make.Switch((ExpressionTree)value.getLeaf(), cases);
            Utilities.copyComments(copy, it.getLeaf(), switchTree, true);
            StatementTree nue = switchTree;
            if (!this.varNotNull) {
                nue = nullBranchResolved == null ? make.If((ExpressionTree)make.Parenthesized((ExpressionTree)make.Binary(Tree.Kind.NOT_EQUAL_TO, (ExpressionTree)make.Literal(null), (ExpressionTree)value.getLeaf())), (StatementTree)switchTree, null) : make.If((ExpressionTree)make.Parenthesized((ExpressionTree)make.Binary(Tree.Kind.EQUAL_TO, (ExpressionTree)make.Literal(null), (ExpressionTree)value.getLeaf())), (StatementTree)nullBranchResolved.getLeaf(), (StatementTree)switchTree);
            } else if (nullBranchResolved != null) {
                nue = make.If((ExpressionTree)make.Parenthesized((ExpressionTree)make.Binary(Tree.Kind.EQUAL_TO, (ExpressionTree)make.Literal(null), (ExpressionTree)value.getLeaf())), (StatementTree)nullBranchResolved.getLeaf(), (StatementTree)switchTree);
            }
            copy.rewrite(it.getLeaf(), (Tree)nue);
            TreePath topLevelMethod = Utilities.findTopLevelBlock(it);
            final HashSet<String> seenLabels = new HashSet<String>();
            new ErrorAwareTreeScanner<Void, Void>(){

                public Void visitLabeledStatement(LabeledStatementTree node, Void p) {
                    seenLabels.add(node.getLabel().toString());
                    return (Void)super.visitLabeledStatement(node, (Object)p);
                }
            }.scan(topLevelMethod.getLeaf(), null);
            IdentityHashMap<StatementTree, String> labels = new IdentityHashMap<StatementTree, String>();
            for (Map.Entry e : break2Target.entrySet()) {
                String label = (String)labels.get(e.getValue());
                if (label == null) {
                    label = ConvertToSwitch.computeLabel(seenLabels);
                    labels.put((StatementTree)e.getValue(), label);
                    copy.rewrite((Tree)e.getValue(), (Tree)make.LabeledStatement((CharSequence)label, (StatementTree)e.getValue()));
                }
                copy.rewrite((Tree)e.getKey(), (Tree)make.Break((CharSequence)label));
            }
        }

        private static String computeLabel(Set<String> labels) {
            int index = 0;
            String label = Bundle.LABEL_OuterGeneratedLabelInitial();
            while (labels.contains(label)) {
                label = Bundle.LABEL_OuterGeneratedLabel(++index);
            }
            labels.add(label);
            return label;
        }

        private Tree findExpressionParentIf(TreePath p) {
            while (p != null && !StatementTree.class.isAssignableFrom(p.getLeaf().getKind().asInterface())) {
                p = p.getParentPath();
            }
            return p == null ? null : p.getLeaf();
        }

        /*
         * WARNING - void declaration
         */
        private boolean addCase(WorkingCopy copy, BranchDescription desc, TreePath path, List<CaseTree> cases, Map<TreePath, Set<Name>> catch2Declared, Map<TreePath, Set<Name>> catch2Used) {
            TreeMaker make = copy.getTreeMaker();
            LinkedList statements = new LinkedList();
            BlockTree replacedByCase = null;
            boolean breakGenerated = false;
            if (path != null) {
                Tree then = path.getLeaf();
                if (then.getKind() == Tree.Kind.BLOCK) {
                    Set<Name> currentDeclared = catch2Declared.get(path);
                    boolean keepBlock = false;
                    for (Map.Entry<TreePath, Set<Name>> e : catch2Declared.entrySet()) {
                        if (e.getKey() == path || Collections.disjoint(currentDeclared, (Collection)e.getValue())) continue;
                        keepBlock = true;
                        break;
                    }
                    if (!keepBlock) {
                        for (Map.Entry<TreePath, Set<Name>> e : catch2Used.entrySet()) {
                            if (e.getKey() == path || Collections.disjoint(currentDeclared, (Collection)e.getValue())) continue;
                            keepBlock = true;
                            break;
                        }
                    }
                    boolean exitsFromAllBranches = false;
                    for (Tree tree : ((BlockTree)then).getStatements()) {
                        exitsFromAllBranches |= Utilities.exitsFromAllBranchers((CompilationInfo)copy, new TreePath(path, tree));
                    }
                    BlockTree block = (BlockTree)then;
                    if (keepBlock) {
                        if (!exitsFromAllBranches) {
                            statements.add((StatementTree)make.asReplacementOf((Tree)make.addBlockStatement(block, (StatementTree)make.Break(null)), (Tree)block, true));
                        } else {
                            statements.add(block);
                        }
                    } else {
                        statements.addAll(block.getStatements());
                        replacedByCase = block;
                        if (!exitsFromAllBranches) {
                            statements.add(make.Break(null));
                        }
                    }
                    breakGenerated = true;
                } else {
                    statements.add((StatementTree)then);
                    if (!Utilities.exitsFromAllBranchers((CompilationInfo)copy, path)) {
                        statements.add(make.Break(null));
                    }
                }
            } else {
                statements.add(make.Break(null));
            }
            if (desc.literals == null) {
                CaseTree ct = make.Case(null, statements);
                if (replacedByCase != null) {
                    ct = (CaseTree)make.asReplacementOf((Tree)ct, replacedByCase, true);
                }
                cases.add(ct);
                return false;
            }
            Iterator it = desc.literals.iterator();
            while (it.hasNext()) {
                void var16_23;
                Element c;
                TreePathHandle tph = (TreePathHandle)it.next();
                TreePath lit = tph.resolve((CompilationInfo)copy);
                if (lit == null) {
                    return true;
                }
                Tree ifSt = this.findExpressionParentIf(lit);
                if (ifSt != null && !this.ifSeen.add(ifSt)) {
                    ifSt = null;
                }
                List body = it.hasNext() ? Collections.emptyList() : statements;
                ExpressionTree expressionTree = (ExpressionTree)lit.getLeaf();
                TypeMirror m = copy.getTrees().getTypeMirror(lit);
                if (m == null || m.getKind() == TypeKind.NULL) continue;
                if (this.enumType && (c = copy.getTrees().getElement(lit)) != null && c.getKind() == ElementKind.ENUM_CONSTANT) {
                    IdentifierTree identifierTree = make.Identifier((CharSequence)((VariableElement)c).getSimpleName());
                }
                CaseTree nc = make.Case((ExpressionTree)var16_23, body);
                if (ifSt != null) {
                    nc = (CaseTree)make.asReplacementOf((Tree)nc, ifSt, true);
                }
                cases.add(nc);
            }
            return false;
        }

        private Set<Name> declaredVariables(TreePath where) {
            HashSet<Name> result = new HashSet<Name>();
            List<Tree> statements = where.getLeaf().getKind() == Tree.Kind.BLOCK ? ((BlockTree)where.getLeaf()).getStatements() : Collections.singletonList(where.getLeaf());
            for (Tree t : statements) {
                if (t.getKind() != Tree.Kind.VARIABLE) continue;
                result.add(((VariableTree)t).getName());
            }
            return result;
        }

        private Set<Name> usedVariables(final CompilationInfo info, TreePath where, final Map<BreakTree, StatementTree> break2Target) {
            final HashSet<Name> result = new HashSet<Name>();
            final HashSet declared = new HashSet();
            final HashSet<Tree> above = new HashSet<Tree>();
            for (Tree t : where) {
                above.add(t);
            }
            new ErrorAwareTreePathScanner<Void, Void>(){

                public Void visitIdentifier(IdentifierTree node, Void p) {
                    if (declared.contains(info.getTrees().getElement(this.getCurrentPath()))) {
                        return null;
                    }
                    result.add(node.getName());
                    return (Void)super.visitIdentifier(node, (Object)p);
                }

                public Void visitVariable(VariableTree node, Void p) {
                    declared.add(info.getTrees().getElement(this.getCurrentPath()));
                    return (Void)super.visitVariable(node, (Object)p);
                }

                public Void visitBreak(BreakTree node, Void p) {
                    StatementTree target;
                    if (node.getLabel() == null && above.contains(target = info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()))) {
                        break2Target.put(node, target);
                    }
                    return (Void)super.visitBreak(node, (Object)p);
                }
            }.scan(where, null);
            return result;
        }
    }

    public static final class BranchDescription {
        @NullAllowed
        private final Iterable<TreePathHandle> literals;
        @NonNull
        private final TreePathHandle path;

        public BranchDescription(Iterable literals, TreePathHandle path) {
            this.literals = literals;
            this.path = path;
        }
    }

    static class EnumConst {
        final Element constEl;

        public EnumConst(Element constEl) {
            this.constEl = constEl;
        }

        public int hashCode() {
            int hash = 3;
            hash = 79 * hash + Objects.hashCode(this.constEl);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumConst other = (EnumConst)obj;
            return this.constEl == other.constEl;
        }
    }
}

