/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.impl.APIAccessor;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.java.plugins.DeleteFile;
import org.netbeans.modules.refactoring.java.spi.hooks.JavaModificationResult;
import org.netbeans.modules.refactoring.plugins.FileMovePlugin;
import org.netbeans.modules.refactoring.spi.ModificationResult;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;

public abstract class CodeRefactoring
extends CodeActionsProvider {
    protected final WorkspaceEdit perform(AbstractRefactoring refactoring, String name) throws Exception {
        RefactoringSession session = RefactoringSession.create((String)name);
        Problem p = refactoring.checkParameters();
        if (p != null && p.isFatal()) {
            throw new IllegalStateException(p.getMessage());
        }
        p = refactoring.preCheck();
        if (p != null && p.isFatal()) {
            throw new IllegalStateException(p.getMessage());
        }
        p = refactoring.prepare(session);
        if (p != null && p.isFatal()) {
            throw new IllegalStateException(p.getMessage());
        }
        ArrayList<Either> resultChanges = new ArrayList<Either>();
        HashMap<String, Object> renames = new HashMap<String, Object>();
        List fileChanges = APIAccessor.DEFAULT.getFileChanges(session);
        for (RefactoringElementImplementation rei : fileChanges) {
            String oldURI;
            if (rei instanceof FileMovePlugin.MoveFile) {
                oldURI = Utils.toUri(rei.getParentFile());
                int slash = oldURI.lastIndexOf(47);
                URL url = (URL)((MoveRefactoring)refactoring).getTarget().lookup(URL.class);
                String newURI = url.toString() + oldURI.substring(slash + 1);
                renames.put(oldURI, newURI);
                RenameFile op = new RenameFile(oldURI, newURI);
                resultChanges.add(Either.forRight((Object)op));
                continue;
            }
            if (rei instanceof DeleteFile) {
                oldURI = Utils.toUri(rei.getParentFile());
                org.eclipse.lsp4j.DeleteFile op = new org.eclipse.lsp4j.DeleteFile(oldURI);
                resultChanges.add(Either.forRight((Object)op));
                continue;
            }
            throw new IllegalStateException(rei.getClass().toString());
        }
        List transactions = APIAccessor.DEFAULT.getCommits(session);
        ArrayList<org.netbeans.api.java.source.ModificationResult> results = new ArrayList<org.netbeans.api.java.source.ModificationResult>();
        for (Transaction t : transactions) {
            if (t instanceof RefactoringCommit) {
                RefactoringCommit c = (RefactoringCommit)t;
                for (ModificationResult refResult : SPIAccessor.DEFAULT.getTransactions(c)) {
                    if (refResult instanceof JavaModificationResult) {
                        results.add(((JavaModificationResult)refResult).delegate);
                        continue;
                    }
                    throw new IllegalStateException(refResult.getClass().toString());
                }
                continue;
            }
            throw new IllegalStateException(t.getClass().toString());
        }
        for (org.netbeans.api.java.source.ModificationResult mr : results) {
            Set newFiles = mr.getNewFiles();
            if (newFiles.size() > 1) {
                throw new IllegalStateException();
            }
            String newFilePath = null;
            for (File newFile : newFiles) {
                newFilePath = newFile.toURI().toString();
                resultChanges.add(Either.forRight((Object)new CreateFile(newFilePath)));
            }
            for (FileObject modified : mr.getModifiedFileObjects()) {
                String modifiedUri = Utils.toUri(modified);
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                for (ModificationResult.Difference diff : mr.getDifferences(modified)) {
                    String newText = diff.getNewText();
                    if (diff.getKind() == ModificationResult.Difference.Kind.CREATE) {
                        Position pos = new Position(0, 0);
                        resultChanges.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(newFilePath, Integer.valueOf(-1)), Collections.singletonList(new TextEdit(new Range(pos, pos), newText != null ? newText : "")))));
                        continue;
                    }
                    edits.add(new TextEdit(new Range(Utils.createPosition(modified, diff.getStartPosition().getOffset()), Utils.createPosition(modified, diff.getEndPosition().getOffset())), newText != null ? newText : ""));
                }
                resultChanges.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(renames.getOrDefault(modifiedUri, modifiedUri), Integer.valueOf(-1)), edits)));
            }
        }
        session.finished();
        return new WorkspaceEdit(resultChanges);
    }
}

