/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.JSFFrameworkProvider;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.palette.JSFPaletteUtilities;
import org.netbeans.modules.web.jsf.wizards.JSFValidationPanel;
import org.netbeans.modules.web.jsf.wizards.TemplatePanel;
import org.netbeans.modules.web.jsf.wizards.TemplatePanelVisual;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class TemplateIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 458897855L;
    private int index;
    private transient WizardDescriptor.Panel[] panels;
    private TemplatePanel templatePanel;
    static final String CSS_FOLDER = "css";
    private static final String CSS_FOLDER2 = "resources/css";
    private static final String CSS_EXT = "css";
    private static final String XHTML_EXT = "xhtml";
    private static final String ENCODING = "UTF-8";
    private static String TEMPLATE_XHTML = "template.xhtml";
    private static String TEMPLATE_XHTML2 = "template-jsf2.template";
    private static String TEMPLATE_XHTML22 = "template-jsf22.template";
    private static String FL_RESOURCE_FOLDER = "org/netbeans/modules/web/jsf/facelets/resources/templates/";

    static FileObject createTemplate(Project project, FileObject targetDir, boolean addJSFFrameworkIfNecessary) throws IOException {
        FileObject result = null;
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm != null) {
            FileObject dir = wm.getDocumentBase();
            if (dir.getFileObject(TEMPLATE_XHTML) != null) {
                return null;
            }
            if (addJSFFrameworkIfNecessary && !JSFConfigUtilities.hasJsfFramework(dir)) {
                JSFConfigUtilities.extendJsfFramework(dir, false);
            }
            JSFVersion version = JSFVersion.forWebModule(wm);
            String templateFile = TEMPLATE_XHTML2;
            if (version != null && version.isAtLeast(JSFVersion.JSF_2_2)) {
                templateFile = TEMPLATE_XHTML22;
            }
            String content = JSFFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(FL_RESOURCE_FOLDER + templateFile), ENCODING);
            result = FileUtil.createData((FileObject)targetDir, (String)TEMPLATE_XHTML);
            JSFFrameworkProvider.createFile(result, content, ENCODING);
            DataObject dob = DataObject.find((FileObject)result);
            if (dob != null) {
                JSFPaletteUtilities.reformat(dob);
            }
        }
        return result;
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wiz);
        String targetName = Templates.getTargetName((WizardDescriptor)wiz);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        if (df != null) {
            WebModule wm = WebModule.getWebModule((FileObject)df.getPrimaryFile());
            if (wm != null) {
                FileObject docBase = wm.getDocumentBase();
                if (!JSFConfigUtilities.hasJsfFramework(docBase)) {
                    JSFConfigUtilities.extendJsfFramework(dir, false);
                }
                JSFVersion jsfVersion = JSFVersion.forWebModule(wm) != null ? JSFVersion.forWebModule(wm) : JSFVersion.JSF_2_2;
                FileObject cssFolder = this.handleCssFolderCreation(jsfVersion, docBase);
                return this.createTemplate(wiz, df, targetName, cssFolder, jsfVersion);
            }
            Project project = Templates.getProject((WizardDescriptor)wiz);
            JSFVersion jsfVersion = JSFVersion.forProject(project);
            jsfVersion = jsfVersion == null ? JSFVersion.JSF_2_2 : jsfVersion;
            String folderName = jsfVersion == null || jsfVersion.isAtLeast(JSFVersion.JSF_2_0) ? CSS_FOLDER2 : "css";
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroups = sources.getSourceGroups("java");
            if (sourceGroups.length > 0) {
                FileObject root = sourceGroups[0].getRootFolder();
                FileObject metaInf = root.getFileObject("META-INF");
                if (metaInf == null) {
                    metaInf = FileUtil.createFolder((FileObject)root, (String)"META-INF");
                }
                FileObject cssFolder = this.handleCssFolderCreation(jsfVersion, metaInf);
                return this.createTemplate(wiz, df, targetName, cssFolder, jsfVersion);
            }
        }
        return Collections.emptySet();
    }

    public void initialize(TemplateWizard wiz) {
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        this.panels = this.createPanels(project, wiz);
        Object prop = wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(TemplateIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    protected WizardDescriptor.Panel[] createPanels(Project project, TemplateWizard wiz) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups1 = sources.getSourceGroups("doc_root");
        SourceGroup[] sourceGroups = sourceGroups1.length == 0 ? sources.getSourceGroups("java") : (sourceGroups1.length == 1 ? new SourceGroup[]{sourceGroups1[0], sourceGroups1[0]} : sourceGroups1);
        this.templatePanel = new TemplatePanel((WizardDescriptor)wiz);
        JSFValidationPanel firstPanel = new JSFValidationPanel(Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups).bottomPanel((WizardDescriptor.Panel)this.templatePanel).create());
        JComponent c = (JComponent)firstPanel.getComponent();
        Dimension d = c.getPreferredSize();
        d.setSize(d.getWidth(), d.getHeight() + 65.0);
        c.setPreferredSize(d);
        return new WizardDescriptor.Panel[]{firstPanel};
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    private FileObject handleCssFolderCreation(JSFVersion jsfVersion, FileObject rootDir) throws IOException {
        String folderName = jsfVersion == null || jsfVersion.isAtLeast(JSFVersion.JSF_2_0) ? CSS_FOLDER2 : "css";
        FileObject cssFolder = rootDir.getFileObject(folderName);
        if (cssFolder == null) {
            cssFolder = FileUtil.createFolder((FileObject)rootDir, (String)folderName);
        }
        return cssFolder;
    }

    private Set<DataObject> createTemplate(TemplateWizard wiz, DataFolder df, String targetName, FileObject cssFolder, JSFVersion jsfVersion) throws IOException {
        CreateTemplateAction createTemplateAction = new CreateTemplateAction(this.templatePanel.getComponent(), Templates.getTargetName((WizardDescriptor)wiz), Templates.getTargetFolder((WizardDescriptor)wiz), cssFolder, jsfVersion);
        df.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)createTemplateAction);
        FileObject target = df.getPrimaryFile().getFileObject(targetName, XHTML_EXT);
        DataObject dob = DataObject.find((FileObject)target);
        JSFPaletteUtilities.reformat(dob);
        return Collections.singleton(dob);
    }

    static class CreateTemplateAction
    implements FileSystem.AtomicAction {
        private final TemplatePanelVisual templatePanel;
        private final String templateName;
        private final FileObject targetFolder;
        private final FileObject cssTargetFolder;
        private final JSFVersion jsfVersion;
        private FileObject result;

        public CreateTemplateAction(TemplatePanelVisual templatePanel, String templateName, FileObject targetFolder, FileObject cssTargetFolder, JSFVersion jsfVersion) {
            this.templatePanel = templatePanel;
            this.templateName = templateName;
            this.targetFolder = targetFolder;
            this.cssTargetFolder = cssTargetFolder;
            this.jsfVersion = jsfVersion;
        }

        public void run() throws IOException {
            InputStream is;
            FileObject target = this.targetFolder.createData(this.templateName, TemplateIterator.XHTML_EXT);
            String layoutName = this.templatePanel.getLayoutFileName();
            FileObject cssFile = this.cssTargetFolder.getFileObject(layoutName, "css");
            if (cssFile == null) {
                cssFile = this.cssTargetFolder.createData(layoutName, "css");
                is = this.templatePanel.getLayoutCSS();
                JSFFrameworkProvider.createFile(cssFile, JSFFrameworkProvider.readResource(is, TemplateIterator.ENCODING), TemplateIterator.ENCODING);
            }
            String layoutPath = CreateTemplateAction.getResourceRelativePath(target, cssFile);
            cssFile = this.cssTargetFolder.getFileObject("default", "css");
            if (cssFile == null) {
                cssFile = this.cssTargetFolder.createData("default", "css");
                is = this.templatePanel.getDefaultCSS();
                JSFFrameworkProvider.createFile(cssFile, JSFFrameworkProvider.readResource(is, TemplateIterator.ENCODING), TemplateIterator.ENCODING);
            }
            String defaultPath = CreateTemplateAction.getResourceRelativePath(target, cssFile);
            is = this.templatePanel.getTemplate();
            String content = JSFFrameworkProvider.readResource(is, TemplateIterator.ENCODING);
            if (!this.jsfVersion.isAtLeast(JSFVersion.JSF_2_0)) {
                content = content.replaceAll("h:head", "head").replaceAll("h:body", "body");
            }
            String namespaceLocation = this.jsfVersion.isAtLeast(JSFVersion.JSF_2_2) ? "http://xmlns.jcp.org" : "http://java.sun.com";
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("LAYOUT_CSS_PATH", layoutPath);
            args.put("DEFAULT_CSS_PATH", defaultPath);
            args.put("NS_LOCATION", namespaceLocation);
            MapFormat formater = new MapFormat(args);
            formater.setLeftBrace("__");
            formater.setRightBrace("__");
            formater.setExactMatch(false);
            content = formater.format((Object)content);
            JSFFrameworkProvider.createFile(target, content, TemplateIterator.ENCODING);
            this.result = target;
        }

        public FileObject getResult() {
            return this.result;
        }

        private static String getResourceRelativePath(FileObject fromFO, FileObject toFO) {
            String relativePath = JSFUtils.getRelativePath(fromFO, toFO);
            if (relativePath.contains("resources")) {
                return "./css/" + toFO.getNameExt();
            }
            return relativePath;
        }
    }
}

