/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.mordant.internal.gen.CellWidthTableEntry;
import com.github.ajalt.mordant.internal.gen.CellwidthtableKt;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\b"}, d2={"cellWidth", "", "codepoint", "codepointSequence", "Lkotlin/sequences/Sequence;", "string", "", "stringCellWidth", "mordant"})
public final class CellwidthKt {
    public static final int cellWidth(int codepoint) {
        int n = codepoint;
        if (32 <= n && 126 >= n) {
            return 1;
        }
        if (codepoint == 8 || codepoint == 127) {
            return -1;
        }
        CellWidthTableEntry[] table = CellwidthtableKt.getCELL_WIDTH_TABLE();
        int min = 0;
        int mid = 0;
        int max = ArraysKt.getLastIndex(table);
        if (codepoint < table[0].getLow() || codepoint > table[max].getHigh()) {
            return 1;
        }
        while (max >= min) {
            mid = (min + max) / 2;
            CellWidthTableEntry entry = table[mid];
            if (codepoint > entry.getHigh()) {
                min = mid + 1;
                continue;
            }
            if (codepoint < entry.getLow()) {
                max = mid - 1;
                continue;
            }
            return table[mid].getWidth();
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static final int stringCellWidth(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        Sequence<Integer> sequence = CellwidthKt.codepointSequence(string);
        boolean bl = false;
        int n = 0;
        Iterator<Integer> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            Integer n2 = iterator2.next();
            int n3 = ((Number)n2).intValue();
            int n4 = n;
            boolean bl2 = false;
            int n5 = CellwidthKt.cellWidth((int)it);
            n = n4 + n5;
        }
        return n;
    }

    private static final Sequence<Integer> codepointSequence(String string) {
        PrimitiveIterator.OfInt ofInt = string.codePoints().iterator();
        Intrinsics.checkNotNullExpressionValue(ofInt, "string.codePoints().iterator()");
        return SequencesKt.asSequence(ofInt);
    }
}

