/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.AtxHeaderMarkerBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\u00020\u00042\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\u0010\b\u001a\u00060\tR\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/AtxHeaderProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "requireSpace", "", "(Z)V", "calcTailStartPos", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "headerSize", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "getRegex", "Lkotlin/text/Regex;", "interruptsParagraph", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "Lkotlin/ranges/IntRange;", "Companion", "3ce148cfd89a773"})
public final class AtxHeaderProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    private final boolean requireSpace;
    @NotNull
    private static final Regex REGEX_WITH_SPACE;
    @NotNull
    private static final Regex REGEX_NO_SPACE;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(productionHolder, "productionHolder");
        Intrinsics.checkParameterIsNotNull(stateInfo, "stateInfo");
        IntRange headerRange = this.matches(pos);
        if (headerRange != null) {
            return CollectionsKt.listOf(new AtxHeaderMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, headerRange, this.calcTailStartPos(pos, headerRange.getEndInclusive()), pos.getNextLineOrEofOffset()));
        }
        return CollectionsKt.emptyList();
    }

    private final int calcTailStartPos(LookaheadText.Position pos, int headerSize) {
        int offset;
        CharSequence line = pos.getCurrentLineFromPosition();
        for (offset = line.length() - 1; offset > headerSize && Character.isWhitespace(line.charAt(offset)); --offset) {
        }
        while (offset > headerSize && line.charAt(offset) == '#' && line.charAt(offset - 1) != '\\') {
            --offset;
        }
        if (offset + 1 < line.length() && Character.isWhitespace(line.charAt(offset)) && line.charAt(offset + 1) == '#') {
            return pos.getOffset() + offset + 1;
        }
        return pos.getOffset() + line.length();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(constraints, "constraints");
        return this.matches(pos) != null;
    }

    private final IntRange matches(LookaheadText.Position pos) {
        MatchResult matchResult;
        if (pos.getOffsetInCurrentLine() != -1 && (matchResult = Regex.find$default(this.getRegex(), pos.getCurrentLineFromPosition(), 0, 2, null)) != null) {
            MatchGroup matchGroup = matchResult.getGroups().get(1);
            if (matchGroup == null) {
                Intrinsics.throwNpe();
            }
            return matchGroup.getRange();
        }
        return null;
    }

    private final Regex getRegex() {
        return this.requireSpace ? REGEX_WITH_SPACE : REGEX_NO_SPACE;
    }

    public AtxHeaderProvider(boolean requireSpace) {
        this.requireSpace = requireSpace;
    }

    static {
        Companion = new Companion(null);
        REGEX_WITH_SPACE = new Regex("\\A {0,3}(#{1,6})( |$)");
        REGEX_NO_SPACE = new Regex("\\A {0,3}(#{1,6})");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/AtxHeaderProvider$Companion;", "", "()V", "REGEX_NO_SPACE", "Lkotlin/text/Regex;", "getREGEX_NO_SPACE", "()Lkotlin/text/Regex;", "REGEX_WITH_SPACE", "getREGEX_WITH_SPACE", "3ce148cfd89a773"})
    public static final class Companion {
        @NotNull
        public final Regex getREGEX_WITH_SPACE() {
            return REGEX_WITH_SPACE;
        }

        @NotNull
        public final Regex getREGEX_NO_SPACE() {
            return REGEX_NO_SPACE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

