/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.service.CustomerGatewayConfigurationService;
import com.amazon.aes.service.impl.CustomerGatewayConfigurationServiceImpl;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreateVpnConnectionRoute
extends BaseCmd {
    private static final String VPN_CONNECTION_DESC = "The ID of the VPN connection.";
    private static final String CIDR_DESC = "The CIDR block to be routed.";
    private CustomerGatewayConfigurationService configurationService = new CustomerGatewayConfigurationServiceImpl();
    private String vpnConnectionId;
    private String destinationCidrBlock;

    public CreateVpnConnectionRoute(String[] args) {
        super("ec2cvcr", "ec2-create-vpn-connection-route");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "[SPECIFIC OPTIONS]";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"vpn-connection");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"VPN_CONNECTION");
        OptionBuilder.withDescription((String)this.joinDescription(VPN_CONNECTION_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"cidr");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"CIDR");
        OptionBuilder.withDescription((String)this.joinDescription(CIDR_DESC));
        options.addOption(OptionBuilder.create());
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Create a route for the VPN connection.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("vpn-connection");
        this.printOption("cidr");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.vpnConnectionId = this.getOptionValue("vpn-connection");
        this.destinationCidrBlock = this.getOptionValue("cidr");
        RequestResultPair rsp = jec2.createVpnConnectionRoute(this.vpnConnectionId, this.destinationCidrBlock);
        out.output(System.out, (Boolean)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertOptionSet("vpn-connection");
        this.assertOptionSet("cidr");
    }

    public static void main(String[] args) {
        new CreateVpnConnectionRoute(args).invoke();
    }
}

