/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.token;

import java.util.Date;
import org.springframework.security.token.Token;
import org.springframework.util.Assert;

public class DefaultToken
implements Token {
    private String key;
    private long keyCreationTime;
    private String extendedInformation;

    public DefaultToken(String key, long keyCreationTime, String extendedInformation) {
        Assert.hasText((String)key, (String)"Key required");
        Assert.notNull((Object)extendedInformation, (String)"Extended information cannot be null");
        this.key = key;
        this.keyCreationTime = keyCreationTime;
        this.extendedInformation = extendedInformation;
    }

    public String getKey() {
        return this.key;
    }

    public long getKeyCreationTime() {
        return this.keyCreationTime;
    }

    public String getExtendedInformation() {
        return this.extendedInformation;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DefaultToken) {
            DefaultToken rhs = (DefaultToken)obj;
            return this.key.equals(rhs.key) && this.keyCreationTime == rhs.keyCreationTime && this.extendedInformation.equals(rhs.extendedInformation);
        }
        return false;
    }

    public int hashCode() {
        int code = 979;
        code *= this.key.hashCode();
        code *= new Long(this.keyCreationTime).hashCode();
        return code *= this.extendedInformation.hashCode();
    }

    public String toString() {
        return "DefaultToken[key=" + new String(this.key) + "; creation=" + new Date(this.keyCreationTime) + "; extended=" + this.extendedInformation + "]";
    }
}

