/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.jruby.dirgra.Edge;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;

public class LiveVariableNode
extends FlowGraphNode<LiveVariablesProblem, LiveVariableNode> {
    private BitSet in;
    private BitSet out;
    private BitSet living;
    private int setSize;

    public LiveVariableNode(LiveVariablesProblem prob, BasicBlock n) {
        super(prob, n);
    }

    @Override
    public void init() {
        this.setSize = ((LiveVariablesProblem)this.problem).getDFVarsCount();
        this.out = new BitSet(this.setSize);
    }

    private void addDFVar(Variable v) {
        if (!((LiveVariablesProblem)this.problem).dfVarExists(v)) {
            ((LiveVariablesProblem)this.problem).addDFVar(v);
        }
    }

    @Override
    public void buildDataFlowVars(Instr i2) {
        if (i2 instanceof ResultInstr) {
            this.addDFVar(((ResultInstr)((Object)i2)).getResult());
        }
        for (Variable x : i2.getUsedVariables()) {
            this.addDFVar(x);
        }
    }

    @Override
    public void applyPreMeetHandler() {
        this.in = new BitSet(this.setSize);
        if (this.basicBlock.isExitBB()) {
            Collection<LocalVariable> lv = ((LiveVariablesProblem)this.problem).getVarsLiveOnScopeExit();
            if (lv != null && !lv.isEmpty()) {
                for (Variable variable : lv) {
                    this.in.set(((LiveVariablesProblem)this.problem).getDFVar(variable));
                }
            }
            if (((LiveVariablesProblem)this.problem).getFIC().bindingHasEscaped()) {
                for (Variable variable : ((LiveVariablesProblem)this.problem).getNonSelfLocalVars()) {
                    this.in.set(((LiveVariablesProblem)this.problem).getDFVar(variable));
                }
            }
        }
    }

    @Override
    public void compute_MEET(Edge e, LiveVariableNode pred2) {
        this.in.or(pred2.out);
    }

    private void markAllVariablesLive(LiveVariablesProblem lvp, Collection<? extends Variable> variableList) {
        for (Variable variable : variableList) {
            this.markVariableLive(lvp, variable);
        }
    }

    private void markVariableLive(LiveVariablesProblem lvp, Variable x) {
        Integer dv = lvp.getDFVar(x);
        if (dv != null) {
            this.living.set(dv);
        }
    }

    @Override
    public void initSolution() {
        this.living = (BitSet)this.in.clone();
    }

    @Override
    public void applyTransferFunction(Instr i2) {
        boolean scopeBindingHasEscaped = ((LiveVariablesProblem)this.problem).getFIC().bindingHasEscaped();
        if (i2 instanceof ResultInstr) {
            Variable v = ((ResultInstr)((Object)i2)).getResult();
            this.living.clear(((LiveVariablesProblem)this.problem).getDFVar(v));
        }
        if (i2 instanceof ClosureAcceptingInstr) {
            Operand o = ((ClosureAcceptingInstr)((Object)i2)).getClosureArg();
            if (o != null && o instanceof WrappedIRClosure || scopeBindingHasEscaped) {
                for (Variable variable : ((LiveVariablesProblem)this.problem).getNonSelfLocalVars()) {
                    this.living.set(((LiveVariablesProblem)this.problem).getDFVar(variable));
                }
            } else {
                for (Variable variable : ((LiveVariablesProblem)this.problem).getNonSelfLocalVars()) {
                    if (!(variable instanceof LocalVariable) || !((LocalVariable)variable).isOuterScopeVar()) continue;
                    this.living.set(((LiveVariablesProblem)this.problem).getDFVar(variable));
                }
            }
        }
        if (i2.canRaiseException()) {
            this.makeOutExceptionVariablesLiving();
        }
        this.markAllVariablesLive((LiveVariablesProblem)this.problem, i2.getUsedVariables());
    }

    @Override
    public boolean solutionChanged() {
        return !this.living.equals(this.out);
    }

    @Override
    public void finalizeSolution() {
        this.out = this.living;
    }

    private void makeOutExceptionVariablesLiving() {
        this.living.or(((LiveVariableNode)this.getExceptionTargetNode()).out);
    }

    public String toString() {
        int i2;
        StringBuilder buf = new StringBuilder();
        buf.append("\tVars Live on Entry: ");
        int count2 = 0;
        for (i2 = 0; i2 < this.in.size(); ++i2) {
            if (!this.in.get(i2)) continue;
            buf.append(' ').append(((LiveVariablesProblem)this.problem).getVariable(i2));
            if (++count2 % 10 != 0) continue;
            buf.append("\t\n");
        }
        if (count2 % 10 != 0) {
            buf.append("\t\t");
        }
        buf.append("\n\tVars Live on Exit: ");
        count2 = 0;
        for (i2 = 0; i2 < this.out.size(); ++i2) {
            if (!this.out.get(i2)) continue;
            buf.append(' ').append(((LiveVariablesProblem)this.problem).getVariable(i2));
            if (++count2 % 10 != 0) continue;
            buf.append("\t\n");
        }
        if (count2 % 10 != 0) {
            buf.append("\t\t");
        }
        return buf.append('\n').toString();
    }

    void markDeadInstructions() {
        boolean scopeBindingHasEscaped = ((LiveVariablesProblem)this.problem).getFIC().bindingHasEscaped();
        if (this.in == null) {
            for (Instr i2 : this.basicBlock.getInstrs()) {
                i2.markDead();
            }
            return;
        }
        this.initSolution();
        List<Instr> instrs = this.basicBlock.getInstrs();
        ListIterator<Instr> it = instrs.listIterator(instrs.size());
        while (it.hasPrevious()) {
            Instr i3 = it.previous();
            if (i3 instanceof ResultInstr) {
                Variable v = ((ResultInstr)((Object)i3)).getResult();
                Integer dv = ((LiveVariablesProblem)this.problem).getDFVar(v);
                if (this.living.get(dv)) {
                    this.living.clear(dv);
                } else if (i3.isDeletable()) {
                    i3.markDead();
                    it.remove();
                }
            } else if (i3.isDeletable()) {
                i3.markDead();
                it.remove();
            }
            if (i3 instanceof ClosureAcceptingInstr) {
                Operand o = ((ClosureAcceptingInstr)((Object)i3)).getClosureArg();
                if (o != null && o instanceof WrappedIRClosure || scopeBindingHasEscaped) {
                    for (Variable variable : ((LiveVariablesProblem)this.problem).getNonSelfLocalVars()) {
                        this.living.set(((LiveVariablesProblem)this.problem).getDFVar(variable));
                    }
                } else {
                    for (Variable variable : ((LiveVariablesProblem)this.problem).getNonSelfLocalVars()) {
                        if (!(variable instanceof LocalVariable) || !((LocalVariable)variable).isOuterScopeVar()) continue;
                        this.living.set(((LiveVariablesProblem)this.problem).getDFVar(variable));
                    }
                }
            }
            if (i3.canRaiseException()) {
                this.makeOutExceptionVariablesLiving();
            }
            if (i3.isDead()) continue;
            this.markAllVariablesLive((LiveVariablesProblem)this.problem, i3.getUsedVariables());
        }
    }

    BitSet getLiveInBitSet() {
        return this.in;
    }

    BitSet getLiveOutBitSet() {
        return this.out;
    }
}

