/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters.parser;

import java.math.BigDecimal;
import java.util.Arrays;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.logstash.filters.parser.TimestampParser;

public class CasualISO8601Parser
implements TimestampParser {
    private static final DateTimeFormatter[] baseParsers = new DateTimeFormatter[]{ISODateTimeFormat.dateTimeParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSZ"), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS"), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss,SSSZ"), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss,SSS")};
    private final DateTimeFormatter[] parsers;
    private String timeZone;

    public CasualISO8601Parser(String timeZone) {
        this.timeZone = timeZone;
        this.parsers = timeZone == null ? baseParsers : (DateTimeFormatter[])Arrays.stream(baseParsers).map(p -> p.withZone(DateTimeZone.forID((String)timeZone))).toArray(DateTimeFormatter[]::new);
    }

    @Override
    public Instant parse(String value) {
        IllegalArgumentException lastException = null;
        for (DateTimeFormatter parser : this.parsers) {
            try {
                return new Instant(parser.parseMillis(value));
            }
            catch (IllegalArgumentException e) {
                lastException = e;
            }
        }
        throw lastException;
    }

    @Override
    public Instant parse(Long value) {
        throw new IllegalArgumentException("Expected a string value, but got a long (" + value + "). Cannot parse date.");
    }

    @Override
    public Instant parse(Double value) {
        throw new IllegalArgumentException("Expected a string value, but got a double (" + value + "). Cannot parse date.");
    }

    @Override
    public Instant parse(BigDecimal value) {
        throw new IllegalArgumentException("Expected a string value, but got a bigdecimal (" + value + "). Cannot parse date.");
    }

    @Override
    public Instant parseWithTimeZone(String value, String timezone) {
        DateTimeZone tz = DateTimeZone.forID((String)timezone);
        IllegalArgumentException lastException = null;
        for (DateTimeFormatter parser : this.parsers) {
            try {
                DateTimeFormatter parserWithZone = parser.withZone(tz);
                return new Instant(parserWithZone.parseMillis(value));
            }
            catch (IllegalArgumentException e) {
                lastException = e;
            }
        }
        throw lastException;
    }
}

