/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.RequestAndCompletionHandler;
import kafka.raft.KafkaNetworkChannel$;
import kafka.raft.RaftSendThread;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.RaftResponse;
import org.apache.kafka.raft.RaftUtil;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%w!B\r\u001b\u0011\u0003yb!B\u0011\u001b\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003BB\u0016\u0002\t\u0003QBF\u0002\u0003\"5\u0001\u0011\u0006\u0002\u00034\u0005\u0005\u0003\u0005\u000b\u0011B4\t\u00111$!\u0011!Q\u0001\n5D\u0001b\u001d\u0003\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\to\u0012\u0011\t\u0011)A\u0005q\"1\u0011\u0006\u0002C\u0001\u0003\u000f)a!a\u0005\u0005\u0001\u0005U\u0001\"CA\u0014\t\t\u0007I\u0011BA\u0015\u0011!\ty\u0004\u0002Q\u0001\n\u0005-\u0002\"CA!\t\t\u0007I\u0011BA\"\u0011!\ti\u0006\u0002Q\u0001\n\u0005\u0015\u0003\"CA0\t\t\u0007I\u0011BA1\u0011!\tI\u0007\u0002Q\u0001\n\u0005\r\u0004bBA6\t\u0011\u0005\u0013Q\u000e\u0005\t\u0003\u0003#A\u0011\u0001\u000e\u0002\u0004\"9\u0011Q\u0011\u0003\u0005B\u0005\u001d\u0005bBAE\t\u0011%\u00111\u0012\u0005\b\u00033#A\u0011IAN\u0011\u001d\t\u0019\r\u0002C\u0001\u0003\u0007Cq!!2\u0005\t\u0003\t\u0019\tC\u0004\u0002H\u0012!\t%a!\u0002'-\u000bgm[1OKR<xN]6DQ\u0006tg.\u001a7\u000b\u0005ma\u0012\u0001\u0002:bMRT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001!\t\u0001\u0013!D\u0001\u001b\u0005MY\u0015MZ6b\u001d\u0016$xo\u001c:l\u0007\"\fgN\\3m'\t\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\tABY;jY\u0012\u0014V-];fgR$\"!\f&1\u00059\n\u0005cA\u0018=\u007f9\u0011\u0001GO\u0007\u0002c)\u0011!gM\u0001\te\u0016\fX/Z:ug*\u0011A'N\u0001\u0007G>lWn\u001c8\u000b\u0005u1$BA\u001c9\u0003\u0019\t\u0007/Y2iK*\t\u0011(A\u0002pe\u001eL!aO\u0019\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRL!!\u0010 \u0003\u000f\t+\u0018\u000e\u001c3fe*\u00111(\r\t\u0003\u0001\u0006c\u0001\u0001B\u0005C\u0007\u0005\u0005\t\u0011!B\u0001\u0007\n\u0019q\fJ\u0019\u0012\u0005\u0011;\u0005C\u0001\u0013F\u0013\t1UEA\u0004O_RD\u0017N\\4\u0011\u0005AB\u0015BA%2\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b\"B&\u0004\u0001\u0004a\u0015a\u0003:fcV,7\u000f\u001e#bi\u0006\u0004\"!\u0014)\u000e\u00039S!aT\u001a\u0002\u0011A\u0014x\u000e^8d_2L!!\u0015(\u0003\u0015\u0005\u0003\u0018.T3tg\u0006<Wm\u0005\u0003\u0005'n\u0003\u0007C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0011a\u0017M\\4\u000b\u0003a\u000bAA[1wC&\u0011!,\u0016\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005qsV\"A/\u000b\u0005m)\u0014BA0^\u00059qU\r^<pe.\u001c\u0005.\u00198oK2\u0004\"!\u00193\u000e\u0003\tT!a\u0019\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0015\u0014'a\u0002'pO\u001eLgnZ\u0001\u0005i&lW\r\u0005\u0002iU6\t\u0011N\u0003\u0002dg%\u00111.\u001b\u0002\u0005)&lW-\u0001\u0004dY&,g\u000e\u001e\t\u0003]Fl\u0011a\u001c\u0006\u0003aV\nqa\u00197jK:$8/\u0003\u0002s_\nY1*\u00194lC\u000ec\u0017.\u001a8u\u0003A\u0011X-];fgR$\u0016.\\3pkRl5\u000f\u0005\u0002%k&\u0011a/\n\u0002\u0004\u0013:$\u0018\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y!\rI\u0018\u0011\u0001\b\u0003uz\u0004\"a_\u0013\u000e\u0003qT!! \u0010\u0002\rq\u0012xn\u001c;?\u0013\tyX%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\t)A\u0001\u0004TiJLgn\u001a\u0006\u0003\u007f\u0016\"\"\"!\u0003\u0002\f\u00055\u0011qBA\t!\t\u0001C\u0001C\u0003g\u0013\u0001\u0007q\rC\u0003m\u0013\u0001\u0007Q\u000eC\u0003t\u0013\u0001\u0007A\u000fC\u0003x\u0013\u0001\u0007\u0001PA\bSKN\u0004xN\\:f\u0011\u0006tG\r\\3s!\u001d!\u0013qCA\u000e\u0003CI1!!\u0007&\u0005%1UO\\2uS>t\u0017\u0007E\u00021\u0003;I1!a\b2\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cX\rE\u0002%\u0003GI1!!\n&\u0005\u0011)f.\u001b;\u0002)\r|'O]3mCRLwN\\%e\u0007>,h\u000e^3s+\t\tY\u0003\u0005\u0003\u0002.\u0005mRBAA\u0018\u0015\u0011\t\t$a\r\u0002\r\u0005$x.\\5d\u0015\u0011\t)$a\u000e\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002:]\u000bA!\u001e;jY&!\u0011QHA\u0018\u00055\tEo\\7jG&sG/Z4fe\u0006)2m\u001c:sK2\fG/[8o\u0013\u0012\u001cu.\u001e8uKJ\u0004\u0013!C3oIB|\u0017N\u001c;t+\t\t)\u0005E\u0004\u0002H\u0005EC/!\u0016\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\nq!\\;uC\ndWMC\u0002\u0002P\u0015\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019&!\u0013\u0003\u000f!\u000b7\u000f['baB!\u0011qKA-\u001b\u0005\u0019\u0014bAA.g\t!aj\u001c3f\u0003))g\u000e\u001a9pS:$8\u000fI\u0001\u000ee\u0016\fX/Z:u)\"\u0014X-\u00193\u0016\u0005\u0005\r\u0004c\u0001\u0011\u0002f%\u0019\u0011q\r\u000e\u0003\u001dI\u000bg\r^*f]\u0012$\u0006N]3bI\u0006q!/Z9vKN$H\u000b\u001b:fC\u0012\u0004\u0013\u0001B:f]\u0012$B!!\t\u0002p!9\u0011\u0011O\tA\u0002\u0005M\u0014a\u0002:fcV,7\u000f\u001e\t\u0005\u0003k\nYHD\u0002]\u0003oJ1!!\u001f^\u0003-\u0011\u0016M\u001a;SKF,Xm\u001d;\n\t\u0005u\u0014q\u0010\u0002\t\u001fV$(m\\;oI*\u0019\u0011\u0011P/\u0002\u0011A|G\u000e\\(oG\u0016$\"!!\t\u0002!9,woQ8se\u0016d\u0017\r^5p]&#G#\u0001;\u0002\u001b\u0015\u0014(o\u001c:SKN\u0004xN\\:f)\u0015a\u0015QRAH\u0011\u0019\t\t\b\u0006a\u0001\u0019\"9\u0011\u0011\u0013\u000bA\u0002\u0005M\u0015!B3se>\u0014\bcA'\u0002\u0016&\u0019\u0011q\u0013(\u0003\r\u0015\u0013(o\u001c:t\u00039)\b\u000fZ1uK\u0016sG\r]8j]R$b!!\t\u0002\u001e\u0006\u0005\u0006BBAP+\u0001\u0007A/\u0001\u0002jI\"9\u00111U\u000bA\u0002\u0005\u0015\u0016\u0001B:qK\u000e\u0004B!a*\u0002>:!\u0011\u0011VA]\u001d\u0011\tY+a.\u000f\t\u00055\u0016Q\u0017\b\u0005\u0003_\u000b\u0019LD\u0002|\u0003cK\u0011!O\u0005\u0003oaJ!!\b\u001c\n\u0005m)\u0014bAA^;\u0006Q!+\u00194u\u0007>tg-[4\n\t\u0005}\u0016\u0011\u0019\u0002\u0010\u0013:,G/\u00113ee\u0016\u001c8o\u00159fG*\u0019\u00111X/\u0002\u000bM$\u0018M\u001d;\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^t\u0017!B2m_N,\u0007")
public class KafkaNetworkChannel
implements NetworkChannel,
Logging {
    private final AtomicInteger correlationIdCounter;
    private final HashMap<Object, Node> endpoints;
    private final RaftSendThread requestThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicInteger correlationIdCounter() {
        return this.correlationIdCounter;
    }

    private HashMap<Object, Node> endpoints() {
        return this.endpoints;
    }

    private RaftSendThread requestThread() {
        return this.requestThread;
    }

    public void send(RaftRequest.Outbound request) {
        Option option = this.endpoints().get((Object)BoxesRunTime.boxToInteger((int)request.destinationId()));
        if (option instanceof Some) {
            Node node = (Node)((Some)option).value();
            this.requestThread().sendRequest(new RequestAndCompletionHandler(request.createdTimeMs(), node, KafkaNetworkChannel$.MODULE$.buildRequest(request.data()), clientResponse -> this.onComplete$1(clientResponse, request)));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            KafkaNetworkChannel.completeFuture$1(this.errorResponse(request.data(), Errors.BROKER_NOT_AVAILABLE), request);
            return;
        }
        throw new MatchError((Object)option);
    }

    public void pollOnce() {
        this.requestThread().doWork();
    }

    public int newCorrelationId() {
        return this.correlationIdCounter().getAndIncrement();
    }

    private ApiMessage errorResponse(ApiMessage request, Errors error) {
        return RaftUtil.errorResponse((ApiKeys)ApiKeys.forId((int)request.apiKey()), (Errors)error);
    }

    public void updateEndpoint(int id, RaftConfig.InetAddressSpec spec) {
        Node node = new Node(id, spec.address.getHostString(), spec.address.getPort());
        this.endpoints().put((Object)BoxesRunTime.boxToInteger((int)id), (Object)node);
    }

    public void start() {
        this.requestThread().start();
    }

    public void initiateShutdown() {
        this.requestThread().initiateShutdown();
    }

    public void close() {
        this.requestThread().shutdown();
    }

    private static final void completeFuture$1(ApiMessage message, RaftRequest.Outbound request$1) {
        RaftResponse.Inbound response = new RaftResponse.Inbound(request$1.correlationId(), message, request$1.destinationId());
        request$1.completion.complete(response);
    }

    private final void onComplete$1(ClientResponse clientResponse, RaftRequest.Outbound request$1) {
        ApiMessage apiMessage;
        if (clientResponse.versionMismatch() != null) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Request ").append(request$1).append(" failed due to unsupported version error").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> clientResponse.versionMismatch());
            apiMessage = this.errorResponse(request$1.data(), Errors.UNSUPPORTED_VERSION);
        } else if (clientResponse.authenticationException() != null) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Request ").append(request$1).append(" failed due to authentication error").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> clientResponse.authenticationException());
            apiMessage = this.errorResponse(request$1.data(), Errors.NETWORK_EXCEPTION);
        } else {
            apiMessage = clientResponse.wasDisconnected() ? this.errorResponse(request$1.data(), Errors.BROKER_NOT_AVAILABLE) : clientResponse.responseBody().data();
        }
        KafkaNetworkChannel.completeFuture$1(apiMessage, request$1);
    }

    public KafkaNetworkChannel(Time time, KafkaClient client, int requestTimeoutMs, String threadNamePrefix) {
        Logging.$init$(this);
        this.correlationIdCounter = new AtomicInteger(0);
        this.endpoints = HashMap$.MODULE$.empty();
        this.requestThread = new RaftSendThread(new StringBuilder(24).append(threadNamePrefix).append("-outbound-request-thread").toString(), client, requestTimeoutMs, time, false);
    }
}

