/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager$;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.tools.DumpLogSegments;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class DumpLogSegments$ {
    public static DumpLogSegments$ MODULE$;
    private final String RecordIndent;

    static {
        new DumpLogSegments$();
    }

    public String RecordIndent() {
        return this.RecordIndent;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        void forKeyValue$extension_f2;
        void forKeyValue$extension_$this2;
        DumpLogSegments.DumpLogSegmentsOptions opts = new DumpLogSegments.DumpLogSegmentsOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        opts.checkArgs();
        scala.collection.mutable.Map misMatchesForIndexFilesMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors = new DumpLogSegments.TimeIndexDumpErrors();
        scala.collection.mutable.Map nonConsecutivePairsForLogFilesMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts.files())).foreach((Function1 & Serializable & scala.Serializable)arg -> {
            DumpLogSegments$.$anonfun$main$1(opts, nonConsecutivePairsForLogFilesMap, misMatchesForIndexFilesMap, timeIndexDumpErrors, arg);
            return BoxedUnit.UNIT;
        });
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(fileName, listOfMismatches) -> {
            DumpLogSegments$.$anonfun$main$2(fileName, listOfMismatches);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods(misMatchesForIndexFilesMap);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this2), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f2, arg_0, arg_1));
        timeIndexDumpErrors.printErrors();
        Function2 & Serializable & scala.Serializable intersect2 = (Function2 & Serializable & scala.Serializable)(fileName, listOfNonConsecutivePairs) -> {
            DumpLogSegments$.$anonfun$main$4(fileName, listOfNonConsecutivePairs);
            return BoxedUnit.UNIT;
        };
        Map map2 = Implicits$.MODULE$.MapExtensionMethods(nonConsecutivePairsForLogFilesMap);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    private void dumpTxnIndex(File file) {
        new TransactionIndex(Log$.MODULE$.offsetFromFile(file), file).allAbortedTxns().foreach((Function1 & Serializable & scala.Serializable)abortedTxn -> {
            Predef$.MODULE$.println((Object)new StringBuilder(68).append("version: ").append(abortedTxn.version()).append(" producerId: ").append(abortedTxn.producerId()).append(" firstOffset: ").append(abortedTxn.firstOffset()).append(" ").append("lastOffset: ").append(abortedTxn.lastOffset()).append(" lastStableOffset: ").append(abortedTxn.lastStableOffset()).toString());
            return BoxedUnit.UNIT;
        });
    }

    private void dumpProducerIdSnapshot(File file) {
        try {
            ProducerStateManager$.MODULE$.readSnapshot(file).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                DumpLogSegments$.$anonfun$dumpProducerIdSnapshot$1(entry);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (CorruptSnapshotException e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    public void dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, scala.collection.mutable.Map<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        Object object = new Object();
        try {
            long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
            FileRecords fileRecords = FileRecords.open((File)new File(file.getAbsoluteFile().getParent(), new StringBuilder(0).append(file.getName().split("\\.")[0]).append(Log$.MODULE$.LogFileSuffix()).toString()), (boolean)false);
            boolean x$3 = false;
            int x$4 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
            OffsetIndex index = new OffsetIndex(file, startOffset, x$4, x$3);
            if (index.entries() == 0) {
                Predef$.MODULE$.println((Object)new StringBuilder(10).append(file).append(" is empty.").toString());
                return;
            }
            if (indexSanityOnly) {
                index.sanityCheck();
                Predef$.MODULE$.println((Object)new StringBuilder(21).append(file).append(" passed sanity check.").toString());
                return;
            }
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), index.entries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                OffsetPosition entry = index.entry(i);
                if (entry.offset() == index.baseOffset() && i > 0) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                long firstBatchLastOffset = ((RecordBatch)fileRecords.slice(entry.position(), maxMessageSize).batches().iterator().next()).lastOffset();
                if (firstBatchLastOffset != entry.offset()) {
                    List misMatchesSeq = (List)misMatchesForIndexFilesMap.getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                    misMatchesSeq = misMatchesSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(entry.offset(), firstBatchLastOffset));
                    misMatchesForIndexFilesMap.put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
                }
                if (!verifyOnly) {
                    Predef$.MODULE$.println((Object)new StringBuilder(19).append("offset: ").append(entry.offset()).append(" position: ").append(entry.position()).toString());
                }
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    public void dumpTimeIndex(File file, boolean indexSanityOnly, boolean verifyOnly, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors, int maxMessageSize) {
        Object object = new Object();
        try {
            block8: {
                block7: {
                    long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
                    FileRecords fileRecords = FileRecords.open((File)new File(file.getAbsoluteFile().getParent(), new StringBuilder(0).append(file.getName().split("\\.")[0]).append(Log$.MODULE$.LogFileSuffix()).toString()), (boolean)false);
                    File indexFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder(0).append(file.getName().split("\\.")[0]).append(Log$.MODULE$.IndexFileSuffix()).toString());
                    boolean x$3 = false;
                    int x$4 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
                    OffsetIndex index = new OffsetIndex(indexFile, startOffset, x$4, x$3);
                    boolean x$7 = false;
                    int x$8 = TimeIndex$.MODULE$.$lessinit$greater$default$3();
                    TimeIndex timeIndex = new TimeIndex(file, startOffset, x$8, x$7);
                    try {
                        if (indexSanityOnly) {
                            timeIndex.sanityCheck();
                            Predef$.MODULE$.println((Object)new StringBuilder(21).append(file).append(" passed sanity check.").toString());
                            break block7;
                        }
                        LongRef prevTimestamp = LongRef.create((long)-1L);
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), timeIndex.entries()).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> DumpLogSegments$.$anonfun$dumpTimeIndex$1(timeIndex, object, index, fileRecords, timeIndexDumpErrors, file, prevTimestamp, verifyOnly, arg_0)));
                        break block8;
                    }
                    finally {
                        fileRecords.closeHandlers();
                        index.closeHandler();
                        timeIndex.closeHandler();
                    }
                }
                return;
            }
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private void dumpLog(File file, boolean printContents, scala.collection.mutable.Map<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, int maxMessageSize, DumpLogSegments.MessageParser<?, ?> parser, boolean skipRecordMetadata) {
        long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
        Predef$.MODULE$.println((Object)new StringBuilder(17).append("Starting offset: ").append(startOffset).toString());
        FileRecords fileRecords = FileRecords.open((File)file, (boolean)false);
        try {
            LongRef validBytes = LongRef.create((long)0L);
            LongRef lastOffset = LongRef.create((long)-1L);
            ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fileRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                DumpLogSegments$.$anonfun$dumpLog$1(validBytes, isDeepIteration, lastOffset, nonConsecutivePairsForLogFilesMap, file, skipRecordMetadata, printContents, parser, batch);
                return BoxedUnit.UNIT;
            });
            long trailingBytes = (long)fileRecords.sizeInBytes() - validBytes.elem;
            if (trailingBytes > 0L) {
                Predef$.MODULE$.println((Object)new StringBuilder(35).append("Found ").append(trailingBytes).append(" invalid bytes at the end of ").append(file.getName()).toString());
            }
        }
        finally {
            fileRecords.closeHandlers();
        }
    }

    private void printBatchLevel(FileLogInputStream.FileChannelRecordBatch batch, long accumulativeBytes) {
        if (batch.magic() >= 2) {
            Predef$.MODULE$.print((Object)new StringBuilder(145).append("baseOffset: ").append(batch.baseOffset()).append(" lastOffset: ").append(batch.lastOffset()).append(" count: ").append(batch.countOrNull()).append(" baseSequence: ").append(batch.baseSequence()).append(" lastSequence: ").append(batch.lastSequence()).append(" producerId: ").append(batch.producerId()).append(" producerEpoch: ").append(batch.producerEpoch()).append(" partitionLeaderEpoch: ").append(batch.partitionLeaderEpoch()).append(" isTransactional: ").append(batch.isTransactional()).append(" isControl: ").append(batch.isControlBatch()).toString());
        } else {
            Predef$.MODULE$.print((Object)new StringBuilder(8).append("offset: ").append(batch.lastOffset()).toString());
        }
        Predef$.MODULE$.println((Object)new StringBuilder(61).append(" position: ").append(accumulativeBytes).append(" ").append(batch.timestampType()).append(": ").append(batch.maxTimestamp()).append(" size: ").append(batch.sizeInBytes()).append(" magic: ").append(batch.magic()).append(" compresscodec: ").append(batch.compressionType()).append(" crc: ").append(batch.checksum()).append(" isvalid: ").append(batch.isValid()).toString());
    }

    public static final /* synthetic */ void $anonfun$main$1(DumpLogSegments.DumpLogSegmentsOptions opts$1, scala.collection.mutable.Map nonConsecutivePairsForLogFilesMap$1, scala.collection.mutable.Map misMatchesForIndexFilesMap$1, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1, String arg) {
        File file = new File(arg);
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("Dumping ").append(file).toString());
        String filename = file.getName();
        String suffix = filename.substring(filename.lastIndexOf("."));
        String string = Log$.MODULE$.LogFileSuffix();
        if (!(string != null ? !string.equals(suffix) : suffix != null)) {
            MODULE$.dumpLog(file, opts$1.shouldPrintDataLog(), (scala.collection.mutable.Map<String, List<Tuple2<Object, Object>>>)nonConsecutivePairsForLogFilesMap$1, opts$1.isDeepIteration(), opts$1.maxMessageSize(), opts$1.messageParser(), opts$1.skipRecordMetadata());
            return;
        }
        String string2 = Log$.MODULE$.IndexFileSuffix();
        if (!(string2 != null ? !string2.equals(suffix) : suffix != null)) {
            MODULE$.dumpIndex(file, opts$1.indexSanityOnly(), opts$1.verifyOnly(), (scala.collection.mutable.Map<String, List<Tuple2<Object, Object>>>)misMatchesForIndexFilesMap$1, opts$1.maxMessageSize());
            return;
        }
        String string3 = Log$.MODULE$.TimeIndexFileSuffix();
        if (!(string3 != null ? !string3.equals(suffix) : suffix != null)) {
            MODULE$.dumpTimeIndex(file, opts$1.indexSanityOnly(), opts$1.verifyOnly(), timeIndexDumpErrors$1, opts$1.maxMessageSize());
            return;
        }
        String string4 = Log$.MODULE$.ProducerSnapshotFileSuffix();
        if (!(string4 != null ? !string4.equals(suffix) : suffix != null)) {
            MODULE$.dumpProducerIdSnapshot(file);
            return;
        }
        String string5 = Log$.MODULE$.TxnIndexFileSuffix();
        if (!(string5 != null ? !string5.equals(suffix) : suffix != null)) {
            MODULE$.dumpTxnIndex(file);
            return;
        }
        System.err.println(new StringBuilder(22).append("Ignoring unknown file ").append(file).toString());
    }

    public static final /* synthetic */ void $anonfun$main$3(Tuple2 x0$1) {
        if (x0$1 != null) {
            long indexOffset = x0$1._1$mcJ$sp();
            long logOffset = x0$1._2$mcJ$sp();
            System.err.println(new StringBuilder(30).append("  Index offset: ").append(indexOffset).append(", log offset: ").append(logOffset).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$main$2(String fileName, List listOfMismatches) {
        System.err.println(new StringBuilder(15).append("Mismatches in :").append(fileName).toString());
        listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DumpLogSegments$.$anonfun$main$3(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$main$5(Tuple2 x0$2) {
        if (x0$2 != null) {
            long first = x0$2._1$mcJ$sp();
            long second = x0$2._2$mcJ$sp();
            System.err.println(new StringBuilder(18).append("  ").append(first).append(" is followed by ").append(second).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$main$4(String fileName, List listOfNonConsecutivePairs) {
        System.err.println(new StringBuilder(27).append("Non-consecutive offsets in ").append(fileName).toString());
        listOfNonConsecutivePairs.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DumpLogSegments$.$anonfun$main$5(x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$dumpProducerIdSnapshot$1(ProducerStateEntry entry) {
        Predef$.MODULE$.print((Object)new StringBuilder(72).append("producerId: ").append(entry.producerId()).append(" producerEpoch: ").append(entry.producerEpoch()).append(" ").append("coordinatorEpoch: ").append(entry.coordinatorEpoch()).append(" currentTxnFirstOffset: ").append(entry.currentTxnFirstOffset()).append(" ").toString());
        entry.batchMetadata().headOption().foreach((Function1 & Serializable & scala.Serializable)metadata -> {
            Predef$.MODULE$.print((Object)new StringBuilder(69).append("firstSequence: ").append(metadata.firstSeq()).append(" lastSequence: ").append(metadata.lastSeq()).append(" ").append("lastOffset: ").append(metadata.lastOffset()).append(" offsetDelta: ").append(metadata.offsetDelta()).append(" timestamp: ").append(metadata.timestamp()).toString());
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ boolean $anonfun$dumpTimeIndex$2(TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return x$1.lastOffset() >= entry$1.offset();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$dumpTimeIndex$1(TimeIndex timeIndex$1, Object nonLocalReturnKey2$1, OffsetIndex index$2, FileRecords fileRecords$2, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$2, File file$2, LongRef prevTimestamp$1, boolean verifyOnly$2, int i) {
        block9: {
            block8: {
                entry = timeIndex$1.entry(i);
                if (entry.offset() == timeIndex$1.baseOffset() && i > 0) {
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
                }
                position = index$2.lookup(entry.offset()).position();
                partialFileRecords = fileRecords$2.slice(position, 0x7FFFFFFF);
                batches = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(partialFileRecords.batches()).asScala();
                maxTimestamp = LongRef.create((long)-1L);
                var14_14 = false;
                var15_15 = null;
                var16_16 = batches.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$2$adapted(kafka.log.TimestampOffset org.apache.kafka.common.record.FileLogInputStream$FileChannelRecordBatch ), (Lorg/apache/kafka/common/record/FileLogInputStream$FileChannelRecordBatch;)Ljava/lang/Object;)((TimestampOffset)entry));
                if (!None$.MODULE$.equals(var16_16)) break block8;
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$2, entry.offset(), -1);
                break block9;
            }
            if (!(var16_16 instanceof Some)) ** GOTO lbl-1000
            var14_14 = true;
            var15_15 = (Some)var16_16;
            batch = (FileLogInputStream.FileChannelRecordBatch)var15_15.value();
            if (batch.lastOffset() != entry.offset()) {
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$2, entry.offset(), batch.lastOffset());
            } else if (var14_14) {
                batch = (FileLogInputStream.FileChannelRecordBatch)var15_15.value();
                ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$3$adapted(scala.runtime.LongRef org.apache.kafka.common.record.Record ), (Lorg/apache/kafka/common/record/Record;)Ljava/lang/Object;)((LongRef)maxTimestamp));
                if (maxTimestamp.elem != entry.timestamp()) {
                    timeIndexDumpErrors$2.recordMismatchTimeIndex(file$2, entry.timestamp(), maxTimestamp.elem);
                }
                if (prevTimestamp$1.elem >= entry.timestamp()) {
                    timeIndexDumpErrors$2.recordOutOfOrderIndexTimestamp(file$2, entry.timestamp(), prevTimestamp$1.elem);
                }
            } else {
                throw new MatchError((Object)var16_16);
            }
        }
        if (!verifyOnly$2) {
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("timestamp: ").append(entry.timestamp()).append(" offset: ").append(entry.offset()).toString());
        }
        prevTimestamp$1.elem = entry.timestamp();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$5(ObjectRef prefix$1, Object key) {
        Predef$.MODULE$.print((Object)new StringBuilder(5).append((String)prefix$1.elem).append("key: ").append(key).toString());
        prefix$1.elem = " ";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$dumpLog$2(LongRef lastOffset$1, scala.collection.mutable.Map nonConsecutivePairsForLogFilesMap$2, File file$3, boolean skipRecordMetadata$1, FileLogInputStream.FileChannelRecordBatch batch$1, LongRef validBytes$1, boolean printContents$1, DumpLogSegments.MessageParser parser$1, Record record) {
        if (lastOffset$1.elem == -1L) {
            lastOffset$1.elem = record.offset();
        } else if (record.offset() != lastOffset$1.elem + 1L) {
            List nonConsecutivePairsSeq = (List)nonConsecutivePairsForLogFilesMap$2.getOrElse((Object)file$3.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(lastOffset$1.elem, record.offset()));
            nonConsecutivePairsForLogFilesMap$2.put((Object)file$3.getAbsolutePath(), (Object)nonConsecutivePairsSeq);
        }
        lastOffset$1.elem = record.offset();
        ObjectRef prefix = ObjectRef.create((Object)new StringBuilder(1).append(MODULE$.RecordIndent()).append(" ").toString());
        if (!skipRecordMetadata$1) {
            Predef$.MODULE$.print((Object)new StringBuilder(190).append((String)prefix.elem).append("offset: ").append(record.offset()).append(" isValid: ").append(record.isValid()).append(" crc: ").append(record.checksumOrNull()).append(" keySize: ").append(record.keySize()).append(" valueSize: ").append(record.valueSize()).append(" ").append(batch$1.timestampType()).append(": ").append(record.timestamp()).append(" baseOffset: ").append(batch$1.baseOffset()).append(" lastOffset: ").append(batch$1.lastOffset()).append(" baseSequence: ").append(batch$1.baseSequence()).append(" lastSequence: ").append(batch$1.lastSequence()).append(" producerEpoch: ").append(batch$1.producerEpoch()).append(" partitionLeaderEpoch: ").append(batch$1.partitionLeaderEpoch()).append(" batchSize: ").append(batch$1.sizeInBytes()).append(" magic: ").append(batch$1.magic()).append(" compressType: ").append(batch$1.compressionType()).append(" position: ").append(validBytes$1.elem).toString());
            prefix.elem = " ";
            if (batch$1.magic() >= 2) {
                Predef$.MODULE$.print((Object)new StringBuilder(24).append(" sequence: ").append(record.sequence()).append(" headerKeys: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])record.headers())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.key(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]")).toString());
            } else {
                Predef$.MODULE$.print((Object)new StringBuilder(16).append(" crc: ").append(record.checksumOrNull()).append(" isvalid: ").append(record.isValid()).toString());
            }
            if (batch$1.isControlBatch()) {
                short controlTypeId = ControlRecordType.parseTypeId((ByteBuffer)record.key());
                ControlRecordType controlRecordType = ControlRecordType.fromTypeId((short)controlTypeId);
                boolean bl = ControlRecordType.ABORT.equals(controlRecordType) ? true : ControlRecordType.COMMIT.equals(controlRecordType);
                if (bl) {
                    EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
                    Predef$.MODULE$.print((Object)new StringBuilder(34).append(" endTxnMarker: ").append(endTxnMarker.controlType()).append(" coordinatorEpoch: ").append(endTxnMarker.coordinatorEpoch()).toString());
                } else {
                    Predef$.MODULE$.print((Object)new StringBuilder(16).append(" controlType: ").append(controlRecordType).append("(").append(controlTypeId).append(")").toString());
                }
            }
        }
        if (printContents$1 && !batch$1.isControlBatch()) {
            void var17_17;
            void var16_16;
            Tuple2 tuple2 = parser$1.parse(record);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option key2 = (Option)tuple2._1();
            Option payload2 = (Option)tuple2._2();
            void key3 = var16_16;
            void payload3 = var17_17;
            key3.foreach((Function1 & Serializable & scala.Serializable)key -> {
                DumpLogSegments$.$anonfun$dumpLog$5(prefix, key);
                return BoxedUnit.UNIT;
            });
            payload3.foreach((Function1 & Serializable & scala.Serializable)payload -> {
                Predef$.MODULE$.print((Object)new StringBuilder(10).append(" payload: ").append(payload).toString());
                return BoxedUnit.UNIT;
            });
        }
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$1(LongRef validBytes$1, boolean isDeepIteration$1, LongRef lastOffset$1, scala.collection.mutable.Map nonConsecutivePairsForLogFilesMap$2, File file$3, boolean skipRecordMetadata$1, boolean printContents$1, DumpLogSegments.MessageParser parser$1, FileLogInputStream.FileChannelRecordBatch batch) {
        MODULE$.printBatchLevel(batch, validBytes$1.elem);
        if (isDeepIteration$1) {
            ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                DumpLogSegments$.$anonfun$dumpLog$2(lastOffset$1, nonConsecutivePairsForLogFilesMap$2, file$3, skipRecordMetadata$1, batch, validBytes$1, printContents$1, parser$1, record);
                return BoxedUnit.UNIT;
            });
        }
        validBytes$1.elem += (long)batch.sizeInBytes();
    }

    private DumpLogSegments$() {
        MODULE$ = this;
        this.RecordIndent = "|";
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$2$adapted(TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return BoxesRunTime.boxToBoolean((boolean)DumpLogSegments$.$anonfun$dumpTimeIndex$2(entry$1, x$1));
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$3$adapted(LongRef maxTimestamp$1, Record record) {
        maxTimestamp$1.elem = scala.math.package$.MODULE$.max(maxTimestamp$1.elem, record.timestamp());
        return BoxedUnit.UNIT;
    }
}

