/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.logstash.ingest.IngestConverter;

public class IngestGsub {
    public static String toLogstash(String json, boolean appendStdio) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap<String, Object> jsonDefinition = mapper.readValue(json, typeRef);
        List processors = (List)jsonDefinition.get("processors");
        List<String> filters_pipeline = processors.stream().map(IngestGsub::mapProcessor).collect(Collectors.toList());
        return IngestConverter.filtersToFile(IngestConverter.appendIoPlugins(filters_pipeline, appendStdio));
    }

    private static String mapProcessor(Map processor) {
        return IngestConverter.filterHash(IngestConverter.createHash("mutate", IngestGsub.gsubHash(processor)));
    }

    static String gsubHash(Map<String, Map> processor) {
        Map gsub_data = processor.get("gsub");
        String body = String.join((CharSequence)", ", IngestConverter.quoteString(IngestConverter.dotsToSquareBrackets((String)gsub_data.get("field"))), IngestConverter.quoteString((String)gsub_data.get("pattern")), IngestConverter.quoteString((String)gsub_data.get("replacement")));
        return IngestConverter.createField("gsub", "[\n" + body + "\n]");
    }

    public static boolean has_gsub(Map<String, Object> processor) {
        return processor.containsKey("gsub");
    }
}

