/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.cluster.BrokerEndPoint;
import org.apache.kafka.common.KafkaException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class BrokerEndPoint$
implements scala.Serializable {
    public static BrokerEndPoint$ MODULE$;
    private final Regex uriParseExp;

    static {
        new BrokerEndPoint$();
    }

    private Regex uriParseExp() {
        return this.uriParseExp;
    }

    public Option<Tuple2<String, Object>> parseHostPort(String connectionString) {
        None$ none$;
        Option option = this.uriParseExp().unapplySeq((CharSequence)connectionString);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            Some some;
            String host = (String)((LinearSeqOptimized)option.get()).apply(0);
            String port = (String)((LinearSeqOptimized)option.get()).apply(1);
            try {
                some = new Some((Object)new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
            }
            catch (NumberFormatException numberFormatException) {
                some = None$.MODULE$;
            }
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public BrokerEndPoint createBrokerEndPoint(int brokerId, String connectionString) {
        return (BrokerEndPoint)this.parseHostPort(connectionString).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String host = (String)x0$1._1();
            int port = x0$1._2$mcI$sp();
            BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, host, port);
            return brokerEndPoint;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException(new StringBuilder(37).append("Unable to parse ").append(connectionString).append(" to a broker endpoint").toString());
        });
    }

    public BrokerEndPoint readFrom(ByteBuffer buffer) {
        int brokerId = buffer.getInt();
        String host = ApiUtils$.MODULE$.readShortString(buffer);
        int port = buffer.getInt();
        return new BrokerEndPoint(brokerId, host, port);
    }

    public BrokerEndPoint apply(int id, String host, int port) {
        return new BrokerEndPoint(id, host, port);
    }

    public Option<Tuple3<Object, String, Object>> unapply(BrokerEndPoint x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.id()), (Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BrokerEndPoint$() {
        MODULE$ = this;
        this.uriParseExp = new StringOps(Predef$.MODULE$.augmentString("\\[?([0-9a-zA-Z\\-%._:]*)\\]?:([0-9]+)")).r();
    }
}

