/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdGenerator;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r\u001dq!B\u0014)\u0011\u0003yc!B\u0019)\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004\"B\u001e\u0002\t\u0003a\u0004b\u0002B~\u0003\u0011%!Q \u0005\b\u0007\u0003\tA\u0011BB\u0002\r\u0011\t\u0004\u0006\u0001 \t\u0011\u00153!\u0011!Q\u0001\n\u0019C\u0001\"\u0013\u0004\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001b\u001a\u0011\t\u0011)A\u0005\u001d\"A\u0011K\u0002B\u0001B\u0003%!\u000b\u0003\u0005Y\r\t\u0005\t\u0015!\u0003Z\u0011!afA!A!\u0002\u0013i\u0006\u0002\u00031\u0007\u0005\u0003\u0005\u000b\u0011B1\t\u001154!\u0011!Q\u0001\n9DQ!\u000f\u0004\u0005\u0002E,AA\u001f\u0004\u0001w\u00161\u0011\u0011\u0002\u0004\u0001\u0003\u0017)a!!\u0007\u0007\u0001\u0005-QABA\u000e\r\u0001\ti\u0002C\u0005\u0002N\u0019\u0011\r\u0011\"\u0003\u0002P!A\u0011\u0011\u000e\u0004!\u0002\u0013\t\t\u0006C\u0005\u0002l\u0019\u0011\r\u0011\"\u0001\u0002n!9\u0011q\u000e\u0004!\u0002\u0013)\u0006bBA9\r\u0011\u0005\u00111\u000f\u0005\b\u0003K3A\u0011BAT\u0011\u001d\tYM\u0002C\u0001\u0003\u001bDqA!\u0001\u0007\t\u0003\u0011\u0019\u0001C\u0004\u0003\f\u0019!\tA!\u0004\t\u000f\tUa\u0001\"\u0003\u0003\u0018!9!q\b\u0004\u0005\u0002\t\u0005\u0003b\u0002B)\r\u0011%!1\u000b\u0005\b\u0005S2A\u0011\u0001B6\u0011\u001d\u0011)H\u0002C\u0001\u0005oBqAa\u001f\u0007\t\u0013\u0011i\b\u0003\u0005\u0003\u0010\u001a!\t\u0001\u000bBI\u0011\u001d\u0011IJ\u0002C\u0001\u00057C\u0011Ba*\u0007#\u0003%\tA!+\t\u000f\t}f\u0001\"\u0001\u0003B\u00061BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'O\u0003\u0002*U\u0005YAO]1og\u0006\u001cG/[8o\u0015\tYC&A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0017\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001'A\u0007\u0002Q\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'o\u0005\u0002\u0002gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0018\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001fu\u0012\u0019Ma5\u0003^\n}'\u0011\u001dBx\u0005s\u0004\"\u0001\r\u0004\u0014\u0007\u0019\u0019t\b\u0005\u0002A\u00076\t\u0011I\u0003\u0002CY\u0005)Q\u000f^5mg&\u0011A)\u0011\u0002\b\u0019><w-\u001b8h\u0003!\u0011'o\\6fe&#\u0007C\u0001\u001bH\u0013\tAUGA\u0002J]R\f\u0011\u0002\u001e=o\u0007>tg-[4\u0011\u0005AZ\u0015B\u0001')\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\ng\u000eDW\rZ;mKJ\u0004\"\u0001Q(\n\u0005A\u000b%!C*dQ\u0016$W\u000f\\3s\u0003e\u0019'/Z1uKB\u0013x\u000eZ;dKJLEmR3oKJ\fGo\u001c:\u0011\u0007Q\u001aV+\u0003\u0002Uk\tIa)\u001e8di&|g\u000e\r\t\u0003aYK!a\u0016\u0015\u0003'A\u0013x\u000eZ;dKJLEmR3oKJ\fGo\u001c:\u0002\u0015QDh.T1oC\u001e,'\u000f\u0005\u000215&\u00111\f\u000b\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\fq\u0003\u001e=o\u001b\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0011\u0005Ar\u0016BA0)\u0005}!&/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u0005i&lW\r\u0005\u0002cW6\t1M\u0003\u0002CI*\u0011QMZ\u0001\u0007G>lWn\u001c8\u000b\u00055:'B\u00015j\u0003\u0019\t\u0007/Y2iK*\t!.A\u0002pe\u001eL!\u0001\\2\u0003\tQKW.Z\u0001\u000bY><7i\u001c8uKb$\bC\u00012p\u0013\t\u00018M\u0001\u0006M_\u001e\u001cuN\u001c;fqR$\u0012\"\u0010:tiV4x\u000f_=\t\u000b\u0015{\u0001\u0019\u0001$\t\u000b%{\u0001\u0019\u0001&\t\u000b5{\u0001\u0019\u0001(\t\u000bE{\u0001\u0019\u0001*\t\u000ba{\u0001\u0019A-\t\u000bq{\u0001\u0019A/\t\u000b\u0001|\u0001\u0019A1\t\u000b5|\u0001\u0019\u00018\u0003-%s\u0017\u000e\u001e)s_\u0012,8-\u001a:JI\u000e\u000bG\u000e\u001c2bG.\u0004R\u0001\u000e?\u007f\u0003\u0007I!!`\u001b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u0019\u0000\u0013\r\t\t\u0001\u000b\u0002\u0015\u0013:LG\u000f\u0015:pIV\u001cWM]%e%\u0016\u001cX\u000f\u001c;\u0011\u0007Q\n)!C\u0002\u0002\bU\u0012A!\u00168ji\n)\u0012\t\u001a3QCJ$\u0018\u000e^5p]N\u001c\u0015\r\u001c7cC\u000e\\\u0007C\u0002\u001b}\u0003\u001b\t\u0019\u0001\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019\u0002Z\u0001\taJ|Go\\2pY&!\u0011qCA\t\u0005\u0019)%O]8sg\nqQI\u001c3Uq:\u001c\u0015\r\u001c7cC\u000e\\'!C!qSJ+7/\u001e7u+\u0011\ty\"a\u000f\u0011\u0011\u0005\u0005\u0012\u0011GA\u0007\u0003oqA!a\t\u0002.9!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*9\na\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0007\u0005=R'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0012Q\u0007\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\u0005=R\u0007\u0005\u0003\u0002:\u0005mB\u0002\u0001\u0003\b\u0003{\u0019\"\u0019AA \u0005\u0005!\u0016\u0003BA!\u0003\u000f\u00022\u0001NA\"\u0013\r\t)%\u000e\u0002\b\u001d>$\b.\u001b8h!\r!\u0014\u0011J\u0005\u0004\u0003\u0017*$aA!os\u0006A\u0011n]!di&4X-\u0006\u0002\u0002RA!\u00111KA3\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013AB1u_6L7M\u0003\u0003\u0002\\\u0005u\u0013AC2p]\u000e,(O]3oi*!\u0011qLA1\u0003\u0011)H/\u001b7\u000b\u0005\u0005\r\u0014\u0001\u00026bm\u0006LA!a\u001a\u0002V\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0011\"[:BGRLg/\u001a\u0011\u0002'A\u0014x\u000eZ;dKJLEmR3oKJ\fGo\u001c:\u0016\u0003U\u000bA\u0003\u001d:pIV\u001cWM]%e\u000f\u0016tWM]1u_J\u0004\u0013\u0001\u00065b]\u0012dW-\u00138jiB\u0013x\u000eZ;dKJLE\r\u0006\u0006\u0002\u0004\u0005U\u0014\u0011RAG\u0003;Cq!a\u001e\u0019\u0001\u0004\tI(A\bue\u0006t7/Y2uS>t\u0017\r\\%e!\u0011\tY(a!\u000f\t\u0005u\u0014q\u0010\t\u0004\u0003K)\u0014bAAAk\u00051\u0001K]3eK\u001aLA!!\"\u0002\b\n11\u000b\u001e:j]\u001eT1!!!6\u0011\u0019\tY\t\u0007a\u0001\r\u0006!BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bNDq!a$\u0019\u0001\u0004\t\t*\u0001\u000efqB,7\r^3e!J|G-^2fe&#\u0017I\u001c3Fa>\u001c\u0007\u000eE\u00035\u0003'\u000b9*C\u0002\u0002\u0016V\u0012aa\u00149uS>t\u0007c\u00012\u0002\u001a&\u0019\u00111T2\u0003%A\u0013x\u000eZ;dKJLE-\u00118e\u000bB|7\r\u001b\u0005\b\u0003?C\u0002\u0019AAQ\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0002\u0002$Bi\u0011AB\u0001\u001daJ,\u0007/\u0019:f\u0013:LG\u000f\u0015:pIV\u001cWM]%e)J\fgn]5u)1\tI+a.\u0002:\u0006m\u0016qXAe!\u0015\t\u0019kEAV!\u0019!\u0014Q\u0016$\u00022&\u0019\u0011qV\u001b\u0003\rQ+\b\u000f\\33!\r\u0001\u00141W\u0005\u0004\u0003kC#A\u0005+y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006Dq!a\u001e\u001a\u0001\u0004\tI\b\u0003\u0004\u0002\ff\u0001\rA\u0012\u0005\u0007\u0003{K\u0002\u0019\u0001$\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007bBAa3\u0001\u0007\u00111Y\u0001\fibtW*\u001a;bI\u0006$\u0018\rE\u00021\u0003\u000bL1!a2)\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0011\u001d\ty)\u0007a\u0001\u0003#\u000b\u0001\u0005[1oI2,\u0017\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016:b]N\f7\r^5p]Ra\u00111AAh\u0003#\fY.!:\u0002~\"9\u0011q\u000f\u000eA\u0002\u0005e\u0004bBAj5\u0001\u0007\u0011Q[\u0001\u000baJ|G-^2fe&#\u0007c\u0001\u001b\u0002X&\u0019\u0011\u0011\\\u001b\u0003\t1{gn\u001a\u0005\b\u0003;T\u0002\u0019AAp\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQB\u0019A'!9\n\u0007\u0005\rXGA\u0003TQ>\u0014H\u000fC\u0004\u0002hj\u0001\r!!;\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0002l\u0006E\u0018Q_\u0007\u0003\u0003[T1!a<6\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\fiOA\u0002TKR\u0004B!a>\u0002z6\tA-C\u0002\u0002|\u0012\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002 j\u0001\r!a@\u0011\u0007\u0005\r\u0016#\u0001\u0006p]\u0016cWm\u0019;j_:$b!a\u0001\u0003\u0006\t%\u0001B\u0002B\u00047\u0001\u0007a)A\nuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:LE\r\u0003\u0004\u0002>n\u0001\rAR\u0001\u000e_:\u0014Vm]5h]\u0006$\u0018n\u001c8\u0015\r\u0005\r!q\u0002B\t\u0011\u0019\u00119\u0001\ba\u0001\r\"9\u0011Q\u0018\u000fA\u0002\tM\u0001\u0003\u0002\u001b\u0002\u0014\u001a\u000bq\u0005\\8h\u0013:4\u0018\r\\5e'R\fG/\u001a+sC:\u001c\u0018\u000e^5p]\u0006sGMU3ukJtWI\u001d:peRA!\u0011\u0004B\u0012\u0005K\u0011y\u0003\u0005\u0005\u0003\u001c\t}\u0011QBA!\u001b\t\u0011iBC\u0002\u0002`UJAA!\t\u0003\u001e\t!A*\u001a4u\u0011\u001d\t9(\ba\u0001\u0003sBqAa\n\u001e\u0001\u0004\u0011I#\u0001\tue\u0006t7/Y2uS>t7\u000b^1uKB\u0019\u0001Ga\u000b\n\u0007\t5\u0002F\u0001\tUe\u0006t7/Y2uS>t7\u000b^1uK\"9!\u0011G\u000fA\u0002\tM\u0012!\u0005;sC:\u001c\u0018m\u0019;j_:\u0014Vm];miB!!Q\u0007B\u001e\u001b\t\u00119DC\u0002\u0003:\u0011\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0005{\u00119DA\tUe\u0006t7/Y2uS>t'+Z:vYR\fA\u0003[1oI2,WI\u001c3Ue\u0006t7/Y2uS>tG\u0003DA\u0002\u0005\u0007\u0012)Ea\u0012\u0003J\t5\u0003bBA<=\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003't\u0002\u0019AAk\u0011\u001d\tiN\ba\u0001\u0003?DqAa\u0013\u001f\u0001\u0004\u0011\u0019$A\buq:l\u0015M]6feJ+7/\u001e7u\u0011\u001d\tyJ\ba\u0001\u0005\u001f\u00022!a)\u0013\u00039)g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$b\"a\u0001\u0003V\t]#\u0011\fB.\u0005;\u00129\u0007C\u0004\u0002x}\u0001\r!!\u001f\t\u000f\u0005Mw\u00041\u0001\u0002V\"9\u0011Q\\\u0010A\u0002\u0005}\u0007b\u0002B&?\u0001\u0007!1\u0007\u0005\b\u0005?z\u0002\u0019\u0001B1\u00031I7O\u0012:p[\u000ec\u0017.\u001a8u!\r!$1M\u0005\u0004\u0005K*$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003?{\u0002\u0019\u0001B(\u0003]!(/\u00198tC\u000e$\u0018n\u001c8U_BL7mQ8oM&<7/\u0006\u0002\u0003nA!!q\u000eB9\u001b\t\ti&\u0003\u0003\u0003t\u0005u#A\u0003)s_B,'\u000f^5fg\u0006a\u0001/\u0019:uSRLwN\u001c$peR\u0019aI!\u001f\t\u000f\u0005]\u0014\u00051\u0001\u0002z\u0005ArN\\#oIR\u0013\u0018M\\:bGRLwN\\\"p[BdW\r^3\u0015\t\t}$Q\u0011\u000b\u0005\u0003\u0007\u0011\t\tC\u0004\u0003\u0004\n\u0002\r!!\u0004\u0002\u000b\u0015\u0014(o\u001c:\t\u000f\t\u001d%\u00051\u0001\u0003\n\u0006\u0001B\u000f\u001f8JI\u0006sG\rU5e\u000bB|7\r\u001b\t\u0004a\t-\u0015b\u0001BGQ\t\tCK]1og\u0006\u001cG/[8oC2LE-\u00118e!J|G-^2fe&#W\t]8dQ\u0006I\u0012MY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t)\u0011\t\u0019Aa%\t\u000f\tU5\u00051\u0001\u0003\u0018\u0006QqN\\\"p[BdW\r^3\u0011\rQb(\u0011\u0012B(\u0003\u001d\u0019H/\u0019:ukB$b!a\u0001\u0003\u001e\n\r\u0006b\u0002BPI\u0001\u0007!\u0011U\u0001'e\u0016$(/[3wKR\u0013\u0018M\\:bGRLwN\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$\bc\u0001\u001bT\r\"I!Q\u0015\u0013\u0011\u0002\u0003\u0007!\u0011M\u0001 K:\f'\r\\3Ue\u0006t7/Y2uS>t\u0017\r\\%e\u000bb\u0004\u0018N]1uS>t\u0017!E:uCJ$X\u000f\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0016\u0016\u0005\u0005C\u0012ik\u000b\u0002\u00030B!!\u0011\u0017B^\u001b\t\u0011\u0019L\u0003\u0003\u00036\n]\u0016!C;oG\",7m[3e\u0015\r\u0011I,N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B_\u0005g\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003!\u0019\b.\u001e;e_^tGCAA\u0002\u0011\u001d\u0011)m\u0001a\u0001\u0005\u000f\faaY8oM&<\u0007\u0003\u0002Be\u0005\u001fl!Aa3\u000b\u0007\t5G&\u0001\u0004tKJ4XM]\u0005\u0005\u0005#\u0014YMA\u0006LC\u001a\\\u0017mQ8oM&<\u0007b\u0002Bk\u0007\u0001\u0007!q[\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\u0011\u0011IM!7\n\t\tm'1\u001a\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u0015i5\u00011\u0001O\u0011\u0015\t6\u00011\u0001S\u0011\u001d\u0011\u0019o\u0001a\u0001\u0005K\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0003h\n-XB\u0001Bu\u0015\r\u0011\u0019\u000fZ\u0005\u0005\u0005[\u0014IOA\u0004NKR\u0014\u0018nY:\t\u000f\tE8\u00011\u0001\u0003t\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004BA!3\u0003v&!!q\u001fBf\u00055iU\r^1eCR\f7)Y2iK\")\u0001m\u0001a\u0001C\u0006!\u0012N\\5u)J\fgn]1di&|g.\u0012:s_J$2A B\u0000\u0011\u001d\u0011\u0019\t\u0002a\u0001\u0003\u001b\tq#\u001b8jiR\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0015\u0007y\u001c)\u0001C\u0004\u0002B\u0016\u0001\r!!-")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private final ProducerIdGenerator producerIdGenerator;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Scheduler scheduler, Function0<ProducerIdGenerator> function0, Metrics metrics, MetadataCache metadataCache, Time time) {
        if (TransactionCoordinator$.MODULE$ == null) {
            throw null;
        }
        TransactionConfig apply_txnConfig = new TransactionConfig(Predef$.MODULE$.Integer2int(kafkaConfig.transactionalIdExpirationMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionMaxTimeoutMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicPartitions()), Predef$.MODULE$.Short2short(kafkaConfig.transactionTopicReplicationFactor()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicSegmentBytes()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionsLoadBufferSize()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicMinISR()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionAbortTimedOutTransactionCleanupIntervalMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionRemoveExpiredTransactionalIdCleanupIntervalMs()), Predef$.MODULE$.Integer2int(kafkaConfig.requestTimeoutMs()));
        TransactionStateManager apply_txnStateManager = new TransactionStateManager(kafkaConfig.brokerId(), scheduler, replicaManager, apply_txnConfig, time, metrics);
        LogContext apply_logContext = new LogContext(new StringBuilder(29).append("[TransactionCoordinator id=").append(kafkaConfig.brokerId()).append("] ").toString());
        TransactionMarkerChannelManager apply_txnMarkerChannelManager = TransactionMarkerChannelManager$.MODULE$.apply(kafkaConfig, metrics, metadataCache, apply_txnStateManager, time, apply_logContext);
        return new TransactionCoordinator(kafkaConfig.brokerId(), apply_txnConfig, scheduler, function0, apply_txnStateManager, apply_txnMarkerChannelManager, time, apply_logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public ProducerIdGenerator producerIdGenerator() {
        return this.producerIdGenerator;
    }

    /*
     * WARNING - void declaration
     */
    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch, Function1<InitProducerIdResult, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        if (transactionalId == null) {
            long producerId = this.producerIdGenerator().generateProducerId();
            responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
            return;
        }
        if (transactionalId.isEmpty()) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
            return;
        }
        if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Either<Errors, CoordinatorEpochAndTxnMetadata> either;
            if (None$.MODULE$.equals(x0$1)) {
                long producerId = this.producerIdGenerator().generateProducerId();
                long x$3 = -1L;
                short x$4 = -1;
                short x$5 = -1;
                Empty$ x$7 = Empty$.MODULE$;
                scala.collection.mutable.Set x$8 = Set$.MODULE$.empty();
                long x$9 = $this.time.milliseconds();
                long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
                TransactionMetadata createdMetadata = new TransactionMetadata(transactionalId, producerId, x$3, x$4, x$5, transactionTimeoutMs, x$7, (scala.collection.mutable.Set<TopicPartition>)x$8, x$10, x$9);
                either = $this.txnManager.putTransactionStateIfNotExists(createdMetadata);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                either = package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
            } else {
                throw new MatchError(x0$1);
            }
            return either;
        }).flatMap((Function1 & Serializable & scala.Serializable)existingEpochAndMetadata -> {
            int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
            TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
            return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> this.prepareInitProducerIdTransit(transactionalId, transactionTimeoutMs, coordinatorEpoch, txnMetadata, expectedProducerIdAndEpoch));
        });
        if (result instanceof Left) {
            Errors error2 = (Errors)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            TransactionState transactionState = newMetadata.txnState();
            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
            if (!(transactionState != null ? !transactionState.equals(prepareEpochFence$) : prepareEpochFence$ != null)) {
                Tuple2 tuple22;
                void endTransaction_txnMarkerResult;
                void endTransaction_producerEpoch;
                void endTransaction_isFromClient;
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)error -> {
                    Errors errors = error;
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                    } else {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    }
                    return BoxedUnit.UNIT;
                };
                boolean bl = false;
                TransactionResult transactionResult = TransactionResult.ABORT;
                short s = newMetadata.producerEpoch();
                long endTransaction_producerId = newMetadata.producerId();
                BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
                if (transactionalId.isEmpty()) {
                    Errors errors;
                    Errors errors2 = errors = Errors.INVALID_REQUEST;
                    Errors errors3 = Errors.NONE;
                    if (errors2 == null ? errors3 != null : !errors2.equals(errors3)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(errors));
                        return;
                    }
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    return;
                }
                Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap(arg_0 -> TransactionCoordinator.$anonfun$endTransaction$1(this, endTransaction_producerId, (boolean)endTransaction_isFromClient, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, endTransaction_isEpochFence, transactionalId, arg_0));
                if (endTransaction_preAppendResult instanceof Left) {
                    Errors errors;
                    Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
                    this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TransactionCoordinator.$anonfun$endTransaction$4((TransactionResult)endTransaction_txnMarkerResult, endTransaction_err, transactionalId)));
                    Errors errors4 = errors = endTransaction_err;
                    Errors errors5 = Errors.NONE;
                    if (errors4 == null ? errors5 != null : !errors4.equals(errors5)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(errors));
                        return;
                    }
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    return;
                }
                if (endTransaction_preAppendResult instanceof Right && (tuple22 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
                    void endTransaction_responseCallback;
                    int endTransaction_coordinatorEpoch = tuple22._1$mcI$sp();
                    TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple22._2();
                    this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)((Function1 & Serializable & scala.Serializable)arg_0 -> TransactionCoordinator.$anonfun$endTransaction$15$adapted(this, transactionalId, endTransaction_coordinatorEpoch, endTransaction_producerId, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, (Function1)endTransaction_responseCallback, endTransaction_newMetadata, endTransaction_isEpochFence, arg_0)), this.txnManager.appendTransactionToLog$default$5());
                    return;
                }
                throw new MatchError((Object)endTransaction_preAppendResult);
            }
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata));
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                }
                return BoxedUnit.UNIT;
            }, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError((Object)result);
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProducerIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch) {
        Left left;
        if (txnMetadata.pendingTransitionInProgress()) {
            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        }
        if (!expectedProducerIdAndEpoch.forall((Function1 & Serializable & scala.Serializable)producerIdAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.isValidProducerId$1(producerIdAndEpoch, txnMetadata)))) {
            return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
        }
        TransactionState transactionState = txnMetadata.state();
        boolean bl = PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState);
        if (bl) {
            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        } else {
            boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState));
            if (bl2) {
                Left left2;
                Right transitMetadataResult;
                Right right;
                if (txnMetadata.isProducerEpochExhausted() && expectedProducerIdAndEpoch.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$prepareInitProducerIdTransit$2(txnMetadata, x$1)))) {
                    long newProducerId = this.producerIdGenerator().generateProducerId();
                    right = package$.MODULE$.Right().apply((Object)txnMetadata.prepareProducerIdRotation(newProducerId, transactionTimeoutMs, this.time.milliseconds(), expectedProducerIdAndEpoch.isDefined()));
                } else {
                    right = transitMetadataResult = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, (Option<Object>)expectedProducerIdAndEpoch.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToShort((short)x$2.epoch)), this.time.milliseconds());
                }
                if (transitMetadataResult instanceof Right) {
                    TxnTransitMetadata transitMetadata = (TxnTransitMetadata)((Right)transitMetadataResult).value();
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
                } else if (transitMetadataResult instanceof Left) {
                    Errors err = (Errors)((Left)transitMetadataResult).value();
                    left2 = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError(transitMetadataResult);
                }
                left = left2;
            } else if (Ongoing$.MODULE$.equals(transactionState)) {
                left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
            } else {
                boolean bl3 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                if (bl3) {
                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                throw new MatchError((Object)transactionState);
            }
        }
        return left;
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    block8: {
                        block7: {
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                            if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block7;
                            TransactionState transactionState2 = txnMetadata.state();
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block8;
                        }
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    TransactionState transactionState = txnMetadata.state();
                    Ongoing$ ongoing$ = Ongoing$.MODULE$;
                    if (!(transactionState != null ? !transactionState.equals(ongoing$) : ongoing$ != null) && partitions.subsetOf(txnMetadata.topicPartitions())) {
                        return package$.MODULE$.Left().apply((Object)Errors.NONE);
                    }
                    return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions.toSet(), $this.time.milliseconds())));
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (result instanceof Left) {
            Errors err = (Errors)((Left)result).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError((Object)result);
    }

    public void onElection(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Elected as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch2).toString());
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void onResignation(int txnTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Resigned as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        if (coordinatorEpoch instanceof Some) {
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)coordinatorEpoch).value());
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, epoch);
        } else if (None$.MODULE$.equals(coordinatorEpoch)) {
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId);
        } else {
            throw new MatchError(coordinatorEpoch);
        }
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("TransactionalId: ").append(transactionalId).append("'s state is ").append(transactionState).append(", but received transaction ").append("marker result to send: ").append(transactionResult).toString());
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        boolean endTransaction_isFromClient = true;
        BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    Right right;
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (Empty$.MODULE$.equals(transactionState)) {
                        right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else {
                        boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl) {
                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return right;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (endTransaction_preAppendResult instanceof Left) {
            Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)endTransaction_err);
            return;
        }
        if (endTransaction_preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
            int endTransaction_coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple2._2();
            this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either $anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Left left;
                        if (None$.MODULE$.equals(x0$1)) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        if (x0$1 instanceof Some) {
                            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                            if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                                    Left<Errors, Nothing$> left;
                                    if (txnMetadata.producerId() != producerId) {
                                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    }
                                    if (txnMetadata.producerEpoch() != producerEpoch) {
                                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                                    }
                                    if (txnMetadata.pendingTransitionInProgress()) {
                                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    }
                                    TransactionState transactionState = txnMetadata.state();
                                    boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                                    if (bl) {
                                        left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                        left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                                        left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else {
                                        boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                        if (bl2) {
                                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                            throw new IllegalStateException(errorMsg);
                                        }
                                        throw new MatchError((Object)transactionState);
                                    }
                                    return left;
                                });
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                            }
                        } else {
                            throw new MatchError(x0$1);
                        }
                        Left left2 = left;
                        return left2;
                    });
                    if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                        Errors $anonfun$endTransaction$15_sendTxnMarkersCallback$1_err = (Errors)((Left)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Right) || (tuple2 = (Tuple2)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value()) == null) throw new MatchError((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult);
                        TransactionMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(endTransaction_coordinatorEpoch, txnMarkerResult, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
                    if (isEpochFence$1.elem) {
                        $this.txnManager.getTransactionState(transactionalId).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            }, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError((Object)endTransaction_preAppendResult);
    }

    private void endTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, boolean isFromClient, Function1<Errors, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        BooleanRef isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    Right right;
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (Empty$.MODULE$.equals(transactionState)) {
                        right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else {
                        boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl) {
                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return right;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (preAppendResult instanceof Left) {
            Errors err = (Errors)((Left)preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)preAppendResult).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either $anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Left left;
                        if (None$.MODULE$.equals(x0$1)) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        if (x0$1 instanceof Some) {
                            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                            if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                                    Left<Errors, Nothing$> left;
                                    if (txnMetadata.producerId() != producerId) {
                                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    }
                                    if (txnMetadata.producerEpoch() != producerEpoch) {
                                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                                    }
                                    if (txnMetadata.pendingTransitionInProgress()) {
                                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    }
                                    TransactionState transactionState = txnMetadata.state();
                                    boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                                    if (bl) {
                                        left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                        left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                                        left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else {
                                        boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                        if (bl2) {
                                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                            throw new IllegalStateException(errorMsg);
                                        }
                                        throw new MatchError((Object)transactionState);
                                    }
                                    return left;
                                });
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                            }
                        } else {
                            throw new MatchError(x0$1);
                        }
                        Left left2 = left;
                        return left2;
                    });
                    if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                        Errors $anonfun$endTransaction$15_sendTxnMarkersCallback$1_err = (Errors)((Left)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Right) || (tuple2 = (Tuple2)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value()) == null) throw new MatchError((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult);
                        TransactionMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(endTransaction_coordinatorEpoch, txnMarkerResult, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
                    if (isEpochFence$1.elem) {
                        $this.txnManager.getTransactionState(transactionalId).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            }, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError((Object)preAppendResult);
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void onEndTransactionComplete(TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch, Errors error) {
        if (Errors.NONE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Completed rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" due to timeout").toString());
            return;
        }
        boolean bl = Errors.INVALID_PRODUCER_ID_MAPPING.equals(error) ? true : (Errors.PRODUCER_FENCED.equals(error) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(error));
        if (bl) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("has been cancelled due to error ").append(error).toString());
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("failed due to error ").append(error).toString());
    }

    public void abortTimedOutTransactions(Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>> onComplete) {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> {
            $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (None$.MODULE$.equals(x0$1)) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
                } else if (x0$1 instanceof Some) {
                    TransactionMetadata $anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                    ((Option)$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                            return None$.MODULE$;
                        }
                        if (txnMetadata.pendingTransitionInProgress()) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                            return None$.MODULE$;
                        }
                        return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                    })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                        this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)));
                        return BoxedUnit.UNIT;
                    });
                } else {
                    throw new MatchError(x0$1);
                }
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.abortTimedOutTransactions((Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>>)(Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> (Function1 & Serializable & scala.Serializable)error -> {
            this.onEndTransactionComplete(txnIdAndPidEpoch, error);
            return BoxedUnit.UNIT;
        }), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.scheduler.schedule$default$5());
        this.txnManager.startup(retrieveTransactionTopicPartitionCount, enableTransactionalIdExpiration);
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$2() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdGenerator().shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$4(Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$7(TransactionCoordinator $this, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    private static final boolean isValidProducerId$1(ProducerIdAndEpoch producerIdAndEpoch, TransactionMetadata txnMetadata$2) {
        return txnMetadata$2.producerEpoch() == -1 || producerIdAndEpoch.producerId == txnMetadata$2.producerId() || producerIdAndEpoch.producerId == txnMetadata$2.lastProducerId() && TransactionMetadata$.MODULE$.isEpochExhausted(producerIdAndEpoch.epoch);
    }

    public static final /* synthetic */ boolean $anonfun$prepareInitProducerIdTransit$2(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch x$1) {
        return x$1.epoch == txnMetadata$2.producerEpoch();
    }

    public static final /* synthetic */ void $anonfun$endTransaction$12(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$6, Errors error$2, TxnTransitMetadata newMetadata$2, Option x0$2) {
        if (None$.MODULE$.equals(x0$2)) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId$4).append(", but there is ").append("no metadata in the cache; this is not expected").toString());
            return;
        }
        if (x0$2 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$2).value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$6) {
                epochAndMetadata.transactionMetadata().hasFailedEpochFence_$eq(true);
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(166).append("The coordinator failed to write an epoch fence transition for producer ").append(transactionalId$4).append(" to the transaction log ").append("with error ").append(error$2).append(". The epoch was increased to ").append(newMetadata$2.producerEpoch()).append(" but not returned to the client").toString());
                return;
            }
        } else {
            throw new MatchError((Object)x0$2);
        }
    }

    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$4, int coordinatorEpoch$6, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$4).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Left left;
                if (None$.MODULE$.equals(x0$1)) {
                    String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (x0$1 instanceof Some) {
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                    if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                            Left<Errors, Nothing$> left;
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                            if (bl) {
                                left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else {
                                boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                if (bl2) {
                                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                    throw new IllegalStateException(errorMsg);
                                }
                                throw new MatchError((Object)transactionState);
                            }
                            return left;
                        });
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError(x0$1);
                }
                Left left2 = left;
                return left2;
            });
            if (preSendResult instanceof Left) {
                Errors err = (Errors)((Left)preSendResult).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            }
            if (preSendResult instanceof Right && (tuple2 = (Tuple2)((Right)preSendResult).value()) != null) {
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)preSendResult);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
        if (isEpochFence$1.elem) {
            this.txnManager.getTransactionState(transactionalId$4).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$endTransaction$15(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$6, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId$4).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Left left;
                if (None$.MODULE$.equals(x0$1)) {
                    String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (x0$1 instanceof Some) {
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                    if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                            Left<Errors, Nothing$> left;
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                            if (bl) {
                                left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else {
                                boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                if (bl2) {
                                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                    throw new IllegalStateException(errorMsg);
                                }
                                throw new MatchError((Object)transactionState);
                            }
                            return left;
                        });
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError(x0$1);
                }
                Left left2 = left;
                return left2;
            });
            if (sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                Errors sendTxnMarkersCallback$1_err = (Errors)((Left)sendTxnMarkersCallback$1_preSendResult).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)sendTxnMarkersCallback$1_err);
                return;
            }
            if (sendTxnMarkersCallback$1_preSendResult instanceof Right && (tuple2 = (Tuple2)((Right)sendTxnMarkersCallback$1_preSendResult).value()) != null) {
                TransactionMetadata sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                $this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, sendTxnMarkersCallback$1_txnMetadata, sendTxnMarkersCallback$1_newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)sendTxnMarkersCallback$1_preSendResult);
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
        if (isEpochFence$1.elem) {
            $this.txnManager.getTransactionState(transactionalId$4).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$7(TransactionCoordinator $this, TransactionMetadata txnMetadata$6, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, TxnTransitMetadata txnTransitMetadata) {
        $this.endTransaction(txnMetadata$6.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete$1.apply((Object)txnIdAndPidEpoch$2)));
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$2(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Function1 onComplete$1, Option x0$1) {
        if (None$.MODULE$.equals(x0$1)) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
            return;
        }
        if (x0$1 instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
            ((Option)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                    return None$.MODULE$;
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                    return None$.MODULE$;
                }
                return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
            })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)));
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$1(TransactionCoordinator $this, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch) {
        $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
            } else if (x0$1 instanceof Some) {
                TransactionMetadata $anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                ((Option)$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                        return None$.MODULE$;
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                        return None$.MODULE$;
                    }
                    return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                    this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)));
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return BoxedUnit.UNIT;
        });
    }

    public TransactionCoordinator(int brokerId, TransactionConfig txnConfig, Scheduler scheduler, Function0<ProducerIdGenerator> createProducerIdGenerator, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
        this.producerIdGenerator = (ProducerIdGenerator)createProducerIdGenerator.apply();
    }
}

