/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.logstash.instrument.metrics.BaseFlowMetric;
import org.logstash.instrument.metrics.FlowCapture;
import org.logstash.instrument.metrics.Metric;

class SimpleFlowMetric
extends BaseFlowMetric {
    private final AtomicReference<FlowCapture> head;
    private final AtomicReference<FlowCapture> instant = new AtomicReference();
    static final String CURRENT_KEY = "current";

    public SimpleFlowMetric(String name, Metric<? extends Number> numeratorMetric, Metric<? extends Number> denominatorMetric) {
        this(System::nanoTime, name, numeratorMetric, denominatorMetric);
    }

    SimpleFlowMetric(LongSupplier nanoTimeSupplier, String name, Metric<? extends Number> numeratorMetric, Metric<? extends Number> denominatorMetric) {
        super(nanoTimeSupplier, name, numeratorMetric, denominatorMetric);
        this.head = new AtomicReference<FlowCapture>(this.lifetimeBaseline.orElse(null));
    }

    @Override
    public void capture() {
        Optional<FlowCapture> possibleCapture = this.doCapture();
        if (possibleCapture.isEmpty()) {
            return;
        }
        FlowCapture newestHead = possibleCapture.get();
        FlowCapture previousHead = this.head.getAndSet(newestHead);
        if (Objects.nonNull(previousHead)) {
            this.instant.getAndAccumulate(previousHead, (current, given) -> SimpleFlowMetric.calculateCapturePeriod(newestHead, given).toMillis() > 100L ? given : current);
        }
    }

    @Override
    public Map<String, Double> getValue() {
        FlowCapture headCapture = this.head.get();
        if (Objects.isNull(headCapture)) {
            return Map.of();
        }
        LinkedHashMap<String, Double> rates = new LinkedHashMap<String, Double>();
        SimpleFlowMetric.calculateRate(headCapture, this.instant::get).ifPresent(rate -> rates.put(CURRENT_KEY, rate));
        this.injectLifetime(headCapture, rates);
        return Collections.unmodifiableMap(rates);
    }

    private static Duration calculateCapturePeriod(FlowCapture current, FlowCapture baseline) {
        return Duration.ofNanos(Math.subtractExact(current.nanoTime(), baseline.nanoTime()));
    }
}

