/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Password;
import co.elastic.logstash.api.PluginConfigSpec;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.RubyObject;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.config.ir.compiler.RubyIntegration;
import org.logstash.plugins.factory.RubyCodecDelegator;

public final class ConfigurationImpl
implements Configuration {
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationImpl.class);
    private final RubyIntegration.PluginFactory pluginFactory;
    private final Map<String, Object> rawSettings;

    public ConfigurationImpl(Map<String, Object> raw, RubyIntegration.PluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
        this.rawSettings = raw;
    }

    public ConfigurationImpl(Map<String, Object> raw) {
        this(raw, null);
    }

    @Override
    public <T> T get(PluginConfigSpec<T> configSpec) {
        if (this.rawSettings.containsKey(configSpec.name())) {
            Object o = this.rawSettings.get(configSpec.name());
            if (configSpec.type().isAssignableFrom(o.getClass())) {
                return (T)o;
            }
            if (configSpec.type() == Double.class && o.getClass() == Long.class) {
                return configSpec.type().cast(((Long)o).doubleValue());
            }
            if (configSpec.type() == Boolean.class && o instanceof String) {
                return configSpec.type().cast(Boolean.parseBoolean((String)o));
            }
            if (configSpec.type() == Codec.class && o instanceof String && this.pluginFactory != null) {
                Codec codec = this.pluginFactory.buildDefaultCodec((String)o);
                return configSpec.type().cast(codec);
            }
            if (configSpec.type() == Codec.class && o instanceof RubyObject && RubyCodecDelegator.isRubyCodecSubclass((IRubyObject)((RubyObject)o))) {
                Codec codec = this.pluginFactory.buildRubyCodecWrapper((RubyObject)o);
                return configSpec.type().cast(codec);
            }
            if (configSpec.type() == URI.class && o instanceof String) {
                try {
                    URI uri = new URI((String)o);
                    return configSpec.type().cast(uri);
                }
                catch (URISyntaxException ex) {
                    throw new IllegalStateException(String.format("Invalid URI specified for '%s'", configSpec.name()));
                }
            }
            if (configSpec.type() == Password.class && o instanceof String) {
                Password p = new Password((String)o);
                return configSpec.type().cast(p);
            }
            throw new IllegalStateException(String.format("Setting value for '%s' of type '%s' incompatible with defined type of '%s'", configSpec.name(), o.getClass(), configSpec.type()));
        }
        if (configSpec.type() == Codec.class && configSpec.getRawDefaultValue() != null && this.pluginFactory != null) {
            Codec codec = this.pluginFactory.buildDefaultCodec(configSpec.getRawDefaultValue());
            return configSpec.type().cast(codec);
        }
        if (configSpec.type() == URI.class && configSpec.getRawDefaultValue() != null) {
            try {
                URI uri = new URI(configSpec.getRawDefaultValue());
                return configSpec.type().cast(uri);
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException(String.format("Invalid default URI specified for '%s'", configSpec.name()));
            }
        }
        if (configSpec.type() == Password.class && configSpec.getRawDefaultValue() != null) {
            Password p = new Password(configSpec.getRawDefaultValue());
            return configSpec.type().cast(p);
        }
        return configSpec.defaultValue();
    }

    @Override
    public Object getRawValue(PluginConfigSpec<?> configSpec) {
        return this.rawSettings.get(configSpec.name());
    }

    @Override
    public boolean contains(PluginConfigSpec<?> configSpec) {
        return this.rawSettings.containsKey(configSpec.name());
    }

    @Override
    public Collection<String> allKeys() {
        return this.rawSettings.keySet();
    }
}

